<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use \App\Http\Controllers\AsociadoController;
use \App\Http\Controllers\ProveedorController;
use \App\Http\Controllers\ClientesController;
use \App\Http\Controllers\FacturacionController;
use \App\Http\Controllers\FacturacionFinKokController;
use \App\Http\Controllers\ConfiguracionesController;
use \App\Http\Controllers\ConceptosController;
use \App\Http\Controllers\NominaController;
use \App\Http\Controllers\RegistroController;
use App\Http\Controllers\TestController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('admin/login', [ProveedorController::class, 'login']);

Route::post("admin/proveedores/listadoFacturas", [ProveedorController::class, 'listadoFacturas']);
Route::post("admin/proveedores/home", [ProveedorController::class, 'home']);
Route::post("admin/proveedores/misDatos", [ProveedorController::class, 'misDatos']);
Route::post("admin/proveedores/guardarMisDatos", [ProveedorController::class, 'guardarMisDatos']);
Route::post("admin/proveedores/obtenerRegimenesFiscales", [ProveedorController::class, 'obtenerRegimenesFiscales']);
Route::post("admin/proveedores/actualizarCertificado", [ProveedorController::class, 'actualizarCertificado']);
Route::post("admin/proveedores/getDataMultiusuario", [ProveedorController::class, 'getDataMultiusuario']);

Route::post("admin/clientes/obtenerClientes", [ClientesController::class, 'obtenerClientes']);
Route::post("admin/clientes/obtenerCliente", [ClientesController::class, 'obtenerCliente']);
Route::post("admin/clientes/guardar", [ClientesController::class, 'guardar']);
Route::post("admin/clientes/borrarCliente", [ClientesController::class, 'borrarCliente']);


Route::post("admin/facturacion/listadoFacturas", [FacturacionController::class, 'listadoFacturas']);
Route::get("admin/facturacion/test", [FacturacionController::class, 'test']);
Route::post("admin/facturacion/getXML",  [FacturacionController::class, 'getXML']);
Route::post("admin/facturacion/getXML33", [FacturacionController::class, 'getXML33']);
Route::post("admin/facturacion/getPDF", [FacturacionController::class, 'getPDF']);
Route::post("admin/facturacion/datosFacturar", [FacturacionController::class, 'datosFacturar']);
Route::post("admin/facturacion/datosFacturarTest", [FacturacionController::class, 'datosFacturarTest']);
Route::post("admin/facturacion/obtenerFacturasRel", [FacturacionController::class, 'obtenerFacturasRel']);
Route::post("admin/facturacion/obtenerPaises", [FacturacionController::class, 'obtenerPaises']);
Route::post("admin/facturacion/obtenerEmailPorCliente", [FacturacionController::class, 'obtenerEmailPorCliente']);
Route::post("admin/facturacion/enviarFactura", [FacturacionController::class, 'enviarFactura']);
Route::post("admin/facturacion/verVistaPreviaFactura",  [FacturacionController::class, 'verVistaPreviaFactura']);
Route::post("admin/facturacion/obtenerFacturasPorCliente",  [FacturacionController::class, 'obtenerFacturasPorCliente']);
Route::post("admin/facturacion/obtenerAbonosFactura",  [FacturacionController::class, 'obtenerAbonosFactura']);
Route::post("admin/facturacion/obtenerFacturaPago",  [FacturacionController::class, 'obtenerFacturaPago']);
Route::post("admin/facturacion/obtenerEstados",  [FacturacionController::class, 'obtenerEstados']);
Route::post("admin/facturacion/facturarTest", [FacturacionFacController::class, 'facturar']);
Route::post("admin/facturacion/obtenerMunicipios",  [FacturacionController::class, 'obtenerMunicipios']);
Route::get("admin/facturacion/cancelarTmp", [FacturacionFinKokController::class, 'cancelarFacturaFinkokTmp']);
Route::post("admin/facturacion/getEstados",  [FacturacionController::class, 'getEstados']);
Route::post("admin/facturacion/getMunicipio",  [FacturacionController::class, 'getMunicipio']);
Route::post("admin/facturacion/getProducts", [FacturacionController::class, 'getProducts']);
Route::get("admin/facturacion/importarXML", [FacturacionController::class, 'importarXML']);

Route::post("admin/facturacion/facturar40", [FacturacionFinKokController::class, 'facturar40']);
Route::post("admin/facturacion/facturasPorRelacionar", [FacturacionController::class, 'facturasPorRelacionar']);
Route::post("admin/facturacion/facturarPorConcepto40",  [FacturacionFinKokController::class, 'facturarPorConcepto40']);






//Handlers ProFact
/*
Route::post("admin/facturacion/facturar", [FacturacionController::class, 'facturar']);
Route::post("admin/facturacion/facturarPago",  [FacturacionController::class, 'facturarPago']);
Route::post("admin/facturacion/facturarPorConcepto",  [FacturacionController::class, 'facturarPorConcepto']);
Route::post("admin/nomina/timbrarNomina", [NominaController::class, 'timbrarNomina']);
*/


//Handlers Finkok
Route::post("admin/facturacion/facturar", [FacturacionFinKokController::class, 'facturar40']);
Route::post("admin/facturacion/facturarPago",  [FacturacionFinKokController::class, 'facturarPago']);
Route::post("admin/facturacion/facturarPago40",  [FacturacionFinKokController::class, 'facturarPago40']);
Route::post("admin/facturacion/facturarPorConcepto",  [FacturacionFinKokController::class, 'facturarPorConcepto']);
Route::get("admin/facturacion/registrarUsuario", [FacturacionFinKokController::class, 'registrarUsuario']);
Route::post("admin/nomina/timbrarNomina", [FacturacionFinKokController::class, 'timbrarNomina']);

Route::get("admin/facturacion/consultaFactura", [FacturacionFinKokController::class, 'checkarStatusFactura']);

//Handlers cancelacion
Route::post("admin/facturacion/cancelarFacturaPro", [FacturacionController::class, 'cancelarFactura']);
Route::post("admin/facturacion/cancelarFactura", [FacturacionFinKokController::class, 'cancelarFacturaFinkok']);


Route::get("admin/facturacion/cancelarFacturaTest", [FacturacionController::class, 'cancelarFacturaTest']);
Route::post("admin/facturacion/exportToExcelReport", [FacturacionController::class, 'exportToExcelReport']);

Route::post("admin/configuraciones/obtenerDatos", [ConfiguracionesController::class, 'obtenerDatos']);
Route::post("admin/configuraciones/obtenerDivisiones", [ConfiguracionesController::class, 'obtenerDivisiones']);
Route::post("admin/configuraciones/obtenerGrupos", [ConfiguracionesController::class, 'obtenerGrupos']);
Route::post("admin/configuraciones/obtenerClavesProdServ", [ConfiguracionesController::class, 'obtenerClavesProdServ']);
Route::post("admin/configuraciones/agregarProdServicio", [ConfiguracionesController::class, 'agregarProdServicio']);
Route::post("admin/configuraciones/obtenerUnidadesMedida", [ConfiguracionesController::class, 'obtenerUnidadesMedida']);
Route::post("admin/configuraciones/agregarUnidadMedida", [ConfiguracionesController::class, 'agregarUnidadMedida']);
Route::post("admin/configuraciones/guardarSerie", [ConfiguracionesController::class, 'guardarSerie']);
Route::post("admin/configuraciones/borrarSerie", [ConfiguracionesController::class, 'borrarSerie']);
Route::post("admin/configuraciones/actualizarLogotipo", [ConfiguracionesController::class, 'actualizarLogotipo']);
Route::get("admin/configuraciones/menu", [ConfiguracionesController::class, 'menu']);


Route::post("admin/conceptos/obtenerConceptos", [ConceptosController::class, 'obtenerConceptos']);
Route::post("admin/conceptos/obtenerConcepto", [ConceptosController::class, 'obtenerConcepto']);
Route::post("admin/conceptos/guardar", [ConceptosController::class, 'guardar']);
Route::post("admin/conceptos/borrarConcepto", [ConceptosController::class, 'borrarConcepto']);


Route::post("admin/nomina/listadoEmpleados", [NominaController::class, 'listadoEmpleados']);
Route::post("admin/nomina/borrarEmpleado", [NominaController::class, 'borrarEmpleado']);
Route::post("admin/nomina/obtenerDatosEmpleado", [NominaController::class, 'obtenerDatosEmpleado']);
Route::post("admin/nomina/borrarPercepcion", [NominaController::class, 'borrarPercepcion']);
Route::post("admin/nomina/guardarPercepcionDeduccion", [NominaController::class, 'guardarPercepcionDeduccion']);
Route::post("admin/nomina/guardarEmpleado", [NominaController::class, 'guardarEmpleado']);
Route::post("admin/nomina/datosNomina", [NominaController::class, 'datosNomina']);
Route::post("admin/nomina/guardarDatosNomina", [NominaController::class, 'guardarDatosNomina']);
Route::post("admin/nomina/listaPeriodos", [NominaController::class, 'listaPeriodos']);
Route::post("admin/nomina/obtenerPeriodo", [NominaController::class, 'obtenerPeriodo']);
Route::post("admin/nomina/obtenerEmpleadosNoEnPeriodo", [NominaController::class, 'obtenerEmpleadosNoEnPeriodo']);
Route::post("admin/nomina/agregarEmpleadosPeriodo", [NominaController::class, 'agregarEmpleadosPeriodo']);
Route::post("admin/nomina/eliminarEmpleadoPeriodo", [NominaController::class, 'eliminarEmpleadoPeriodo']);
Route::post("admin/nomina/obtenerDatosEmpleadoRecibo", [NominaController::class, 'obtenerDatosEmpleadoRecibo']);
Route::post("admin/nomina/guardarReciboNomina", [NominaController::class, 'guardarReciboNomina']);
Route::post("admin/nomina/borrarPercepcionRecibo", [NominaController::class, 'borrarPercepcionRecibo']);
Route::post("admin/nomina/guardarPercepcionDeduccionRecibo", [NominaController::class, 'guardarPercepcionDeduccionRecibo']);
Route::post("admin/nomina/guardarPeriodo", [NominaController::class, 'guardarPeriodo']);
Route::post("admin/nomina/uploadFile", [NominaController::class, 'uploadFile']);

Route::post("admin/asociados/getAsociados", [AsociadoController::class, 'getAsociados']);
Route::post("admin/asociados/getDataAsociado", [AsociadoController::class, 'getDataAsociado']);
Route::post("admin/asociados/agregarPaquete", [AsociadoController::class, 'agregarPaquete']);

Route::get("registroUsuario", [RegistroController::class, 'validarTokenRegistro']);

Route::get("loginSat", [TestController::class, 'doLogin']);
Route::get("importarProductosExcel", [TestController::class, 'importarProductosExcel']);

Route::get("copiarClientes", [ProveedorController::class, 'copiarClientes']);
