<style type="text/css">

#previewFactura{
	font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
	font-size: 12px;
	margin: 0;
	padding: 0;
	margin-bottom: 0;
	padding-bottom: 0;
	color: {{$factura->color}};
}

#previewFactura h3{
	color: #666666;
	font-size: 18px;
}


#previewFactura .maxWidth {
	width: 100%;
	margin: 0;
	padding: 0;
}


#previewFactura .text-center{
	text-align: center;
}
#previewFactura .text-right{
	text-align: right;
}
#previewFactura .float{
	display: inline-block;
}

#previewFactura .header{
	width: 100%;
	background: #EFF3F6;
}

#previewFactura .logo{
	display: inline-block;
	width: 40%;
	text-align: center;
}

#previewFactura .receptor{
	width: 100%;
	padding-top: 2mm;
}

#previewFactura .receptor .h2{
	font-weight: bold;
	font-size: 16px;
}
#previewFactura .receptor .h3{
	font-weight: bold;
	font-size: 14px;
}
#previewFactura .float{
	display: inline-block;
}
#previewFactura #total{
	background: {{$factura->color}};
	width: 50mm;
	font-size: 18px;
	color: #FFFFFF;
	text-align: center;
	padding: 4mm;
	font-weight: bold;
}
#previewFactura .f13{
	font-size: 13px;
}
#previewFactura .borderedTotales{
	border-bottom: 1px solid #E6E6E6;
}
#previewFactura .lastElements .title{
	background: #EFF3F6;
	padding-bottom: 2mm;
	padding-top: 2mm;
	text-align: center;
	font-weight: bold;
}

#previewFactura .lastElements .content{
	word-wrap: break-word; 
	overflow-wrap: break-word;
	background: #FFFFFF;
}
#previewFactura .infoCFDI {
	text-align: left;
}
#previewFactura .infoCFDI td, #previewFactura .infoCFDI th{
	padding-bottom: 1mm;
	padding-top: 1mm;
}
#previewFactura .tableProducts thead tr{
	padding: 0;
	margin: 0;
	background: #EFF3F6;
}

#previewFactura .tableProducts thead th, #previewFactura .tableProducts td{
	padding: 5px;
}

#previewFactura .tableProducts tbody td{
	border-bottom: 1px solid #E6E6E6;
}
#previewFactura .infoCFDIMobile{
	display: none;
}

#previewFactura .infoCFDI{
	display: block;
}

@media only screen and (max-width: 767px) {

	#previewFactura #total {
	        width: 100% !important;
		    margin-bottom: 10px !important;
		    float: none !important;
		    padding-left: 0px !important;
		    padding-right: 0px !important;
	}
	
	#previewFactura .header {
	    padding: 0 !important;
	}
	#previewFactura .datosInformativos{
		padding-bottom: 20px;
    	padding-left: 10px;
	}
	#previewFactura .infoCFDIMobile{
		display: block !important;
	}
	
	#previewFactura .infoCFDI{
		display: none;
	}
}

#previewFactura .datosInformativos {
    padding-left: 10px;
    padding-bottom: 15px;
}
#previewFactura .noFactura{
    font-size: 16px;
    font-weight: bold;
    color: red;
    padding-bottom: 10px;
}
</style>

<div id="previewFactura">
	<div class="header">
	
	
		<div id="total" style="float: right;">
			${{number_format ($factura->total, 2, '.', ',')}} {{$factura->moneda}}
		</div>
		
		<div class="datosInformativos">
		<div class="receptor">
			<div style="font-size: 20px; padding-top: 14px; font-weight: bold;">{{$factura->rFCRecep}} - {{$factura->nmbRecep}}</div>
		</div>
		
		<div style="padding-top: 10px;">
		<table cellspacing="0" cellpadding="0">
				<tr>
					<td colspan="2" class="noFactura">FACTURA {{$factura->serie}}{{$factura->noFactura}}</td>
				</tr>
				<tr>
					<td><strong>FECHA EMISIÓN: </strong></td>
					<td>{{$factura->timeStamp}}</td>
				</tr>
				<tr>
					<td><strong>TIPO DOCUMENTO: </strong></td>
					<td>{{$adicionales['tipoDocumento'][$factura->tipoDeComprobante]}}</td>
				</tr>
				<tr>
					<td><strong>USO DOCUMENTO: </strong></td>
					<td>{{$factura->usoCFDI}}</td>
				</tr>
			</table>
		</div>
		</div>
	</div>
	
	<table style="width: 100%;" class="tableProducts" cellspacing="0" cellpadding="0">
		<thead>
		<tr>
			<th>CANTIDAD</th>
			<th>PRODUCTO</th>
			<th>P.U</th>
			<th>PRECIO</th>
		</tr>
		</thead>
		<tbody>
		@foreach($factura->conceptos as $concepto)
		<tr>
			<td class="text-center">{{$concepto->qtyItem}}</td>
			<td>
				{{$concepto->unidadc['descripcion']}} - {{$concepto->dscItem}} ({{$concepto->clave}})
			</td>
			<td class="text-center">${{number_format ($concepto->montoNetoItem, 2, '.', ',')}}</td>
			<td class="text-center">${{number_format ($concepto->prcNetoItem, 2, '.', ',')}}</td>
		</tr>
	@endforeach
		</tbody>
		<tfoot>
			<tr>
				<td colspan="2"></td>
				<th class="text-right f13 borderedTotales">Subtotal:</th>
				<td class="text-center f13 borderedTotales">${{number_format ($factura->subtotal, 2, '.', ',')}}</td>
			</tr>
			
			@if($factura->descuento > 0)
			<tr>
				<td colspan="2"></td>
				<th class="text-right f13 borderedTotales">Descuento:</th>
				<td class="text-center f13 borderedTotales">${{number_format ($factura->descuento, 2, '.', ',')}}</td>
			</tr>
			@endif
			@foreach($factura->impuestosTrasladados as $impuesto)
			<tr>
				<td colspan="2"></td>
				<th class="text-right f13 borderedTotales">{{$adicionales['impuestos'][$impuesto->impuesto]}} (+):</th>
				<td class="text-center f13 borderedTotales">${{number_format ($impuesto->importe, 2, '.', ',')}}</td>
			</tr>
			@endforeach
			@foreach($factura->impuestosRetenidos as $impuesto)
			<tr>
				<td colspan="2"></td>
				<th class="text-right f13 borderedTotales">{{$adicionales['impuestos'][$impuesto->impuesto]}} (-):</th>
				<td class="text-center f13 borderedTotales">${{number_format ($impuesto->importe, 2, '.', ',')}}</td>
			</tr>
			@endforeach
			
			@foreach($factura->impuestosTrasladadosLcl as $impuesto)
			<tr>
				<td colspan="2"></td>
				<th class="text-right f13 borderedTotales">{{$impuesto->tipoImp}} (+):</th>
				<td class="text-center f13 borderedTotales">${{number_format ($impuesto->montoImp, 2, '.', ',')}}</td>
			</tr>
			@endforeach
			@foreach($factura->impuestosRetenidosLcl as $impuesto)
			<tr>
				<td colspan="2"></td>
				<th class="text-right f13 borderedTotales">{{$impuesto->tipoImp}} (-):</th>
				<td class="text-center f13 borderedTotales">${{number_format ($impuesto->montoImp, 2, '.', ',')}}</td>
			</tr>
			@endforeach
		</tfoot>
	</table>
	
	<div style="width: 100%; padding-top: 5mm;">
	
		<div class="lastElements" style="padding-bottom: 5mm;">
				<div class="title">Información del CFDI</div>
				<div class="content"  style="padding-left: 2mm;">
				
				<table class="infoCFDI">
						<tr>
							<td style="width: 110px;"><strong>Folio fiscal:</strong></td>
							<td style="width: 220px;">{{$factura->uUID}}</td>
							@if($factura->formaPago != '')
							<td><strong>Forma de pago:</strong></td>
							<td>{{$factura->formaPago}}</td>
							@endif
						</tr>
						<tr>
							<td><strong>No. de certificado:</strong></td>
							<td>{{$factura->noCertificado}}</td>
							<td><strong>Método de pago:</strong></td>
							<td>{{$factura->metodoDePago}}</td>
						</tr>
						<tr>
							<td><strong>Fecha certificación:</strong></td>
							<td>{{$factura->fechaTimbrado}}</td>
							@if($factura->condicionesDePago != '')
							<td><strong>Condiciones de pago:</strong></td>
							<td>{{$factura->condicionesDePago}}</td>
							@endif
						</tr>
						<tr>
							<td><strong>Importe con letra:</strong></td>
							<td colspan="2">{{$factura->cantidadLetra}} {{$factura->decimales}} /100 MN</td>
						</tr>
					</table>
					
					
					
					<table class="infoCFDIMobile">
						<tr>
							<td><strong>Folio fiscal:</strong></td>
							<td>{{$factura->uUID}}</td>
						</tr>
						<tr>
							<td><strong>Forma de pago:</strong></td>
							<td>{{$factura->formaPago}}</td>
						</tr>
						<tr>
							<td><strong>No. de certificado:</strong></td>
							<td>{{$factura->noCertificado}}</td>
						</tr>
						<tr>
							<td><strong>Método de pago:</strong></td>
							<td>{{$factura->metodoDePago}}</td>
						</tr>
						<tr>
							<td><strong>Fecha certificación:</strong></td>
							<td>{{$factura->fechaTimbrado}}</td>
						</tr>
						<tr>
							<td><strong>Condiciones de pago:</strong></td>
							<td>{{$factura->metodoDePago}}</td>
						</tr>
						<tr>
							<td><strong>Importe con letra:</strong></td>
							<td>{{$factura->cantidadLetra}} {{$factura->decimales}} /100 MN</td>
						</tr>
					</table>
					
				</div>
			</div>
	
	
			
	</div>
</div>
