<?php use chillerlan\QRCode\QRCode;?>
<!DOCTYPE html>
<html>
<head>
<style type="text/css">
@page *{
	margin: 0;
	padding: 0;
	margin-bottom: 0;
	padding-bottom: 0;
}

html, .nopadding {
	margin: 0;
	padding: 0;
}

body {
	font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
	font-size: 12px;
	margin: 0;
	padding: 0;
	margin-bottom: 0;
	padding-bottom: 0;
	color: {{$factura->color}};
}

h3{
	color: #666666;
	font-size: 18px;
}

.panelLeft {
	color: #FFF;
}

.maxWidth {
	width: 200mm;
	margin: 0;
	padding: 0;
}

.panelLeft {
	width: 50mm;
	display: inline-block;
}

.panelContent {
	width: 158mm;
	display: inline-block;
	padding-top: 5mm;
	padding-left: 1mm;
	padding-right: 2mm;
}

.rowData {
	text-align: center;
	vertical-align: middle;
	padding: 10px;
	height: 53mm;
}

.text-center{
	text-align: center;
}
.text-left{
	text-align: left;
}
.text-right{
	text-align: right;
}
#contenidoFactura{
	padding-bottom: 5mm;
	line-height: 5mm;
}
.float{
	float: left;
}
.width50{
	width: 49%;
}
.noBorder{
	border: none;
}
.title3{
	font-weight: bold;
	font-size: 22px;
	padding-top: 5px;
	padding-bottom: 15px;
}
.lineHeight{
	line-height: 5mm;
}

.header{
	width: 100%;
	background: #EFF3F6;
	padding: 5mm;
}

.logo{
	display: inline-block;
	width: 40%;
	text-align: center;
	padding-top: 4mm;
}
.logo img{
	width: 100%;
	display: inline-block;
	max-height: 28mm;
	max-width: 70mm;
}

.datosFacturas tr td{
    border-top: 1px solid #999999;
    padding-top: 1mm;
}
.datosFacturas tr th{
    padding-top: 1mm;
}
.datosFacturas tr th, .datosFacturas tr td{
    padding: 1mm;
}
.datosFacturas h3{
    padding-top: 0;
    padding-bottom: 0px;
    margin-bottom: 0px;
}
.receptor{
	width: 200mm;
	padding-top: 2mm;
}

.receptor .h2{
	font-weight: bold;
	font-size: 16px;
}
.receptor .h3{
	font-weight: bold;
	font-size: 14px;
}
.float{
	display: inline-block;
}
#total{
	background: {{$factura->color}};
	width: 50mm;
	font-size: 18px;
	color: #FFFFFF;
	text-align: center;
	padding: 4mm;
	font-weight: bold;
}
.rowProd{
	padding-top: 3mm;
	border-bottom: 1px solid #E6E6E6;
	padding-bottom: 3mm;
	font-size: 12px;
}
.rowProd small{
	font-size: 11px;
}
.f13{
	font-size: 13px;
	font-weight: bold;

}

.tableTotales td, .tableTotales th{
	padding-bottom: 2mm;
	padding-top: 2mm;
	margin: 0;
}
.borderedTotales{
	border-bottom: 1px solid #E6E6E6;
}
.lastElements .title{
	background: #EFF3F6;
	padding-bottom: 2mm;
	padding-top: 2mm;
	text-align: center;
	font-weight: bold;
}

.lastElements .content{
	word-wrap: break-word;
	overflow-wrap: break-word;
	background: #FFFFFF;
}
.infoCFDI {
	text-align: left;
}
.infoCFDI td, .infoCFDI th{
	padding-bottom: 1mm;
	padding-top: 1mm;
}
.rowHead{
    text-align: center;
    font-weight: bold;
    border: 1px solid #E6E6E6;
}
.tableProdD tr td{
	height: 5mm;
	border: 1px solid #E6E6E6;
	font-size: 10px;
}
.small{
    font-size: 10px;
}
</style>
</head>
<body>
	<div class="header">
		<div class="receptor">
			<table cellspacing="0" cellpadding="0">
                <tr>
                    <td>
                        <table cellspacing="0" cellpadding="0" class="text-center datosFacturas" style="width: 90%;">
                            <tr>
                                <th>FACTURA</th>
                                <th>FECHA EMISIÓN</th>
                            </tr>
                            <tr>
                                <td>{{$factura->serie}}{{$factura->noFactura}}</td>
                                <td>{{$factura->timeStamp}}</td>
                            </tr>
                            <tr>
                                <th style="padding-top: 3mm;">TIPO DOCUMENTO</th>
                                <th style="padding-top: 3mm;">USO DOCUMENTO</th>
                            </tr>
                            <tr>
                                <td>{{$adicionales['tipoDocumento'][$factura->tipoDeComprobante]}}</td>
                                <td>{{$factura->usoCFDI}}</td>
                            </tr>
                        </table>

                    </td>
                </tr>
				<tr>
					<td style="width: 150mm;">
						<div class="h2">(E) {{$factura->nmbEmisor}} <br> {{$factura->rFCEmisor}}</div>
						{{$factura->regimenFiscal}}<br />
						Lugar de expedición: {{$factura->lugarExpedicion}}
                        @if(!empty($factura->direccionProveedor))
                            - {{$factura->direccionProveedor}}
                        @endif

						<div class="h3" style="padding-top: 5mm;">(R) {{$factura->nmbRecep}} <br /> {{$factura->rFCRecep}}</div>
                        @if($factura->domicilioFiscalReceptor != '')
                            Domicilio: {{$factura->domicilioFiscalReceptor}}
                        @endif
                        @if(isset($factura->direccionCliente) && $factura->direccionCliente != '')
                            {{$factura->direccionCliente}}
                        @endif

                        @if(!empty($factura->regimenFiscalReceptor))
                            <br />Regimen fiscal: {{$factura->regimenFiscalReceptor}}
                        @endif

						@if($factura->tipoFacturasRelacionadas != '')
							<strong>Facturas relacionadas</strong><br />
							{{$factura->tipoFacturasRelacionadas}} - {{$factura->labelFacturasRelacionadas}}<br />
							@foreach($factura->facturasRelacionadas as $relacionada)
								{{$relacionada->uuid}}<br />
							@endforeach
						@endif
					</td>
					<td style="width: 50mm;">
						<div id="total">
							${{number_format ($factura->total, 2, '.', ',')}} {{$factura->moneda}}
						</div>
					</td>
				</tr>
			</table>
		</div>
	</div>



	<table cellspacing="0" cellpadding="0" style="width: 100%;" class="tableProdD">
		<tr>
			<td class="rowHead" style="width: 15mm;">CANT.</td>
			<td class="rowHead" style="width: 30mm;">C. PRODUCTO</td>
			<td class="rowHead">DESCRIPCION</td>
			<td class="rowHead" style="width: 20mm;">C. UNIDAD</td>
            @if($factura->version == '4.0')
            <td class="rowHead" style="width: 20mm;">OBJ. IMP</td>
            @endif
			<td class="rowHead" style="width: 25mm;">P. UNITARIO</td>
			<td class="rowHead" style="width: 25mm;">DESCUENTO</td>
			<td class="rowHead" style="width: 25mm;">IMPORTE</td>
		</tr>
	</table>
	@foreach($factura->conceptos as $concepto)
	<table cellspacing="0" cellpadding="0" style="width: 100%;" class="tableProdD">
		<tr>
			<td class="text-center" style="width: 15mm;">{{$concepto->qtyItem}}</td>
			<td class="text-center" style="width: 30mm;">{{$concepto->clave}}</td>
			<td>{{$concepto->dscItem}}</td>
			<td class="text-center" style="width: 20mm;">{{$concepto->unmdItem}}</td>
            @if($factura->version == '4.0')
            <td class="text-center" style="width: 20mm;">{{$concepto->objetoImp}}</td>
            @endif
			<td class="text-center" style="width: 25mm;">${{number_format ($concepto->montoNetoItem, 2, '.', ',')}}</td>
			<td class="text-center" style="width: 25mm;">${{number_format ($concepto->descuento, 2, '.', ',')}}</td>
			<td class="text-center" style="width: 25mm;">${{number_format ($concepto->prcNetoItem, 2, '.', ',')}}</td>
		</tr>
        @if(isset($concepto->alumno) && is_object($concepto->alumno))
        <tr>
            <td colspan="8">
                <strong>CURP:</strong> {{$concepto->alumno->curp}}
                <strong>Nombre alumno:</strong> {{$concepto->alumno->nombreAlumno}}
                <strong>Nivel educativo:</strong> {{$concepto->alumno->nivelEducativo}}
                <strong>Centro trabajo:</strong> {{$concepto->alumno->autRVOE}}</td>
        </tr>
        @endif
	</table>
	@endforeach

	<div style="padding-top: 2mm;">
	<table>
		<tr>
			<td style="width: 135mm; padding: 0; margin: 0; vertical-align: top;">
					@if(isset($factura->cuentaPredial) && $factura->cuentaPredial != '')
					<strong>Cuenta Predial: {{$factura->cuentaPredial}}</strong>
					@endif
			</td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >Subtotal:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($factura->subtotal, 2, '.', ',')}}</td>
		</tr>
		@if($factura->descuento > 0)
		<tr>
			<td></td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >Descuento:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($factura->descuento, 2, '.', ',')}}</td>
		</tr>
		@endif
		@foreach($factura->impuestosTrasladados as $impuesto)
		<tr>
			<td></td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >{{$adicionales['impuestos'][$impuesto->impuesto]}} {{$impuesto->tasaOCuota * 100}}% trasladado:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($impuesto->importe, 2, '.', ',')}}</td>
		</tr>
		@endforeach
		@foreach($factura->impuestosRetenidos as $impuesto)
		<tr>
			<td></td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >{{$adicionales['impuestos'][$impuesto->impuesto]}} retenido:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($impuesto->importe, 2, '.', ',')}}</td>
		</tr>
		@endforeach


		@if(isset($factura->impuestosTrasladadosLcl) && count($factura->impuestosTrasladadosLcl) > 0)
		@foreach($factura->impuestosTrasladadosLcl as $impuesto)
		<tr>
			<td></td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >{{$impuesto->tipoImp}} trasladado:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($impuesto->montoImp, 2, '.', ',')}}</td>
		</tr>
		@endforeach
		@endif

		@if(isset($factura->impuestosRetenidosLcl) && count($factura->impuestosRetenidosLcl) > 0)
		@foreach($factura->impuestosRetenidosLcl as $impuesto)
		<tr>
			<td></td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >{{$impuesto->tipoImp}} retenido:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($impuesto->montoImp, 2, '.', ',')}}</td>
		</tr>
		@endforeach
		@endif
		<tr>
			<td></td>
			<th style="width: 50mm;" class="text-right f13 borderedTotales" >Total:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($factura->total, 2, '.', ',')}}</td>
		</tr>
	</table>
	</div>


	<div class="row" style="width: 100%; padding-top: 2mm;">

		<div class="lastElements" style="padding-bottom: 5mm;">
				<div class="title">Información del CFDI</div>
				<div class="content"  style="padding-left: 2mm;">

				<table class="infoCFDI">
						<tr>
							<td><strong>Folio fiscal:</strong></td>
							<td style="width: 60mm;">{{$factura->uUID}}</td>
							@if($factura->formaPago != '')
							<td style="width: 40mm;"><strong>Forma de pago:</strong></td>
							<td>{{$factura->formaPago}}</td>
							@endif
						</tr>
						<tr>
							<td><strong>No. de certificado:</strong></td>
							<td>{{$factura->noCertificado}}</td>
							<td><strong>No. de certificado SAT:</strong></td>
							<td>{{$factura->noCertificadoSAT}}</td>
						</tr>
						<tr>
							<td style="width: 40mm;"><strong>Método de pago:</strong></td>
							<td>{{$factura->metodoDePago}}</td>
							<td><strong>Fecha certificación:</strong></td>
							<td>{{$factura->fechaTimbrado}}</td>
						</tr>
						@if($factura->condicionesDePago != '' || $factura->nota != '')
						<tr>
							@if($factura->condicionesDePago != '')
							<td style="width: 40mm;"><strong>Condiciones de pago:</strong></td>
							<td>{{$factura->condicionesDePago}}</td>
							@endif
							@if($factura->nota != '')
							<td><strong>Nota:</strong></td>
							<td colspan="3">{{$factura->nota}}</td>
							@endif
						</tr>
						@endif

						<tr>
							<td><strong>Importe con letra:</strong></td>
							<td>{{$factura->cantidadLetra}} @if($factura->moneda == 'MXN')  Pesos @endif {{$factura->decimales}} /100
								@if($factura->moneda == 'MXN')  M.N. @endif
								@if($factura->moneda == 'USD') USD @endif</td>
                            <td><strong>Moneda:</strong></td>
                            <td>{{$factura->moneda}}</td>

                            @if(!empty($factura->exportacion))
                            <td><strong>Exportacion</strong></td>
                            <td>{{$factura->exportacion}}</td>
                            @endif
						</tr>
						<tr>
                            @if($factura->moneda == 'USD' && $factura->tipoCambio > 1)
							<td><strong>Tipo de cambio:</strong></td>
							<td>{{number_format (($factura->tipoCambio), 2, '.', ',')}}</td>
							@endif
						</tr>
					</table>

				</div>
			</div>


		<div class="lastElements" style="padding-bottom: 2mm;">
				<div class="title">Sello digital del CFDI</div>
				<div class="content small"  style="padding-left: 2mm; padding-right: 2mm;">{{$factura->sello}}</div>
			</div>
		<div class="lastElements" style="padding-bottom: 2mm;">
				<div class="title">Sello digital del SAT</div>
				<div class="content small"  style="padding-left: 2mm; padding-right: 2mm;">{{$factura->selloSAT}}</div>
			</div>

        @if(isset($factura->addenda))
        <div class="lastElements" style="padding-bottom: 2mm;">
            <div class="title">Addenda</div>
            <div class="content small"  style="padding-left: 2mm; padding-right: 2mm;">
                <table class="infoCFDI">
                    <tr>
                        <td><strong>Importe:</strong></td>
                        <td>{{$factura->addenda->Importe}}</td>
                        <td><strong>Periodo meses:</strong></td>
                        <td>{{$factura->addenda->PeriodoEnMeses}}</td>
                        <td><strong>Importe:</strong></td>
                        <td>{{$factura->addenda->Descripcion}}</td>
                    </tr>
                </table>
            </div>
        </div>
        @endif

		<div class="float" style="padding-left: 2mm; width: 40mm;">
            <img style="height: 40mm;" src="{{(new QRCode)->render($factura->qr)}}" alt="QR Code" />
		</div>
		<div class="float" style="width: 174mm;">
			<div class="lastElements">
				<div class="title">Cadena original del complemento de certificacion digital del SAT</div>
				<div class="content small" style="padding-right: 1mm;">||1.1|{{$factura->uUID}}|{{$factura->timeStamp}}|{{$factura->selloSAT}}|{{$factura->noCertificadoSAT}}||</div>
			</div>

		</div>
	</div>
	<div style="padding-left: 3mm; padding-top: 3mm;">
        Version: {{$factura->version}}<br />
        **Este documento es una representación impresa de un CFDI.</div>

</body>
</html>
