(function() {
    'use strict';

    angular
        .module('app.forms')
        .controller('ConceptosController', ConceptosController);

    ConceptosController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder'];

    function ConceptosController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder) {
        var vm = this;
        vm.conceptos = [];
        
        vm.dtOptions = DTOptionsBuilder.newOptions()
		.withOption('order', [1, 'desc'])
        .withDisplayLength(50);
        
        activate();

        ////////////////
        
        function activate() {

        	
        	vm.obtenerDatos = function(){
        	
	        	vm.loading = "whirl double-up";
	        	
	        	$http.post('/api/admin/conceptos/obtenerConceptos', {
					user : $rootScope.user
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {
						
						vm.loading = "";
						vm.conceptos = response.conceptos;
						
					}
					
				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					vm.loadingWare = "";
				  });
        	}
        	
        	vm.obtenerConcepto = function(id_concepto){
        		
        		$state.transitionTo('app.conceptoDetalle', {id: id_concepto});
        	
        	};
        	
        	vm.borrarConcepto = function(concepto){
        		
        		SweetAlert.swal({
                    title: 'Eliminar concepto',
                    text: 'Estás seguro de eliminar a ' + concepto.nmbRecep,
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#DD6B55',
                    confirmButtonText: 'Sí, elimínalo!',
                    cancelButtonText: 'No, cancelar!',
                    closeOnConfirm: false,
                    closeOnCancel: false
                }, function (isConfirm) {
                    if (isConfirm) {


                        $http.post('/api/admin/conceptos/borrarConcepto', {
                        	id_concepto: concepto.id_producto,
                            user: $rootScope.user
                        }).then(function (res) {
                            var response = res['data'];
                            if (response['success']) {
                            	
                            	for(var x = 0; x < vm.conceptos.length; x++){
                            		if(vm.conceptos[x].id_producto == concepto.id_producto){
                            			vm.conceptos.splice(x, 1);
                            			break;
                            		}
                            	}
                            	
                                SweetAlert.swal('Eliminado!', 'El concepto fue eliminado correctamente.', 'success');
                            }
                        });

                    } else {
                        SweetAlert.swal('Cancelado', 'El concepto NO fue eliminado :)', 'error');
                    }
                });
        		
        	};
        	
        	
        	vm.obtenerDatos();

        }
        
    }
})();


(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('ConceptoDetalleController', ConceptoDetalleController);

    ConceptoDetalleController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert'];

    function ConceptoDetalleController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert) {
        var vm = this;
        vm.concepto = {
        		nombre: '',
        		nmbRecep: '',
        		id_producto: 0,
        		codigo: 0,
        		precioU: 0
        };
        
        vm.clavesProducto = [];
		vm.unidadesMedida = [];
        
        activate();

        ////////////////
        
        function activate() {

        	
        	vm.obtenerDatos = function(){
        	
	        	vm.loading = "whirl double-up";
	        	
	        	var id_concepto = $stateParams.id;
	        	
	        	$http.post('/api/admin/conceptos/obtenerConcepto', {
					user : $rootScope.user,
					id_concepto: id_concepto
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {
						
						vm.loading = "";
						if(id_concepto > 0){
							vm.concepto = response.concepto;
							vm.concepto.precioU = Number(vm.concepto.precioU);
						}
						
						vm.clavesProducto = response.clavesProducto;
						vm.unidadesMedida = response.unidadesMedida;
						
					}
					
				}, function errorCallback(response) {
					vm.obtenerDatos();
				  });
        	}
        	
        	vm.obtenerConcepto = function(id_concepto){
        		
        		$state.transitionTo('app.concepto', {id: id_concepto});
        	
        	};
        	
        	vm.guardarDatos = function(){
        		
        		if(vm.concepto.clave == undefined || vm.concepto.clave == ''){
        			Notify.alert('Debe seleccionar una clave de producto o servicio.', {status: 'danger'});
        			return;
        		}
        		
        		if(vm.concepto.unidad == undefined || vm.concepto.unidad == ''){
        			Notify.alert('Debe seleccionar una unidad de medida.', {status: 'danger'});
        			return;
        		}
        		
        		if(vm.concepto.nombre == undefined || vm.concepto.nombre == ''){
        			Notify.alert('Debe ingresar la descripción del concepto.', {status: 'danger'});
        			return;
        		}
        		
        		
        		if(vm.concepto.precioU == undefined || vm.concepto.precioU == ''){
        			Notify.alert('Debe ingresar el importe del concepto.', {status: 'danger'});
        			return;
        		}
        		
        		vm.loading = "whirl double-up";
        		
        		
        		
	        		$http.post('/api/admin/conceptos/guardar', {
						user : $rootScope.user,
						concepto: vm.concepto
					}).then(function(res) {
						var response = res['data'];
						if (response['success']) {
							
							vm.loading = "";
							
							SweetAlert.swal('Concepto guardado', 'El concepto ha sido guardado correctamente.', 'success');
							
							$state.transitionTo('app.conceptos');
							
						}
						
					}, function errorCallback(response) {
						Notify.alert('Ocurrió un error.', {status: 'danger'});
						vm.loadingWare = "";
					  });
	        		
        	}
        	
        	
        	vm.obtenerDatos();

        }
        
    }
})();
