(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('AsociadosController', AsociadosController);

    AsociadosController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'ngDialog'];

    function AsociadosController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, ngDialog) {
        var vm = this;
        vm.asociados = [];
        vm.showAddButton = false;
        vm.proveedorPrincipal = {};
        vm.paqueteAsignado = {
        	foliosRestantes: 0,
        	folios: 0,
        	foliosAsignados: 0
        };

        activate();

        ////////////////

        function activate() {


        	vm.obtenerDatos = function(){

	        	vm.loading = "whirl double-up";

	        	$http.post('/api/admin/asociados/getAsociados', {
					user : $rootScope.user
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.asociados = response.asociados;
						if(response.paqueteAsignado != null){
							vm.paqueteAsignado = response.paqueteAsignado;
							vm.paqueteAsignado.foliosRestantes = vm.paqueteAsignado.folios - vm.paqueteAsignado.foliosAsignados;
						}
						vm.proveedorPrincipal = response.proveedorPrincipal;

						if(vm.proveedorPrincipal.asociado == 1 &&  vm.proveedorPrincipal.premium == 1 && vm.paqueteAsignado.foliosRestantes > 0){
							vm.showAddButton = true;
						}else if(vm.proveedorPrincipal.asociado == 1 &&  vm.proveedorPrincipal.premium == 0){
							vm.showAddButton = true;
						}

					}

				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					vm.loadingWare = "";
				  });
        	}

        	vm.obtenerAsociado = function(id_asociado){

        		$state.transitionTo('app.asociadoDetalle', {id: id_asociado});

        	};

        	vm.borrarAsociado = function(asociado){

        		SweetAlert.swal({
                    title: 'Eliminar asociado',
                    text: 'Estás seguro de eliminar a ' + asociado.proveedor.rFCEmisor,
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#DD6B55',
                    confirmButtonText: 'Sí, elimínalo!',
                    cancelButtonText: 'No, cancelar!',
                    closeOnConfirm: false,
                    closeOnCancel: false
                }, function (isConfirm) {
                    if (isConfirm) {


                        $http.post('/api/admin/asociados/borrarAsociado', {
                        	id_asociado: asociado.id_asociadosProveedor,
                            user: $rootScope.user
                        }).then(function (res) {
                            var response = res['data'];
                            if (response['success']) {

                            	for(var x = 0; x < vm.asociados.length; x++){
                            		if(vm.asociados[x].id_asociadosProveedor == asociado.id_asociadosProveedor){
                            			vm.asociados.splice(x, 1);
                            		}
                            	}

                                SweetAlert.swal('Deleted!', 'El asociado fue eliminado correctamente.', 'success');
                            }
                        });

                    } else {
                        SweetAlert.swal('Cancelado', 'El asociado NO fue eliminado :)', 'error');
                    }
                });

        	};


        	vm.agregarPaquete = function(asociado){

        		ngDialog.openConfirm({
                    template: 'addPaquete',
                    className: 'ngdialog-theme-default',
                    data: {asociado: asociado},
                    controller: 'AddPaquetesController',
                }).then(function (buscar) {
                }, function (state) {
                    if(state > 1){

                    	for(var x = 0; x < vm.asociados.length; x++){
                    		if(vm.asociados[x].id_asociadosProveedor == asociado.id_asociadosProveedor){
                    			vm.asociados[x].paquete = Number(vm.asociados[x].paquete) + Number(state);
                    			vm.asociados[x].restantes = vm.asociados[x].restantes + Number(state);

                    			vm.paqueteAsignado.foliosAsignados = Number(vm.paqueteAsignado.foliosAsignados) + Number(state);
                    			vm.paqueteAsignado.foliosRestantes = vm.paqueteAsignado.folios - vm.paqueteAsignado.foliosAsignados;
                    			break;
                    		}
                    	}
                    	Notify.alert('El paquete se agregó de forma correcta.', {status: 'success'});
                    }
                });

        	};

            vm.verDetallAsociado = function(asociado){
                ngDialog.openConfirm({
                    template: 'verDetalleAsociado',
                    className: 'ngdialog-theme-default',
                    data: {asociado: asociado},
                });

            };


        	vm.obtenerDatos();

        }

    }
})();



(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('AsociadoDetalleController', AsociadoDetalleController);

    AsociadoDetalleController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert'];

    function AsociadoDetalleController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert) {
        var vm = this;
        vm.proveedor = {rFCEmisor: '', nmbEmisor: '', codigoPostal: '', tipoPersona: '', regimenFiscal33: '', contacto: {email: '', telefono: ''}, domicilio: {curp: ''}, asociado: '0'  };
        vm.tipoPersona = [{label:'Persona Moral', id: '1'}, {label: 'Persona física', id: '2'}];
        vm.compartirCon = [{id_proveedor: $rootScope.user.id_proveedorPrincipal, rfc: $rootScope.user.rfc}];
        vm.files = [0,1];
        vm.cerFile = '';
        vm.counter = 0;
        vm.isPremium = 0;
        vm.isNuevo = false;
        vm.pass = '';
        vm.readonly = false;
        vm.password = '';

        activate();

        ////////////////

        function activate() {


        	vm.id_proveedor = $stateParams.id;

        	vm.obtenerDatos = function(){

	        	vm.loading = "whirl double-up";

	        	vm.counter++;

	        	$http.post('/api/admin/asociados/getDataAsociado', {
					user : $rootScope.user,
					id_proveedor: vm.id_proveedor
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						if(vm.id_proveedor > 0){
							vm.proveedor = response.proveedor;
							vm.readonly = true;
						}
						vm.catalogoregimenfiscal = response.catalogoregimenfiscal;
						vm.isPremium = response.isPremium;
						vm.noFoliosProveedor = response.noFoliosProveedor;

					}
				});
        	}

        	vm.guardarDatos = function(){

        		if(vm.proveedor.tipoPersona == undefined || vm.proveedor.tipoPersona == ''){
	        		Notify.alert('Debe seleccionar el tipo de persona.', {status: 'danger'});
	        		return;
	        	}

	        	if(vm.proveedor.regimenFiscal33 == undefined || vm.proveedor.regimenFiscal33 == ''){
	        		Notify.alert('Debe seleccionar su regimen fiscal.', {status: 'danger'});
	        		return;
	        	}

	        	if(vm.proveedor.id_proveedor == undefined){

	        		var val1 = $("#cerFileNew").val();
	            	var val2 = $("#keyFileNew").val();
	            	var password = $("#passwordNew").val();


	            	if(val1 == ''){
	            		Notify.alert('Debe seleccionar el archivo .cer', {status: 'danger'});
	            		return;
	            	}

	            	if(val2 == ''){
	            		Notify.alert('Debe seleccionar el archivo .key', {status: 'danger'});
	            		return;
	            	}

	            	if(password == ''){
	            		Notify.alert('Debe ingresar el password', {status: 'danger'});
	            		$("#password").focus();
	            		return;
	            	}

	        	}

	        	vm.loading = "whirl double-up";

	        	$http.post('/api/admin/proveedores/guardarMisDatos', {
					user : $rootScope.user,
					proveedor: vm.proveedor
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

                        vm.loading = "";

						if(vm.proveedor.id_proveedor == null || vm.proveedor.id_proveedor == undefined){
							vm.proveedor.id_proveedor = response.id_proveedor;
							vm.proveedor.certificados ={cerFile: '', keyFile: ''};
                            vm.password = response.pass;
							SweetAlert.swal('Usario dado de alta', 'Se dió de alta el usuario con la contraseña: ' + response.pass + ' ahora procederemos a cargar los folios.', 'success');
							vm.actualizarCertificado(true);
						}else{
							SweetAlert.swal('Datos guardados', 'Sus datos se han guardado de forma correcta', 'success');
						}
					}

				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					vm.loading = "";
				  });
        	}


        	vm.obtenerRegimenesFiscales = function(){

        		vm.proveedor.regimenFiscal33 = '';

	        	vm.loading = "whirl double-up";

	        	$http.post('/api/admin/proveedores/obtenerRegimenesFiscales', {
					user : $rootScope.user,
					tipo: vm.proveedor.tipoPersona
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.catalogoregimenfiscal = response.catalogoregimenfiscal;
					}

				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					vm.loading = "";
				  });
        	}


        	vm.obtenerDatos();

        }

        //Actualizar certificados
        $('#cerFile').on('change', prepareCerUpload);
        $('#keyFile').on('change', prepareKeyUpload);
        $('#cerFileNew').on('change', prepareCerUpload);
        $('#keyFileNew').on('change', prepareKeyUpload);

        function prepareCerUpload(event) {
        	vm.files[0] = event.target.files[0];
        }
        function prepareKeyUpload(event) {
        	vm.files[1] = event.target.files[0];
        }

        vm.actualizarCertificado = function(isNew)
        {

        	var cerFileField = 'cerFile';
        	var keyFileField = 'keyFile';
        	var password = 'password';

        	if(isNew == true){
        		cerFileField = 'cerFileNew';
            	keyFileField = 'keyFileNew';
            	password = 'passwordNew';
        	}

        	var val1 = $("#"+cerFileField).val();
        	var val2 = $("#"+keyFileField).val();
        	var password = $("#"+password).val();


        	if(val1 == ''){
        		Notify.alert('Debe seleccionar el archivo .cer', {status: 'danger'});
        		return;
        	}

        	if(val2 == ''){
        		Notify.alert('Debe seleccionar el archivo .key', {status: 'danger'});
        		return;
        	}

        	if(password == ''){
        		Notify.alert('Debe ingresar el password', {status: 'danger'});
        		$("#"+password).focus();
        		return;
        	}

        	vm.loadingCers = "whirl double-up";


            // Create a formdata object and add the files
            var data = new FormData();
            $.each(vm.files, function(key, value)
            {
                data.append(key, value);
            });

            data.append('id_proveedor', $rootScope.user.id_proveedor);
            data.append('id_proveedorAsoc', vm.id_proveedor);
            data.append('token', $rootScope.user.token);
            data.append('password', password);


            $.ajax({
                url: '/api/admin/proveedores/actualizarCertificado',
                type: 'POST',
                data: data,
                cache: false,
                dataType: 'json',
                processData: false, // Don't process the files
                contentType: false, // Set content type to false as jQuery will tell the server its a query string request
                success: function(data, textStatus, jqXHR)
                {

                	if(data.errorCode == 0){

                		$("#cerFile").val('');
                    	$("#keyFile").val('');
                    	$("#password").val('');

                		vm.proveedor.certificados.cerFile = data.cerFile;
                		vm.proveedor.certificados.keyFile = data.keyFile;

                		SweetAlert.swal('Certificado actualizado', 'Sus certificado se actualizó de forma correcta. La contraseña es: ' + vm.password, 'success');

                	}else{

                		Notify.alert(data.message, {status: 'danger'});

                	}
                	vm.loadingCers = "";
                },
                error: function(jqXHR, textStatus, errorThrown)
                {
                	Notify.alert('Ocurrió un error al cargar tu certificado. Vuelve a intentarlo nuevamente.', {status: 'danger'});
                	vm.loadingCers = "";
                }
            });
        };

    }
})();





(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('AddPaquetesController', AddPaquetesController);

    AddPaquetesController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function AddPaquetesController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {

    	$scope.noFolios = '';


    	$scope.agregarPaquete = function(){

    		if($scope.noFolios == '' || Number($scope.noFolios) <= 0){
    			Notify.alert('Debe agregar un número de folios válidos', {status: 'danger'});
    			return;
    		}

			if(Number($scope.noFolios) < 50){
				Notify.alert('El mínimo de folios para cargar por cuenta es de 50.', {status: 'danger'});
				return;
			}

    		$scope.loadingPaquete = "whirl double-up";

    		var request = {
    			id_asociado: $scope.ngDialogData.asociado.id_proveedorAsociado,
    			noFolios: $scope.noFolios,
    			id_proveedor: $scope.ngDialogData.asociado.id_proveedor
    		};

    		$http.post('/api/admin/asociados/agregarPaquete', {
				user : $rootScope.user,
				request: request
			}).then(function(res) {
				var response = res['data'];
				if (response['success']) {

					$scope.loadingPaquete = "";
					$scope.closeThisDialog($scope.noFolios);

				}

			}, function errorCallback(response) {
				Notify.alert('Ocurrió un error.', {status: 'danger'});
				$scope.loadingPaquete = "";
			  });
    	};

    }
})();
