# Documentación del Sistema de Facturación CFDI

Bienvenido a la documentación completa del sistema de facturación electrónica CFDI para México.

## 📚 Índice de Documentación

### Documentos Principales

1. **[01-OVERVIEW.md](01-OVERVIEW.md)** - Visión General del Sistema
   - Descripción del proyecto
   - Stack tecnológico
   - Estructura del proyecto
   - Flujo general de facturación
   - Tipos de comprobantes y complementos

2. **[02-XML-GENERATION-V40.md](02-XML-GENERATION-V40.md)** - Generación de XML CFDI 4.0
   - Método `createXML40()` detallado
   - Parámetros de entrada
   - Proceso de generación paso a paso
   - Estructura de todos los complementos
   - Validaciones importantes

3. **[03-FACTURAR40-CONTROLLER.md](03-FACTURAR40-CONTROLLER.md)** - Controlador de Facturación 4.0
   - Método `facturar40()` completo
   - Flujo de ejecución
   - Estructura del request
   - Procesamiento de conceptos e impuestos
   - Integración con Finkok
   - Persistencia en base de datos

4. **[04-DATABASE-MODELS.md](04-DATABASE-MODELS.md)** - Modelos de Base de Datos
   - Modelos Eloquent principales
   - Estructura de tablas
   - Relaciones entre modelos
   - Catálogos SAT
   - Convenciones de nomenclatura

5. **[05-COMPLEMENTOS.md](05-COMPLEMENTOS.md)** - Complementos CFDI
   - Pagos 2.0
   - Carta Porte 3.1
   - Nómina 1.2
   - Comercio Exterior 2.0
   - Impuestos Locales
   - INE, IEDU, Leyendas Fiscales
   - Addendas personalizadas

6. **[06-UTILS-HELPERS.md](06-UTILS-HELPERS.md)** - Utilidades y Funciones Helper
   - Utils.php - Funciones generales
   - XMLUtils.php - Generación de XML
   - NumeroLetra.php - Conversión de números
   - Constantes del sistema
   - Buenas prácticas

7. **[07-COMMON-WORKFLOWS.md](07-COMMON-WORKFLOWS.md)** - Flujos de Trabajo Comunes
   - Facturación estándar (Ingreso)
   - Notas de crédito (Egreso)
   - Recibos de pago
   - Nómina
   - Carta Porte
   - Comercio Exterior
   - Cancelación y reimpresión
   - Errores comunes y soluciones

## 🚀 Inicio Rápido

### Para Nuevos Desarrolladores

1. **Leer primero**: [01-OVERVIEW.md](01-OVERVIEW.md) para entender el sistema completo
2. **Entender el flujo**: [07-COMMON-WORKFLOWS.md](07-COMMON-WORKFLOWS.md) - Flujo de facturación estándar
3. **Estudiar el código**:
   - [02-XML-GENERATION-V40.md](02-XML-GENERATION-V40.md) - Cómo se genera el XML
   - [03-FACTURAR40-CONTROLLER.md](03-FACTURAR40-CONTROLLER.md) - Cómo se procesa la factura

### Para Implementar una Nueva Funcionalidad

1. **Revisar complementos**: [05-COMPLEMENTOS.md](05-COMPLEMENTOS.md)
2. **Consultar modelos**: [04-DATABASE-MODELS.md](04-DATABASE-MODELS.md)
3. **Usar utilidades**: [06-UTILS-HELPERS.md](06-UTILS-HELPERS.md)
4. **Seguir flujos**: [07-COMMON-WORKFLOWS.md](07-COMMON-WORKFLOWS.md)

## 🔑 Conceptos Clave

### CFDI (Comprobante Fiscal Digital por Internet)
Factura electrónica que cumple con los requisitos del SAT (Servicio de Administración Tributaria) de México.

### Versiones CFDI
- **3.2**: Deprecada (legacy)
- **3.3**: Estándar hasta 2022
- **4.0**: **Versión actual** (desde 2022)

### Tipos de Comprobante
- **I**: Ingreso (facturas de venta)
- **E**: Egreso (notas de crédito)
- **P**: Pago (complemento de pago)
- **N**: Nómina (recibos de nómina)
- **T**: Traslado (carta porte)

### Timbrado
Proceso de certificación del CFDI por un PAC (Proveedor Autorizado de Certificación). Este sistema usa **Finkok** como PAC.

### UUID
Folio Fiscal único asignado por el SAT al timbrar un CFDI.

## 📁 Archivos Principales del Código

```
app/
├── Commands/
│   ├── XMLUtils.php              ← Generación de XML CFDI
│   ├── Utils.php                 ← Utilidades generales
│   └── FacturacionApiFunctions.php
├── Http/Controllers/
│   └── FacturacionFinKokController.php  ← Controlador principal
└── Models/                       ← 104 modelos Eloquent
    ├── Factura.php
    ├── IdDoc.php
    ├── Concepto.php
    ├── ExImpuestos.php
    └── ...
```

## 🔄 Flujo Básico de Facturación

```
1. Usuario captura datos
   ↓
2. Frontend envía a API
   ↓
3. Controller valida certificado CSD
   ↓
4. Controller construye objeto de factura
   ↓
5. XMLUtils genera XML CFDI 4.0
   ↓
6. Se genera sello digital
   ↓
7. Se envía a Finkok para timbrado
   ↓
8. Finkok retorna UUID y sellos SAT
   ↓
9. Se guarda en base de datos
   ↓
10. Se retorna respuesta al usuario
```

## 🛠️ Stack Tecnológico

- **Backend**: Laravel 8.x (PHP 7.3+/8.0+)
- **Base de Datos**: MySQL/MariaDB
- **XML**: FluidXML
- **PDF**: DOMPDF
- **QR**: chillerlan/php-qrcode
- **PAC**: Finkok (SOAP)

## 📋 Complementos Implementados

- ✅ Pagos 2.0
- ✅ Carta Porte 3.1
- ✅ Nómina 1.2
- ✅ Comercio Exterior 2.0
- ✅ Impuestos Locales 1.0
- ✅ INE 1.1
- ✅ Instituciones Educativas (IEDU)
- ✅ Leyendas Fiscales
- ✅ Addendas personalizadas

## 🔍 Búsqueda Rápida

### ¿Cómo generar un CFDI 4.0?
→ [02-XML-GENERATION-V40.md](02-XML-GENERATION-V40.md)

### ¿Cómo procesar una factura?
→ [03-FACTURAR40-CONTROLLER.md](03-FACTURAR40-CONTROLLER.md)

### ¿Cómo funciona el complemento de Pagos?
→ [05-COMPLEMENTOS.md](05-COMPLEMENTOS.md#1-pagos-20)

### ¿Cómo se estructura la base de datos?
→ [04-DATABASE-MODELS.md](04-DATABASE-MODELS.md)

### ¿Qué funciones helper están disponibles?
→ [06-UTILS-HELPERS.md](06-UTILS-HELPERS.md)

### ¿Cómo hacer una nota de crédito?
→ [07-COMMON-WORKFLOWS.md](07-COMMON-WORKFLOWS.md#2-nota-de-crédito-egreso)

### ¿Cómo emitir nómina?
→ [07-COMMON-WORKFLOWS.md](07-COMMON-WORKFLOWS.md#4-nómina)

### ¿Cómo usar Carta Porte?
→ [07-COMMON-WORKFLOWS.md](07-COMMON-WORKFLOWS.md#5-carta-porte-transporte)

## ⚠️ Importante

### Certificados CSD
- Cada emisor requiere certificado CSD (.cer y .key)
- Los certificados deben estar activos (status=1)
- Validar vigencia antes de facturar

### Ambientes
- **Producción**: `https://facturacion.finkok.com`
- **Demo**: `https://demo-facturacion.finkok.com`

### Logs
Todas las operaciones de timbrado se registran en:
```
{DIR_LOGS}/YYYY-MM-DD.log
```

### Validaciones CFDI 4.0
- ✅ ObjetoImp obligatorio en conceptos
- ✅ Exportación obligatoria
- ✅ RegimenFiscalReceptor obligatorio
- ✅ DomicilioFiscalReceptor obligatorio

## 📞 Soporte

Para dudas sobre CFDI:
- Documentación oficial SAT: https://www.sat.gob.mx
- Catálogos SAT: http://omawww.sat.gob.mx/tramitesyservicios/
- Finkok: https://www.finkok.com

## 🔄 Actualizaciones

Este sistema se mantiene actualizado con:
- Últimas versiones de complementos SAT
- Nuevos catálogos y validaciones
- Mejoras de seguridad y performance

## 📝 Notas de Versiones

### CFDI 4.0 (Actual)
- Obligatorio desde 1 de enero de 2022
- Nuevos campos requeridos
- Complementos actualizados
- Catálogos ampliados

### Complemento Carta Porte 3.1
- Obligatorio desde 17 de julio de 2024
- Nuevos campos y validaciones
- IdCCP obligatorio

### Complemento Pagos 2.0
- Nodo Totales obligatorio
- ObjetoImpDR requerido
- Nuevos catálogos

---

**Última actualización**: Enero 2024  
**Versión de documentación**: 1.0  
**Sistema**: SISPAC v3
