# Sistema de Facturación CFDI - Visión General

## Descripción del Proyecto

Sistema de facturación electrónica para México que genera Comprobantes Fiscales Digitales por Internet (CFDI) cumpliendo con los estándares del SAT (Servicio de Administración Tributaria).

## Versiones CFDI Soportadas

- **CFDI 3.2** (Versión anterior - deprecada)
- **CFDI 3.3** (Versión estándar)
- **CFDI 4.0** (Versión actual y más reciente)

## Stack Tecnológico

### Backend
- **Framework**: Laravel 8.x
- **PHP**: ^7.3 | ^8.0
- **Base de datos**: MySQL/MariaDB (implícito por Laravel)

### Dependencias Principales
- `servo/fluidxml`: ^1.21 - Generación de XML
- `dompdf/dompdf`: ^1.0.0 - Generación de PDFs
- `phpoffice/phpspreadsheet`: ^1.15 - Manejo de Excel
- `chillerlan/php-qrcode`: ^4.3 - Generación de códigos QR
- `simplesoftwareio/simple-qrcode`: ^4.1 - Códigos QR adicionales
- `guzzlehttp/guzzle`: ^7.0.1 - Cliente HTTP

### Proveedor de Timbrado
- **Finkok** - Proveedor Autorizado de Certificación (PAC)
  - URL Producción: `https://facturacion.finkok.com/servicios/soap/stamp.wsdl`
  - URL Demo: `https://demo-facturacion.finkok.com/servicios/soap/stamp.wsdl`

## Estructura del Proyecto

```
sispacV3/
├── app/
│   ├── Commands/          # Clases de utilidades y lógica de negocio
│   │   ├── XMLUtils.php   # Generación de XML CFDI (3.2, 3.3, 4.0)
│   │   ├── Utils.php      # Funciones utilitarias generales
│   │   └── FacturacionApiFunctions.php
│   ├── Http/
│   │   └── Controllers/
│   │       └── FacturacionFinKokController.php  # Controlador principal de facturación
│   └── Models/            # Modelos Eloquent ORM (104 modelos)
├── routes/
│   ├── api.php           # Rutas de API
│   └── web.php           # Rutas web
├── database/             # Migraciones y seeders
├── html/                 # Frontend (331 items)
└── docs/                 # Documentación del sistema
```

## Componentes Principales

### 1. XMLUtils.php
Responsable de la generación de XML CFDI en todas sus versiones:
- `createXML32()` - CFDI versión 3.2 (deprecada)
- `createXML33()` - CFDI versión 3.3
- `createXML40()` - **CFDI versión 4.0 (actual)**

### 2. FacturacionFinKokController.php
Controlador que maneja el flujo completo de facturación:
- `facturar()` - Facturación CFDI 3.3
- `facturar40()` - **Facturación CFDI 4.0 (actual)**
- `facturarPorConcepto()` - Facturación por conceptos individuales
- Gestión de certificados CSD
- Integración con Finkok para timbrado
- Persistencia en base de datos

### 3. Utils.php
Funciones utilitarias del sistema:
- Formateo de números
- Validación de certificados
- Encriptación/desencriptación
- Obtención de datos de factura desde BD
- Gestión de nómina

## Flujo General de Facturación

```
1. Usuario ingresa datos de factura
   ↓
2. Validación de certificado CSD
   ↓
3. Construcción de datos de factura (conceptos, impuestos, etc.)
   ↓
4. Generación de XML con XMLUtils::createXML40()
   ↓
5. Generación de sello digital
   ↓
6. Envío a Finkok para timbrado (SOAP)
   ↓
7. Recepción de TimbreFiscalDigital (UUID, sellos SAT)
   ↓
8. Persistencia en base de datos (Factura, IdDoc, Totales, Conceptos, etc.)
   ↓
9. Retorno de resultado al usuario
```

## Tipos de Comprobantes Soportados

- **I** - Ingreso (facturas de venta)
- **E** - Egreso (notas de crédito)
- **P** - Pago (recibos de pago)
- **N** - Nómina (recibos de nómina)
- **T** - Traslado (carta porte)

## Complementos CFDI Implementados

1. **Pagos 2.0** - Complemento de recepción de pagos
2. **Nómina 1.2** - Recibos de nómina
3. **Comercio Exterior** (Versiones 1.1 y 2.0) - Exportación/importación
4. **Carta Porte** (Versiones 2.0, 3.0, 3.1) - Transporte de mercancías
5. **Impuestos Locales 1.0** - Impuestos estatales/municipales
6. **INE 1.1** - Donaciones a partidos políticos
7. **Instituciones Educativas (IEDU)** - Colegiaturas
8. **Leyendas Fiscales** - Leyendas especiales SAT
9. **Addendas personalizadas** - Fondo de garantía, etc.

## Configuración de Ambiente

### Variables de Entorno (.env)
- `DIR_LOGS` - Directorio para logs de timbrado
- `DIR_CERTS` - Directorio para certificados CSD

### Certificados CSD
Los Certificados de Sello Digital (CSD) son requeridos por cada emisor:
- Archivo .cer (certificado público)
- Archivo .key (llave privada)
- Contraseña de la llave privada

## Base de Datos

El sistema utiliza múltiples tablas para gestionar:
- Facturas y documentos
- Clientes y proveedores
- Conceptos e impuestos
- Certificados
- Nómina
- Complementos específicos

### Tablas Principales
- `Factura` - Datos generales de factura
- `IdDoc` - Datos del documento (serie, folio, UUID)
- `Totales` - Totales de la factura
- `Concepto` - Conceptos/productos facturados
- `ExImpuestos` - Impuestos por concepto y generales
- `Cliente` - Información de receptores
- `Proveedor` - Información de emisores
- `CertificadosProveedor` - Certificados CSD

## Seguridad

- Validación de certificados CSD antes de facturar
- Encriptación de datos sensibles
- Generación de sellos digitales con RSA
- Logs de todas las operaciones de timbrado
- Validación de permisos por proveedor

## Próximas Secciones de Documentación

1. **Proceso de Generación XML 4.0** - Detalles técnicos del método createXML40
2. **Flujo de Facturación 4.0** - Detalles del método facturar40
3. **Modelos de Base de Datos** - Estructura y relaciones
4. **API y Endpoints** - Documentación de rutas
5. **Complementos Específicos** - Implementación de cada complemento
