<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class Quotation extends Model {

	protected $table = 'Quotation';

	public $timestamps = false;

	protected $primaryKey = 'id';
	
	public function employee(){
		return $this->hasOne('App\Models\Employee', 'id', 'id_employee');
	}
	
	public function customer(){
		return $this->hasOne('App\Models\Customer', 'id', 'id_customer');
	}
	
	public function details() {
		return $this->hasMany('App\Models\QuotationDetails', 'id_quotation', 'id');
	}
	
	public function detailsp() {
		return $this->hasMany('App\Models\QuotationDetails', 'id_quotation', 'id')->where('weight', '>', 0);
	}
	
	public function states() {
		return $this->hasMany('App\Models\QuotationStates', 'id_quotation', 'id')->orderBy('datetime', 'desc');
	}
	
	public function bill(){
		return $this->hasMany('App\Models\Bill', 'id_quotation', 'id');
	}
	
	public function remisiones(){
		return $this->hasMany('App\Models\Remision', 'id_quotation', 'id')->where('status', '=', 1);
	}

}
?>