<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class Proveedor extends Model {

	protected $table = 'Proveedor';

	public $timestamps = false;

	protected $primaryKey = 'id_proveedor';
	
	
	public function contacto(){
		return $this->hasOne('App\Models\ContactoEmisor', 'id_proveedor', 'id_proveedor');
	}
	
	public function domicilio(){
		return $this->hasOne('App\Models\DomFiscal', 'id_proveedor', 'id_proveedor');
	}
	
	
	public function paquetes() {
		return $this->hasMany('App\Models\PaqueteAsignado', 'id_proveedor', 'id_proveedor')->where('status', '=', 1);
	}
	
	public function certificados(){
		return $this->hasOne('App\Models\AdicionalesCancelacion', 'id_proveedor', 'id_proveedor')->where('status', '=', 1);
	}
	

}
?>