<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Response;
use App\Commands\Utils;
use App\Models\ClaveProdServ;
use App\Models\ClaveProdServProveedor;
use App\Models\Division;
use App\Models\Grupo;
use App\Models\Serie;
use App\Models\PaqueteAsignado;
use App\Models\Proveedor;
use App\Models\UnidadMedida;
use App\Models\UnidadMedidaProveedor;

use Illuminate\Support\Facades\DB;
use App\Models\AsociadosProveedor;
use App\Models\Multiusuario;
use App\Models\Factura;
use App\Models\CatalogoRegimenFiscal;
use App\Models\PaqueteAsignadoAsociado;

class AsociadoController extends BaseController {

	public function getAsociados(Request $request){

		$user = $request->input('user');

		$provedorMain = Proveedor::find($user['id_proveedorPrincipal']);
		$asociados = AsociadosProveedor::with('proveedor')->where('id_proveedorAsociado', '=', $user['id_proveedorPrincipal'])->where('status', '=', 1)->get();

		$paqueteAsignado = PaqueteAsignadoAsociado::where('id_proveedor', '=', $user['id_proveedor'])->where ( 'status', '=', 1 )->first();
		if(is_object($paqueteAsignado))
			$paqueteAsignado = $paqueteAsignado->toArray();


		if(count($asociados) > 0){
			foreach($asociados as $asociado){

				$multiusuario = Multiusuario::where('id_proveedorRel', '=', $asociado->id_proveedor)->where('status', '=', 1)->first();

				if(is_object($multiusuario)){

					$proveedor = $multiusuario->proveedor;
					$asociado->paquete = $proveedor->rFCEmisor;
				}else{

					$noFolios = PaqueteAsignado::where('id_proveedor', '=', $asociado->id_proveedor)->where('status', '=', 1)->sum('noFolios');

					$asociado->paquete = $noFolios;
					$asociado->restantes = 0;
				}
			}

			$asociados = $asociados->toArray();
		}



		return Response::json ( array (
			'success' => true,
			'asociados' => $asociados,
			'paqueteAsignado' => $paqueteAsignado,
		    'proveedorPrincipal' => $provedorMain->toArray()
		));
	}



	public function getDataAsociado(Request $request){

		$id_proveedor = $request->input('id_proveedor');
		$user = $request->input('user');

		$provedorMain = Proveedor::find($user['id_proveedorPrincipal']);

		$proveedor = Proveedor::with ( 'contacto', 'paquetes', 'certificados', 'domicilio' )->find ( $id_proveedor );
		$catalogoRegimen = CatalogoRegimenFiscal::where ( 'status', '=', 1 )->get ();

        $noFoliosProveedor = DB::table('PaqueteAsignado')
            ->select('id_proveedor', DB::raw('SUM(noFolios) as noFolios'))
            ->groupBy('id_proveedor')
            ->where('id_proveedor', '=', $user['id_proveedorPrincipal'])
            ->first();

		if(is_object($proveedor)){
			if(!is_object($proveedor->domicilio)){
				$domFiscal = DomFiscal();
				$domFiscal->id_proveedor = $id_proveedor;
				$domFiscal->save();
			}

			$proveedor = $proveedor->toArray ();
		}

		return Response::json ( array (
			'success' => true,
			'proveedor' => $proveedor,
			'catalogoregimenfiscal' => $catalogoRegimen->toArray (),
		    'isPremium' => $provedorMain->premium,
		    'noFoliosProveedor' => $noFoliosProveedor
		));
	}


	public function borrarAsociado(Request $request){

		$id_asociado = $request->input('id_asociado');

		AsociadosProveedor::where('id_asociadosProveedor', '=', $id_asociado)->update(['status' => 0]);

		return Response::json ( array (
			'success' => true
		));
	}

	public function agregarPaquete(Request $requestT){

		$request = $requestT->input('request');

		$user = $requestT->input('user');

		$paqueteAsignadoAsociado = PaqueteAsignadoAsociado::where('id_proveedor', '=', $user['id_proveedor'])->where ( 'status', '=', 1 )->first();

		$paqueteAsingado = new PaqueteAsignado();
		$paqueteAsingado->id_proveedorCrea = $user['id_proveedor'];
		$paqueteAsingado->id_proveedor = $request['id_proveedor'];
		$paqueteAsingado->noFolios = $request['noFolios'];
		$paqueteAsingado->fechaVigencia = date ( 'Y-m-d', strtotime ( '+364 day' ) );;
		$paqueteAsingado->fechaCreacion = date ( 'Y-m-d' );
		$paqueteAsingado->tipo = 1;
		$paqueteAsingado->status = 1;
		$paqueteAsingado->save();

		$paqueteAsignadoAsociado->foliosAsignados += $paqueteAsingado->noFolios;
		$paqueteAsignadoAsociado->save();


		return Response::json ( array (
			'success' => true
		));
	}

}

