<?php use chillerlan\QRCode\QRCode;?>
<!DOCTYPE html>
<html>
<head>
<style type="text/css">
@page *{
	margin: 0;
	padding: 0;
	margin-bottom: 0;
	padding-bottom: 0;
}

html, .nopadding {
	margin: 0;
	padding: 0;
}

body {
	font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
	font-size: 12px;
	margin: 0;
	padding: 0;
	margin-bottom: 0;
	padding-bottom: 0;
	color: {{$factura->color}};
}

h3{
	color: #666666;
	font-size: 18px;
}

.panelLeft {
	color: #FFF;
}

.maxWidth {
	width: 200mm;
	margin: 0;
	padding: 0;
}

.panelLeft {
	width: 50mm;
	display: inline-block;
}

.panelContent {
	width: 158mm;
	display: inline-block;
	padding-top: 5mm;
	padding-left: 1mm;
	padding-right: 2mm;
}

.rowData {
	text-align: center;
	vertical-align: middle;
	padding: 10px;
	height: 53mm;
}

.text-center{
	text-align: center;
}
.text-left{
	text-align: left;
}
.text-right{
	text-align: right;
}
#contenidoFactura{
	padding-bottom: 5mm;
	line-height: 5mm;
}
.float{
float: left;
}
.width50{
	width: 49%;
}
.noBorder{
	border: none;
}
.title3{
	font-weight: bold;
	font-size: 22px;
	padding-top: 5px;
	padding-bottom: 15px;
}
.lineHeight{
	line-height: 5mm;
}

.header{
	width: 100%;
	height: 35mm;
	background: #EFF3F6;
	padding: 2mm;
}

.logo{
	display: inline-block;
	width: 40%;
	text-align: center;
}
.logo img{
	width: 100%;
	display: inline-block;
	max-height: 28mm;
	max-width: 70mm;
}
.datosFacturas{
	display: inline-block;;
	width: 60%;
	height: 32mm;
}
.datosFacturas tr td{
	border-bottom: 1px solid #999999;
	padding-bottom: 1mm;
}
.datosFacturas tr th{
	padding-top: 1mm;
}
.datosFacturas tr th, .datosFacturas tr td{
	padding: 1mm;
}
.datosFacturas h3{
	padding-top: 0;
	padding-bottom: 0px;
	margin-bottom: 0px;
}
.receptor{
	width: 200mm;
	padding-top: 2mm;
}

.h2{
	font-weight: bold;
	font-size: 16px;
}
.h3{
	font-weight: bold;
	font-size: 14px;
}
#total{
	background: {{$factura->color}};
	width: 50mm;
	font-size: 18px;
	color: #FFFFFF;
	text-align: center;
	padding: 4mm;
	font-weight: bold;
}
.rowProd{
	padding-top: 3mm;
	border-bottom: 1px solid #E6E6E6;
	padding-bottom: 3mm;
	font-size: 12px;
}
.rowProd small{
	font-size: 11px;
}
.f13{
	font-size: 13px;
	font-weight: bold;

}

.tableTotales td, .tableTotales th{
	padding-bottom: 1mm;
	padding-top: 1mm;
	margin: 0;
}
.borderedTotales{
	border-bottom: 1px solid #E6E6E6;
}
.lastElements .title{
	background: #EFF3F6;
	padding-bottom: 2mm;
	padding-top: 2mm;
	text-align: center;
	font-weight: bold;
}

.lastElements .content{
	word-wrap: break-word;
	overflow-wrap: break-word;
	background: #FFFFFF;
}
.small{
    font-size: 10px;
}
.infoCFDI {
	text-align: left;
}
.infoCFDI td, .infoCFDI th{
	padding-bottom: 1mm;
	padding-top: 1mm;
}
.rowHead{
    text-align: center;
    font-weight: bold;
    border: 1px solid #E6E6E6;
}
.tableProdD tr td{
	height: 5mm;
	border: 1px solid #E6E6E6;
}
.colorRojo{
	color: red;
}
.borderBottom{
	border-bottom: 1px solid #999999;
	padding-bottom: 2mm;
}
.width100{
	width: 100%;
}
table tr td{
	vertical-align: top;
	text-align: left;
}
.pt{
	padding-top: 2mm;
}
.pb{
	padding-bottom: 2mm;
}
.backgroundBlue{
background: #EFF3F6;
}
</style>
</head>
<body>
	<div class="header">
		<div class="h2 borderBottom width100">
			RECIBO DE NÓMINA NO. <span class="colorRojo">{{$factura->serie}}{{$factura->noFactura}}</span>
		</div>

		<table cellspacing="0" cellpadding="0" style="width: 100%;">
				<tr>
					<td style="width: 100mm; vertical-align: top;">
						<div class="h3 pt">
							EMPLEADOR:
						</div>
						{{$factura->nmbEmisor}} <br> {{$factura->rFCEmisor}} <br />
						{{$factura->regimenFiscal}} <br />
						Registro patronal: {{$factura->nomina['Emisor']['RegistroPatronal']}} <br />
						Expedido en: {{$factura->lugarExpedicion}}

					</td>
					<td style="width: 100mm; vertical-align: top;">
						<div class="h3 pt">
							EMPLEADO:
						</div>
						{{$factura->nmbRecep}} <br /> {{$factura->rFCRecep}} <br />
						Uso CFDI: {{$factura->usoCFDI}} <br />
						CURP: {{$factura->nomina['Receptor']['Curp']}} <br />
						@if(isset($factura->nomina['Receptor']['NumSeguridadSocial']))
						NSS: {{$factura->nomina['Receptor']['NumSeguridadSocial']}} <br />
						@endif
						No. empleado: {{$factura->nomina['Receptor']['NumEmpleado']}} <br />
					</td>
				</tr>
			</table>

	</div>

	<div class="pt">
	<table cellspacing="0" cellpadding="0" style="width: 100%;">
		<tr style="padding-bottom: 2mm;">
			<th style="width: 100mm; padding-bottom: 2mm;" class="text-center">PERCEPCIONES</th>
			<th style="width: 100mm; padding-bottom: 2mm;" class="text-center">DEDUCCIONES</th>
		</tr>
		<tr>
			<td style="width: 100mm; vertical-align: top;">

				<table style="width: 100%; vertical-align: top;" cellspacing="0" cellpadding="0" class="tableProdD">
					<tr>
						<th class="text-center">Tipo</th>
						<th class="text-center">Clave</th>
						<th class="text-center">Concepto</th>
						<th class="text-center">Gravado</th>
						<th class="text-center">Excento</th>
					</tr>
					@foreach($factura->nomina['Percepciones']['listadoPercepciones'] as $percepcionObj)
					<tr>
						<td class="text-center">{{$percepcionObj['TipoPercepcion']}}</td>
						<td class="text-center">{{$percepcionObj['Clave']}}</td>
						<td>{{$percepcionObj['Concepto']}} @if($percepcionObj['TipoPercepcion'] == '019') ({{$percepcionObj['HorasExtra']}}hrs {{$adicionales['tipoHoras'][str_pad ( $percepcionObj['TipoHoras'], 2, "0", STR_PAD_LEFT )]}}) @endif</td>
						<td class="text-center">${{$percepcionObj['ImporteGravado']}}</td>
						<td class="text-center">${{$percepcionObj['ImporteExento']}}</td>
					</tr>
					@endforeach
					@foreach($factura->nomina['OtrosPagos']['listadoOtrosPagos'] as $percepcionObj)
						<tr>
							<td class="text-center">{{$percepcionObj['TipoOtroPago']}}</td>
							<td class="text-center">{{$percepcionObj['Clave']}}</td>
							<td>{{$percepcionObj['Concepto']}}</td>
							<td class="text-center"></td>
							<td class="text-center">${{$percepcionObj['Importe']}}</td>
						</tr>
					@endforeach
				</table>

			</td>
			<td style="width: 100mm; vertical-align: top;">

				<table style="width: 100%; vertical-align: top;" cellspacing="0" cellpadding="0" class="tableProdD">
					<tr>
						<th class="text-center">Tipo</th>
						<th class="text-center">Clave</th>
						<th class="text-center">Concepto</th>
						<th class="text-center">Importe</th>
					</tr>
					@foreach($factura->nomina['Deducciones']['listadoDeducciones'] as $deduccion)
					<tr>
						<td class="text-center">{{$deduccion['TipoDeduccion']}}</td>
						<td class="text-center">{{$deduccion['Clave']}}</td>
						<td>{{$deduccion['Concepto']}}</td>
						<td class="text-center">${{$deduccion['Importe']}}</td>
					</tr>
					@endforeach
					@if(count($factura->nomina['Incapacidades']['listadoIncapacidades']) > 0)
					<tr>
						<th>No días.</th>
						<th colspan="2">Tipo incapacidad</th>
						<th></th>
					</tr>
						@foreach($factura->nomina['Incapacidades']['listadoIncapacidades'] as $incapacidad)
						<tr>
							<td class="text-center">{{$incapacidad['DiasIncapacidad']}}</td>
							<td colspan="2">
							{{$adicionales['tipoIncapacidad'][str_pad ( $incapacidad['TipoIncapacidad'], 2, "0", STR_PAD_LEFT )]}}</td>
							<td class="text-center"></td>
						</tr>
						@endforeach
					@endif
				</table>

			</td>
		</tr>
	</table>
	</div>

	<div>


	<table cellspacing="0" cellpadding="0" class="tableTotales backgroundBlue" style="width: 100%;">
		<tr class="backgroundBlue">
			<th style="width: 30mm;" class="text-right f13 borderedTotales" >Subtotal:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($factura->subtotal, 2, '.', ',')}}</td>
		@if($factura->descuento > 0)
			<th style="width: 30mm;" class="text-right f13 borderedTotales" >Descuento:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($factura->descuento, 2, '.', ',')}}</td>
		@endif
		@foreach($factura->impuestosTrasladados as $impuesto)
			<th style="width: 30mm;" class="text-right f13 borderedTotales" >{{$adicionales['impuestos'][$impuesto->impuesto]}} {{$impuesto->tasaOCuota * 100}}% trasladado:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($impuesto->importe, 2, '.', ',')}}</td>
		@endforeach
		@foreach($factura->impuestosRetenidos as $impuesto)
			<th style="width: 30mm;" class="text-right f13 borderedTotales" >{{$adicionales['impuestos'][$impuesto->impuesto]}} retenido:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($impuesto->importe, 2, '.', ',')}}</td>
		@endforeach


		@if(isset($factura->impuestosTrasladadosLcl) && count($factura->impuestosTrasladadosLcl) > 0)
		@foreach($factura->impuestosTrasladadosLcl as $impuesto)
			<th style="width: 30mm;" class="text-right f13 borderedTotales" >{{$impuesto->tipoImp}} trasladado:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($impuesto->montoImp, 2, '.', ',')}}</td>
		@endforeach
		@endif

		@if(isset($factura->impuestosRetenidosLcl) && count($factura->impuestosRetenidosLcl) > 0)
		@foreach($factura->impuestosRetenidosLcl as $impuesto)
			<th style="width: 30mm;" class="text-right f13 borderedTotales" >{{$impuesto->tipoImp}} retenido:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($impuesto->montoImp, 2, '.', ',')}}</td>
		@endforeach
		@endif
			<th style="width: 30mm;" class="text-right f13 borderedTotales" >Total:</th>
			<td style="width: 30mm;" class="text-center f13 borderedTotales">${{number_format ($factura->total, 2, '.', ',')}}</td>
		</tr>
	</table>

	</div>

	<div class="row" style="width: 100%; padding-top: 2mm;">

		<div class="lastElements" style="padding-bottom: 2mm;">
				<div class="title">Nómina</div>
				<div class="content"  style="padding-left: 2mm;">

				<table class="infoCFDI" style="width: 100%;">
						<tr>
							<td><strong>Periodo desde:</strong></td>
							<td>{{$factura->nomina['FechaInicialPago']}}</td>
							<td><strong>Hasta:</strong></td>
							<td>{{$factura->nomina['FechaFinalPago']}}</td>
							<td><strong>Fecha pago:</strong></td>
							<td>{{$factura->nomina['FechaPago']}}</td>
						</tr>
						<tr>
							<td><strong>Fecha emisión:</strong></td>
							<td>{{$factura->timeStamp}}</td>
							<td><strong>No días pagados:</strong></td>
							<td>{{$factura->nomina['NumDiasPagados']}}</td>
							<td><strong>Tipo nómina:</strong></td>
							<td>{{$factura->nomina['TipoNomina']}}</td>
						</tr>
					</table>

				</div>
			</div>

			<div class="lastElements" style="padding-bottom: 2mm;">
				<div class="title">Información del CFDI</div>
				<div class="content"  style="padding-left: 2mm;">

				<table class="infoCFDI">
						<tr>
							<td><strong>Folio fiscal:</strong></td>
							<td style="width: 60mm;">{{$factura->uUID}}</td>
							@if($factura->formaPago != '')
							<td style="width: 40mm;"><strong>Forma de pago:</strong></td>
							<td>{{$factura->formaPago}}</td>
							@endif
						</tr>
						<tr>
							<td><strong>No. de certificado:</strong></td>
							<td>{{$factura->noCertificado}}</td>
							<td><strong>No. de certificado SAT:</strong></td>
							<td>{{$factura->noCertificadoSAT}}</td>
						</tr>
						<tr>
							<td style="width: 40mm;"><strong>Método de pago:</strong></td>
							<td>{{$factura->metodoDePago}}</td>
							<td><strong>Fecha certificación:</strong></td>
							<td>{{$factura->fechaTimbrado}}</td>
						</tr>
						@if($factura->condicionesDePago != '' || $factura->nota != '')
						<tr>
							@if($factura->condicionesDePago != '')
							<td style="width: 40mm;"><strong>Condiciones de pago:</strong></td>
							<td>{{$factura->condicionesDePago}}</td>
							@endif
							@if($factura->nota != '')
							<td><strong>Nota:</strong></td>
							<td colspan="3">{{$factura->nota}}</td>
							@endif
						</tr>
						@endif

						<tr>
							<td><strong>Importe con letra:</strong></td>
							<td colspan="2">{{$factura->cantidadLetra}} {{number_format ($factura->decimales, 2, '.', ',')}} /100
								@if($factura->moneda == 'MXN') Pesos MN @endif
								@if($factura->moneda == 'USD') USD @endif</td>
						</tr>
					</table>

				</div>
			</div>


		<div class="lastElements" style="padding-bottom: 2mm;">
				<div class="title">Sello digital del CFDI</div>
				<div class="content small"  style="padding-left: 2mm; padding-right: 2mm;">{{$factura->sello}}</div>
			</div>

		<div class="lastElements" style="padding-bottom: 2mm;">
				<div class="title">Sello digital del SAT</div>
				<div class="content small"  style="padding-left: 2mm; padding-right: 2mm;">{{$factura->selloSAT}}</div>
			</div>

		<div class="float" style="padding-left: 2mm; width: 40mm;">
            <img style="height: 40mm;" src="{{(new QRCode)->render($factura->qr)}}" alt="QR Code" />
		</div>
		<div class="float" style="width: 175mm;">
			<div class="lastElements">
				<div class="title">Cadena original del complemento de certificacion digital del SAT</div>
				<div class="content small" style="padding-right: 1mm;">||1.1|{{$factura->uUID}}|{{$factura->timeStamp}}|{{$factura->selloSAT}}|{{$factura->noCertificadoSAT}}||</div>
			</div>

		</div>
	</div>
	<div style="padding-left: 3mm; padding-top: 40mm;"><br />Se puso a mi disposición el archivo XML correspondiente y recibí de la empresa arriba mencionada la cantidad neta a que este documento se refiere estando conforme con las percepciones y deducciones que en él aparecen especificados.</div>

	<div style="text-align: center; width: 200mm;"><br /><br />_____________________________________ <br> Firma de conformidad del empleado</div>

	<div style="padding-left: 3mm; padding-top: 3mm;">**Este documento es una representación impresa de un CFDI.</div>

</body>
</html>
