<!DOCTYPE html>
<html>
<head>
<style type="text/css">
@page *{
	margin: 0;
	padding: 0;
	margin-bottom: 0;
	padding-bottom: 0;
}

html, .nopadding {
	margin: 0;
	padding: 0;
}

body {
	font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
	font-size: 11px;
	margin: 0;
	padding: 0;
	margin-bottom: 0;
	padding-bottom: 0;
	color: {{$factura->color}};
}

h3{
	color: #666666;
	font-size: 18px;
}

.panelLeft {
	color: #FFF;
}

.maxWidth {
	width: 200mm;
	margin: 0;
	padding: 0;
}

.panelLeft {
	width: 50mm;
	display: inline-block;
}

.rowData {
	text-align: center;
	vertical-align: middle;
	padding: 10px;
	height: 53mm;
}

.text-center{
	text-align: center;
}
.text-left{
	text-align: left;
}
.text-right{
	text-align: right;
}
#contenidoFactura{
	padding-bottom: 5mm;
	line-height: 5mm;
}
.float{
	display: inline-block;
}
.width50{
	width: 49%;
}
.noBorder{
	border: none;
}

.lineHeight{
	line-height: 5mm;
}

.header{
	width: 210mm;
	padding: 5mm;
}

.logo{
	display: inline-block;
	width: 40%;
	text-align: center;
	padding-top: 4mm;
}
.logo img{
	width: 100%;
	display: inline-block;
	max-height: 28mm;
	max-width: 70mm;
}
.datosFacturas{
	display: inline-block;;
	width: 60%;
	height: 25mm;
	padding-top: 10px;
}
.datosFacturas tr td{
	border-bottom: 1px solid #999999;
	padding-bottom: 1mm;
}
.datosFacturas tr th{
	padding-top: 1mm;
}
.datosFacturas tr th, .datosFacturas tr td{
	padding: 1mm;
}
.datosFacturas h3{
	padding-top: 0;
	padding-bottom: 0px;
	margin-bottom: 0px;
}
.receptor{
	width: 200mm;
	padding-top: 2mm;
}

.float{
	float: left;
}

.rowProd{
	padding-top: 3mm;
	border-bottom: 1px solid #E6E6E6;
	padding-bottom: 3mm;
	font-size: 11px;
}
.rowProd small{
	font-size: 11px;
}
.f13{
	font-size: 13px;
	font-weight: bold;

}

.tableTotales td, .tableTotales th{
	padding-bottom: 2mm;
	padding-top: 2mm;
	margin: 0;
}
.borderedTotales{
	border-bottom: 1px solid #E6E6E6;
}
.lastElements .title{
	padding-bottom: 2mm;
	padding-top: 2mm;
	text-align: center;
	font-weight: bold;
	float: left;
	width: 41mm;
}

.lastElements .content{
	word-wrap: break-word;
	overflow-wrap: break-word;
	float: left;
	width: 160mm;
	border-right: 1px solid #333333;
	padding-right: 2mm;
	font-size: 10px;
}

	.padding5{
		padding: 5mm;
	}
	.padding2{
		padding: 2mm;
	}
	.text-right{
		text-align: right;
	}
	.text-center{
		text-align: center;
	}
	.paddinglr2{
		padding-left: 2mm;
		padding-right: 2mm;
	}
	.colLeft{
		width: 170mm;
		border-right: 1px solid #333333;
		text-align: right;
		padding-right: 2mm;
	}
	.colLeftLast{
		width: 120mm;
		border-right: 1px solid #333333;
		text-align: right;
		padding-right: 2mm;
	}
	.colRightLast{
		width: 41mm;
		padding-left: 2mm;
	}
	.colRight{
		width: 41mm;
		padding-left: 2mm;
	}
	.padding1{
		padding: 1mm;
	}
	.cellConcepto{
		border-bottom: 1px solid #E6E6E6;
		font-size: 11px;
	}

	.lastElements .title{
		padding-bottom: 2mm;
		padding-top: 2mm;
		text-align: center;
		font-weight: bold;
		width: 210mm;
	}
	td{
		font-size: 11px;
	}
	.tableProd tr td{
		font-size: 11px;
	}

</style>
</head>
<body>
	<div style="padding: 2mm; line-height: 5mm; width: 201mm;">
		<div style="float: left; padding-top: 3mm; padding-left: 3mm;">
            @if($factura->base64 != '')
                <img src="{{$factura->base64}}" />
            @endif
		</div>
		<div style="width: 210mm; border-bottom: 1px solid #333333; padding-top: 3mm;">
			<table cellpadding="0" cellspacing="0">
				<tr>
					<td class="colLeft">{{$factura->serie}}{{$factura->noFactura}}</td>
					<td class="colRight"><strong>Factura</strong></td>
				</tr>
				<tr>
					<td class="colLeft">{{$factura->timeStamp}}</td>
					<td class="colRight"><strong>Fecha emisión</strong></td>
				</tr>
				<tr>
					<td class="colLeft">{{$adicionales['tipoDocumento'][$factura->tipoDeComprobante]}}</td>
					<td class="colRight"><strong>Tipo de documento</strong></td>
				</tr>
				<tr>
					<td class="colLeft">{{$factura->usoCFDI}}</td>
					<td class="colRight"><strong>Uso de documento</strong></td>
				</tr>
				<tr>
					<td class="colLeft">{{$factura->formaPago}}</td>
					<td class="colRight"><strong>Forma de pago</strong></td>
				</tr>
				<tr>
					<td class="colLeft">{{$factura->metodoDePago}}</td>
					<td class="colRight"><strong>Método de pago</strong></td>
				</tr>
				<tr>
					<td class="colLeft">{{$factura->nmbEmisor}} - {{$factura->rFCEmisor}}</td>
					<td class="colRight"><strong>Emisor</strong></td>
				</tr>
				<tr>
					<td class="colLeft" style="padding-bottom: 2mm;">{{$factura->nmbRecep}} - {{$factura->rFCRecep}}</td>
					<td class="colRight" style="padding-bottom: 2mm;"><strong>Receptor</strong></td>
				</tr>
			</table>

		</div>

			<table cellpadding="0" cellspacing="0">
				<tr>
					<th style="width: 15mm;" class="padding1 cellConcepto">Cantidad</th>
					<th style="width: 22mm;" class="padding1 cellConcepto">Clave SAT</th>
					<th style="width: 88mm;" class="padding1 cellConcepto">Descripción</th>
					<th style="width: 15mm;" class="padding1 cellConcepto">Clave U.</th>
					<th style="width: 20mm;" class="padding1 cellConcepto">P. Unitario</th>
					<th style="width: 20mm;" class="padding1 cellConcepto">Descuento</th>
					<th style="width: 20mm;" class="padding1 cellConcepto">Importe</th>
				</tr>
			</table>
				@foreach($factura->conceptos as $concepto)
					<table cellpadding="0" cellspacing="0" class="tableProd">
						<tr>
							<td style="width: 15mm;" class="padding1 cellConcepto">{{$concepto->qtyItem}}</td>
							<td style="width: 22mm;" class="padding1 cellConcepto">{{$concepto->clave}}</td>
							<td style="width: 88mm;" class="padding1 cellConcepto">{{$concepto->dscItem}}</td>
							<td style="width: 15mm;" class="padding1 cellConcepto">{{$concepto->unmdItem}}</td>
							<td style="width: 20mm;" class="padding1 cellConcepto">${{number_format ($concepto->montoNetoItem, 2, '.', ',')}}</td>
							<td style="width: 20mm;" class="padding1 cellConcepto">${{number_format ($concepto->descuento, 2, '.', ',')}}</td>
							<td style="width: 20mm;" class="padding1 cellConcepto">${{number_format ($concepto->prcNetoItem, 2, '.', ',')}}</td>
						</tr>
					</table>
				@endforeach

		<table cellpadding="0" cellspacing="0" class="tableProd">
			<tr>
				<td style="width: 170mm;" class="padding1">&nbsp;</td>
				<td style="width: 20mm;" class="padding1 cellConcepto"><strong>Subtotal:</strong></td>
				<td style="width: 20mm;" class="padding1 cellConcepto">${{number_format ($factura->subtotal, 2, '.', ',')}}</td>
			</tr>
			@if($factura->descuento > 0)
			<tr>
				<td style="width: 170mm;" class="padding1">&nbsp;</td>
				<td style="width: 20mm;" class="padding1 cellConcepto"><strong>Descuento:</strong></td>
				<td style="width: 20mm;" class="padding1 cellConcepto">${{number_format ($factura->descuento, 2, '.', ',')}}</td>
			</tr>
			@endif



			@foreach($factura->impuestosTrasladados as $impuesto)
				<tr>
					<td style="width: 170mm;" class="padding1">&nbsp;</td>
					<td style="width: 20mm;" class="padding1 cellConcepto"><strong>{{$adicionales['impuestos'][$impuesto->impuesto]}} {{$impuesto->tasaOCuota * 100}}% trasladado:</strong></td>
					<td style="width: 20mm;" class="padding1 cellConcepto">${{number_format ($impuesto->importe, 2, '.', ',')}}</td>
				</tr>
			@endforeach
			@foreach($factura->impuestosRetenidos as $impuesto)
				<tr>
					<td style="width: 170mm;" class="padding1">&nbsp;</td>
					<td style="width: 20mm;" class="padding1 cellConcepto"><strong>{{$adicionales['impuestos'][$impuesto->impuesto]}} retenido:</strong></td>
					<td style="width: 20mm;" class="padding1 cellConcepto">${{number_format ($impuesto->importe, 2, '.', ',')}}</td>
				</tr>
			@endforeach


			@if(isset($factura->impuestosTrasladadosLcl) && count($factura->impuestosTrasladadosLcl) > 0)
				@foreach($factura->impuestosTrasladadosLcl as $impuesto)
					<tr>
						<td style="width: 170mm;" class="padding1">&nbsp;</td>
						<td style="width: 20mm;" class="padding1 cellConcepto"><strong>{{$impuesto->tipoImp}} trasladado:</strong></td>
						<td style="width: 20mm;" class="padding1 cellConcepto">${{number_format ($impuesto->montoImp, 2, '.', ',')}}</td>
					</tr>
				@endforeach
			@endif

			@if(isset($factura->impuestosRetenidosLcl) && count($factura->impuestosRetenidosLcl) > 0)
				@foreach($factura->impuestosRetenidosLcl as $impuesto)
					<tr>
						<td style="width: 170mm;" class="padding1">&nbsp;</td>
						<td style="width: 20mm;" class="padding1 cellConcepto"><strong>{{$impuesto->tipoImp}} retenido:</strong></td>
						<td style="width: 20mm;" class="padding1 cellConcepto">${{number_format ($impuesto->montoImp, 2, '.', ',')}}</td>
					</tr>
				@endforeach
			@endif
			<tr>
				<td style="width: 170mm;" class="padding1">&nbsp;</td>
				<td style="width: 20mm;" class="padding1 cellConcepto"><strong>Total:</strong></td>
				<td style="width: 20mm;" class="padding1 cellConcepto">${{number_format ($factura->total, 2, '.', ',')}}</td>
			</tr>

		</table>

		<div style="width: 210mm; border-bottom: 1px solid #333333; border-top: 1px solid #333333;">
			<table cellpadding="0" cellspacing="0">
				<tr>
					<td class="colLeft" style="padding-top: 2mm;">{{$factura->noCertificado}}</td>
					<td class="colRight" style="padding-top: 2mm;"><strong>No. de certificado</strong></td>
				</tr>
				<tr>
					<td class="colLeft">{{$factura->noCertificadoSAT}}</td>
					<td class="colRight"><strong>No. de certificado SAT</strong></td>
				</tr>
				<tr>
					<td class="colLeft">{{$factura->fechaTimbrado}}</td>
					<td class="colRight"><strong>Fecha de certificación</strong></td>
				</tr>
				<tr>
					<td class="colLeft">{{$factura->uUID}}</td>
					<td class="colRight"><strong>Folio fiscal</strong></td>
				</tr>
				<tr>
					<td class="colLeft">{{$factura->cantidadLetra}} @if($factura->moneda == 'MXN')  Pesos @endif {{$factura->decimales}} /100
						@if($factura->moneda == 'MXN')  M.N. @endif
						@if($factura->moneda == 'USD') USD @endif</td>
					<td class="colRight" style="padding-bottom: 2mm;"><strong>Importe con letra</strong></td>
				</tr>
				<tr>
					<td class="colLeft" style="font-size: 9px; border-top: 1px solid #333333;">{{chunk_split($factura->sello, 90)}}</td>
					<td class="colRight" style="border-top: 1px solid #333333;"><strong style="font-size: 11px;">Sello digital del CFDI</strong></td>
				</tr>
				<tr>
					<td class="colLeft" style="font-size: 9px;">{{chunk_split($factura->selloSAT, 90)}}</td>
					<td class="colRight"><strong style="font-size: 11px;">Sello digital del SAT</strong></td>
				</tr>
				<tr>
					<td class="colLeft" style="font-size: 9px;">||1.1|{{$factura->uUID}}|{{$factura->timeStamp}}|{{chunk_split($factura->selloSAT,90)}}|{{$factura->noCertificadoSAT}}||</td>
					<td class="colRight"><strong style="font-size: 11px;">Sello digital del CFDI</strong></td>
				</tr>
			</table>
		</div>
		<div style="padding-top: 2mm;">**Este documento es una representación impresa de un CFDI.</div>



	</div>
</body>
</html>
