(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('NominaController', NominaController);

    NominaController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function NominaController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {
        var vm = this;
        vm.empleados = [];

        vm.dtOptions = DTOptionsBuilder.newOptions()
        .withDisplayLength(25);

        activate();

        ////////////////

        function activate() {


        	vm.obtenerDatos = function(){

	        	vm.loading = "whirl double-up";

	        	$http.post('/api/admin/nomina/listadoEmpleados', {
					user : $rootScope.user
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						var empleadosTmp = response.empleados;

						for(var key in empleadosTmp){
							vm.empleados.push(empleadosTmp[key]);
						}
						console.log(vm.empleados);
					}

				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					vm.loadingWare = "";
				  });
        	}

        	vm.obtenerEmpleado = function(id_empleado){

        		$state.transitionTo('app.empleado-details', {id: id_empleado});

        	};

        	vm.borrarEmpleado = function(empleado){

        		SweetAlert.swal({
                    title: 'Eliminar empleado',
                    text: 'Estás seguro de eliminar a ' + empleado.cliente.nmbRecep,
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#DD6B55',
                    confirmButtonText: 'Sí, elimínalo!',
                    cancelButtonText: 'No, cancelar!',
                    closeOnConfirm: false,
                    closeOnCancel: false
                }, function (isConfirm) {
                    if (isConfirm) {


                        $http.post('/api/admin/nomina/borrarEmpleado', {
                        	id_empleado: empleado.id_empleado,
                            user: $rootScope.user
                        }).then(function (res) {
                            var response = res['data'];
                            if (response['success']) {

                            	for(var x = 0; x < vm.empleados.length; x++){
                            		if(vm.empleados[x].id_empleado == empleado.id_empleado){
                            			vm.empleados.splice(x, 1);
                            		}
                            	}

                                SweetAlert.swal('Deleted!', 'El empleado fue eliminado correctamente.', 'success');
                            }
                        });

                    } else {
                        SweetAlert.swal('Cancelado', 'El empleado NO fue eliminado :)', 'error');
                    }
                });

        	};

            vm.importDocuments = function(){

                ngDialog.openConfirm({
                    template: 'importarEmpleados',
                    className: 'ngdialog-theme-default',
                    controller: 'ImportFileController',
                }).then(function (buscar) {
                }, function (state) {

                    if(state === 1){
                        SweetAlert.swal('Éxito!', 'El archivo se ha importado correctamente.', 'success');
                        $state.transitionTo('app.nomina', {}, {reload: true, inherit: false, notify: true});
                    }

                });

            };


        	vm.obtenerDatos();

        }

    }
})();



(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('EmpleadoDetailsController', EmpleadoDetailsController);

    EmpleadoDetailsController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function EmpleadoDetailsController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {
        var vm = this;
        vm.regimenesContratacion = [];
        vm.bancos = [];
        vm.riesgosPuesto = [];
        vm.tipoPercepciones = [];
        vm.tipoDeducciones = [];
        vm.isLiquidacion = false;
        vm.empleado = {
        		cliente: {rFCRecep: '', nmbRecep: ''}
        };
        vm.percepciones = [];
        vm.deducciones = [];

        activate();

        ////////////////

        function activate() {

        	var id_empleado = $stateParams.id;

        	$( ".datepicker" ).datepicker({dateFormat: "yy-mm-dd"});

        	vm.tipoJornada = [{codigo: '01', description: 'Diurna'},
        	                  {codigo: '02', description: 'Nocturna'},
        	                  {codigo: '03', description: 'Mixta'},
        	                  {codigo: '04', description: 'Por hora'},
        	                  {codigo: '05', description: 'Reducida'},
        	                  {codigo: '06', description: 'Continuada'},
        	                  {codigo: '07', description: 'Partida'},
        	                  {codigo: '08', description: 'Por turnos'},
        	                  {codigo: '99', description: 'Otra Jornada'}];

        	vm.tipoContrato = [
        		               {codigo: '', description: 'Ningúno'},
				               {codigo: '01', description: 'Contrato de trabajo por tiempo indeterminado'},
        	                   {codigo: '02', description: 'Contrato de trabajo para obra determinada'},
        	                   {codigo: '03', description: 'Contrato de trabajo por tiempo determinado'},
        	                   {codigo: '04', description: 'Contrato de trabajo por temporada'},
        	                   {codigo: '05', description: 'Contrato de trabajo sujeto a prueba'},
        	                   {codigo: '06', description: 'Contrato de trabajo con capacitación inicial'},
        	                   {codigo: '07', description: 'Modalidad de contratación por pago de hora laborada'},
        	                   {codigo: '08', description: 'Modalidad de trabajo por comisión laboral'},
        	                   {codigo: '09', description: 'Modalidades de contratación donde no existe relación de trabajo'},
        	                   {codigo: '10', description: 'Jubilación, pensión, retiro'},
        	                   {codigo: '99', description: 'Otro contrato'}];

        	vm.periodicidadPago = [{codigo: '01', description: 'Diario'},
        	                       {codigo: '02', description: 'Semanal'},
        	                       {codigo: '03', description: 'Catorcenal'},
        	                       {codigo: '04', description: 'Quincenal'},
        	                       {codigo: '05', description: 'Mensual'},
        	                       {codigo: '06', description: 'Bimestral'},
        	                       {codigo: '07', description: 'Unidad de obra'},
        	                       {codigo: '08', description: 'Comisión'},
        	                       {codigo: '09', description: 'Precio alzado'},
                                    {codigo: '10', description: 'Decenal'},
        	                       {codigo: '99', description: 'Otra periodicidad'}];


        	vm.estadosList = [{ codigo: 'AGU', description: 'Aguascalientes'},
			{ codigo: 'BCN', description: 'Baja California'},
			{ codigo: 'BCS', description: 'Baja California Sur'},
			{ codigo: 'CAM', description: 'Campeche'},
			{ codigo: 'COA', description: 'Coahuila'},
			{ codigo: 'COL', description: 'Colima'},
			{ codigo: 'CHP', description: 'Chiapas'},
			{ codigo: 'CHH', description: 'Chihuahua'},
			{ codigo: 'CMX', description: 'Ciudad de México'},
			{ codigo: 'DUR', description: 'Durango'},
			{ codigo: 'GUA', description: 'Guanajuato'},
			{ codigo: 'GRO', description: 'Guerrero'},
			{ codigo: 'HID', description: 'Hidalgo'},
			{ codigo: 'JAL', description: 'Jalisco'},
			{ codigo: 'MEX', description: 'México'},
			{ codigo: 'MIC', description: 'Michoacán de Ocampo'},
			{ codigo: 'MOR', description: 'Morelos'},
			{ codigo: 'NAY', description: 'Nayarit'},
			{ codigo: 'NLE', description: 'Nuevo León'},
			{ codigo: 'OAX', description: 'Oaxaca'},
			{ codigo: 'PUE', description: 'Puebla'},
			{ codigo: 'QUE', description: 'Querétaro'},
			{ codigo: 'ROO', description: 'Quintana Roo'},
			{ codigo: 'SLP', description: 'San Luis Potosí'},
			{ codigo: 'SIN', description: 'Sinaloa'},
			{ codigo: 'SON', description: 'Sonora'},
			{ codigo: 'TAB', description: 'Tabasco'},
			{ codigo: 'TAM', description: 'Tamaulipas'},
			{ codigo: 'TLA', description: 'Tlaxcala'},
			{ codigo: 'VER', description: 'Veracruz'},
			{ codigo: 'YUC', description: 'Yucatán'},
			{ codigo: 'ZAC', description: 'Zacatecas'}];

        	vm.tipoHoras = [{codigo: '01', description: 'Dobles'},
        	                {codigo: '02', description: 'Triples'},
        	                {codigo: '03', description: 'Simples'}];

        	vm.tipoIncapacidades = [{codigo: '02', description: 'Enfermedad en general'},
                	                {codigo: '03', description: 'Maternidad'},
                	                {codigo: '01', description: 'Riesgo de trabajo'}];


        	vm.obtenerDatos = function(){

	        	vm.loading = "whirl double-up";

	        	$http.post('/api/admin/nomina/obtenerDatosEmpleado', {
					user : $rootScope.user,
					id_empleado: id_empleado
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";

						vm.regimenesContratacion = response.regimenesContratacion;
				        vm.bancos = response.bancos;
				        vm.riesgosPuesto = response.riesgosPuesto;
				        vm.tipoPercepciones = response.tipoPercepciones;
				        vm.tipoDeducciones = response.tipoDeducciones;
                        vm.regimenesFiscalesList = response.regimenesFiscalesList;

				        if(id_empleado > 0){
					        vm.empleado = response.empleado;
					        vm.doCalcules();
				        }

					}

				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					vm.loadingWare = "";
				  });
        	}


        	vm.agregarPercepcionDeduccion = function(tipo, percepcionDeduccion){

        		var titulo = "Percepción";
        		var percepcionesDeducciones = vm.tipoPercepciones;
        		if(tipo == 2){
        			titulo = "Deducción";
        			percepcionesDeducciones = vm.tipoDeducciones;
        		}

        		if(percepcionDeduccion == null){
        			percepcionDeduccion = {
        				id_tipoPercepcionDeduccion: 0,
        				importeGravado: '',
        				importeExcento: '',
        				tipo: tipo,
        				id_empleado: vm.empleado.id_empleado
        			};
        		}

        		ngDialog.openConfirm({
                    template: 'percepcionDeduccion',
                    className: 'ngdialog-theme-default',
                    controller: 'PercepcionDeduccionController',
                    data: {percepcionesDeducciones: percepcionesDeducciones, titulo: titulo, percepcionDeduccion: percepcionDeduccion, tipo: tipo, tipoHoras: vm.tipoHoras,
                    	tipoIncapacidades: vm.tipoIncapacidades, id_empleado: vm.empleado.id_empleado},
                }).then(function (buscar) {
                }, function (state) {

                	if(state.id_percepcionDeduccion != undefined || state.id_percepcionDeduccion > 0){

                		if(state.tipo == 1){

                			if(state.isNew){
                				vm.empleado.percepciones.push(state);
                			}else{
                				for(var x = 0; x < vm.empleado.percepciones.length; x++){
                					if(vm.empleado.percepciones[x].id_percepcionDeduccion == state.id_percepcionDeduccion){
                						vm.empleado.percepciones[x] = state;
                					}
                				}
                			}

                		} else{

                			if(state.isNew){
                				vm.empleado.deducciones.push(state);
                			}else{

                				for(var x = 0; x < vm.empleado.deducciones.length; x++){
                					if(vm.empleado.deducciones[x].id_percepcionDeduccion == state.id_percepcionDeduccion){
                						vm.empleado.deducciones[x] = state;
                					}
                				}

                			}
                		}
                	}

                    vm.doCalcules();

                });
        	};

        	vm.doCalcules = function(){

        		vm.empleado.totalImporteGravadoPer = 0;
        		vm.empleado.totalImporteExcentoPer = 0;

        		vm.empleado.totalImporteGravadoDed = 0;
        		vm.empleado.totalImporteExcentoDed = 0;

                vm.isLiquidacion = false;

        		for(var x = 0; x < vm.empleado.percepciones.length; x++){
        			vm.empleado.totalImporteGravadoPer += Number(vm.empleado.percepciones[x].importeGravado);
        			vm.empleado.totalImporteExcentoPer += Number(vm.empleado.percepciones[x].importeExcento);
        		}

        		for(var x = 0; x < vm.empleado.deducciones.length; x++){

        			vm.empleado.totalImporteGravadoDed += Number(vm.empleado.deducciones[x].importeGravado);
        			vm.empleado.totalImporteExcentoDed += Number(vm.empleado.deducciones[x].importeExcento);

        		}

        		vm.empleado.totalPercepciones = vm.empleado.totalImporteGravadoPer + vm.empleado.totalImporteExcentoPer;
        		vm.empleado.totalDeducciones = vm.empleado.totalImporteGravadoDed + vm.empleado.totalImporteExcentoDed;

        	};

        	vm.deletePercepcionDeduccion = function(percepcion, tipo, index){

        		vm.loading = "whirl double-up";

        		$http.post('/api/admin/nomina/borrarPercepcion', {
					user : $rootScope.user,
					id_percepcionDeduccion: percepcion.id_percepcionDeduccion
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";

						if(tipo == 1){
							vm.empleado.percepciones.splice(index, 1);
						}else{
							vm.empleado.deducciones.splice(index, 1);
						}

						Notify.alert('Se ha eliminado de forma correcta.', {status: 'success'});

					    vm.doCalcules();

					}

				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					vm.loading = "";
				  });

        	};


        	vm.guardar = function(){

                if(vm.empleado.regimenFiscalReceptor !== '605'){
                    Notify.alert('El regimen fiscal debe ser siempre (605) 605 Sueldos y Salarios e Ingresos Asimilados a Salarios.', {status: 'danger'});
                    return;
                }

                if(!$rootScope.isValidCURP(vm.empleado.curp)){
                    Notify.alert('La CURP ingresada no tiene el formato esperado.', {status: 'danger'});
                    return;
                }

                vm.loading = "whirl double-up";

        		$http.post('/api/admin/nomina/guardarEmpleado', {
					user : $rootScope.user,
					empleado: vm.empleado
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";

						vm.empleado = response.empleado;

						SweetAlert.swal('Éxito!', 'Se guardó el empleado con éxito. ', 'success');

					}

				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					vm.loading = "";
				  });

        	};

        	vm.obtenerDatos();

        }

    }
})();


(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('PercepcionDeduccionController', PercepcionDeduccionController);

    PercepcionDeduccionController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder'];

    function PercepcionDeduccionController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder) {

    	var isNew = false;
    	if($scope.ngDialogData.percepcionDeduccion.id_percepcionDeduccion == undefined){
    		isNew = true;
    	}


    	$scope.guardarPercepcion = function(){

    		if($scope.ngDialogData.percepcionDeduccion.id_tipoPercepcionDeduccion == undefined || $scope.ngDialogData.percepcionDeduccion.id_tipoPercepcionDeduccion < 0){
    			Notify.alert('Debe seleccionar un tipo de percepción/deducción', {status: 'danger'});
    			return;
    		}


    		$http.post('/api/admin/nomina/guardarPercepcionDeduccion', {
				user : $rootScope.user,
				percepcionDeduccion: $scope.ngDialogData.percepcionDeduccion
			}).then(function(res) {
				var response = res['data'];
				if (response['success']) {

					$scope.loading = "";

					Notify.alert('Los datos se han guardado de forma correcta.', {status: 'success'});

					response.percepcionDeduccion.isNew = isNew;

					$scope.closeThisDialog(response.percepcionDeduccion);

				}

			}, function errorCallback(response) {
				Notify.alert('Ocurrió un error.', {status: 'danger'});
				$scope.loading = "";
			  });

    	};



    }
})();



(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('DatosNominaController', DatosNominaController);

    DatosNominaController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder'];

    function DatosNominaController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder) {

    	var vm = this;
    	vm.datosNomina = {};
    	vm.series = [];
        activate();

        function activate() {

        	vm.loading = "whirl double-up";

        	$http.post('/api/admin/nomina/datosNomina', {
				user : $rootScope.user
			}).then(function(res) {
				var response = res['data'];
				if (response['success']) {

					vm.loading = "";

					vm.datosNomina = response.datosNomina;
					vm.series = response.series;
					vm.formasPago = response.formasPago;

				}

			}, function errorCallback(response) {
				Notify.alert('Ocurrió un error.', {status: 'danger'});
				$scope.loading = "";
			  });


        	vm.guardar = function(){

        		$http.post('/api/admin/nomina/guardarDatosNomina', {
    				user : $rootScope.user,
    				datosNomina: vm.datosNomina
    			}).then(function(res) {
    				var response = res['data'];
    				if (response['success']) {

    					$scope.loading = "";
    					SweetAlert.swal('Éxito!', 'Se guardaron los datos con éxito. ', 'success');

    				}

    			}, function errorCallback(response) {
    				Notify.alert('Ocurrió un error.', {status: 'danger'});
    				$scope.loading = "";
    			  });

        	};

        };


    }
})();


(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('PeriodosNominaController', PeriodosNominaController);

    PeriodosNominaController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder'];

    function PeriodosNominaController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder) {

    	var vm = this;
    	vm.periodos = [];

    	vm.dtOptions = DTOptionsBuilder.newOptions()
    	.withOption('order', [1, 'desc'])
        .withDisplayLength(25);

        activate();

        function activate() {

        	vm.loading = "whirl double-up";

        	$http.post('/api/admin/nomina/listaPeriodos', {
				user : $rootScope.user
			}).then(function(res) {
				var response = res['data'];
				if (response['success']) {

					vm.loading = "";
					vm.periodos = response.periodos;

				}

			}, function errorCallback(response) {
				Notify.alert('Ocurrió un error.', {status: 'danger'});
				$scope.loading = "";
			  });


        	vm.obtenerPeriodo = function(id_periodo){
        		$state.transitionTo('app.periodo-details', {id: id_periodo});
        	};


        };


    }
})();



(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('PeriodosDetailNominaController', PeriodosDetailNominaController);

    PeriodosDetailNominaController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function PeriodosDetailNominaController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {

    	var vm = this;
    	vm.periodo = {nombre: '', fechaInicio: '', fechaFin: '', metodoPago: '', fechaPago: '', lugarExpedicion: '', TipoNomina: 'O'};
    	vm.formasPago = [];
    	vm.tiposNomina = [{code: 'O', description: 'Ordinaria'},
    	                  {code: 'E', description: 'Extraordinaria'}];
    	vm.isNewPeriodo = true;
    	vm.textFilter = '';
    	vm.selectData = true;

        activate();

        function activate() {

        	$( ".datepicker" ).datepicker({dateFormat: "yy-mm-dd"});

        	vm.loading = "whirl double-up";

        	var id_periodo = $stateParams.id;

        	if(id_periodo > 0)
        		vm.isNewPeriodo = false;

        	$http.post('/api/admin/nomina/obtenerPeriodo', {
				user : $rootScope.user,
				id_periodo: id_periodo,
				isNewPeriodo: vm.isNewPeriodo
			}).then(function(res) {
				var response = res['data'];
				if (response['success']) {

					vm.loading = "";
					vm.formasPago = response.formasPago;
					vm.datosNomina = response.datosNomina;

					if(id_periodo > 0){
						vm.periodo = response.periodo;
						vm.periodo.empleados = response.periodo.empleados2;
					}else{
						vm.periodo.empleadosN = response.listaEmpleados;
					}


				}

			}, function errorCallback(response) {
				Notify.alert('Ocurrió un error.', {status: 'danger'});
				$scope.loading = "";
			  });


        	vm.obtenerEmpleadosNoEnPeriodo = function(){

        		ngDialog.openConfirm({
                    template: 'AgregarEmpleadoTmpl',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'AgregarEmpleadoPeriodoController',
                    data: {id_periodo: vm.periodo.id_periodoNomina},
                }).then(function (buscar) {
                }, function (state) {

                	$state.transitionTo('app.periodo-details', {id: $stateParams.id}, {
						  reload: true, inherit: false, notify: true
						});
                });

        	};


        	vm.eliminarEmpleadoPeriodo = function(id_empleadoFac, index){

        		vm.loading = "whirl double-up";

        		$http.post('/api/admin/nomina/eliminarEmpleadoPeriodo', {
    				user : $rootScope.user,
    				id_empleadoFac: id_empleadoFac
    			}).then(function(res) {
    				var response = res['data'];
    				if (response['success']) {

    					vm.loading = "";
    					Notify.alert('El empleado se eliminó del periodo correctamente.', {status: 'success'});

    					vm.periodo.empleados.splice(index, 1);
    				}

    			}, function errorCallback(response) {
    				Notify.alert('Ocurrió un error.', {status: 'danger'});
    				$scope.loading = "";
    			  });

        	};

        	vm.verReciboNomina = function(id_empleadoFac){
        		$state.transitionTo('app.recibo-nomina', {id: id_empleadoFac});
        	}

        	vm.guardar = function(){

        		vm.loading = "whirl double-up";

        		$http.post('/api/admin/nomina/guardarPeriodo', {
    				user : $rootScope.user,
    				periodo: vm.periodo
    			}).then(function(res) {
    				var response = res['data'];
    				if (response['success']) {

    					vm.loading = "";
    					Notify.alert('El periodo se guardó correctamente.', {status: 'success'});

    					$state.transitionTo('app.periodo-details', {id: response.id_periodo}, {
  						  reload: true, inherit: false, notify: true
  						});

    				}

    			}, function errorCallback(response) {
    				Notify.alert('Ocurrió un error.', {status: 'danger'});
    				$scope.loading = "";
    			  });

        	};

        	vm.selectDeselectData = function(){

        		for(var x = 0; x < vm.periodo.empleadosN.length; x++){
        			vm.periodo.empleadosN[x].addNew = vm.selectData;
        		}

        	};

        	vm.obtenerXML = function(id_factura){
        		$("#id_facturaXML").val(id_factura);
        		$("#tokenXML").val($rootScope.user.token);
        		$("#id_proveedorXML").val($rootScope.user.id_proveedor);
        		$("#downloadXML").submit();
        	};

        	vm.obtenerPDF = function(id_factura){
        		$("#id_facturaPDF").val(id_factura);
        		$("#tokenPDF").val($rootScope.user.token);
        		$("#id_proveedorPDF").val($rootScope.user.id_proveedor);
        		$("#downloadPDF").submit();
        	};


        	vm.timbrar = function(){

        		ngDialog.openConfirm({
                    template: 'TimbrarNominaTmpl',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'TimbrarPeriodoController',
                    data: {periodo: vm.periodo},
                    showClose: false,
                    closeByEscape: false,
                    closeByNavigation : false,
                    closeByDocument : false
                }).then(function (buscar) {
                }, function (state) {

                	$state.transitionTo('app.periodo-details', {id: $stateParams.id}, {
						  reload: true, inherit: false, notify: true
						});
                });

        	};


        };


    }
})();


(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('AgregarEmpleadoPeriodoController', AgregarEmpleadoPeriodoController);

    AgregarEmpleadoPeriodoController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function AgregarEmpleadoPeriodoController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {

    	$scope.searchText = '';
    	$scope.loading = "whirl double-up";

    	$scope.obtenerDatos = function(){

    		$http.post('/api/admin/nomina/obtenerEmpleadosNoEnPeriodo', {
				user : $rootScope.user,
				id_periodo: $scope.ngDialogData.id_periodo
			}).then(function(res) {
				var response = res['data'];
				if (response['success']) {

					$scope.loading = "";
					$scope.empleados = response.empleados;

				}

			}, function errorCallback(response) {
				Notify.alert('Ocurrió un error.', {status: 'danger'});
				$scope.loading = "";
			  });

    	};


    	$scope.agregarEmpleados = function(){

    		$scope.loading = "whirl double-up";

    		$http.post('/api/admin/nomina/agregarEmpleadosPeriodo', {
				user : $rootScope.user,
				id_periodo: $scope.ngDialogData.id_periodo,
				empleados: $scope.empleados
			}).then(function(res) {
				var response = res['data'];
				if (response['success']) {

					$scope.loading = "";
					SweetAlert.swal('Éxito!', 'Se agregaron '+ response.noEmpleados +'  empleados con éxito. ', 'success');
					$scope.closeThisDialog(0);

				}

			}, function errorCallback(response) {
				Notify.alert('Ocurrió un error.', {status: 'danger'});
				$scope.loading = "";
			  });

    	};

    	$scope.obtenerDatos();


    }
})();


(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('ReciboNominaController', ReciboNominaController);

    ReciboNominaController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function ReciboNominaController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {
        var vm = this;
        vm.regimenesContratacion = [];
        vm.bancos = [];
        vm.riesgosPuesto = [];
        vm.tipoPercepciones = [];
        vm.tipoDeducciones = [];
        vm.empleado = {
        		cliente: {rFCRecep: '', nmbRecep: ''},
            isLiquidacion: false,
            liquidacion: {}
        };
        vm.percepciones = [];
        vm.deducciones = [];

        activate();

        ////////////////

        function activate() {

        	var id_empleadoFac = $stateParams.id;

        	$( ".datepicker" ).datepicker({dateFormat: "yy-mm-dd"});

        	vm.tipoJornada = [{codigo: '01', description: 'Diurna'},
        	                  {codigo: '02', description: 'Nocturna'},
        	                  {codigo: '03', description: 'Mixta'},
        	                  {codigo: '04', description: 'Por hora'},
        	                  {codigo: '05', description: 'Reducida'},
        	                  {codigo: '06', description: 'Continuada'},
        	                  {codigo: '07', description: 'Partida'},
        	                  {codigo: '08', description: 'Por turnos'},
        	                  {codigo: '99', description: 'Otra Jornada'}];

        	vm.tipoContrato = [
				{codigo: '', description: 'Ningúno'},
        					   {codigo: '01', description: 'Contrato de trabajo por tiempo indeterminado'},
        	                   {codigo: '02', description: 'Contrato de trabajo para obra determinada'},
        	                   {codigo: '03', description: 'Contrato de trabajo por tiempo determinado'},
        	                   {codigo: '04', description: 'Contrato de trabajo por temporada'},
        	                   {codigo: '05', description: 'Contrato de trabajo sujeto a prueba'},
        	                   {codigo: '06', description: 'Contrato de trabajo con capacitación inicial'},
        	                   {codigo: '07', description: 'Modalidad de contratación por pago de hora laborada'},
        	                   {codigo: '08', description: 'Modalidad de trabajo por comisión laboral'},
        	                   {codigo: '09', description: 'Modalidades de contratación donde no existe relación de trabajo'},
        	                   {codigo: '10', description: 'Jubilación, pensión, retiro'},
        	                   {codigo: '99', description: 'Otro contrato'}];

        	vm.periodicidadPago = [{codigo: '01', description: 'Diario'},
        	                       {codigo: '02', description: 'Semanal'},
        	                       {codigo: '03', description: 'Catorcenal'},
        	                       {codigo: '04', description: 'Quincenal'},
        	                       {codigo: '05', description: 'Mensual'},
        	                       {codigo: '06', description: 'Bimestral'},
        	                       {codigo: '07', description: 'Unidad de obra'},
        	                       {codigo: '08', description: 'Comisión'},
        	                       {codigo: '09', description: 'Precio alzado'},
                                    {codigo: '10', description: 'Decenal'},
        	                       {codigo: '99', description: 'Otra periodicidad'}];


        	vm.estadosList = [{ codigo: 'AGU', description: 'Aguascalientes'},
			{ codigo: 'BCN', description: 'Baja California'},
			{ codigo: 'BCS', description: 'Baja California Sur'},
			{ codigo: 'CAM', description: 'Campeche'},
			{ codigo: 'COA', description: 'Coahuila'},
			{ codigo: 'COL', description: 'Colima'},
			{ codigo: 'CHP', description: 'Chiapas'},
			{ codigo: 'CHH', description: 'Chihuahua'},
			{ codigo: 'CMX', description: 'Ciudad de México'},
			{ codigo: 'DUR', description: 'Durango'},
			{ codigo: 'GUA', description: 'Guanajuato'},
			{ codigo: 'GRO', description: 'Guerrero'},
			{ codigo: 'HID', description: 'Hidalgo'},
			{ codigo: 'JAL', description: 'Jalisco'},
			{ codigo: 'MEX', description: 'México'},
			{ codigo: 'MIC', description: 'Michoacán de Ocampo'},
			{ codigo: 'MOR', description: 'Morelos'},
			{ codigo: 'NAY', description: 'Nayarit'},
			{ codigo: 'NLE', description: 'Nuevo León'},
			{ codigo: 'OAX', description: 'Oaxaca'},
			{ codigo: 'PUE', description: 'Puebla'},
			{ codigo: 'QUE', description: 'Querétaro'},
			{ codigo: 'ROO', description: 'Quintana Roo'},
			{ codigo: 'SLP', description: 'San Luis Potosí'},
			{ codigo: 'SIN', description: 'Sinaloa'},
			{ codigo: 'SON', description: 'Sonora'},
			{ codigo: 'TAB', description: 'Tabasco'},
			{ codigo: 'TAM', description: 'Tamaulipas'},
			{ codigo: 'TLA', description: 'Tlaxcala'},
			{ codigo: 'VER', description: 'Veracruz'},
			{ codigo: 'YUC', description: 'Yucatán'},
			{ codigo: 'ZAC', description: 'Zacatecas'}];

        	vm.tipoHoras = [{codigo: '01', description: 'Dobles'},
        	                {codigo: '02', description: 'Triples'},
        	                {codigo: '03', description: 'Simples'}];

        	vm.tipoIncapacidades = [{codigo: '02', description: 'Enfermedad en general'},
        	                {codigo: '03', description: 'Maternidad'},
        	                {codigo: '01', description: 'Riesgo de trabajo'}];


        	vm.obtenerDatos = function(){

	        	vm.loading = "whirl double-up";

	        	$http.post('/api/admin/nomina/obtenerDatosEmpleadoRecibo', {
					user : $rootScope.user,
					id_empleadoFac: id_empleadoFac
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";

						vm.regimenesContratacion = response.regimenesContratacion;
				        vm.bancos = response.bancos;
				        vm.riesgosPuesto = response.riesgosPuesto;
				        vm.tipoPercepciones = response.tipoPercepciones;
				        vm.tipoDeducciones = response.tipoDeducciones;
                        vm.regimenesFiscalesList = response.regimenesFiscalesList;

					    vm.empleado = response.empleado;
                        vm.empleado.id_catalogoRegimenContratacion = parseInt(vm.empleado.id_catalogoRegimenContratacion);
                        vm.empleado.id_catalogoRiesgoPuesto = parseInt(vm.empleado.id_catalogoRiesgoPuesto);
                        vm.empleado.id_catalogoBancos = parseInt(vm.empleado.id_catalogoBancos);

					    vm.doCalcules();

					}

				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					vm.loadingWare = "";
				  });
        	}


        	vm.agregarPercepcionDeduccion = function(tipo, percepcionDeduccion){

        		var titulo = "Percepción";
        		var percepcionesDeducciones = vm.tipoPercepciones;
        		if(tipo == 2){
        			titulo = "Deducción";
        			percepcionesDeducciones = vm.tipoDeducciones;
        		}

        		if(percepcionDeduccion == null){
        			percepcionDeduccion = {
        				id_tipoPercepcionDeduccion: 0,
        				importeGravado: '',
        				importeExcento: '',
        				tipo: tipo,
        				id_empleadoFac: vm.empleado.id_empleadoFac
        			};
        		}

        		ngDialog.openConfirm({
                    template: 'percepcionDeduccion',
                    className: 'ngdialog-theme-default',
                    controller: 'PercepcionDeduccionReciboController',
                    data: {percepcionesDeducciones: percepcionesDeducciones, titulo: titulo, percepcionDeduccion: percepcionDeduccion, tipo: tipo,
                    		tipoHoras: vm.tipoHoras, tipoIncapacidades: vm.tipoIncapacidades, id_empleadoFac: vm.empleado.id_empleadoFac},
                }).then(function (buscar) {
                }, function (state) {

                	if(state.id_percepcionDeduccionFac != undefined || state.id_percepcionDeduccionFac > 0){

                		if(state.tipo == 1){

                			if(state.isNew){
                				vm.empleado.percepciones.push(state);
                			}else{
                				for(var x = 0; x < vm.empleado.percepciones.length; x++){
                					if(vm.empleado.percepciones[x].id_percepcionDeduccionFac == state.id_percepcionDeduccionFac){
                						vm.empleado.percepciones[x] = state;
                					}
                				}
                			}

                		} else{

                			if(state.isNew){
                				vm.empleado.deducciones.push(state);
                			}else{

                				for(var x = 0; x < vm.empleado.deducciones.length; x++){
                					if(vm.empleado.deducciones[x].id_percepcionDeduccionFac == state.id_percepcionDeduccionFac){
                						vm.empleado.deducciones[x] = state;
                					}
                				}

                			}
                		}
                	}

                    vm.doCalcules();

                });
        	};

        	vm.doCalcules = function(){

        		vm.empleado.totalImporteGravadoPer = 0;
        		vm.empleado.totalImporteExcentoPer = 0;

        		vm.empleado.totalImporteGravadoDed = 0;
        		vm.empleado.totalImporteExcentoDed = 0;

                vm.empleado.isLiquidacion = false;

        		for(var x = 0; x < vm.empleado.percepciones.length; x++){
        			vm.empleado.totalImporteGravadoPer += Number(vm.empleado.percepciones[x].importeGravado);
        			vm.empleado.totalImporteExcentoPer += Number(vm.empleado.percepciones[x].importeExcento);

                    if(vm.empleado.percepciones[x].tipopd.clave === '022' || vm.empleado.percepciones[x].tipopd.clave === '023'
                        || vm.empleado.percepciones[x].tipopd.clave === '025'){
                        vm.empleado.isLiquidacion = true;
                    }
        		}

        		for(var x = 0; x < vm.empleado.deducciones.length; x++){

        			vm.empleado.totalImporteGravadoDed += Number(vm.empleado.deducciones[x].importeGravado);
        			vm.empleado.totalImporteExcentoDed += Number(vm.empleado.deducciones[x].importeExcento);

        		}

        		vm.empleado.totalPercepciones = vm.empleado.totalImporteGravadoPer + vm.empleado.totalImporteExcentoPer;
        		vm.empleado.totalDeducciones = vm.empleado.totalImporteGravadoDed + vm.empleado.totalImporteExcentoDed;

        	};

        	vm.deletePercepcionDeduccion = function(percepcion, tipo, index){

        		vm.loading = "whirl double-up";

        		$http.post('/api/admin/nomina/borrarPercepcionRecibo', {
					user : $rootScope.user,
					id_percepcionDeduccionFac: percepcion.id_percepcionDeduccionFac
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";

						if(tipo == 1){
							vm.empleado.percepciones.splice(index, 1);
						}else{
							vm.empleado.deducciones.splice(index, 1);
						}

						Notify.alert('Se ha eliminado de forma correcta.', {status: 'success'});

					    vm.doCalcules();

					}

				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					vm.loading = "";
				  });

        	};


        	vm.guardar = function(){

                if(!$rootScope.isValidCURP(vm.empleado.curp)){
                    Notify.alert('La CURP ingresada no tiene el formato esperado.', {status: 'danger'});
                    return;
                }

                if(vm.empleado.regimenFiscalReceptor !== '605'){
                    Notify.alert('El regimen fiscal debe ser siempre (605) 605 Sueldos y Salarios e Ingresos Asimilados a Salarios.', {status: 'danger'});
                    return;
                }

        		vm.loading = "whirl double-up";

        		$http.post('/api/admin/nomina/guardarReciboNomina', {
					user : $rootScope.user,
					empleado: vm.empleado
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";

						vm.empleado = response.empleado;
                        vm.empleado.id_catalogoRegimenContratacion = parseInt(vm.empleado.id_catalogoRegimenContratacion);
                        vm.empleado.id_catalogoRiesgoPuesto = parseInt(vm.empleado.id_catalogoRiesgoPuesto);
                        vm.empleado.id_catalogoBancos = parseInt(vm.empleado.id_catalogoBancos);

						SweetAlert.swal('Éxito!', 'Se guardó el empleado con éxito. ', 'success');

						vm.doCalcules();

					}

				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					vm.loading = "";
				  });

        	};


        	vm.back = function(){
        		$state.transitionTo('app.periodo-details', {id: vm.empleado.id_periodoNomina});

        	}

        	vm.obtenerDatos();

        }

    }
})();


(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('PercepcionDeduccionReciboController', PercepcionDeduccionReciboController);

    PercepcionDeduccionReciboController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder'];

    function PercepcionDeduccionReciboController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder) {

    	var isNew = false;
    	if($scope.ngDialogData.percepcionDeduccion.id_percepcionDeduccionFac == undefined){
    		isNew = true;
    	}


    	$scope.guardarPercepcion = function(){

    		if($scope.ngDialogData.percepcionDeduccion.id_tipoPercepcionDeduccion == undefined || $scope.ngDialogData.percepcionDeduccion.id_tipoPercepcionDeduccion < 0){
    			Notify.alert('Debe seleccionar un tipo de percepción/deducción', {status: 'danger'});
    			return;
    		}


    		$http.post('/api/admin/nomina/guardarPercepcionDeduccionRecibo', {
				user : $rootScope.user,
				percepcionDeduccion: $scope.ngDialogData.percepcionDeduccion
			}).then(function(res) {
				var response = res['data'];
				if (response['success']) {

					$scope.loading = "";

					Notify.alert('Los datos se han guardado de forma correcta.', {status: 'success'});

					response.percepcionDeduccion.isNew = isNew;

					$scope.closeThisDialog(response.percepcionDeduccion);

				}

			}, function errorCallback(response) {
				Notify.alert('Ocurrió un error.', {status: 'danger'});
				$scope.loading = "";
			  });

    	};



    }
})();


(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('TimbrarPeriodoController', TimbrarPeriodoController);

    TimbrarPeriodoController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder'];

    function TimbrarPeriodoController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder) {

    	$scope.maxEmployees = $scope.ngDialogData.periodo.empleados.length;
    	$scope.titleProcess = '';
    	$scope.processComplete = false;

    	$scope.procesoTimbrar = function(index){

    		$scope.ngDialogData.periodo.empleados[index].process = 1;

    		$scope.titleProcess = $scope.ngDialogData.periodo.empleados[index].empleado.cliente.rFCRecep + ' - ' + $scope.ngDialogData.periodo.empleados[index].empleado.cliente.nmbRecep;

    		if($scope.ngDialogData.periodo.empleados[index].id_factura > 0){

    			$scope.ngDialogData.periodo.empleados[index].msj = 'Ya fue timbrado previamente.'
    			$scope.ngDialogData.periodo.empleados[index].process = 2;

    			if((index + 1) <  $scope.maxEmployees){
					$scope.procesoTimbrar(index + 1);
				}else{
					$scope.processComplete = true;
				}

    		}else{

    			var urlFacturar = '/api/admin/nomina/timbrarNomina';
				if($rootScope.user.id_proveedor == 943){
					urlFacturar = '/api/admin/nomina/timbrarNominaFinkok';
				}

    		$http.post(urlFacturar, {
				user : $rootScope.user,
				id_empleadoFac: $scope.ngDialogData.periodo.empleados[index].id_empleadoFac,
				id_periodo: $scope.ngDialogData.periodo.id_periodoNomina
			}).then(function(res) {
				var response = res['data'];
				if (response['success']) {

					if(response.errorCode == 0){
						$scope.ngDialogData.periodo.empleados[index].msj = 'Éxito'
						$scope.ngDialogData.periodo.empleados[index].process = 2;
					}else{
						$scope.ngDialogData.periodo.empleados[index].msj = response.errortext;
						$scope.ngDialogData.periodo.empleados[index].process = 3;
					}

					if((index + 1) <  $scope.maxEmployees){
						$scope.procesoTimbrar(index + 1);
					}else{
						$scope.processComplete = true;
					}

				}else{

					$scope.ngDialogData.periodo.empleados[index].process = 3;
					$scope.ngDialogData.periodo.empleados[index].msj = 'Ocurrió un error no esperado.';

					if((index + 1) <  $scope.maxEmployees){
						$scope.procesoTimbrar(index + 1);
					}else{
						$scope.processComplete = true;
					}

				}

			}, function errorCallback(response) {

				$scope.ngDialogData.periodo.empleados[index].process = 3;
				$scope.ngDialogData.periodo.empleados[index].msj = 'Ocurrió un error no esperado.';

				if((index + 1) <  $scope.maxEmployees){
					$scope.procesoTimbrar(index + 1);
				}else{
					$scope.processComplete = true;
				}


			  });

    		}

    	};

    	$scope.completarProcess = function(){

    		$scope.closeThisDialog(0);

    		$state.transitionTo('app.periodo-details', {id: $scope.ngDialogData.periodo.id_periodoNomina}, {
				  reload: true, inherit: false, notify: true
				});

    	}

    	$scope.procesoTimbrar(0);

    }
})();


(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('ImportFileController', ImportFileController);

    ImportFileController.$inject = ['$scope', '$http', '$state', '$stateParams',
        'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder'];

    function ImportFileController($scope, $http, $state, $stateParams, Notify,
                                  $rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder) {


        $scope.uploadFile = function (){


            var file_data = $('#fileToImport').prop('files')[0];

            if($scope.validateExtention(file_data)){

                $scope.loading = "whirl double-up";

                var form_data = new FormData();
                form_data.append('file', file_data);
                form_data.append('id_proveedor', $rootScope.user.id_proveedor);
                form_data.append('rfc', $rootScope.user.rfc);

                console.log(form_data);
                $.ajax({
                    url: '/api/admin/nomina/uploadFile', // point to server-side PHP script
                    dataType: 'json',  // what to expect back from the PHP script, if anything
                    cache: false,
                    contentType: false,
                    processData: false,
                    data: form_data,
                    type: 'post',
                    success: function(response){
                        $scope.loading = "";

                        if(response.success == true){

                            $scope.closeThisDialog(1);

                        }else{
                            Notify.alert('Hubo un error al cargar el archivo, vuelva a intentarlo.', {status: 'danger'});
                        }
                    }
                });
            }
        };


        $scope.validateExtention = function(file_data){

            var fileName = file_data.name;

            var extensionName = (/[.]/.exec(fileName)) ? /[^.]+$/.exec(fileName) : undefined;
            var isValidExtention = false;
            if(extensionName[0] == 'xls' || extensionName[0] == 'xlsx' ){
                isValidExtention = true;
            }else{
                Notify.alert('La extensión del archivo es inválida.', {status: 'danger'});
                return false;
            }

            if(file_data.size > 5242880){
                Notify.alert('La tamaño del archivo no debe exceder de 5MB.', {status: 'danger'});
                return false;
            }

            return true;
        };

    }
})();
