(function() {
    'use strict';

    angular
        .module('app.pages')
        .controller('LoginFormController', LoginFormController);

    LoginFormController.$inject = ['$http', '$state', '$rootScope', '$localStorage', 'Notify'];
    function LoginFormController($http, $state, $rootScope, $localStorage, Notify) {
        var vm = this;
		vm.account = {};
		vm.isUser = false;
		vm.isPass = false;
		vm.loadingWare = "";
		activate();
		
		function activate() {
			
			$localStorage.userLogin = undefined;
        	$rootScope.user = {
        			token: '',
        			id_proveedor: '',
        			rfc: ''
                };
			
			setTimeout(function(){$("#inputRFC").focus();}, 1500);
			
			vm.login = function(){
				
				vm.loadingWare = "whirl double-up";
				
				if(typeof vm.account.rfc === 'undefined' || vm.account.rfc == ""){
					vm.isUser = true;
					vm.loadingWare = "";
				}else if(typeof vm.account.password === 'undefined' || vm.account.password == ""){
					vm.isPass = true;
					vm.isUser = false;
					vm.loadingWare = "";
				}else{
					
					vm.isUser = false;
					vm.isPass = false;
					
					$http.post('/api/admin/login', {
						user : vm.account 
					}).then(function(res) {
						var response = res['data'];
						if (response['success']) {
							
							if ( response.login.token != "" && response.login.accessStatus == true) {

                                $rootScope.user.token = response.login.token;
                                $rootScope.user.id_proveedor = response.login.id_proveedor + '';
                                $rootScope.user.id_proveedorPrincipal = response.login.id_proveedor;
                                $rootScope.user.rfc = response.login.rfc;
                                
                                var date = new Date(), y = date.getFullYear(), m = date.getMonth();
                                var firstDay = new Date(y, m, 1);
                                var lastDay = new Date(y, m + 1, 0);
                                
                                $rootScope.filterDate ={
                                	initial: firstDay,
                                	end: lastDay,
                                	rfc: '',
                                	tipoDocumento: '',
                                	estatusDocumento: '1'
                                };

                                if (vm.account.remember) {

                                    $localStorage.userLogin.token = response.login.token;
                                    $localStorage.userLogin.id_proveedor = response.login.id_proveedor;
                                    $localStorage.userLogin.rfc = response.login.rfc;
                                }
					            
					            $state.transitionTo('app.home');
					            
							}else{
								vm.loadingWare = "";
								Notify.alert('Su RFC o contraseña son incorrectos', {status: 'danger'});
							}
						}
						
						
					}, function errorCallback(response) {
						Notify.alert('Ocurrió un error.', {status: 'danger'});
						vm.loadingWare = "";
					  });
					
				}
				
			}


		}
    }
})();