(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('FacturacionController', FacturacionController);

    FacturacionController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function FacturacionController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {
        var vm = this;
        vm.facturas = [];
        vm.proveedoresRelacionados = [];
        vm.count = 0;
        vm.puedeFacturar = false;
        vm.tipoEstatusDocumento = ['canceladas', 'activas'];

        vm.dtOptions = DTOptionsBuilder.newOptions()
		.withOption('order', [0, 'desc'])
        .withDisplayLength(50);

        activate();

        ////////////////

        function activate() {


        	vm.obtenerFacturas = function(){

	        	vm.loading = "whirl double-up";

	        	$rootScope.filterDate.initialS = prepareDateForServer($rootScope.filterDate.initial);
	        	$rootScope.filterDate.endS = prepareDateForServer($rootScope.filterDate.end);

	        	$http.post('/api/admin/facturacion/listadoFacturas', {
					user : $rootScope.user,
					filtro: $rootScope.filterDate,
					id_proveedorPrincipal : $rootScope.user.id_proveedorPrincipal
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.facturas = response.facturas;
						vm.proveedoresRelacionados = response.proveedoresRelacionados;
						vm.puedeFacturar = response.puedeFacturar;

					}

				}, function errorCallback(response) {

					if(vm.count >= 3){
						Notify.alert('Ocurrió un error al cargar las facturas, inténtelo más tarde.', {status: 'danger'});
					}else{
						vm.obtenerFacturas();
						vm.count++;
					}

				});
        	}


        	vm.buscarFactura = function(){

        		ngDialog.openConfirm({
                    template: 'filtroFacturas',
                    className: 'ngdialog-theme-default large-ngDialog',
                }).then(function (buscar) {
                    if (buscar == 1) {
                    	vm.obtenerFacturas();
                    }
                }, function (state) {

                });

        	};



        	vm.enviarFactura = function(factura){

        		ngDialog.openConfirm({
                    template: 'enviarFactura',
                    className: 'ngdialog-theme-default',
                    data: {factura: factura},
                    controller: 'EnviarFacturasController',
                }).then(function (buscar) {
                }, function (state) {
                    if(state == 1){
                    	Notify.alert('La factura se ha enviado de forma correcta.', {status: 'success'});
                    }
                });

        	};


        	vm.cancelarFactura = function(factura){

        		ngDialog.openConfirm({
                    template: 'cancelarFactura',
                    className: 'ngdialog-theme-default',
                    data: {factura: factura},
                    controller: 'CancelarFacturaController',
                }).then(function (buscar) {
                }, function (state) {
                    if(state == 1){
                    	Notify.alert('La factura se ha cancelado de forma correcta.', {status: 'success'});

                    	for(var x = 0; x < vm.facturas.length; x++){
                    		if(vm.facturas[x].id_factura == factura.id_factura){
                    			vm.facturas.splice(x, 1);
                    			break;
                    		}
                    	}
                    }
                });
        	};

        	vm.previewFactura = function(factura){

        		ngDialog.openConfirm({
                    template: 'previewFactura',
                    className: 'ngdialog-theme-default large-ngDialog no-padding-modal',
                    data: {id_factura: factura.id_factura},
                    controller: 'PreviewFacturaController',
                }).then(function (buscar) {
                }, function (state) {
                });
        	};


        	/*
        	vm.obtenerXML = function(id_factura, folio, serie, version){

        		var api = 'getXML';
        		if(version == '3.3'){
        			api = 'getXML33';
        		}

        		$http.post('/api/admin/facturacion/' + api, {
					user : $rootScope.user,
					id_factura: id_factura
				}).then(function(res) {
					var blob = new Blob([res.data]);
			        var link = document.createElement('a');
			        link.href = window.URL.createObjectURL(blob);
			        link.download = $rootScope.user.rfc + '-' + serie + folio + '.xml';
			        link.click();

				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					vm.loadingWare = "";
				  });

        	};
        	*/


        	vm.obtenerPDF = function(id_factura, folio, serie, version){
        		$("#id_factura").val(id_factura);
        		$("#token").val($rootScope.user.token);
        		$("#id_proveedor").val($rootScope.user.id_proveedor);
        		$("#downloadPDF").submit();
        	};

        	vm.obtenerXML = function(id_factura, folio, serie, version){
        		$("#id_facturaXML").val(id_factura);
        		$("#tokenXML").val($rootScope.user.token);
        		$("#id_proveedorXML").val($rootScope.user.id_proveedor);
        		$("#downloadXML").submit();
        	};

        	vm.generarPago = function(factura){
        		$state.transitionTo('app.nuevoPago', {id: factura.id_factura});
        	}

        	vm.cambiarUsuario = function(){

        		vm.loading = "whirl double-up";

        		$http.post('/api/admin/proveedores/getDataMultiusuario', {
					user : $rootScope.user,
					id_proveedor: $rootScope.user.id_proveedor
				}).then(function(res) {

					var response = res['data'];
					if (response['success']) {
						$rootScope.user.token = response.login.token;
                        $rootScope.user.id_proveedor = response.login.id_proveedor + '';
                        $rootScope.user.rfc = response.login.rfc;

                        var date = new Date(), y = date.getFullYear(), m = date.getMonth();
                        var firstDay = new Date(y, m, 1);
                        var lastDay = new Date(y, m + 1, 0);

                        $rootScope.filterDate ={
                        	initial: firstDay,
                        	end: lastDay,
                        	rfc: '',
                        	tipoDocumento: '',
                        	estatusDocumento: '1'
                        };
					}

					vm.obtenerFacturas();

				}, function errorCallback(response) {

				  });

        	};


        	vm.descargarExcel = function(){

        		$rootScope.filterDate.initialS = prepareDateForServer($rootScope.filterDate.initial);
	        	$rootScope.filterDate.endS = prepareDateForServer($rootScope.filterDate.end);

	        	$("#tokenExc").val($rootScope.user.token);
	        	$("#id_proveedorExc").val($rootScope.user.id_proveedor);
	        	$("#fechaInicial").val($rootScope.filterDate.initialS);
	        	$("#fechaFinal").val($rootScope.filterDate.endS);
	        	$("#estatusDocumento").val($rootScope.filterDate.estatusDocumento);
	        	$("#tipoDocumento").val($rootScope.filterDate.tipoDocumento);
	        	$("#rfcExc").val($rootScope.user.rfc);
	        	$("#rfcBusquedaExc").val($rootScope.filterDate.rfc);

	        	$("#downloadExcel").submit();

        	};

        	vm.obtenerFacturas();

        }


        function prepareDateForServer(dateObj) {

            if (dateObj instanceof Date) {

                var day = (dateObj.getDate() < 10) ? '0' + dateObj.getDate() : dateObj.getDate();
                var month = (dateObj.getMonth() < 9) ? '0' + (dateObj.getMonth() + 1) : (dateObj.getMonth() + 1);
                var year = dateObj.getFullYear();

                dateObj = year + '-' + month + '-' + day;

            }

            return dateObj;

        };
    }
})();


(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('NuevaFacturaController', NuevaFacturaController);

    NuevaFacturaController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog', '$timeout'];

    function NuevaFacturaController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog, $timeout) {
        var vm = this;

        vm.clientes = [];
        vm.formasDePago = [];
        vm.productos = [];
        vm.unidadesMedida = [];
		vm.clavesProducto = [];
		vm.usosCFDI = [];
		vm.addendas = [];
		vm.usosCFDITmp = [];
		vm.searchTextCustomer = '';
		vm.series = [];
		vm.lastSearch = '';
		vm.isLoadingCustomers = '';
        vm.emisor = {
            nombre: '',
            rfc: ''
        }
        vm.factura = {
            tipoDocumento: 'I',
        	id_cliente: '',
            decimales: '2',
        	impuestosRetenidos : [],
        	guardarProd: false,
        	impuestosTrasladados : [{factor: 'Tasa', valor: 0.16, impuesto: '002', label: 'IVA'}],
        	moneda: 'MXN',
        	tipoCambio: 1.0,
        	detalles: [],
        	descuento: 0,
        	facturasRelacionadas: {
            	tipoRelacion: '',
            	noFactura: '',
            	uuids: []
            },
        	cuentaPredial: '',
        	formaPago: '',
        	lugarExpedicion: '',
        	serie: 'A',
        	metodoDePago: 'PUE',
        	truncar: '0',
            exportacion: '01',
            versionF: '4.0',
            publico: {},
            norma: '',
            leyenda: '',
            ine:{},
            inbursa:{},
        }
        vm.productoAgregar = '';
        vm.complementoSeleccionado = '';
        vm.tipoRelaciones = [
                             {value: '01', label: 'Nota de crédito de los documentos relacionados'},
                             {value: '02', label: 'Nota de débito de los documentos relacionados'},
                             {value: '03', label: 'Devolución de mercancía sobre facturas o traslados previos'},
                             {value: '04', label: 'Sustitución de los CFDI previos'},
                             {value: '05', label: 'Traslados de mercancias facturados previamente'},
                             {value: '06', label: 'Factura generada por los traslados previos'},
                             {value: '07', label: 'CFDI por aplicación de anticipo'}
                            ];
        vm.metodosDePago = [{codigo: 'PUE', descripcion: 'Pago en una sola exhibición'}, {codigo: 'PPD', descripcion: 'Pago en parcialidades o diferido'}];
        vm.disableCp = false;

        vm.cambiarTipoDocumento = function(tipo){
        	vm.factura.tipoDocumento = tipo;
        	if(vm.factura.tipoDocumento == 'P')
        		$state.transitionTo('app.nuevoPago');
        };

        activate();

        ////////////////

        function activate() {

        	vm.obtenerNombreTipoRelacion = function(tipoRelacion){
        		for(var x = 0; x < vm.tipoRelaciones.length; x++){
        			if(vm.tipoRelaciones[x].value == tipoRelacion){
        				return vm.tipoRelaciones[x].label;
        			}
        		}
        	};


        	vm.obtenerDatos = function(){

        		if($stateParams.tipoDocumento != undefined && $stateParams.tipoDocumento != ''){
        			vm.factura.tipoDocumento = $stateParams.tipoDocumento;
        		}

	        	vm.loading = "whirl double-up";

	        	$http.post('/api/admin/facturacion/datosFacturar', {
					user : $rootScope.user
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.clientes = response.clientes;
						vm.formasDePago = response.formasDePago;
						vm.productos = response.productos;
						vm.unidadesMedida = response.unidadesMedida;
						vm.clavesProducto = response.clavesProducto;
						vm.usosCFDI = response.usosCFDI;
						vm.series = response.series;
						vm.factura.lugarExpedicion = response.proveedor.domicilio.codigoPostal;
						vm.usosCFDITmp = response.usosCFDI;
                        vm.addendas = response.addendas;
                        vm.regimenesFiscales = response.regimenesFiscales;
                        vm.tieneCartaPorte = response.tieneCartaPorte;
                        vm.tieneEscuelas = response.tieneEscuelas;
                        vm.emisor.rfc = response.proveedor.rFCEmisor;
                        vm.emisor.nombre = response.proveedor.nmbEmisor;
                        vm.tieneIne = response.tieneIne;
                        vm.tieneInbursa = response.tieneInbursa;

                        if(vm.clientes.length === 2000){

                            vm.isLoadingCustomers = '';
                            jQuery("#id_cliente_chosen").find('input').keyup(function() {

                                const customerFilter = this.value;
                                if($scope._timeout){ //if there is already a timeout in process cancel it
                                    $timeout.cancel($scope._timeout);
                                }

                                if(customerFilter.trim().length < 4 || customerFilter.trim() === vm.lastSearch.trim() || vm.isLoadingCustomers !== '')
                                    return

                                $scope._timeout = $timeout(function(){

                                    vm.isLoadingCustomers = 'whirl double-up';
                                    $http.post('/api/admin/facturacion/getCustomersByFilter', {
                                        customerFilter: customerFilter,
                                        user : $rootScope.user
                                    }).then(function (res) {
                                        vm.isLoadingCustomers = '';
                                        let responseChild = res['data'];
                                        if (responseChild['success']) {
                                            if(responseChild.clientes.length > 0){
                                                vm.lastSearch = customerFilter;
                                                vm.clientes = responseChild.clientes;
                                                $("#id_cliente").trigger("chosen:updated");
                                            }
                                        }
                                    });
                                },1000);
                            });
                        }
					}

				}, function errorCallback(response) {

				  });
        	};

            function getProducts(){

                    $http.post('/api/admin/facturacion/getProducts', {
                        user: $rootScope.user,
                        searchText: ''
                    }).then(function (res) {
                        var response = res['data'];
                        if (response['success']) {

                            vm.loading = "";
                            resolve(response.productos);
                        }

                    }, function errorCallback(response) {
                    });
            }


        	vm.opcionesFactura = function(){

                ngDialog.openConfirm({
                    template: 'opcionesFactura',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'OpcionesFacturaController',
                    data: {factura: vm.factura}
                }).then(function (buscar) {

                }, function (factura) {

                	if(factura.tipoDocumento != undefined){
                		vm.factura.impuestosTrasladados = factura.impuestosTrasladados;
                		vm.factura.impuestosRetenidos = factura.impuestosRetenidos;
                		vm.factura.cuentaPredial = factura.cuentaPredial;
                		vm.factura.moneda = factura.moneda;
                		vm.factura.tipoCambio = factura.tipoCambio;
                		vm.factura.truncar = factura.truncar;
                        if(factura.norma !== undefined){
                            vm.factura.norma = factura.norma;
                            vm.factura.leyenda = factura.leyenda;
                        }
                	}

                	vm.calcularTotales();
                });

            };



            vm.facturaRelacionada = function(){

            	vm.factura.facturasRelacionadas.noFactura = '';

                ngDialog.openConfirm({
                    template: 'facturasRelacionadas',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'FacturasRelacionadasController',
                    data: {tipoRelaciones: vm.tipoRelaciones, facturasRelacionadas: vm.factura.facturasRelacionadas}
                }).then(function (documento) {

                }, function (documento) {
                	console.log(documento);
                	if(documento.tipoRelacion != undefined){
                		vm.factura.facturasRelacionadas = documento;
                	}
                });

            };

            vm.agregrProdExistente = function(){
            	if(vm.productoAgregar.id_producto != undefined){
            		vm.productoAgregar.precioU = Number(vm.productoAgregar.precioU);
            		vm.productoAgregar.qty = 1;
            		vm.productoAgregar.descuento = 0;
                    vm.productoAgregar.objetoImp = '02';
            		vm.factura.detalles.push(angular.copy(vm.productoAgregar));
            		vm.productoAgregar = '';
            	}

            	vm.calcularTotales();
            };


            vm.agregrProdNuevo = function(){
            		var productoNuevo = {
            			codigo: '1',
            			clave: '',
            			nombre: '',
            			unidad: '',
            			qty: 1,
            			precioU: 1.00,
            			descuento: 0,
                        objetoImp: '02'
            		};
            		vm.factura.detalles.push(productoNuevo);
            		vm.productoAgregar = '';

            	vm.calcularTotales();
            };

            vm.calcularTotales = function(){

            	vm.factura.subtotal = 0;
            	vm.factura.total = 0;
            	vm.factura.base = 0;
            	vm.factura.descuento = 0;
            	vm.factura.totalTraslados = 0;
            	vm.factura.totalRetenciones = 0;

            	for(var y = 0; y < vm.factura.impuestosTrasladados.length; y++){
        			vm.factura.impuestosTrasladados[y].total = 0;
            	}

            	for(var y = 0; y < vm.factura.impuestosRetenidos.length; y++){
        			vm.factura.impuestosRetenidos[y].total = 0;
            	}

            	for(var x = 0; x < vm.factura.detalles.length; x++){

            		vm.factura.detalles[x].descuento = $rootScope.toFixedNumber(vm.factura.detalles[x].descuento);

                    let tempVal = vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU;
                    tempVal = tempVal.toFixed(5);
                    let baseItem = $rootScope.toFixedNumberSpecial(tempVal)

            		vm.factura.subtotal += baseItem;
            		vm.factura.detalles[x].base = baseItem - vm.factura.detalles[x].descuento;
            		vm.factura.descuento += Number(vm.factura.detalles[x].descuento);

            		for(var y = 0; y < vm.factura.impuestosTrasladados.length; y++){

            			var valorImpuesto = 0;
                		if(vm.factura.impuestosTrasladados[y].factor == 'Tasa'){
                			valorImpuesto = vm.factura.impuestosTrasladados[y].valor * vm.factura.detalles[x].base;
                		}else{
                			valorImpuesto = vm.factura.impuestosTrasladados[y].valor;
                		}

                        valorImpuesto = valorImpuesto.toFixed(5);

                		if(vm.factura.truncar == '1'){
                			valorImpuesto = $rootScope.truncateNumbers(valorImpuesto);
                		}else{
                			valorImpuesto = $rootScope.toFixedNumberSpecial(valorImpuesto);
                		}

                		vm.factura.impuestosTrasladados[y].total += valorImpuesto;
                		vm.factura.totalTraslados += valorImpuesto ;
                	}


            		for(var y = 0; y < vm.factura.impuestosRetenidos.length; y++){

            			var valorImpuesto = 0;
                		if(vm.factura.impuestosRetenidos[y].factor == 'Tasa'){
                			var valorImpRet = vm.factura.impuestosRetenidos[y].valor;
                			var valorBaseProd = vm.factura.detalles[x].base;

                			valorImpuesto = valorImpRet * valorBaseProd;
                		}else{
                			valorImpuesto = vm.factura.impuestosRetenidos[y].valor;
                		}

                        valorImpuesto = valorImpuesto.toFixed(5);

                		if(vm.factura.truncar == '1'){
                			valorImpuesto = $rootScope.truncateNumbers(valorImpuesto);
                		}else{
                			valorImpuesto = $rootScope.toFixedNumberSpecial(valorImpuesto);
                		}

                		vm.factura.impuestosRetenidos[y].total += valorImpuesto;
                		vm.factura.totalRetenciones += valorImpuesto ;
                	}

            		if(vm.factura.impuestosRetenidos.length === 0 &&
                        vm.factura.impuestosTrasladados.length === 0){
                        vm.factura.detalles[x].objetoImp = '01';
                    }
            	}

                if(vm.factura.truncar == '1'){
                    vm.factura.subtotal = $rootScope.truncateNumbers(vm.factura.subtotal);
                }else{
                    vm.factura.subtotal = $rootScope.toFixedNumberSpecial(vm.factura.subtotal);
                }

            	vm.factura.total = vm.factura.base = vm.factura.subtotal - vm.factura.descuento;
            	vm.factura.total += (vm.factura.totalTraslados - vm.factura.totalRetenciones);
            	vm.factura.total = $rootScope.toFixedNumber(vm.factura.total);

            };


            vm.calcularTotalesEspecial = function(){

            	vm.factura.subtotal = 0;
            	vm.factura.total = 0;
            	vm.factura.base = 0;
            	vm.factura.descuento = 0;
            	vm.factura.totalTraslados = 0;
            	vm.factura.totalRetenciones = 0;

            	for(var x = 0; x < vm.factura.detalles.length; x++){

            		vm.factura.detalles[x].precioU = $rootScope.toFixedNumber(vm.factura.detalles[x].precioU);
            		vm.factura.detalles[x].descuento = $rootScope.toFixedNumber(vm.factura.detalles[x].descuento);

            		var baseItem = $rootScope.toFixedNumberSpecial((vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU))
            		vm.factura.subtotal += baseItem;
            		vm.factura.detalles[x].base = baseItem - vm.factura.detalles[x].descuento;
            		vm.factura.descuento += Number(vm.factura.detalles[x].descuento);

            		for(var y = 0; y < vm.factura.impuestosTrasladados.length; y++){

                		valorImpuesto = Number(vm.factura.impuestosTrasladados[y].total);
                		vm.factura.impuestosTrasladados[y].total = valorImpuesto;
                		vm.factura.totalTraslados += valorImpuesto ;
                	}


            		for(var y = 0; y < vm.factura.impuestosRetenidos.length; y++){

            			var valorImpuesto = Number(vm.factura.impuestosRetenidos[y].total);
                		vm.factura.impuestosRetenidos[y].total = valorImpuesto;
                		vm.factura.totalRetenciones += valorImpuesto ;
                	}

            	}

            	vm.factura.total = vm.factura.base = vm.factura.subtotal - vm.factura.descuento;
            	vm.factura.total += (vm.factura.totalTraslados - vm.factura.totalRetenciones);
            	vm.factura.total = $rootScope.toFixedNumber(vm.factura.total);

            };

            vm.borrarConcepto = function(index){
            	vm.factura.detalles.splice(index, 1);
            	vm.calcularTotales();
            };


            /////Funcionalidad select de mobile para customer
            vm.getMatchesCustomer = function(searchText) {
				if(searchText == "" || searchText == null)
					return vm.clientes;
		            var states = vm.clientes.filter(function(customer) {
		            	var pordChane = customer.nmbRecep + " " + customer.rFCRecep;
		                return (pordChane.toUpperCase().match(searchText.toUpperCase()));
		            });

		        return states;
		    }

            vm.selectedCustomer = function(cliente){
				if(typeof(cliente) != 'undefined' && typeof(cliente.id_cliente) != 'undefined'){
					vm.factura.id_cliente = cliente;
					vm.obtenerPaises();
				}else{
					vm.factura.id_cliente = 0;
				}
			};
			////////////////////////////

			vm.obtenerPaises = function(){

                if($scope._timeout){
                    $timeout.cancel($scope._timeout);
                }

				vm.usosCFDITmp = [];
                vm.disableCp = false;

				if(isNaN(Number(vm.factura.id_cliente.rFCRecep.charAt(3)))){

					vm.usosCFDITmp = vm.usosCFDI;

				}else{
					for(var x = 0; x < vm.usosCFDI.length; x++){
						if(vm.usosCFDI[x].validMoral == 1){
							vm.usosCFDITmp.push(vm.usosCFDI[x]);
						}
					}
				}

				vm.factura.formaPago = vm.factura.id_cliente.metodoPago;
				vm.factura.usoCFDI = vm.factura.id_cliente.usoCFDI;
                vm.obtenerRegimenesFiscales();

				if( vm.factura.id_cliente!= null && vm.factura.id_cliente.rFCRecep == 'XEXX010101000'){

					$http.post('/api/admin/facturacion/obtenerPaises', {
						user : $rootScope.user
					}).then(function(res) {
						var response = res['data'];
						if (response['success']) {

							vm.loading = "";
							vm.paises = response.paises;
						}

					}, function errorCallback(response) {
						vm.obtenerDatos();
					  });

				}else if( vm.factura.id_cliente!= null && vm.factura.id_cliente.rFCRecep == 'XAXX010101000'){
                    vm.actualizarDatosPublicoGeneral();
                }
			};

			vm.updatesFor40 = function () {
                vm.actualizarDatosPublicoGeneral()
            }

			vm.actualizarDatosPublicoGeneral = function () {
			    if(vm.factura.versionF == '4.0' && vm.factura.id_cliente.rFCRecep == 'XAXX010101000'){
                    vm.factura.id_cliente.tipoPersona = '2';
                    vm.obtenerRegimenesFiscales()
                    vm.disableCp = true;
                    vm.factura.id_cliente.codigoPostal = vm.factura.lugarExpedicion;
                    vm.factura.id_cliente.regimenFiscalReceptor = '616';
                    vm.factura.usoCFDI = 'S01';
                    vm.factura.formaPago = '99'

                    $("#usoCFDI").trigger("chosen:updated");
                    $("#formaPago").trigger("chosen:updated");
			    }
            }

            vm.selectPeriodicidad = function () {
                if(vm.factura.publico.periodicidad == '05'){
                    vm.factura.id_cliente.tipoPersona = '2';
                    vm.obtenerRegimenesFiscales()
                    vm.factura.id_cliente.regimenFiscalReceptor = '621';
                }
            }

			vm.updateCP = function () {
                vm.disableCp = false;
                if(vm.factura.versionF == '4.0'){
                    if( vm.factura.id_cliente!= null && vm.factura.id_cliente.rFCRecep == 'XAXX010101000'){
                        vm.disableCp = true;
                        vm.factura.id_cliente.codigoPostal = vm.factura.lugarExpedicion;
                    }
                }
            }

			vm.borrarFacturaRelacionada = function(index){
				vm.factura.facturasRelacionadas.uuids.splice(index, 1);
			};


			vm.seleccionarMetodoPago = function(){
				if(vm.factura.metodoDePago == 'PPD'){
					vm.factura.formaPago = '99';
					$("#formaPago").trigger("chosen:updated");
				}
			};


			vm.facturar = function(){

				if(vm.factura.id_cliente == '' || vm.factura.id_cliente == null){
					Notify.alert('Debe seleccionar un cliente.', {status: 'danger'});
					$('#id_cliente').trigger('chosen:activate');
					return;
				}

				if(vm.factura.versionF == '4.0'){

                    if(vm.factura.id_cliente.regimenFiscalReceptor == null
                        || vm.factura.id_cliente.regimenFiscalReceptor == ''){
                        Notify.alert('Debe seleccionar el regimen fiscal.', {status: 'danger'});
                        $('#regimenFiscalReceptor').trigger('chosen:activate');
                        return;
                    }

                    if(vm.factura.id_cliente.codigoPostal == null
                        || vm.factura.id_cliente.codigoPostal.length < 5){
                        Notify.alert('Debe ingresar el codigo postal del receptor.', {status: 'danger'});
                        $('#codigoPostalR').trigger('chosen:activate');
                        return;
                    }

                    if(vm.factura.id_cliente.rFCRecep == 'XAXX010101000'){

                        if(vm.factura.publico.anio == null || vm.factura.publico.anio == ''){
                            Notify.alert('Debe seleccionar Año del periodo.', {status: 'danger'});
                            $('#publicoAnio').focus();
                            return;
                        }

                        if(vm.factura.publico.meses == null || vm.factura.publico.meses == ''){
                            Notify.alert('Debe seleccionar Mes del periodo.', {status: 'danger'});
                            $('#publicoMeses').focus();
                            return;
                        }

                        if(vm.factura.publico.periodicidad == null || vm.factura.publico.periodicidad == ''){
                            Notify.alert('Debe seleccionar Periodicidad.', {status: 'danger'});
                            $('#publicoPeriodicidad').focus();
                            return;
                        }

                    }
                }

				if(vm.factura.formaPago == '' || vm.factura.formaPago == null){
					Notify.alert('Debe seleccionar una forma de pago.', {status: 'danger'});
					$('#formaPago').trigger('chosen:activate');
					$('#formaPago').focus();
					return;
				}


				if(vm.factura.lugarExpedicion == '' || vm.factura.lugarExpedicion == null || vm.factura.lugarExpedicion.length < 5 ){
					Notify.alert('Debe ingresar un lugar de expedición correcto (C.P.)', {status: 'danger'});
					$('#lugarExpedicion').focus();
					return;
				}


				if(vm.factura.usoCFDI == '' || vm.factura.usoCFDI == null || vm.factura.usoCFDI == '0'){
					Notify.alert('Debe seleccionar el uso del CFDI.', {status: 'danger'});
					$('#usoCFDI').trigger('chosen:activate');
					$('#usoCFDI').focus();
					return;
				}

				if(vm.factura.detalles.length == 0){
					Notify.alert('Debe agregar al menos un producto.', {status: 'danger'});
					return;
				}

				for(var x = 0; x < vm.factura.detalles.length; x++){

					var concepto = vm.factura.detalles[x];

					if(concepto.clave == ''){
						Notify.alert('Debe seleccionar una clave para cada concepto.', {status: 'danger'});
						$('#clave' + x).focus();
						$('#clave' + x).trigger('chosen:activate');
						return;
					}

					if(concepto.nombre == ''){
						Notify.alert('Debe agregar una descripción para cada concepto.', {status: 'danger'});
						$('#nombre' + x).focus();
						return;
					}

					if(concepto.unidad == null || concepto.unidad == ''){
						Notify.alert('Debe seleccionar una unidad para cada concepto.', {status: 'danger'});
						$('#unidad' + x).focus();
						$('#unidad' + x).trigger('chosen:activate');
						return;
					}

					if(concepto.qty == null || concepto.qty < 0.00001){
						Notify.alert('La cantidad por concepto debe ser al mayor a 0.', {status: 'danger'});
						$('#qty' + x).focus();
						return;
					}

					if(concepto.precioU == null){
						Notify.alert('Debe ingresar un precio unitario.', {status: 'danger'});
						$('#precioU' + x).focus();
						return;
					}
				}

				// Validaciones para complemento Inbursa
				if(vm.factura.id_addenda!== undefined && vm.factura.id_addenda.nombre === 'Inbursa'){

					if(vm.factura.inbursa.emisor == null || vm.factura.inbursa.emisor == ''){
						Notify.alert('Debe ingresar el emisor del siniestro de Inbursa.', {status: 'danger'});
						$('#emisorInbursa').focus();
						return;
					}

					if(vm.factura.inbursa.numero == null || vm.factura.inbursa.numero == ''){
						Notify.alert('Debe ingresar el número de siniestro de Inbursa.', {status: 'danger'});
						$('#numeroInbursa').focus();
						return;
					}

					if(vm.factura.inbursa.afectado == null || vm.factura.inbursa.afectado == ''){
						Notify.alert('Debe seleccionar el afectado (A/T) de Inbursa.', {status: 'danger'});
						$('#afectadoInbursa').trigger('chosen:activate');
						$('#afectadoInbursa').focus();
						return;
					}

					if(vm.factura.inbursa.fechaEntrega == null || vm.factura.inbursa.fechaEntrega == ''){
						Notify.alert('Debe ingresar la fecha de entrega de Inbursa.', {status: 'danger'});
						$('#fechaEntregaInbursa').focus();
						return;
					}

					if(vm.factura.inbursa.manaoObra == null || vm.factura.inbursa.manaoObra == ''){
						Notify.alert('Debe ingresar el total de mano de obra (puede ser 0.00).', {status: 'danger'});
						$('#manaoObraInbursa').focus();
						return;
					}
				}


				vm.loading = "whirl double-up";


				let urlFacturar = 'facturar';
				if(vm.factura.versionF == '4.0')
                    urlFacturar = 'facturar40';

				$http.post('/api/admin/facturacion/'+urlFacturar, {
					user : $rootScope.user,
					factura: vm.factura
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						SweetAlert.swal('Éxito!', 'Se generó su factura de forma correcta con el No. ' + response.facturaResult, 'success');
						$state.transitionTo('app.listadoFacturas');

					}else{
						SweetAlert.swal('Error', response.errortext , 'error');
					}

					vm.loading = "";

				}, function errorCallback(response) {
					vm.loading = "";
				});



			};


			vm.facturarTest = function(){

				if(vm.factura.id_cliente == '' || vm.factura.id_cliente == null){
					Notify.alert('Debe seleccionar un cliente.', {status: 'danger'});
					$('#id_cliente').trigger('chosen:activate');
					return;
				}

				if(vm.factura.formaPago == '' || vm.factura.formaPago == null){
					Notify.alert('Debe seleccionar una forma de pago.', {status: 'danger'});
					$('#formaPago').trigger('chosen:activate');
					$('#formaPago').focus();
					return;
				}


				if(vm.factura.lugarExpedicion == '' || vm.factura.lugarExpedicion == null || vm.factura.lugarExpedicion.length < 5 ){
					Notify.alert('Debe ingresar un lugar de expedición correcto (C.P.)', {status: 'danger'});
					$('#lugarExpedicion').focus();
					return;
				}


				if(vm.factura.usoCFDI == '' || vm.factura.usoCFDI == null || vm.factura.usoCFDI == '0'){
					Notify.alert('Debe seleccionar el uso del CFDI.', {status: 'danger'});
					$('#usoCFDI').trigger('chosen:activate');
					$('#usoCFDI').focus();
					return;
				}

				if(vm.factura.detalles.length == 0){
					Notify.alert('Debe agregar al menos un producto.', {status: 'danger'});
					return;
				}

				for(var x = 0; x < vm.factura.detalles.length; x++){

					var concepto = vm.factura.detalles[x];

					if(concepto.clave == ''){
						Notify.alert('Debe seleccionar una clave para cada concepto.', {status: 'danger'});
						$('#clave' + x).focus();
						$('#clave' + x).trigger('chosen:activate');
						return;
					}

					if(concepto.nombre == ''){
						Notify.alert('Debe agregar una descripción para cada concepto.', {status: 'danger'});
						$('#nombre' + x).focus();
						return;
					}

					if(concepto.unidad == null || concepto.unidad == ''){
						Notify.alert('Debe seleccionar una unidad para cada concepto.', {status: 'danger'});
						$('#unidad' + x).focus();
						$('#unidad' + x).trigger('chosen:activate');
						return;
					}

					if(concepto.qty == null || concepto.qty < 0.00001){
						Notify.alert('La cantidad por concepto debe ser al mayor a 0.', {status: 'danger'});
						$('#qty' + x).focus();
						return;
					}

					if(concepto.precioU == null){
						Notify.alert('Debe ingresar un precio unitario.', {status: 'danger'});
						$('#precioU' + x).focus();
						return;
					}

				}

				vm.loading = "whirl double-up";


				$http.post('/api/admin/facturacion/facturarTest', {
					user : $rootScope.user,
					factura: vm.factura
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						SweetAlert.swal('Éxito!', 'Se generó su factura de forma correcta con el No. ' + response.facturaResult, 'success');
						$state.transitionTo('app.listadoFacturas');

					}else{
						SweetAlert.swal('Error!', response.errorCode + ' - ' + response.errortext + ' <br>' + response.nombreArchivo, 'error');
					}

					vm.loading = "";

				}, function errorCallback(response) {
					vm.loading = "";
				});



			};

			vm.obtenerRegimenesFiscales = function (){
                vm.regimenesFiscalesList = [];
                if(vm.regimenesFiscales !== undefined)
			    for(let x = 0; x < vm.regimenesFiscales.length; x++){
                    if(vm.regimenesFiscales[x].tipo == vm.factura.id_cliente.tipoPersona || vm.regimenesFiscales[x].tipo == 3){
                        vm.regimenesFiscalesList.push(vm.regimenesFiscales[x]);
                    }
                }
            };

            vm.getNombreRegimen = function (code) {
                if(vm.regimenesFiscales != undefined && vm.regimenesFiscales.length > 0)
                for(let x = 0; x < vm.regimenesFiscales.length; x++){
                    if(vm.regimenesFiscales[x].code === code){
                        return vm.regimenesFiscales[x].descripcion;
                    }
                }
            }
            vm.getFormaPago = function (code){
                if(vm.formasDePago.length > 0)
                for(let x = 0; x < vm.formasDePago.length; x++){
                    if(vm.formasDePago[x].codigo === code){
                        return vm.formasDePago[x].descripcion;
                    }
                }
            }
            vm.getMetodoPago = function (code){
                if(vm.metodosDePago.length > 0)
                for(let x = 0; x < vm.metodosDePago.length; x++){
                    if(vm.metodosDePago[x].codigo === code){
                        return vm.metodosDePago[x].descripcion;
                    }
                }
            }
            vm.getUsoCFDI = function (code){
                if(vm.usosCFDITmp.length > 0)
                for(let x = 0; x < vm.usosCFDITmp.length; x++){
                    if(vm.usosCFDITmp[x].codigo === code){
                        return vm.usosCFDITmp[x].descripcion;
                    }
                }
            }

            vm.print = function () {
                window.print();
            }

        	vm.obtenerDatos();



        }
    }
})();



(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('NuevaEscuelaController', NuevaEscuelaController);

    NuevaEscuelaController.$inject = ['$scope', '$http', '$state', '$stateParams',
        'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog', '$timeout'];

    function NuevaEscuelaController($scope, $http, $state, $stateParams, Notify,
                                    $rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog, $timeout) {
        var vm = this;

        vm.clientes = [];
        vm.formasDePago = [];
        vm.productos = [];
        vm.unidadesMedida = [];
        vm.clavesProducto = [];
        vm.usosCFDI = [];
        vm.addendas = [];
        vm.usosCFDITmp = [];
        vm.searchTextCustomer = '';
        vm.series = [];
        vm.lastSearch = '';
        vm.isLoadingCustomers = '';
        vm.factura = {
            tipoDocumento: 'I',
            id_cliente: '',
            decimales: '2',
            impuestosRetenidos : [],
            guardarProd: false,
            impuestosTrasladados : [{factor: 'Exento', valor: 0, impuesto: '002', label: 'IVA'}],
            moneda: 'MXN',
            tipoCambio: 1.0,
            detalles: [],
            descuento: 0,
            facturasRelacionadas: {
                tipoRelacion: '',
                noFactura: '',
                uuids: []
            },
            cuentaPredial: '',
            formaPago: '',
            lugarExpedicion: '',
            serie: 'A',
            metodoDePago: 'PUE',
            truncar: '0',
            exportacion: '01',
            versionF: '4.0',
            publico: {}
        }
        vm.productoAgregar = '';
        vm.tipoRelaciones = [
            {value: '01', label: 'Nota de crédito de los documentos relacionados'},
            {value: '02', label: 'Nota de débito de los documentos relacionados'},
            {value: '03', label: 'Devolución de mercancía sobre facturas o traslados previos'},
            {value: '04', label: 'Sustitución de los CFDI previos'},
            {value: '05', label: 'Traslados de mercancias facturados previamente'},
            {value: '06', label: 'Factura generada por los traslados previos'},
            {value: '07', label: 'CFDI por aplicación de anticipo'}
        ];
        vm.metodosDePago = [{codigo: 'PUE', descripcion: 'Pago en una sola exhibición'}, {codigo: 'PPD', descripcion: 'Pago en parcialidades o diferido'}];
        vm.disableCp = false;

        vm.cambiarTipoDocumento = function(tipo){
            vm.factura.tipoDocumento = tipo;
            if(vm.factura.tipoDocumento == 'P')
                $state.transitionTo('app.nuevoPago');
        };

        activate();

        ////////////////

        function activate() {

            vm.obtenerNombreTipoRelacion = function(){
                for(var x = 0; x < vm.tipoRelaciones.length; x++){
                    if(vm.tipoRelaciones[x].value == vm.factura.facturasRelacionadas.tipoRelacion){
                        return vm.tipoRelaciones[x].label;
                    }
                }
            };


            vm.obtenerDatos = function(){

                if($stateParams.tipoDocumento != undefined && $stateParams.tipoDocumento != ''){
                    vm.factura.tipoDocumento = $stateParams.tipoDocumento;
                }

                vm.loading = "whirl double-up";

                $http.post('/api/admin/facturacion/datosFacturar', {
                    user : $rootScope.user
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {

                        vm.loading = "";
                        vm.clientes = response.clientes;
                        vm.formasDePago = response.formasDePago;
                        vm.productos = response.productos;
                        vm.unidadesMedida = response.unidadesMedida;
                        vm.clavesProducto = response.clavesProducto;
                        vm.usosCFDI = response.usosCFDI;
                        vm.series = response.series;
                        vm.factura.lugarExpedicion = response.proveedor.domicilio.codigoPostal;
                        vm.usosCFDITmp = response.usosCFDI;
                        vm.addendas = response.addendas;
                        vm.regimenesFiscales = response.regimenesFiscales;
                        vm.tieneCartaPorte = response.tieneCartaPorte;
                        vm.tieneEscuelas = response.tieneEscuelas;
                        vm.tieneIne = response.tieneIne;

                        if(vm.clientes.length === 2000){

                            vm.isLoadingCustomers = '';
                            jQuery("#id_cliente_chosen").find('input').keyup(function() {

                                const customerFilter = this.value;
                                if($scope._timeout){ //if there is already a timeout in process cancel it
                                    $timeout.cancel($scope._timeout);
                                }

                                if(customerFilter.trim().length < 4 || customerFilter.trim() === vm.lastSearch.trim() || vm.isLoadingCustomers !== '')
                                    return

                                $scope._timeout = $timeout(function(){

                                    vm.isLoadingCustomers = 'whirl double-up';
                                    $http.post('/api/admin/facturacion/getCustomersByFilter', {
                                        customerFilter: customerFilter,
                                        user : $rootScope.user
                                    }).then(function (res) {
                                        vm.isLoadingCustomers = '';
                                        let responseChild = res['data'];
                                        if (responseChild['success']) {
                                            if(responseChild.clientes.length > 0){
                                                vm.lastSearch = customerFilter;
                                                vm.clientes = responseChild.clientes;
                                                $("#id_cliente").trigger("chosen:updated");
                                                /*
                                                $scope._timeout = $timeout(function() {
                                                    jQuery("#id_cliente_chosen").find('input').val(customerFilter);
                                                    var e = jQuery.Event("keyup");
                                                    e.which = 10;
                                                    e.keyCode = 10;
                                                    jQuery("#id_cliente_chosen").find('input').trigger( e );
                                                },200);
                                                 */
                                            }
                                        }
                                    });
                                },1000);
                            });
                        }
                    }

                }, function errorCallback(response) {

                });
            };

            function getProducts(){

                $http.post('/api/admin/facturacion/getProducts', {
                    user: $rootScope.user,
                    searchText: ''
                }).then(function (res) {
                    var response = res['data'];
                    if (response['success']) {

                        vm.loading = "";
                        resolve(response.productos);
                    }

                }, function errorCallback(response) {
                });
            }


            vm.opcionesFactura = function(){

                ngDialog.openConfirm({
                    template: 'opcionesFactura',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'OpcionesFacturaController',
                    data: {factura: vm.factura}
                }).then(function (buscar) {

                }, function (factura) {

                    if(factura.tipoDocumento != undefined){
                        vm.factura.impuestosTrasladados = factura.impuestosTrasladados;
                        vm.factura.impuestosRetenidos = factura.impuestosRetenidos;
                        vm.factura.cuentaPredial = factura.cuentaPredial;
                        vm.factura.moneda = factura.moneda;
                        vm.factura.tipoCambio = factura.tipoCambio;
                        vm.factura.truncar = factura.truncar;
                        if(factura.norma !== undefined){
                            vm.factura.norma = factura.norma;
                            vm.factura.leyenda = factura.leyenda;
                        }
                    }

                    vm.calcularTotales();
                });

            };



            vm.facturaRelacionada = function(){

                vm.factura.facturasRelacionadas.noFactura = '';

                ngDialog.openConfirm({
                    template: 'facturasRelacionadas',
                    className: 'ngdialog-theme-default',
                    controller: 'FacturasRelacionadasController',
                    data: {tipoRelaciones: vm.tipoRelaciones, facturasRelacionadas: vm.factura.facturasRelacionadas}
                }).then(function (documento) {

                }, function (documento) {
                    console.log(documento);
                    if(documento.tipoRelacion != undefined){
                        vm.factura.facturasRelacionadas = documento;
                    }
                });

            };

            vm.agregrProdExistente = function(){
                if(vm.productoAgregar.id_producto != undefined){
                    vm.productoAgregar.precioU = Number(vm.productoAgregar.precioU);
                    vm.productoAgregar.qty = 1;
                    vm.productoAgregar.descuento = 0;
                    vm.productoAgregar.objetoImp = '02';
                    vm.productoAgregar.alumno = null;
                    vm.factura.detalles.push(angular.copy(vm.productoAgregar));
                    vm.productoAgregar = '';
                }

                vm.calcularTotales();
            };


            vm.agregrProdNuevo = function(){
                let productoNuevo = {
                    codigo: '1',
                    clave: '',
                    nombre: '',
                    unidad: '',
                    qty: 1,
                    precioU: 1.00,
                    descuento: 0,
                    objetoImp: '02',
                    alumno: null
                };
                vm.factura.detalles.push(productoNuevo);
                vm.productoAgregar = '';

                vm.calcularTotales();
            };

            vm.calcularTotales = function(){

                vm.factura.subtotal = 0;
                vm.factura.total = 0;
                vm.factura.base = 0;
                vm.factura.descuento = 0;
                vm.factura.totalTraslados = 0;
                vm.factura.totalRetenciones = 0;

                for(var y = 0; y < vm.factura.impuestosTrasladados.length; y++){
                    vm.factura.impuestosTrasladados[y].total = 0;
                }

                for(var y = 0; y < vm.factura.impuestosRetenidos.length; y++){
                    vm.factura.impuestosRetenidos[y].total = 0;
                }

                for(var x = 0; x < vm.factura.detalles.length; x++){

                    vm.factura.detalles[x].precioU = $rootScope.toFixedNumber(vm.factura.detalles[x].precioU);
                    vm.factura.detalles[x].descuento = $rootScope.toFixedNumber(vm.factura.detalles[x].descuento);

                    let tempVal = vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU;
                    tempVal = tempVal.toFixed(5);
                    let baseItem = $rootScope.toFixedNumberSpecial(tempVal)

                    vm.factura.subtotal += baseItem;
                    vm.factura.detalles[x].base = baseItem - vm.factura.detalles[x].descuento;
                    vm.factura.descuento += Number(vm.factura.detalles[x].descuento);

                    for(var y = 0; y < vm.factura.impuestosTrasladados.length; y++){

                        var valorImpuesto = 0;
                        if(vm.factura.impuestosTrasladados[y].factor == 'Tasa'){
                            valorImpuesto = vm.factura.impuestosTrasladados[y].valor * vm.factura.detalles[x].base;
                        }else{
                            valorImpuesto = vm.factura.impuestosTrasladados[y].valor;
                        }

                        valorImpuesto = valorImpuesto.toFixed(5);

                        if(vm.factura.truncar == '1'){
                            valorImpuesto = $rootScope.truncateNumbers(valorImpuesto);
                        }else{
                            valorImpuesto = $rootScope.toFixedNumberSpecial(valorImpuesto);
                        }

                        vm.factura.impuestosTrasladados[y].total += valorImpuesto;
                        vm.factura.totalTraslados += valorImpuesto ;
                    }


                    for(var y = 0; y < vm.factura.impuestosRetenidos.length; y++){

                        var valorImpuesto = 0;
                        if(vm.factura.impuestosRetenidos[y].factor == 'Tasa'){
                            var valorImpRet = vm.factura.impuestosRetenidos[y].valor;
                            var valorBaseProd = vm.factura.detalles[x].base;

                            valorImpuesto = valorImpRet * valorBaseProd;
                        }else{
                            valorImpuesto = vm.factura.impuestosRetenidos[y].valor;
                        }

                        valorImpuesto = valorImpuesto.toFixed(5);

                        if(vm.factura.truncar == '1'){
                            valorImpuesto = $rootScope.truncateNumbers(valorImpuesto);
                        }else{
                            valorImpuesto = $rootScope.toFixedNumberSpecial(valorImpuesto);
                        }

                        vm.factura.impuestosRetenidos[y].total += valorImpuesto;
                        vm.factura.totalRetenciones += valorImpuesto ;
                    }

                    if(vm.factura.impuestosRetenidos.length === 0 &&
                        vm.factura.impuestosTrasladados.length === 0){
                        vm.factura.detalles[x].objetoImp = '01';
                    }

                }

                vm.factura.total = vm.factura.base = vm.factura.subtotal - vm.factura.descuento;
                vm.factura.total += (vm.factura.totalTraslados - vm.factura.totalRetenciones);
                vm.factura.total = $rootScope.toFixedNumber(vm.factura.total);

            };


            vm.calcularTotalesEspecial = function(){

                vm.factura.subtotal = 0;
                vm.factura.total = 0;
                vm.factura.base = 0;
                vm.factura.descuento = 0;
                vm.factura.totalTraslados = 0;
                vm.factura.totalRetenciones = 0;

                for(var x = 0; x < vm.factura.detalles.length; x++){

                    vm.factura.detalles[x].precioU = $rootScope.toFixedNumber(vm.factura.detalles[x].precioU);
                    vm.factura.detalles[x].descuento = $rootScope.toFixedNumber(vm.factura.detalles[x].descuento);

                    var baseItem = $rootScope.toFixedNumberSpecial((vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU))
                    vm.factura.subtotal += baseItem;
                    vm.factura.detalles[x].base = baseItem - vm.factura.detalles[x].descuento;
                    vm.factura.descuento += Number(vm.factura.detalles[x].descuento);

                    for(var y = 0; y < vm.factura.impuestosTrasladados.length; y++){

                        valorImpuesto = Number(vm.factura.impuestosTrasladados[y].total);
                        vm.factura.impuestosTrasladados[y].total = valorImpuesto;
                        vm.factura.totalTraslados += valorImpuesto ;
                    }


                    for(var y = 0; y < vm.factura.impuestosRetenidos.length; y++){

                        var valorImpuesto = Number(vm.factura.impuestosRetenidos[y].total);
                        vm.factura.impuestosRetenidos[y].total = valorImpuesto;
                        vm.factura.totalRetenciones += valorImpuesto ;
                    }

                }

                vm.factura.total = vm.factura.base = vm.factura.subtotal - vm.factura.descuento;
                vm.factura.total += (vm.factura.totalTraslados - vm.factura.totalRetenciones);
                vm.factura.total = $rootScope.toFixedNumber(vm.factura.total);

            };

            vm.borrarConcepto = function(index){
                vm.factura.detalles.splice(index, 1);
                vm.calcularTotales();
            };


            /////Funcionalidad select de mobile para customer
            vm.getMatchesCustomer = function(searchText) {
                if(searchText == "" || searchText == null)
                    return vm.clientes;
                var states = vm.clientes.filter(function(customer) {
                    var pordChane = customer.nmbRecep + " " + customer.rFCRecep;
                    return (pordChane.toUpperCase().match(searchText.toUpperCase()));
                });

                return states;
            }

            vm.selectedCustomer = function(cliente){
                if(typeof(cliente) != 'undefined' && typeof(cliente.id_cliente) != 'undefined'){
                    vm.factura.id_cliente = cliente;
                    vm.obtenerPaises();
                }else{
                    vm.factura.id_cliente = 0;
                }
            };
            ////////////////////////////

            vm.obtenerPaises = function(){

                if($scope._timeout){
                    $timeout.cancel($scope._timeout);
                }

                vm.usosCFDITmp = [];
                vm.disableCp = false;

                if(isNaN(Number(vm.factura.id_cliente.rFCRecep.charAt(3)))){

                    vm.usosCFDITmp = vm.usosCFDI;

                }else{
                    for(var x = 0; x < vm.usosCFDI.length; x++){
                        if(vm.usosCFDI[x].validMoral == 1){
                            vm.usosCFDITmp.push(vm.usosCFDI[x]);
                        }
                    }
                }

                vm.factura.formaPago = vm.factura.id_cliente.metodoPago;
                vm.factura.usoCFDI = vm.factura.id_cliente.usoCFDI;
                vm.obtenerRegimenesFiscales();

                if( vm.factura.id_cliente!= null && vm.factura.id_cliente.rFCRecep == 'XEXX010101000'){

                    $http.post('/api/admin/facturacion/obtenerPaises', {
                        user : $rootScope.user
                    }).then(function(res) {
                        var response = res['data'];
                        if (response['success']) {

                            vm.loading = "";
                            vm.paises = response.paises;
                        }

                    }, function errorCallback(response) {
                        vm.obtenerDatos();
                    });

                }else if( vm.factura.id_cliente!= null && vm.factura.id_cliente.rFCRecep == 'XAXX010101000'){
                    vm.actualizarDatosPublicoGeneral();
                }
            };

            vm.updatesFor40 = function () {
                vm.actualizarDatosPublicoGeneral()
            }

            vm.actualizarDatosPublicoGeneral = function () {
                if(vm.factura.versionF == '4.0' && vm.factura.id_cliente.rFCRecep == 'XAXX010101000'){
                    vm.factura.id_cliente.tipoPersona = '2';
                    vm.obtenerRegimenesFiscales()
                    vm.disableCp = true;
                    vm.factura.id_cliente.codigoPostal = vm.factura.lugarExpedicion;
                    vm.factura.id_cliente.regimenFiscalReceptor = '616';
                    vm.factura.usoCFDI = 'S01';
                    vm.factura.formaPago = '99'

                    $("#usoCFDI").trigger("chosen:updated");
                    $("#formaPago").trigger("chosen:updated");
                }
            }

            vm.selectPeriodicidad = function () {
                if(vm.factura.publico.periodicidad == '05'){
                    vm.factura.id_cliente.tipoPersona = '2';
                    vm.obtenerRegimenesFiscales()
                    vm.factura.id_cliente.regimenFiscalReceptor = '621';
                }
            }

            vm.updateCP = function () {
                vm.disableCp = false;
                if(vm.factura.versionF == '4.0'){
                    if( vm.factura.id_cliente!= null && vm.factura.id_cliente.rFCRecep == 'XAXX010101000'){
                        vm.disableCp = true;
                        vm.factura.id_cliente.codigoPostal = vm.factura.lugarExpedicion;
                    }
                }
            }

            vm.borrarFacturaRelacionada = function(index){
                vm.factura.facturasRelacionadas.uuids.splice(index, 1);
            };


            vm.seleccionarMetodoPago = function(){
                if(vm.factura.metodoDePago == 'PPD'){
                    vm.factura.formaPago = '99';
                    $("#formaPago").trigger("chosen:updated");
                }
            };


            vm.facturar = function(){

                if(vm.factura.id_cliente == '' || vm.factura.id_cliente == null){
                    Notify.alert('Debe seleccionar un cliente.', {status: 'danger'});
                    $('#id_cliente').trigger('chosen:activate');
                    return;
                }

                if(vm.factura.versionF == '4.0'){

                    if(vm.factura.id_cliente.regimenFiscalReceptor == null
                        || vm.factura.id_cliente.regimenFiscalReceptor == ''){
                        Notify.alert('Debe seleccionar el regimen fiscal.', {status: 'danger'});
                        $('#regimenFiscalReceptor').trigger('chosen:activate');
                        return;
                    }

                    if(vm.factura.id_cliente.codigoPostal == null
                        || vm.factura.id_cliente.codigoPostal.length < 5){
                        Notify.alert('Debe ingresar el codigo postal del receptor.', {status: 'danger'});
                        $('#codigoPostalR').trigger('chosen:activate');
                        return;
                    }

                    if(vm.factura.id_cliente.rFCRecep == 'XAXX010101000'){

                        if(vm.factura.publico.anio == null || vm.factura.publico.anio == ''){
                            Notify.alert('Debe seleccionar Año del periodo.', {status: 'danger'});
                            $('#publicoAnio').focus();
                            return;
                        }

                        if(vm.factura.publico.meses == null || vm.factura.publico.meses == ''){
                            Notify.alert('Debe seleccionar Mes del periodo.', {status: 'danger'});
                            $('#publicoMeses').focus();
                            return;
                        }

                        if(vm.factura.publico.periodicidad == null || vm.factura.publico.periodicidad == ''){
                            Notify.alert('Debe seleccionar Periodicidad.', {status: 'danger'});
                            $('#publicoPeriodicidad').focus();
                            return;
                        }

                    }
                }

                if(vm.factura.formaPago == '' || vm.factura.formaPago == null){
                    Notify.alert('Debe seleccionar una forma de pago.', {status: 'danger'});
                    $('#formaPago').trigger('chosen:activate');
                    $('#formaPago').focus();
                    return;
                }


                if(vm.factura.lugarExpedicion == '' || vm.factura.lugarExpedicion == null || vm.factura.lugarExpedicion.length < 5 ){
                    Notify.alert('Debe ingresar un lugar de expedición correcto (C.P.)', {status: 'danger'});
                    $('#lugarExpedicion').focus();
                    return;
                }


                if(vm.factura.usoCFDI == '' || vm.factura.usoCFDI == null || vm.factura.usoCFDI == '0'){
                    Notify.alert('Debe seleccionar el uso del CFDI.', {status: 'danger'});
                    $('#usoCFDI').trigger('chosen:activate');
                    $('#usoCFDI').focus();
                    return;
                }

                if(vm.factura.detalles.length == 0){
                    Notify.alert('Debe agregar al menos un producto.', {status: 'danger'});
                    return;
                }

                for(var x = 0; x < vm.factura.detalles.length; x++){

                    var concepto = vm.factura.detalles[x];

                    if(concepto.clave == ''){
                        Notify.alert('Debe seleccionar una clave para cada concepto.', {status: 'danger'});
                        $('#clave' + x).focus();
                        $('#clave' + x).trigger('chosen:activate');
                        return;
                    }

                    if(concepto.nombre == ''){
                        Notify.alert('Debe agregar una descripción para cada concepto.', {status: 'danger'});
                        $('#nombre' + x).focus();
                        return;
                    }

                    if(concepto.unidad == null || concepto.unidad == ''){
                        Notify.alert('Debe seleccionar una unidad para cada concepto.', {status: 'danger'});
                        $('#unidad' + x).focus();
                        $('#unidad' + x).trigger('chosen:activate');
                        return;
                    }

                    if(concepto.qty == null || concepto.qty < 0.00001){
                        Notify.alert('La cantidad por concepto debe ser al mayor a 0.', {status: 'danger'});
                        $('#qty' + x).focus();
                        return;
                    }

                    if(concepto.precioU == null){
                        Notify.alert('Debe ingresar un precio unitario.', {status: 'danger'});
                        $('#precioU' + x).focus();
                        return;
                    }
                }


                vm.loading = "whirl double-up";

                $http.post('/api/admin/facturacion/facturar40', {
                    user : $rootScope.user,
                    factura: vm.factura
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {

                        SweetAlert.swal('Éxito!', 'Se generó su factura de forma correcta con el No. ' + response.facturaResult, 'success');
                        $state.transitionTo('app.listadoFacturas');

                    }else{
                        SweetAlert.swal('Error', response.errortext , 'error');
                    }

                    vm.loading = "";

                }, function errorCallback(response) {
                    vm.loading = "";
                });



            };


            vm.facturarTest = function(){

                if(vm.factura.id_cliente == '' || vm.factura.id_cliente == null){
                    Notify.alert('Debe seleccionar un cliente.', {status: 'danger'});
                    $('#id_cliente').trigger('chosen:activate');
                    return;
                }

                if(vm.factura.formaPago == '' || vm.factura.formaPago == null){
                    Notify.alert('Debe seleccionar una forma de pago.', {status: 'danger'});
                    $('#formaPago').trigger('chosen:activate');
                    $('#formaPago').focus();
                    return;
                }


                if(vm.factura.lugarExpedicion == '' || vm.factura.lugarExpedicion == null || vm.factura.lugarExpedicion.length < 5 ){
                    Notify.alert('Debe ingresar un lugar de expedición correcto (C.P.)', {status: 'danger'});
                    $('#lugarExpedicion').focus();
                    return;
                }


                if(vm.factura.usoCFDI == '' || vm.factura.usoCFDI == null || vm.factura.usoCFDI == '0'){
                    Notify.alert('Debe seleccionar el uso del CFDI.', {status: 'danger'});
                    $('#usoCFDI').trigger('chosen:activate');
                    $('#usoCFDI').focus();
                    return;
                }

                if(vm.factura.detalles.length == 0){
                    Notify.alert('Debe agregar al menos un producto.', {status: 'danger'});
                    return;
                }

                for(var x = 0; x < vm.factura.detalles.length; x++){

                    var concepto = vm.factura.detalles[x];

                    if(concepto.clave == ''){
                        Notify.alert('Debe seleccionar una clave para cada concepto.', {status: 'danger'});
                        $('#clave' + x).focus();
                        $('#clave' + x).trigger('chosen:activate');
                        return;
                    }

                    if(concepto.nombre == ''){
                        Notify.alert('Debe agregar una descripción para cada concepto.', {status: 'danger'});
                        $('#nombre' + x).focus();
                        return;
                    }

                    if(concepto.unidad == null || concepto.unidad == ''){
                        Notify.alert('Debe seleccionar una unidad para cada concepto.', {status: 'danger'});
                        $('#unidad' + x).focus();
                        $('#unidad' + x).trigger('chosen:activate');
                        return;
                    }

                    if(concepto.qty == null || concepto.qty < 0.00001){
                        Notify.alert('La cantidad por concepto debe ser al mayor a 0.', {status: 'danger'});
                        $('#qty' + x).focus();
                        return;
                    }

                    if(concepto.precioU == null){
                        Notify.alert('Debe ingresar un precio unitario.', {status: 'danger'});
                        $('#precioU' + x).focus();
                        return;
                    }

                }

                vm.loading = "whirl double-up";


                $http.post('/api/admin/facturacion/facturarTest', {
                    user : $rootScope.user,
                    factura: vm.factura
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {

                        SweetAlert.swal('Éxito!', 'Se generó su factura de forma correcta con el No. ' + response.facturaResult, 'success');
                        $state.transitionTo('app.listadoFacturas');

                    }else{
                        SweetAlert.swal('Error!', response.errorCode + ' - ' + response.errortext + ' <br>' + response.nombreArchivo, 'error');
                    }

                    vm.loading = "";

                }, function errorCallback(response) {
                    vm.loading = "";
                });



            };

            vm.obtenerRegimenesFiscales = function (){
                vm.regimenesFiscalesList = [];
                for(let x = 0; x < vm.regimenesFiscales.length; x++){
                    if(vm.regimenesFiscales[x].tipo == vm.factura.id_cliente.tipoPersona || vm.regimenesFiscales[x].tipo == 3){
                        vm.regimenesFiscalesList.push(vm.regimenesFiscales[x]);
                    }
                }
            };

            vm.detallesAlumno = function(index){

                ngDialog.openConfirm({
                    template: 'detallesAlumno',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'DetallesAlumnoController',
                    data: {alumno: vm.factura.detalles[index].alumno}
                }).then(function (buscar) {

                }, function (alumno) {
                    if(alumno.curp){
                        vm.factura.detalles[index].alumno = alumno;
                    }
                });

            }



            vm.obtenerDatos();



        }
    }
})();







(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('NuevaFacturaComercioController', NuevaFacturaComercioController);

    NuevaFacturaComercioController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function NuevaFacturaComercioController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {
        var vm = this;

        vm.clientes = [];
        vm.formasDePago = [];
        vm.productos = [];
        vm.unidadesMedida = [];
		vm.clavesProducto = [];
		vm.usosCFDI = [];
		vm.usosCFDITmp = [];
		vm.searchTextCustomer = '';
		vm.series = [];
        vm.factura = {
        		tipoDocumento: 'I',
        		isComercio: 1,
        		id_cliente: '',
            	decimales: '2',
        		impuestosRetenidos : [],
        		guardarProd: false,
        		impuestosTrasladados : [{factor: 'Tasa', valor: 0.16, impuesto: '002', label: 'IVA'}],
        		moneda: 'MXN',
        		tipoCambio: 1.0,
        		detalles: [],
        		descuento: 0,
        		facturasRelacionadas: {
            		tipoRelacion: '',
            		noFactura: '',
            		uuids: []

            	},
        		cuentaPredial: '',
        		formaPago: '',
        		lugarExpedicion: '',
        		serie: 'A',
        		metodoDePago: 'PUE',
                exportacion: '01',
        		comercio: {
        			incoterm: '',
                    motivoTraslado: '',
        			pedimento: 'A1',
        			tipoOperacion: 2,
        			rfcExtranjero: '',
                    totalUSD: 1.0
        		}

        }
        vm.productoAgregar = '';
        vm.tipoRelaciones = [
                             {value: '01', label: 'Nota de crédito de los documentos relacionados'},
                             {value: '02', label: 'Nota de débito de los documentos relacionados'},
                             {value: '03', label: 'Devolución de mercancía sobre facturas o traslados previos'},
                             {value: '04', label: 'Sustitución de los CFDI previos'},
                             {value: '05', label: 'Traslados de mercancias facturados previamente'},
                             {value: '06', label: 'Factura generada por los traslados previos'},
                             {value: '07', label: 'CFDI por aplicación de anticipo'}
                            ];
        vm.metodosDePago = [{codigo: 'PUE', descripcion: 'Pago en una sola exhibición'}, {codigo: 'PPD', descripcion: 'Pago en parcialidades o diferido'}];

        vm.cambiarTipoDocumento = function(tipo){
        	vm.factura.tipoDocumento = tipo;
        	if(vm.factura.tipoDocumento == 'P')
        		$state.transitionTo('app.nuevoPago');
        };

        activate();

        ////////////////

        function activate() {

        	if($rootScope.user.id_proveedor == 943){
				console.log("Si entro acá");
			}

        	vm.obtenerNombreTipoRelacion = function(){
        		for(var x = 0; x < vm.tipoRelaciones.length; x++){
        			if(vm.tipoRelaciones[x].value == vm.factura.facturasRelacionadas.tipoRelacion){
        				return vm.tipoRelaciones[x].label;
        			}
        		}
        	};


        	vm.obtenerDatos = function(){

        		if($stateParams.tipoDocumento != undefined && $stateParams.tipoDocumento != ''){
        			vm.factura.tipoDocumento = $stateParams.tipoDocumento;
        		}

	        	vm.loading = "whirl double-up";

	        	$http.post('/api/admin/facturacion/datosFacturar', {
					user : $rootScope.user
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.clientes = response.clientes;
						vm.formasDePago = response.formasDePago;
						vm.productos = response.productos;
						vm.unidadesMedida = response.unidadesMedida;
						vm.clavesProducto = response.clavesProducto;
						vm.usosCFDI = response.usosCFDI;
						vm.series = response.series;
						vm.factura.lugarExpedicion = response.proveedor.domicilio.codigoPostal;
						vm.usosCFDITmp = response.usosCFDI;
						vm.incoterms = response.incoterms;
                        vm.regimenesFiscales = response.regimenesFiscales;
                        vm.tieneCartaPorte = response.tieneCartaPorte;
                        vm.tieneEscuelas = response.tieneEscuelas;

					}

				}, function errorCallback(response) {
					vm.obtenerDatos();
				  });
        	};


        	vm.opcionesFactura = function(){

                ngDialog.openConfirm({
                    template: 'opcionesFactura',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'OpcionesFacturaController',
                    data: {factura: vm.factura}
                }).then(function (buscar) {

                }, function (factura) {

                	if(factura.tipoDocumento != undefined){
                		vm.factura.impuestosTrasladados = factura.impuestosTrasladados;
                		vm.factura.impuestosRetenidos = factura.impuestosRetenidos;
                		vm.factura.cuentaPredial = factura.cuentaPredial;
                		vm.factura.moneda = factura.moneda;
                		vm.factura.tipoCambio = factura.tipoCambio;
                		vm.factura.truncar = factura.truncar;
                        if(factura.norma !== undefined){
                            vm.factura.norma = factura.norma;
                            vm.factura.leyenda = factura.leyenda;
                        }
                	}

                	vm.calcularTotales();
                });

            };



            vm.facturaRelacionada = function(){

            	vm.factura.facturasRelacionadas.noFactura = '';

                ngDialog.openConfirm({
                    template: 'facturasRelacionadas',
                    className: 'ngdialog-theme-default',
                    controller: 'FacturasRelacionadasController',
                    data: {tipoRelaciones: vm.tipoRelaciones, facturasRelacionadas: vm.factura.facturasRelacionadas}
                }).then(function (documento) {

                }, function (documento) {
                	console.log(documento);
                	if(documento.tipoRelacion != undefined){
                		vm.factura.facturasRelacionadas = documento;
                	}
                });

            };

            vm.agregrProdExistente = function(){
            	if(vm.productoAgregar.id_producto != undefined){
            		vm.productoAgregar.precioU = Number(vm.productoAgregar.precioU);
            		vm.productoAgregar.qty = 1;
            		vm.productoAgregar.descuento = 0;
                    vm.productoAgregar.objetoImp =
                        vm.factura.impuestosTrasladados.length > 0 || vm.factura.impuestosRetenidos.length > 0 ?
                            '02' : '01';
                    vm.productoAgregar.montoUSD = 0;
                    vm.productoAgregar.fraccionArancelaria = '';
                    vm.productoAgregar.valorUnitarioAduana = 0;
                    vm.productoAgregar.cantidadAduana = 1;
                    vm.productoAgregar.unidadAduana = '01';

            		vm.factura.detalles.push(angular.copy(vm.productoAgregar));
            		vm.productoAgregar = '';
            	}


            	vm.calcularTotales();
            };


            vm.agregrProdNuevo = function(){
            		const productoNuevo = {
            			codigo: '1',
            			clave: '',
            			nombre: '',
            			unidad: '',
            			qty: 1,
            			precioU: 1.00,
            			descuento: 0,
                        montoUSD : 0,
                        fraccionArancelaria : '',
                        valorUnitarioAduana : 0,
                        cantidadAduana : 1,
                        unidadAduana : '01'
            		};
            		vm.factura.detalles.push(productoNuevo);
            		vm.productoAgregar = '';

            	vm.calcularTotales();
            };

            vm.calcularTotales = function(){

            	vm.factura.subtotal = 0;
            	vm.factura.total = 0;
            	vm.factura.base = 0;
            	vm.factura.descuento = 0;
            	vm.factura.totalTraslados = 0;
            	vm.factura.totalRetenciones = 0;

            	for(var y = 0; y < vm.factura.impuestosTrasladados.length; y++){
        			vm.factura.impuestosTrasladados[y].total = 0;
            	}

            	for(var y = 0; y < vm.factura.impuestosRetenidos.length; y++){
        			vm.factura.impuestosRetenidos[y].total = 0;
            	}

            	for(var x = 0; x < vm.factura.detalles.length; x++){

            		vm.factura.detalles[x].precioU = $rootScope.toFixedNumber(vm.factura.detalles[x].precioU);
            		vm.factura.detalles[x].descuento = $rootScope.toFixedNumber(vm.factura.detalles[x].descuento);
                    vm.factura.detalles[x].valorUnitarioAduana = $rootScope.toFixedNumber(vm.factura.detalles[x].valorUnitarioAduana);
                    vm.factura.detalles[x].montoUSD = $rootScope.toFixedNumberSpecial((vm.factura.detalles[x].cantidadAduana * vm.factura.detalles[x].valorUnitarioAduana));

            		let baseItem = $rootScope.toFixedNumberSpecial((vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU));
            		vm.factura.subtotal += baseItem;
            		vm.factura.detalles[x].base = baseItem - vm.factura.detalles[x].descuento;
            		vm.factura.descuento += Number(vm.factura.detalles[x].descuento);

            		for(var y = 0; y < vm.factura.impuestosTrasladados.length; y++){

            			var valorImpuesto = 0;
                		if(vm.factura.impuestosTrasladados[y].factor == 'Tasa'){
                			valorImpuesto = vm.factura.impuestosTrasladados[y].valor * vm.factura.detalles[x].base;
                		}else{
                			valorImpuesto = vm.factura.impuestosTrasladados[y].valor;
                		}

                		valorImpuesto = $rootScope.toFixedNumberSpecial(valorImpuesto);

                		vm.factura.impuestosTrasladados[y].total += valorImpuesto;
                		vm.factura.totalTraslados += valorImpuesto ;
                	}


            		for(var y = 0; y < vm.factura.impuestosRetenidos.length; y++){

            			var valorImpuesto = 0;
                		if(vm.factura.impuestosRetenidos[y].factor == 'Tasa'){
                			valorImpuesto = vm.factura.impuestosRetenidos[y].valor * vm.factura.detalles[x].base;
                		}else{
                			valorImpuesto = vm.factura.impuestosRetenidos[y].valor;
                		}

                		valorImpuesto = $rootScope.toFixedNumberSpecial(valorImpuesto);

                		vm.factura.impuestosRetenidos[y].total += valorImpuesto;
                		vm.factura.totalRetenciones += valorImpuesto ;
                	}



            	}

            	vm.factura.total = vm.factura.base = vm.factura.subtotal - vm.factura.descuento;
            	vm.factura.total += (vm.factura.totalTraslados - vm.factura.totalRetenciones);
            	vm.factura.total = $rootScope.toFixedNumber(vm.factura.total);

            };

            vm.borrarConcepto = function(index){
            	vm.factura.detalles.splice(index, 1);
            	vm.calcularTotales();
            };


            /////Funcionalidad select de mobile para customer
            vm.getMatchesCustomer = function(searchText) {
				if(searchText == "" || searchText == null)
					return vm.clientes;
		            var states = vm.clientes.filter(function(customer) {
		            	var pordChane = customer.nmbRecep + " " + customer.rFCRecep;
		                return (pordChane.toUpperCase().match(searchText.toUpperCase()));
		            });

		        return states;
		    }

            vm.selectedCustomer = function(cliente){
				if(typeof(cliente) != 'undefined' && typeof(cliente.id_cliente) != 'undefined'){
					vm.factura.id_cliente = cliente;
					vm.obtenerPaises();
				}else{
					vm.factura.id_cliente = 0;
				}
			};
			////////////////////////////

			vm.obtenerPaises = function(){

				vm.usosCFDITmp = [];

				if(isNaN(Number(vm.factura.id_cliente.rFCRecep.charAt(3)))){

					vm.usosCFDITmp = vm.usosCFDI;

				}else{
					for(var x = 0; x < vm.usosCFDI.length; x++){
						if(vm.usosCFDI[x].validMoral == 1){
							vm.usosCFDITmp.push(vm.usosCFDI[x]);
						}
					}
				}

				vm.factura.formaPago = vm.factura.id_cliente.metodoPago;
				vm.factura.usoCFDI = vm.factura.id_cliente.usoCFDI

				if( vm.factura.id_cliente!= null && vm.factura.id_cliente.rFCRecep == 'XEXX010101000'){

					$http.post('/api/admin/facturacion/obtenerPaises', {
						user : $rootScope.user
					}).then(function(res) {
						var response = res['data'];
						if (response['success']) {

							vm.loading = "";
							vm.paises = response.paises;
						}

					}, function errorCallback(response) {
						vm.obtenerDatos();
					  });

				}
			};


			vm.obtenerEstados = function(tipoDato){

				var pais = (tipoDato == 1)? vm.factura.comercio.emisor.pais : vm.factura.comercio.receptor.pais;

				$http.post('/api/admin/facturacion/obtenerEstados', {
					user : $rootScope.user,
					pais: pais
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						if(tipoDato == 1){
							vm.estados = response.estados;
						}else{
							vm.estadosR = response.estados;
						}

					}

				}, function errorCallback(response) {
				 });

			}

			vm.obtenerMunicipios = function(tipoDato){

				var estado = (tipoDato == 1)? vm.factura.comercio.emisor.estado : vm.factura.comercio.receptor.estado;

				$http.post('/api/admin/facturacion/obtenerMunicipios', {
					user : $rootScope.user,
					estado: estado
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.municipios = response.municipios;
						if(tipoDato == 1){
							vm.municipios = response.municipios;
						}else{
							vm.municipiosR = response.municipios;
						}
					}

				}, function errorCallback(response) {
				 });

			}

			vm.borrarFacturaRelacionada = function(index){
				vm.factura.facturasRelacionadas.uuids.splice(index, 1);
			};


			vm.seleccionarMetodoPago = function(){
				if(vm.factura.metodoDePago == 'PPD'){
					vm.factura.formaPago = '99';
					$("#formaPago").trigger("chosen:updated");
				}
			};


			vm.facturar = function(){

				if(vm.factura.id_cliente == '' || vm.factura.id_cliente == null){
					Notify.alert('Debe seleccionar un cliente.', {status: 'danger'});
					$('#id_cliente').trigger('chosen:activate');
					return;
				}

				if(vm.factura.formaPago == '' || vm.factura.formaPago == null){
					Notify.alert('Debe seleccionar una forma de pago.', {status: 'danger'});
					$('#formaPago').trigger('chosen:activate');
					$('#formaPago').focus();
					return;
				}


				if(vm.factura.lugarExpedicion == '' || vm.factura.lugarExpedicion == null || vm.factura.lugarExpedicion.length < 5 ){
					Notify.alert('Debe ingresar un lugar de expedición correcto (C.P.)', {status: 'danger'});
					$('#lugarExpedicion').focus();
					return;
				}


				if(vm.factura.usoCFDI == '' || vm.factura.usoCFDI == null || vm.factura.usoCFDI == '0'){
					Notify.alert('Debe seleccionar el uso del CFDI.', {status: 'danger'});
					$('#usoCFDI').trigger('chosen:activate');
					$('#usoCFDI').focus();
					return;
				}

				if(vm.factura.detalles.length == 0){
					Notify.alert('Debe agregar al menos un producto.', {status: 'danger'});
					return;
				}

                if(vm.factura.comercio.incoterm.length == 0){
                    Notify.alert('Debes seleccionar el INCOTERM.', {status: 'danger'});
                    return;
                }

                if(vm.factura.comercio.emisor.codigoPostal.length != 5){
                    Notify.alert('El código postal del emisor no es correcto.', {status: 'danger'});
                    return;
                }

				for(var x = 0; x < vm.factura.detalles.length; x++){

					var concepto = vm.factura.detalles[x];

					if(concepto.clave == ''){
						Notify.alert('Debe seleccionar una clave para cada concepto.', {status: 'danger'});
						$('#clave' + x).focus();
						$('#clave' + x).trigger('chosen:activate');
						return;
					}

					if(concepto.nombre == ''){
						Notify.alert('Debe agregar una descripción para cada concepto.', {status: 'danger'});
						$('#nombre' + x).focus();
						return;
					}

					if(concepto.unidad == null || concepto.unidad == ''){
						Notify.alert('Debe seleccionar una unidad para cada concepto.', {status: 'danger'});
						$('#unidad' + x).focus();
						$('#unidad' + x).trigger('chosen:activate');
						return;
					}

					if(concepto.qty == null || concepto.qty < 0.00001){
						Notify.alert('La cantidad por concepto debe ser al mayor a 0.', {status: 'danger'});
						$('#qty' + x).focus();
						return;
					}

					if(concepto.precioU == null){
						Notify.alert('Debe ingresar un precio unitario.', {status: 'danger'});
						$('#precioU' + x).focus();
						return;
					}

				}

				vm.loading = "whirl double-up";

				var urlFacturar = '/api/admin/facturacion/facturar40';
				$http.post(urlFacturar, {
					user : $rootScope.user,
					factura: vm.factura
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						SweetAlert.swal('Éxito!', 'Se generó su factura de forma correcta con el No. ' + response.facturaResult, 'success');
						$state.transitionTo('app.listadoFacturas');

					}else{
						SweetAlert.swal('Error!', response.errorCode + ' - ' + response.errortext + ' <br>' + response.nombreArchivo, 'error');
					}

					vm.loading = "";

				}, function errorCallback(response) {
					vm.loading = "";
				});



			};


			vm.facturarTest = function(){

				if(vm.factura.id_cliente == '' || vm.factura.id_cliente == null){
					Notify.alert('Debe seleccionar un cliente.', {status: 'danger'});
					$('#id_cliente').trigger('chosen:activate');
					return;
				}

				if(vm.factura.formaPago == '' || vm.factura.formaPago == null){
					Notify.alert('Debe seleccionar una forma de pago.', {status: 'danger'});
					$('#formaPago').trigger('chosen:activate');
					$('#formaPago').focus();
					return;
				}


				if(vm.factura.lugarExpedicion == '' || vm.factura.lugarExpedicion == null || vm.factura.lugarExpedicion.length < 5 ){
					Notify.alert('Debe ingresar un lugar de expedición correcto (C.P.)', {status: 'danger'});
					$('#lugarExpedicion').focus();
					return;
				}


				if(vm.factura.usoCFDI == '' || vm.factura.usoCFDI == null || vm.factura.usoCFDI == '0'){
					Notify.alert('Debe seleccionar el uso del CFDI.', {status: 'danger'});
					$('#usoCFDI').trigger('chosen:activate');
					$('#usoCFDI').focus();
					return;
				}

				if(vm.factura.detalles.length == 0){
					Notify.alert('Debe agregar al menos un producto.', {status: 'danger'});
					return;
				}

				for(var x = 0; x < vm.factura.detalles.length; x++){

					var concepto = vm.factura.detalles[x];

					if(concepto.clave == ''){
						Notify.alert('Debe seleccionar una clave para cada concepto.', {status: 'danger'});
						$('#clave' + x).focus();
						$('#clave' + x).trigger('chosen:activate');
						return;
					}

					if(concepto.nombre == ''){
						Notify.alert('Debe agregar una descripción para cada concepto.', {status: 'danger'});
						$('#nombre' + x).focus();
						return;
					}

					if(concepto.unidad == null || concepto.unidad == ''){
						Notify.alert('Debe seleccionar una unidad para cada concepto.', {status: 'danger'});
						$('#unidad' + x).focus();
						$('#unidad' + x).trigger('chosen:activate');
						return;
					}

					if(concepto.qty == null || concepto.qty < 0.00001){
						Notify.alert('La cantidad por concepto debe ser al mayor a 0.', {status: 'danger'});
						$('#qty' + x).focus();
						return;
					}

					if(concepto.precioU == null){
						Notify.alert('Debe ingresar un precio unitario.', {status: 'danger'});
						$('#precioU' + x).focus();
						return;
					}

				}

				vm.loading = "whirl double-up";


				$http.post('/api/admin/facturacion/facturarTest', {
					user : $rootScope.user,
					factura: vm.factura
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						SweetAlert.swal('Éxito!', 'Se generó su factura de forma correcta con el No. ' + response.facturaResult, 'success');
						$state.transitionTo('app.listadoFacturas');

					}else{
						SweetAlert.swal('Error!', response.errorCode + ' - ' + response.errortext + ' <br>' + response.nombreArchivo, 'error');
					}

					vm.loading = "";

				}, function errorCallback(response) {
					vm.loading = "";
				});



			};



        	vm.obtenerDatos();



        }
    }
})();




(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('NuevaFacturaConceptoController', NuevaFacturaConceptoController);

    NuevaFacturaConceptoController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function NuevaFacturaConceptoController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {
        var vm = this;

        vm.clientes = [];
        vm.formasDePago = [];
        vm.productos = [];
        vm.unidadesMedida = [];
		vm.clavesProducto = [];
		vm.usosCFDI = [];
		vm.usosCFDITmp = [];
		vm.searchTextCustomer = '';
		vm.series = [];
		vm.disableCp = false;
        vm.factura = {
        		tipoDocumento: 'I',
        		id_cliente: '',
            	decimales: '2',
        		guardarProd: false,
        		moneda: 'MXN',
        		tipoCambio: 1.0,
        		detalles: [],
        		descuento: 0,
        		facturasRelacionadas: {
            		tipoRelacion: '',
            		noFactura: '',
            		uuids: []

            	},
        		cuentaPredial: '',
        		formaPago: '',
        		lugarExpedicion: '',
        		serie: 'A',
        		metodoDePago: 'PUE',
                exportacion: '01',
            versionF: '4.0'
        }
        vm.productoAgregar = '';
        vm.tipoRelaciones = [
                             {value: '01', label: 'Nota de crédito de los documentos relacionados'},
                             {value: '02', label: 'Nota de débito de los documentos relacionados'},
                             {value: '03', label: 'Devolución de mercancía sobre facturas o traslados previos'},
                             {value: '04', label: 'Sustitución de los CFDI previos'},
                             {value: '05', label: 'Traslados de mercancias facturados previamente'},
                             {value: '06', label: 'Factura generada por los traslados previos'},
                             {value: '07', label: 'CFDI por aplicación de anticipo'}
                            ];
        vm.metodosDePago = [{codigo: 'PUE', descripcion: 'Pago en una sola exhibición'}, {codigo: 'PPD', descripcion: 'Pago en parcialidades o diferido'}];

        vm.cambiarTipoDocumento = function(tipo){
        	vm.factura.tipoDocumento = tipo;
        	if(vm.factura.tipoDocumento == 'P')
        		$state.transitionTo('app.nuevoPago');
        };

        activate();

        ////////////////

        function activate() {

        	vm.obtenerNombreTipoRelacion = function(){
        		for(var x = 0; x < vm.tipoRelaciones.length; x++){
        			if(vm.tipoRelaciones[x].value == vm.factura.facturasRelacionadas.tipoRelacion){
        				return vm.tipoRelaciones[x].label;
        			}
        		}
        	};


        	vm.obtenerDatos = function(){

        		if($stateParams.tipoDocumento != undefined && $stateParams.tipoDocumento != ''){
        			vm.factura.tipoDocumento = $stateParams.tipoDocumento;
        		}

	        	vm.loading = "whirl double-up";

	        	$http.post('/api/admin/facturacion/datosFacturar', {
					user : $rootScope.user
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.clientes = response.clientes;
						vm.formasDePago = response.formasDePago;
						vm.productos = response.productos;
						vm.unidadesMedida = response.unidadesMedida;
						vm.clavesProducto = response.clavesProducto;
						vm.usosCFDI = response.usosCFDI;
						vm.series = response.series;
						vm.factura.lugarExpedicion = response.proveedor.domicilio.codigoPostal;
						vm.usosCFDITmp = response.usosCFDI;
                        vm.regimenesFiscales = response.regimenesFiscales;
                        vm.tieneCartaPorte = response.tieneCartaPorte;
                        vm.tieneEscuelas = response.tieneEscuelas;

					}

				}, function errorCallback(response) {
					vm.obtenerDatos();
				  });
        	};


        	vm.opcionesFactura = function(){

                ngDialog.openConfirm({
                    template: 'opcionesFactura',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'OpcionesFacturaController',
                    data: {factura: vm.factura}
                }).then(function (buscar) {

                }, function (factura) {

                	if(factura.tipoDocumento != undefined){
                		vm.factura.impuestosTrasladados = factura.impuestosTrasladados;
                		vm.factura.impuestosRetenidos = factura.impuestosRetenidos;
                		vm.factura.cuentaPredial = factura.cuentaPredial;
                		vm.factura.moneda = factura.moneda;
                		vm.factura.tipoCambio = factura.tipoCambio;
                		vm.factura.truncar = factura.truncar;
                        if(factura.norma !== undefined){
                            vm.factura.norma = factura.norma;
                            vm.factura.leyenda = factura.leyenda;
                        }
                	}

                	vm.calcularTotales();
                });

            };



            vm.facturaRelacionada = function(){

            	vm.factura.facturasRelacionadas.noFactura = '';

                ngDialog.openConfirm({
                    template: 'facturasRelacionadas',
                    className: 'ngdialog-theme-default',
                    controller: 'FacturasRelacionadasController',
                    data: {tipoRelaciones: vm.tipoRelaciones, facturasRelacionadas: vm.factura.facturasRelacionadas}
                }).then(function (documento) {

                }, function (documento) {
                	if(documento.tipoRelacion != undefined){
                		vm.factura.facturasRelacionadas = documento;
                	}
                });

            };


            vm.impuestosConcepto = function(index){

            	var concepto = vm.factura.detalles[index];

                ngDialog.openConfirm({
                    template: 'impuestosConcepto',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'ImpuestoConceptoController',
                    data: {concepto: concepto}
                }).then(function (concepto) {

                }, function (concepto) {
                	if(concepto.qty != undefined && concepto.qty > 0){
                		vm.factura.detalles[index] = concepto;
                		vm.calcularTotales();
                	}
                });

            };

            vm.agregrProdExistente = function(){
            	if(vm.productoAgregar.id_producto != undefined){
            		vm.productoAgregar.precioU = Number(vm.productoAgregar.precioU);
            		vm.productoAgregar.qty = 1;
            		vm.productoAgregar.descuento = 0;
                    vm.productoAgregar.objetoImp = '02';
            		vm.productoAgregar.impuestosTrasladados = [];
            		vm.productoAgregar.impuestosRetenidos = [];
            		vm.factura.detalles.push(angular.copy(vm.productoAgregar));
            		vm.productoAgregar = '';
            	}

            	vm.calcularTotales();
            };


            vm.agregrProdNuevo = function(){
            		var productoNuevo = {
            			codigo: '1',
            			clave: '',
            			nombre: '',
            			unidad: '',
            			qty: 1,
            			precioU: 1.00,
            			descuento: 0,
            			impuestosTrasladados: [],
            			impuestosRetenidos : [],
                        objetoImp: '02'
            		};
            		vm.factura.detalles.push(productoNuevo);
            		vm.productoAgregar = '';

            	vm.calcularTotales();
            };

            vm.calcularTotales = function(){

            	vm.factura.subtotal = 0;
            	vm.factura.total = 0;
            	vm.factura.base = 0;
            	vm.factura.descuento = 0;
            	vm.factura.totalTraslados = 0;
            	vm.factura.totalRetenciones = 0;
            	vm.factura.impuestosTrasladados = [];
            	vm.factura.impuestosRetenidos = [];

            	console.log(vm.factura.detalles);

            	for(var x = 0; x < vm.factura.detalles.length; x++){

            		for(var y = 0; y < vm.factura.detalles[x].impuestosTrasladados.length; y++){
            			vm.factura.detalles[x].impuestosTrasladados[y].total = 0;
                	}

                	for(var y = 0; y < vm.factura.detalles[x].impuestosRetenidos.length; y++){
                		vm.factura.detalles[x].impuestosRetenidos[y].total = 0;
                	}

            		vm.factura.detalles[x].precioU = $rootScope.toFixedNumber(vm.factura.detalles[x].precioU);
            		vm.factura.detalles[x].descuento = $rootScope.toFixedNumber(vm.factura.detalles[x].descuento);

            		vm.factura.subtotal += $rootScope.toFixedNumber((vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU));
            		vm.factura.detalles[x].base = (vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU - vm.factura.detalles[x].descuento);
            		vm.factura.descuento += Number(vm.factura.detalles[x].descuento);


            		for(var y = 0; y < vm.factura.detalles[x].impuestosTrasladados.length; y++){

            			var tmp1 = vm.factura.detalles[x].impuestosTrasladados[y];
            			vm.factura.detalles[x].impuestosTrasladados[y].base = vm.factura.detalles[x].base;
                        const montoBase = Number(vm.factura.detalles[x].base);

            			var valorImpuesto = 0;
                		if(vm.factura.detalles[x].impuestosTrasladados[y].factor == 'Tasa'){
                			valorImpuesto = $rootScope.toFixedNumber(vm.factura.detalles[x].impuestosTrasladados[y].valor * vm.factura.detalles[x].impuestosTrasladados[y].base);
                		}else{
                			valorImpuesto = $rootScope.toFixedNumber(vm.factura.detalles[x].impuestosTrasladados[y].valor);
                		}
                		vm.factura.detalles[x].impuestosTrasladados[y].total = valorImpuesto;
                		vm.factura.totalTraslados += valorImpuesto ;

                		var addNewTax = true;

                		for(var z = 0; z < vm.factura.impuestosTrasladados.length; z++){

                			var tmp2 = vm.factura.impuestosTrasladados[z];

                			if(vm.factura.impuestosTrasladados[z].impuesto == vm.factura.detalles[x].impuestosTrasladados[y].impuesto
                					&& vm.factura.impuestosTrasladados[z].factor == vm.factura.detalles[x].impuestosTrasladados[y].factor
                						&& vm.factura.impuestosTrasladados[z].valor == vm.factura.detalles[x].impuestosTrasladados[y].valor){

                                vm.factura.impuestosTrasladados[z].base += montoBase;
                				vm.factura.impuestosTrasladados[z].total += valorImpuesto;
                				addNewTax = false;
                			}
                		}

                		if(addNewTax){
                			vm.factura.impuestosTrasladados.push(angular.copy(vm.factura.detalles[x].impuestosTrasladados[y]));
                		}

                	}


            		for(var y = 0; y < vm.factura.detalles[x].impuestosRetenidos.length; y++){

            			var valorImpuesto = 0;
            			vm.factura.detalles[x].impuestosRetenidos[y].base = vm.factura.detalles[x].base;

                		if(vm.factura.detalles[x].impuestosRetenidos[y].factor == 'Tasa'){
                			valorImpuesto = $rootScope.toFixedNumber(vm.factura.detalles[x].impuestosRetenidos[y].valor * vm.factura.detalles[x].impuestosRetenidos[y].base);
                		}else{
                			valorImpuesto = $rootScope.toFixedNumber(vm.factura.detalles[x].impuestosRetenidos[y].valor);
                		}
                		vm.factura.detalles[x].impuestosRetenidos[y].total += valorImpuesto;
                		vm.factura.totalRetenciones += valorImpuesto;

                		var addNewTax = true;

                		for(var z = 0; z < vm.factura.impuestosRetenidos.length; z++){
                			if(vm.factura.impuestosRetenidos[z].impuesto == vm.factura.detalles[x].impuestosRetenidos[y].impuesto
                					&& vm.factura.impuestosRetenidos[z].factor == vm.factura.detalles[x].impuestosRetenidos[y].factor
                						&& vm.factura.impuestosRetenidos[z].valor == vm.factura.detalles[x].impuestosRetenidos[y].valor){

                				vm.factura.impuestosRetenidos[z].total += valorImpuesto;
                				addNewTax = false;
                			}
                		}

                		if(addNewTax){
                			vm.factura.impuestosRetenidos.push(angular.copy(vm.factura.detalles[x].impuestosRetenidos[y]));
                		}
                	}

            	}

            	vm.factura.total = vm.factura.base = vm.factura.subtotal - vm.factura.descuento;
            	vm.factura.total += (vm.factura.totalTraslados - vm.factura.totalRetenciones);
            	vm.factura.total = $rootScope.toFixedNumber(vm.factura.total);

            };

            vm.borrarConcepto = function(index){
            	vm.factura.detalles.splice(index, 1);
            	vm.calcularTotales();
            };


            /////Funcionalidad select de mobile para customer
            vm.getMatchesCustomer = function(searchText) {
				if(searchText == "" || searchText == null)
					return vm.clientes;
		            var states = vm.clientes.filter(function(customer) {
		            	var pordChane = customer.nmbRecep + " " + customer.rFCRecep;
		                return (pordChane.toUpperCase().match(searchText.toUpperCase()));
		            });

		        return states;
		    }

            vm.selectedCustomer = function(cliente){
				if(typeof(cliente) != 'undefined' && typeof(cliente.id_cliente) != 'undefined'){
					vm.factura.id_cliente = cliente;
					vm.obtenerPaises();
				}else{
					vm.factura.id_cliente = 0;
				}
			};
			////////////////////////////

			vm.obtenerPaises = function(){

				vm.usosCFDITmp = [];
                vm.disableCp = false;

				if(isNaN(Number(vm.factura.id_cliente.rFCRecep.charAt(3)))){

					vm.usosCFDITmp = vm.usosCFDI;

				}else{
					for(var x = 0; x < vm.usosCFDI.length; x++){
						if(vm.usosCFDI[x].validMoral == 1){
							vm.usosCFDITmp.push(vm.usosCFDI[x]);
						}
					}
				}

				vm.factura.formaPago = vm.factura.id_cliente.metodoPago;
				vm.factura.usoCFDI = vm.factura.id_cliente.usoCFDI
                vm.obtenerRegimenesFiscales();

				if( vm.factura.id_cliente!= null && vm.factura.id_cliente.rFCRecep == 'XEXX010101000'){

					$http.post('/api/admin/facturacion/obtenerPaises', {
						user : $rootScope.user
					}).then(function(res) {
						var response = res['data'];
						if (response['success']) {

							vm.loading = "";
							vm.paises = response.paises;
						}

					}, function errorCallback(response) {
						vm.obtenerDatos();
					  });

				}else if( vm.factura.id_cliente!= null && vm.factura.id_cliente.rFCRecep == 'XAXX010101000'){
                    vm.actualizarDatosPublicoGeneral();
                }
			};

			vm.borrarFacturaRelacionada = function(index){
				vm.factura.facturasRelacionadas.uuids.splice(index, 1);
			};


			vm.seleccionarMetodoPago = function(){
				if(vm.factura.metodoDePago == 'PPD'){
					vm.factura.formaPago = '99';
					$("#formaPago").trigger("chosen:updated");
				}
			};


			vm.facturar = function(){

				if(vm.factura.id_cliente == '' || vm.factura.id_cliente == null){
					Notify.alert('Debe seleccionar un cliente.', {status: 'danger'});
					$('#id_cliente').trigger('chosen:activate');
					return;
				}

				if(vm.factura.formaPago == '' || vm.factura.formaPago == null){
					Notify.alert('Debe seleccionar una forma de pago.', {status: 'danger'});
					$('#formaPago').trigger('chosen:activate');
					$('#formaPago').focus();
					return;
				}


				if(vm.factura.lugarExpedicion == '' || vm.factura.lugarExpedicion == null || vm.factura.lugarExpedicion.length < 5 ){
					Notify.alert('Debe ingresar un lugar de expedición correcto (C.P.)', {status: 'danger'});
					$('#lugarExpedicion').focus();
					return;
				}


				if(vm.factura.usoCFDI == '' || vm.factura.usoCFDI == null){
					Notify.alert('Debe seleccionar el uso del CFDI.', {status: 'danger'});
					$('#usoCFDI').trigger('chosen:activate');
					$('#usoCFDI').focus();
					return;
				}

				if(vm.factura.detalles.length == 0){
					Notify.alert('Debe agregar al menos un producto.', {status: 'danger'});
					return;
				}

				for(var x = 0; x < vm.factura.detalles.length; x++){

					var concepto = vm.factura.detalles[x];

					if(concepto.clave == ''){
						Notify.alert('Debe seleccionar una clave para cada concepto.', {status: 'danger'});
						$('#clave' + x).focus();
						$('#clave' + x).trigger('chosen:activate');
						return;
					}

					if(concepto.nombre == ''){
						Notify.alert('Debe agregar una descripción para cada concepto.', {status: 'danger'});
						$('#nombre' + x).focus();
						return;
					}

					if(concepto.qty == null || concepto.qty < 0.00001){
						Notify.alert('La cantidad por concepto debe ser al mayor a 0.', {status: 'danger'});
						$('#qty' + x).focus();
						return;
					}

					if(concepto.precioU == null){
						Notify.alert('Debe ingresar un precio unitario.', {status: 'danger'});
						$('#precioU' + x).focus();
						return;
					}

				}

				vm.loading = "whirl double-up";

                let urlFacturar = 'facturarPorConcepto';
                if(vm.factura.versionF == '4.0')
                    urlFacturar = 'facturarPorConcepto40';

				$http.post('/api/admin/facturacion/'+urlFacturar, {
					user : $rootScope.user,
					factura: vm.factura
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						SweetAlert.swal('Éxito!', 'Se generó su factura de forma correcta con el No. ' + response.facturaResult, 'success');
						$state.transitionTo('app.listadoFacturas');

					}else{
						SweetAlert.swal('Error!', response.errorCode + ' - ' + response.errortext + ' <br>' + response.nombreArchivo, 'error');
					}

					vm.loading = "";

				}, function errorCallback(response) {
					vm.loading = "";
				});
			};


            vm.obtenerRegimenesFiscales = function (){
                vm.regimenesFiscalesList = [];
                for(let x = 0; x < vm.regimenesFiscales.length; x++){
                    if(vm.regimenesFiscales[x].tipo == vm.factura.id_cliente.tipoPersona || vm.regimenesFiscales[x].tipo == 3){
                        vm.regimenesFiscalesList.push(vm.regimenesFiscales[x]);
                    }
                }
            };

            vm.actualizarDatosPublicoGeneral = function () {
                if(vm.factura.versionF == '4.0' && vm.factura.id_cliente.rFCRecep == 'XAXX010101000'){
                    vm.factura.id_cliente.tipoPersona = '2';
                    vm.obtenerRegimenesFiscales()
                    vm.disableCp = true;
                    vm.factura.id_cliente.codigoPostal = vm.factura.lugarExpedicion;
                    vm.factura.id_cliente.regimenFiscalReceptor = '616';
                    vm.factura.usoCFDI = 'S01';
                    vm.factura.formaPago = '99'

                    $("#usoCFDI").trigger("chosen:updated");
                    $("#formaPago").trigger("chosen:updated");
                }
            }

            vm.getNombreRegimen = function (code) {
                for(let x = 0; x < vm.regimenesFiscales.length; x++){
                    if(vm.regimenesFiscales[x].code === code){
                       return vm.regimenesFiscales[x].descripcion;
                    }
                }
            }



        	vm.obtenerDatos();



        }
    }
})();



(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('OpcionesFacturaController', OpcionesFacturaController);

    OpcionesFacturaController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function OpcionesFacturaController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {

    	$scope.factura = angular.copy($scope.ngDialogData.factura);

    	$scope.impTrasladados = [{
    	                        	 impuesto: 'IVA',
    	                        	 codigo: '002',
    	                        	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0, 0.16, 0.06, 0.08] }}, {label: 'Exento', options: {isSelect: false}}]
    	                         },
    	                         {
    	                        	 impuesto: 'IEPS',
    	                        	 codigo: '003',
    	                        	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0,0.03,0.06,0.07,0.08,0.09,0.25,0.265,0.3,0.304,0.50,0.53,1.60] }}, {label: 'Exento', options: {isSelect: false}}]
    	                         },
    	                         {
    	                        	 impuesto: 'ISH',
    	                        	 codigo: 'XXX',
    	                        	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
    	                         }];

    	$scope.impRetenidos = [{
    	                        	 impuesto: 'IVA',
    	                        	 codigo: '002',
    	                        	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 0.16 }}, {label: 'Exento', options: {isSelect: false}}]
    	                         },
    	                         {
    	                        	 impuesto: 'IEPS',
    	                        	 codigo: '003',
    	                        	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0.03,0.06,0.07,0.08,0.09,0.25,0.265,0.3,0.304,0.50,0.53,1.60] }}, {label: 'Cuota', options: {isSelect: false, min: 0, max: 43.77}}, {label: 'Exento', options: {isSelect: false}}]
    	                         },
    	                         {
    	                        	 impuesto: 'ISR',
    	                        	 codigo: '001',
    	                        	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 0.35 }}, {label: 'Cuota', options: {isSelect: false, min: 0, max: 43.77}}, {label: 'Exento', options: {isSelect: false}}]
    	                         },
    	                         {
    	                        	 impuesto: 'ISH',
    	                        	 codigo: 'XXX',
    	                        	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
    	                         },
    	                         {
    	                        	 impuesto: 'Ret 5 al millar',
    	                        	 codigo: 'XXX',
    	                        	 factor: [{label: 'Cuota', options: {isSelect: false, min: 0, max: 99999999999999}}, {label: 'Tasa', options: {isSelect: false, min: 0, max: 1 }}]
    	                         },
                                {
                                    impuesto: 'Ret 2 al millar',
                                    codigo: 'XXX',
                                    factor: [{label: 'Cuota', options: {isSelect: false, min: 0, max: 99999999999999}}, {label: 'Tasa', options: {isSelect: false, min: 0, max: 1 }}]
                                },
                                {
                                    impuesto: 'Retención del 1% al millar',
                                    codigo: 'XXX',
                                    factor: [{label: 'Cuota', options: {isSelect: false, min: 0, max: 99999999999999}}, {label: 'Tasa', options: {isSelect: false, min: 0, max: 1 }}]
                                },
    	                         {
    	                          	 impuesto: '.63% AL MILLAR INSPECCIÓN Y VIGILANCIA',
    	                          	 codigo: 'XXX',
    	                          	 factor: [{label: 'Cuota', options: {isSelect: false, min: 0, max: 99999999999999}}, {label: 'Tasa', options: {isSelect: false, min: 0, max: 99999999999999}}]
    	                           },
    	                           {
      	                          	 impuesto: 'Deducible',
      	                          	 codigo: 'XXX',
      	                          	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 99999999999999}}]
      	                           }];

    	$scope.traslado = {
    		impuesto: '',
    		factor: '',
    		valor: ''
    	};

    	$scope.retencion = {
        		impuesto: '',
        		factor: '',
        		valor: ''
        	};


    	$scope.agregarTraslado = function(){

    		if($scope.traslado.impuesto == '' || $scope.traslado.impuesto == null){
    			Notify.alert('Debe seleccionar un impuesto del listado.', {status: 'danger'});
    			return;
    		}

    		if($scope.traslado.factor == '' || $scope.traslado.factor == null){
    			Notify.alert('Debe seleccionar tasa/cuota/excento.', {status: 'danger'});
    			return;
    		}

    		if($scope.traslado.factor.label != 'Exento' && ($scope.traslado.valor === '' || $scope.traslado.valor === null)){
    			Notify.alert('Debe seleccionar/ingresar el valor del impuesto.', {status: 'danger'});
    			return;
    		}


    		var nuevoImpuesto = {
    				factor:  $scope.traslado.factor.label,
    				impuesto:  $scope.traslado.impuesto.codigo,
    				label: $scope.traslado.impuesto.impuesto,
    				valor: $rootScope.toFixedNumber($scope.traslado.valor, 6)
    		}

    		if(nuevoImpuesto.factor == 'Exento')
    			nuevoImpuesto.valor = 0;

    		$scope.factura.impuestosTrasladados.push(nuevoImpuesto);

    		$scope.traslado = {
            		impuesto: '',
            		factor: '',
            		valor: ''
            	};

    		$scope.validarImpuestosActuales();

    	};

    	$scope.agregarRetencion = function(){


    		if($scope.retencion.impuesto == '' || $scope.retencion.impuesto == null){
    			Notify.alert('Debe seleccionar un impuesto del listado.', {status: 'danger'});
    			return;
    		}

    		if($scope.retencion.factor == '' || $scope.retencion.factor == null){
    			Notify.alert('Debe seleccionar tasa/cuota/excento.', {status: 'danger'});
    			return;
    		}

    		if($scope.retencion.factor.label != 'Exento' && ($scope.retencion.valor === '' || $scope.retencion.valor === null)){
    			Notify.alert('Debe seleccionar/ingresar el valor del impuesto.', {status: 'danger'});
    			return;
    		}

    		if($scope.retencion.factor.options.isSelect == false){
    			if($scope.retencion.valor < $scope.retencion.factor.options.min || $scope.retencion.valor > $scope.retencion.factor.options.max){
    				Notify.alert('El valor del impuesto debe ser entre '+$rootScope.addCommas($scope.retencion.factor.options.min,3)+' y ' + $rootScope.addCommas($scope.retencion.factor.options.max,3), {status: 'danger'});
        			return;
    			}
    		}


    		var nuevoImpuesto = {
    				factor:  $scope.retencion.factor.label,
    				impuesto:  $scope.retencion.impuesto.codigo,
    				label: $scope.retencion.impuesto.impuesto,
    				valor: $rootScope.toFixedNumber($scope.retencion.valor, 6)
    		}

    		if(nuevoImpuesto.factor == 'Exento')
    			nuevoImpuesto.valor = 0;


    		$scope.factura.impuestosRetenidos.push(nuevoImpuesto);

    		$scope.retencion = {
            		impuesto: '',
            		factor: '',
            		valor: ''
            	};

    		$scope.validarImpuestosActuales();
    	};

    	$scope.validarImpuestosActuales = function(){

    		$scope.impTrasladados = [{
           	 impuesto: 'IVA',
           	 codigo: '002',
           	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0, 0.16, 0.06, 0.08] }}, {label: 'Exento', options: {isSelect: false}}]
            },
            {
           	 impuesto: 'IEPS',
           	 codigo: '003',
           	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0,0.03,0.06,0.07,0.08,0.09,0.25,0.265,0.3,0.304,0.50,0.53,1.60] }}, {label: 'Exento', options: {isSelect: false}}]
            },
            {
           	 impuesto: 'ISH',
           	 codigo: 'XXX',
           	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            }];

    		$scope.impRetenidos = [{
           	 impuesto: 'IVA',
           	 codigo: '002',
           	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 0.16 }}, {label: 'Exento', options: {isSelect: false}}]
            },
            {
           	 impuesto: 'IEPS',
           	 codigo: '003',
           	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0.03,0.06,0.07,0.08,0.09,0.25,0.265,0.3,0.304,0.50,0.53,1.60] }}, {label: 'Cuota', options: {isSelect: false, min: 0, max: 43.77}}, {label: 'Exento', options: {isSelect: false}}]
            },
            {
           	 impuesto: 'ISR',
           	 codigo: '001',
           	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 0.35 }}, {label: 'Cuota', options: {isSelect: false, min: 0, max: 43.77}}, {label: 'Exento', options: {isSelect: false}}]
            },
            {
              impuesto: 'CEDULAR',
              codigo: 'XXX',
              factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            },
            {
             impuesto: 'ISH',
             codigo: 'XXX',
             factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            },
            {
             impuesto: 'Amortización por devolución de anticipo',
             codigo: 'XXX',
             factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            },
            {
             impuesto: 'Por garantía de obra',
             codigo: 'XXX',
             factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            },
            {
                impuesto: 'RTP',
                codigo: 'XXX',
                factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            },
            {
           	 impuesto: 'Ret 5 al millar',
           	 codigo: 'XXX',
           	 factor: [{label: 'Cuota', options: {isSelect: false, min: 0, max: 99999999999999}}, {label: 'Tasa', options: {isSelect: false, min: 0, max: 1 }}]
            },
                {
                    impuesto: 'Ret 2 al millar',
                    codigo: 'XXX',
                    factor: [{label: 'Cuota', options: {isSelect: false, min: 0, max: 99999999999999}}, {label: 'Tasa', options: {isSelect: false, min: 0, max: 1 }}]
                },
                {
                    impuesto: 'Retención del 1% al millar',
                    codigo: 'XXX',
                    factor: [{label: 'Cuota', options: {isSelect: false, min: 0, max: 99999999999999}}, {label: 'Tasa', options: {isSelect: false, min: 0, max: 1 }}]
                },
            {
              	 impuesto: '.63% AL MILLAR INSPECCIÓN Y VIGILANCIA',
              	 codigo: 'XXX',
              	 factor: [{label: 'Cuota', options: {isSelect: false, min: 0, max: 99999999999999}}, {label: 'Tasa', options: {isSelect: false, min: 0, max: 99999999999999}}]
            },
            {
            	impuesto: 'Deducible',
                codigo: 'XXX',
                factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 99999999999999}}]
            }];

            if($scope.factura.impuestosRetenidos !== undefined)
    		for(var x = 0; x < $scope.factura.impuestosRetenidos.length; x++){
    			for(var y = 0; y < $scope.impRetenidos.length; y++){
    				if($scope.factura.impuestosRetenidos[x].impuesto == $scope.impRetenidos[y].codigo){
    					$scope.impRetenidos.splice(y, 1);
    					break;
    				}
    			}
    		}

            if($scope.factura.impuestosTrasladados !== undefined)
    		for(var x = 0; x < $scope.factura.impuestosTrasladados.length; x++){
    			for(var y = 0; y < $scope.impTrasladados.length; y++){
    				if($scope.factura.impuestosTrasladados[x].impuesto == $scope.impTrasladados[y].codigo){
    					$scope.impTrasladados.splice(y, 1);
    					break;
    				}
    			}
    		}

    	}

    	$scope.borrarImpuesto = function(index, tipoImp){

    		if(tipoImp == 1){
    			$scope.factura.impuestosTrasladados.splice(index, 1);
    		}else{
    			$scope.factura.impuestosRetenidos.splice(index, 1);
    		}

    		$scope.validarImpuestosActuales();
    	};

    	$scope.aplicarCambios = function(){

    		if($scope.factura.cuentaPredial != undefined
    				&& $scope.factura.cuentaPredial != ''){

    			var validarData = /^[0-9]*$/.test($scope.factura.cuentaPredial);

    			if(validarData == false){
    				Notify.alert('La cuenta predial debe contener únicamente números, sin létras. Puede agregarlo completo en el concepto.', {status: 'danger'});
        			return;
    			}
    		}

            if(($scope.factura.norma !== undefined) && $scope.factura.norma.length > 0
                || ($scope.factura.leyenda !== undefined) && $scope.factura.leyenda.length > 0){
                if($scope.factura.leyenda.length === 0){
                    Notify.alert('La leyenda de la factura no debe estar vacía.', {status: 'danger'});
                    jQuery("#leyenda").focus();
                    return;
                }

                if($scope.factura.norma.length === 0){
                    Notify.alert('La norma de la factura no debe estar vacía.', {status: 'danger'});
                    jQuery("#norma").focus();
                    return;
                }
            };


    		$scope.closeThisDialog($scope.factura);
    	};


    	$scope.validarImpuestosActuales();

    }
})();



(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('FacturasRelacionadasController', FacturasRelacionadasController);

    FacturasRelacionadasController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function FacturasRelacionadasController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {

    	$scope.facturas = [];
    	$scope.facturasRelacionadas = [];
    	$scope.loadingRel = "";
    	$scope.selectedUUIDExt = "";
    	$scope.relacionado = angular.copy($scope.ngDialogData.facturasRelacionadas);

    	var wto;

    	$scope.obtenerFacturasRel = function(){

    		if($scope.relacionado.noFactura == null || $scope.relacionado.noFactura == '')
    			return;



	    		$scope.loadingRel = "whirl double-up";

	    		$http.post('/api/admin/facturacion/obtenerFacturasRel', {
					user : $rootScope.user,
					noFactura: $scope.relacionado.noFactura
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {
						$scope.loadingRel = "";
						$scope.facturas = response.facturas;
                        for(let i = 0; i < $scope.facturas.length; i++){
                            $scope.facturas[i].tipoRelacion = '01';
                        }
					}

				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					$scope.loadingRel = "";
				  });

    	};

    	$scope.agregarFacturaRelacionada = function(){

    		if($scope.selectedUUID != null && $scope.selectedUUID.id_factura != undefined){
	    		$scope.relacionado.uuids.push($scope.selectedUUID);
    		}else if($scope.selectedUUIDExt != ""){
    		    if(/^[0-9a-fA-F]{8}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{12}$/.test($scope.selectedUUIDExt)){
    		        let uuid = {
                        serie: 'S/E',
                        noFactura: '',
                        rFCRecep: '',
                        uUID: $scope.selectedUUIDExt
                    }
                    $scope.relacionado.uuids.push(uuid);
                    $scope.selectedUUIDExt = "";
                }
            }
    	};


    	$scope.agregarRelacion = function(){

    		$scope.closeThisDialog($scope.relacionado);

    	};



    }
})();



(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('EnviarFacturasController', EnviarFacturasController);

    EnviarFacturasController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function EnviarFacturasController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {

    	$scope.elementoEnviar = {email: '', id_factura: 0, nota: ''};


    	$scope.obtenerEmailPorCliente = function(){

	    		$scope.loadingEmail = "whirl double-up";

	    		$http.post('/api/admin/facturacion/obtenerEmailPorCliente', {
					user : $rootScope.user,
					id_cliente: $scope.ngDialogData.factura.id_cliente
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						$scope.loadingEmail = "";
						$scope.elementoEnviar.email = response.email;

					}

				}, function errorCallback(response) {
					Notify.alert('Ocurrió un error.', {status: 'danger'});
					$scope.loadingEmail = "";
				  });
    	};

    	$scope.enviarFactura = function(){

    		if(!$rootScope.validarEmail($scope.elementoEnviar.email)){
    			Notify.alert('Por favor ingrese un correo válido.', {status: 'danger'});
    			return;
    		}

    		$scope.loadingEmail = "whirl double-up";
    		$scope.elementoEnviar.id_factura = $scope.ngDialogData.factura.id_factura;

    		$http.post('/api/admin/facturacion/enviarFactura', {
				user : $rootScope.user,
				factura: $scope.elementoEnviar
			}).then(function(res) {
				var response = res['data'];
				if (response['success']) {

					$scope.loadingEmail = "";
					$scope.closeThisDialog(1);

				}

			}, function errorCallback(response) {
				Notify.alert('Ocurrió un error.', {status: 'danger'});
				$scope.loadingEmail = "";
			  });
	};

    	$scope.obtenerEmailPorCliente();

    }
})();


(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('CancelarFacturaController', CancelarFacturaController);

    CancelarFacturaController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function CancelarFacturaController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {

    	$scope.elementoEnviar = {password: '', id_factura: 0, nota: '', uuidReplace: ''};

    	$scope.motivosCancelacion = [
    	    {code: '01', description: 'Comprobante emitido con errores con relación'},
            {code: '02', description: 'Comprobante emitido con errores sin relación'},
            {code: '03', description: 'No se llevó a cabo la operación'},
            {code: '04', description: 'Operación nominativa relacionada en una factura global'}
        ];

    	$scope.facturasPorRelacionar = [];


    	$scope.cancelar = function(){

    		if($scope.elementoEnviar.password == null || $scope.elementoEnviar.password == ''){
    			Notify.alert('Por favor ingrese la contraseña.', {status: 'danger'});
    			return;
    		}

            if($scope.elementoEnviar.motivo == null || $scope.elementoEnviar.motivo == ''){
                Notify.alert('Por selecciona un motivo de cancelación.', {status: 'danger'});
                return;
            }

    		$scope.elementoEnviar.id_factura = $scope.ngDialogData.factura.id_factura;
    		$scope.elementoEnviar.uUID = $scope.ngDialogData.factura.uUID;

    		$scope.loadingEmail = "whirl double-up";


    		var urlFacturar = '/api/admin/facturacion/cancelarFacturaPro';
			if($scope.ngDialogData.factura.generadoPor == 4){
				urlFacturar = '/api/admin/facturacion/cancelarFactura';
			}

    		$http.post(urlFacturar, {
				user : $rootScope.user,
				factura: $scope.elementoEnviar
			}).then(function(res) {
				var response = res['data'];
				if (response['success']) {

					$scope.loadingEmail = "";
					if(response.passCorrecto == true){
						if(response.seraCancelado == true){
							$scope.closeThisDialog(1);
						}else{
							Notify.alert('En este momento no es posible cancelar tu factura, inténtalo más tarde.', {status: 'danger'});
						}
					}else{

						Notify.alert('La contraseña no es correcta.', {status: 'danger'});

					}

				}

			}, function errorCallback(response) {
				Notify.alert('Ocurrió un error.', {status: 'danger'});
				$scope.loadingEmail = "";
			  });
    	};



        $scope.obtenerFacturasCancelar = function(){

            $scope.loadingEmail = "whirl double-up";

            $http.post('/api/admin/facturacion/facturasPorRelacionar', {
                user : $rootScope.user
            }).then(function(res) {
                var response = res['data'];
                if (response['success']) {
                    $scope.loadingEmail = "";
                    $scope.facturasPorRelacionar = response.facturasPorRelacionar;

                    $("#uuid").trigger("chosen:updated");
                }

            }, function errorCallback(response) {
                Notify.alert('Ocurrió un error.', {status: 'danger'});
                $scope.loadingEmail = "";
            });
        };

        $scope.obtenerFacturasCancelar();

    }
})();


(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('PreviewFacturaController', PreviewFacturaController);

    PreviewFacturaController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function PreviewFacturaController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {




    	$scope.obtenerFactura = function(){

    		$scope.loading = "whirl double-up";

    		$http.post('/api/admin/facturacion/verVistaPreviaFactura', {
				user : $rootScope.user,
				id_factura: $scope.ngDialogData.id_factura
			}).then(function(res) {
				var response = res['data'];
				if (response['success']) {

					$("#previewFacturaIframe").html(response.html);

					$scope.loading = "";

				}

			}, function errorCallback(response) {
				Notify.alert('Ocurrió un error.', {status: 'danger'});
				$scope.loadingEmail = "";
			  });

    	}


    	$scope.obtenerFactura();

    }
})();



(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('NuevaFacturaPagoController', NuevaFacturaPagoController);

    NuevaFacturaPagoController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function NuevaFacturaPagoController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {
        var vm = this;

        vm.clientes = [];
        vm.formasDePago = [];
        vm.productos = [];
        vm.unidadesMedida = [];
		vm.clavesProducto = [];
		vm.usosCFDI = [];
		vm.usosCFDITmp = [];
		vm.searchTextCustomer = '';
		vm.series = [];
		vm.bancos = [];
        vm.factura = {
        		tipoDocumento: 'P',
        		id_cliente: '',
            	decimales: '2',
        		impuestosRetenidos : [],
        		impuestosTrasladados : [],
        		moneda: 'MXN',
        		tipoCambio: 1.0,
        		detalles: [],
        		descuento: 0,
        		facturasRelacionadas: {
            		tipoRelacion: '',
            		noFactura: '',
            		uuids: []

            	},
        		cuentaPredial: '',
        		formaPago: '',
        		lugarExpedicion: '',
        		serie: 'A',
        		metodoDePago: 'PUE',
        		pagos: []
        }
        vm.productoAgregar = '';
        vm.tipoRelaciones = [
                             {value: '01', label: 'Nota de crédito de los documentos relacionados'},
                             {value: '02', label: 'Nota de débito de los documentos relacionados'},
                             {value: '03', label: 'Devolución de mercancía sobre facturas o traslados previos'},
                             {value: '04', label: 'Sustitución de los CFDI previos'},
                             {value: '05', label: 'Traslados de mercancias facturados previamente'},
                             {value: '06', label: 'Factura generada por los traslados previos'},
                             {value: '07', label: 'CFDI por aplicación de anticipo'}
                            ];
        vm.metodosDePago = [{codigo: 'PUE', descripcion: 'Pago en una sola exhibición'}, {codigo: 'PPD', descripcion: 'Pago en parcialidades o diferido'}];



        activate();

        ////////////////

        function activate() {

        	vm.obtenerNombreTipoRelacion = function(){
        		for(var x = 0; x < vm.tipoRelaciones.length; x++){
        			if(vm.tipoRelaciones[x].value == vm.factura.facturasRelacionadas.tipoRelacion){
        				return vm.tipoRelaciones[x].label;
        			}
        		}
        	};


        	vm.obtenerDatos = function(){

	        	vm.loading = "whirl double-up";

	        	$http.post('/api/admin/facturacion/datosFacturar', {
					user : $rootScope.user
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.clientes = response.clientes;
						vm.formasDePago = response.formasDePago;
						vm.productos = response.productos;
						vm.unidadesMedida = response.unidadesMedida;
						vm.clavesProducto = response.clavesProducto;
						vm.usosCFDI = response.usosCFDI;
						vm.series = response.series;
						vm.factura.lugarExpedicion = response.proveedor.domicilio.codigoPostal;
						vm.usosCFDITmp = vm.usosCFDI;
						vm.bancos = response.bancos;
                        vm.regimenesFiscales = response.regimenesFiscales;
                        vm.tieneCartaPorte = response.tieneCartaPorte;
                        vm.tieneEscuelas = response.tieneEscuelas;

						if($stateParams.id != undefined && $stateParams.id != ''){
							vm.agregarPagoDirecto($stateParams.id);
						}

					}

				}, function errorCallback(response) {
					vm.obtenerDatos();
				  });
        	};


        	vm.agregarPago = function(){

        		if( vm.factura.id_cliente == "" || vm.factura.id_cliente == null){
        			Notify.alert('Debe seleccionar el cliente antes de agregar el pago.', {status: 'danger'});

        			$('#id_cliente').trigger('chosen:activate');
					$('#id_cliente').focus();

        			return;
        		}

                ngDialog.openConfirm({
                    template: 'pagoFactura',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'AgregarPagoController',
                    data: {formasDePago: vm.formasDePago, facturasCliente: vm.facturasCliente, pagos: vm.factura.pagos, bancos: vm.bancos}
                }).then(function (buscar) {
                	console.log(vm.factura.pagos);
                }, function (aplicar) {
                    if(aplicar === true){
                        //vm.calculoResumenImpuestos();
                    }
                });

            };


            vm.editarPago = function(index){

                ngDialog.openConfirm({
                    template: 'pagoFactura',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'AgregarPagoController',
                    data: {formasDePago: vm.formasDePago, facturasCliente: vm.facturasCliente, pagos: vm.factura.pagos, index: index, edit: true, bancos: vm.bancos}
                }).then(function (buscar) {
                	console.log(vm.factura.pagos);
                }, function (aplicar) {
                    if(aplicar === true){
                        //vm.calculoResumenImpuestos();
                    }
                });

            };



            vm.facturaRelacionada = function(){

            	vm.factura.facturasRelacionadas.noFactura = '';

                ngDialog.openConfirm({
                    template: 'facturasRelacionadas',
                    className: 'ngdialog-theme-default',
                    controller: 'FacturasRelacionadasController',
                    data: {tipoRelaciones: vm.tipoRelaciones, facturasRelacionadas: vm.factura.facturasRelacionadas}
                }).then(function (documento) {

                }, function (documento) {
                	if(documento.tipoRelacion != undefined){
                		vm.factura.facturasRelacionadas = documento;
                	}
                });

            };

            vm.agregrProdExistente = function(){
            	if(vm.productoAgregar.id_producto != undefined){
            		vm.productoAgregar.precioU = Number(vm.productoAgregar.precioU);
            		vm.productoAgregar.qty = 1;
            		vm.productoAgregar.descuento = 0;
            		vm.factura.detalles.push(angular.copy(vm.productoAgregar));
            		vm.productoAgregar = '';
            	}

            	vm.calcularTotales();
            };


            vm.agregrProdNuevo = function(){
            		var productoNuevo = {
            			codigo: '1',
            			clave: '',
            			nombre: '',
            			unidad: '',
            			qty: 1,
            			precioU: 1.00,
            			descuento: 0
            		};
            		vm.factura.detalles.push(productoNuevo);
            		vm.productoAgregar = '';

            	vm.calcularTotales();
            };

            vm.calcularTotales = function(){

            	vm.factura.subtotal = 0;
            	vm.factura.total = 0;
            	vm.factura.base = 0;
            	vm.factura.descuento = 0;

            	for(var x = 0; x < vm.factura.detalles.length; x++){
            		vm.factura.subtotal += (vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU);
            		vm.factura.detalles[x].base = (vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU - vm.factura.detalles[x].descuento);
            		vm.factura.descuento += Number(vm.factura.detalles[x].descuento);
            	}

            	vm.factura.total = vm.factura.base = vm.factura.subtotal - vm.factura.descuento;

            	for(var x = 0; x < vm.factura.impuestosRetenidos.length; x++){

            		if(vm.factura.impuestosRetenidos[x].factor == 'Tasa'){
            			vm.factura.impuestosRetenidos[x].total = vm.factura.impuestosRetenidos[x].valor * vm.factura.base;
            		}else{
            			vm.factura.impuestosRetenidos[x].total = vm.factura.impuestosRetenidos[x].valor;
            		}

            		vm.factura.total -= vm.factura.impuestosRetenidos[x].total;
            	}



            	for(var x = 0; x < vm.factura.impuestosTrasladados.length; x++){

            		if(vm.factura.impuestosTrasladados[x].factor == 'Tasa'){
						console.log("Sergio calculo. ", vm.factura.impuestosTrasladados[x])
            			vm.factura.impuestosTrasladados[x].total = vm.factura.impuestosTrasladados[x].valor * vm.factura.base;
            		}else{
            			vm.factura.impuestosTrasladados[x].total = vm.factura.impuestosTrasladados[x].valor;
            		}

            		vm.factura.total += vm.factura.impuestosTrasladados[x].total;
            	}

            };

			vm.calcularTotalesParciales = function(){

				for(var x = 0; x < vm.factura.impuestosTrasladados.length; x++){

					if(vm.factura.impuestosTrasladados[x].factor == 'Tasa'){
						console.log("Sergio calculo. ", vm.factura.impuestosTrasladados[x])
						vm.factura.impuestosTrasladados[x].total = vm.factura.impuestosTrasladados[x].valor * vm.factura.base;
					}else{
						vm.factura.impuestosTrasladados[x].total = vm.factura.impuestosTrasladados[x].valor;
					}

					vm.factura.total += vm.factura.impuestosTrasladados[x].total;
				}

			};

            vm.borrarConcepto = function(index){
            	vm.factura.detalles.splice(index, 1);
            	vm.calcularTotales();
            };


            /////Funcionalidad select de mobile para customer
            vm.getMatchesCustomer = function(searchText) {
				if(searchText == "" || searchText == null)
					return vm.clientes;
		            var states = vm.clientes.filter(function(customer) {
		            	var pordChane = customer.nmbRecep + " " + customer.rFCRecep;
		                return (pordChane.toUpperCase().match(searchText.toUpperCase()));
		            });

		        return states;
		    }

            vm.selectedCustomer = function(cliente){
				if(typeof(cliente) != 'undefined' && typeof(cliente.id_cliente) != 'undefined'){
					vm.factura.id_cliente = cliente;
					vm.obtenerFacturasPorCliente();
				}else{
					vm.factura.id_cliente = 0;
				}
			};
			////////////////////////////

			vm.obtenerPaises = function(){

				vm.factura.formaPago = vm.factura.id_cliente.metodoPago;
				vm.factura.usoCFDI = vm.factura.id_cliente.usoCFDI

				if( vm.factura.id_cliente!= null && vm.factura.id_cliente.rFCRecep == 'XEXX010101000'){

					$http.post('/api/admin/facturacion/obtenerPaises', {
						user : $rootScope.user
					}).then(function(res) {
						var response = res['data'];
						if (response['success']) {

							vm.loading = "";
							vm.paises = response.paises;
						}

					}, function errorCallback(response) {
						vm.obtenerDatos();
					  });

				}
			};

			vm.borrarFacturaRelacionada = function(index){
				vm.factura.facturasRelacionadas.uuids.splice(index, 1);
			};


			vm.seleccionarMetodoPago = function(){
				if(vm.factura.metodoDePago == 'PPD'){
					vm.factura.formaPago = '99';
					$("#formaPago").trigger("chosen:updated");
				}
			};

			vm.obtenerFacturasPorCliente = function(){

				vm.factura.pagos = [];

				$http.post('/api/admin/facturacion/obtenerFacturasPorCliente', {
					user : $rootScope.user,
                    rFCRecep: vm.factura.id_cliente.rFCRecep
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.facturasCliente = response.facturas;
					}

				}, function errorCallback(response) {
					vm.obtenerDatos();
				  });

			};


			vm.cambiarTipoDocumento = function(tipo){
	        	vm.factura.tipoDocumento = tipo;
	        	if(vm.factura.tipoDocumento != 'P'){
	        		$state.transitionTo('app.nuevaFactura', {tipoDocumento: vm.factura.tipoDocumento});
	        	}

	        };

            vm.calculoResumenImpuestos = function (){

                for(let w = 0; w < vm.factura.pagos.length; w++){

                    vm.factura.pagos[w].impuestosTrasladados = [];
                    vm.factura.pagos[w].impuestosRetenidos = [];

                    //Agrupar impuestos globales trasladados
                    for(let x = 0; x < vm.factura.pagos[w].documentoRelacionado.length; x++){

                        for(let y = 0; y < vm.factura.pagos[w].documentoRelacionado[x].impuestos.impuestosTrasladados.length; y++){

                            let existImpuesto = false;
                            for(let z = 0; z < vm.factura.pagos[w].impuestosTrasladados.length; z++){
                                if(vm.factura.pagos[w].impuestosTrasladados[z].tipoImp == vm.factura.pagos[w].documentoRelacionado[x].impuestos.impuestosTrasladados[y].tipoImp &&
                                    vm.factura.pagos[w].impuestosTrasladados[z].factor == vm.factura.pagos[w].documentoRelacionado[x].impuestos.impuestosTrasladados[y].factor &&
                                    vm.factura.pagos[w].impuestosTrasladados[z].tasaImp == vm.factura.pagos[w].documentoRelacionado[x].impuestos.impuestosTrasladados[y].tasaImp){

                                    existImpuesto = true;
                                    vm.factura.pagos[w].impuestosTrasladados[z].base = Number(vm.factura.pagos[w].impuestosTrasladados[z].base) + Number(vm.factura.pagos[w].documentoRelacionado[x].impuestos.impuestosTrasladados[y].base);
                                    vm.factura.pagos[w].impuestosTrasladados[z].montoImp = Number(vm.factura.pagos[w].impuestosTrasladados[z].montoImp) + Number(vm.factura.pagos[w].documentoRelacionado[x].impuestos.impuestosTrasladados[y].montoImp);
                                }
                            }

                            if(!existImpuesto){
                                vm.factura.pagos[w].impuestosTrasladados.push(angular.copy(vm.factura.pagos[w].documentoRelacionado[x].impuestos.impuestosTrasladados[y]));
                            }
                        }
                    }

                    //Agrupar impuestos globales retenidos
                    for(let x = 0; x < vm.factura.pagos[w].documentoRelacionado.length; x++){
                        for(let y = 0; y < vm.factura.pagos[w].documentoRelacionado[x].impuestos.impuestosRetenidos.length; y++){
                            let existImpuesto = false;
                            for(let z = 0; z < vm.factura.pagos[w].impuestosRetenidos.length; z++){
                                if(vm.factura.pagos[w].impuestosRetenidos[z].tipoImp == vm.factura.pagos[w].documentoRelacionado[x].impuestos.impuestosRetenidos[y].tipoImp){

                                    existImpuesto = true;
                                    vm.factura.pagos[w].impuestosRetenidos[z].base = Number(vm.factura.pagos[w].impuestosRetenidos[z].base) + Number(vm.factura.pagos[w].documentoRelacionado[x].impuestos.impuestosRetenidos[y].base);
                                    vm.factura.pagos[w].impuestosRetenidos[z].montoImp = Number(vm.factura.pagos[w].impuestosRetenidos[z].montoImp) + Number(vm.factura.pagos[w].documentoRelacionado[x].impuestos.impuestosRetenidos[y].montoImp);
                                }
                            }

                            if(!existImpuesto){
                                vm.factura.pagos[w].impuestosRetenidos.push(angular.copy(vm.factura.pagos[w].documentoRelacionado[x].impuestos.impuestosRetenidos[y]));
                            }
                        }
                    }

                }
            }



			vm.facturar = function(){

				if(vm.factura.id_cliente == '' || vm.factura.id_cliente == null){
					Notify.alert('Debe seleccionar un cliente.', {status: 'danger'});
					$('#id_cliente').trigger('chosen:activate');
					return;
				}

				if(vm.factura.lugarExpedicion == '' || vm.factura.lugarExpedicion == null || vm.factura.lugarExpedicion.length < 5 ){
					Notify.alert('Debe ingresar un lugar de expedición correcto (C.P.)', {status: 'danger'});
					$('#lugarExpedicion').focus();
					return;
				}


				if(vm.factura.pagos.length == 0){
					Notify.alert('Debe agregar al menos un pago.', {status: 'danger'});
					return;
				}

				vm.loading = "whirl double-up";

				for(var x = 0; x < vm.factura.pagos.length; x++){
					var pagoTmp = vm.factura.pagos[x];
					pagoTmp.fechaPago = $rootScope.prepareDateForServer(pagoTmp.fechaPago, true);
				}

				var urlFacturar = '/api/admin/facturacion/facturarPago40';
				$http.post(urlFacturar, {
					user : $rootScope.user,
					factura: vm.factura
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						SweetAlert.swal('Éxito!', 'Se generó su factura de forma correcta con el No. ' + response.facturaResult, 'success');
						$state.transitionTo('app.listadoFacturas');

					}else{
						SweetAlert.swal('Error!', response.errorCode + ' - ' + response.errortext, 'error');
					}

					vm.loading = "";

				}, function errorCallback(response) {
					vm.loading = "";
				});



			};


			vm.agregarPagoDirecto = function(id_factura){

				vm.loading = "whirl double-up";

				$http.post('/api/admin/facturacion/obtenerFacturaPago', {
					user : $rootScope.user,
					id_factura: id_factura
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						let facturaPago = response.factura;

						for(var x = 0; x < vm.clientes.length; x++){
							if(vm.clientes[x].id_cliente == facturaPago.id_cliente){
								vm.factura.id_cliente = vm.clientes[x];
							}
						}


						vm.obtenerFacturasPorCliente();
						$("#id_cliente").trigger("chosen:updated");

						var pago = {
							formaPago: '01',
							moneda: facturaPago.totales.moneda,
							fechaPago: $rootScope.formatDateToString(new Date()),
							documentoRelacionado: [],
							tipoCambio: ''
						}

						if(facturaPago.iddoc.moneda != 'MXN'){
							pago.tipoCambio = '1';
						}

						let doctoRelacionado = {
			        		facturaLbl: facturaPago.iddoc.serie + facturaPago.noFactura,
			        		id_factura: facturaPago.id_factura,
			        		total: facturaPago.totales.VlrPagar,
			        		moneda: facturaPago.totales.moneda,
			        		uuid: facturaPago.iddoc.uUID,
							parcialidad: facturaPago.noPago,
			        		saldoAnterior: (Number(facturaPago.totales.VlrPagar) - Number(facturaPago.importePagado)).toFixed(2),
			        		pago: (Number(facturaPago.totales.VlrPagar) - Number(facturaPago.importePagado)).toFixed(2),
			        		saldoInsoluto: 0,
			        		tipoCambio: '',
                            tipoCambioDR: 0,
                            montoPagoMoneda: 0,
                            objetoImp: response.tieneImpuestos ? '02' : '01',
                            impuestos: response.impuestosEnFactura,
                            pagoReal:0,
                            equivalencia: 0
			        	};


						pago.totalPago = doctoRelacionado.pago;

						pago.documentoRelacionado.push(doctoRelacionado);

						vm.factura.pagos.push(pago);

                        //vm.calculoResumenImpuestos();

						vm.loading = "";
					}

				}, function errorCallback(response) {
					vm.loading = "";
					Notify.alert('Hubo un error al cargar el pago, favor de hacerlo manualmente.', {status: 'danger'});
				  });

			};



        	vm.obtenerDatos();



        }
    }
})();


(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('AgregarPagoController', AgregarPagoController);

    AgregarPagoController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function AgregarPagoController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {

        $scope.usdToMxn = false;
    	$scope.monedas = ['MXN', 'USD'];
    	$scope.pago = {moneda: 'MXN', fechaPago: $rootScope.formatDateToString(new Date()), formaPago: '01', tipoCambio: '', documentoRelacionado: [], totalPago: 0,
    			banco: '', cuenta: '', objetoImp: '01'};

        if($scope.ngDialogData.edit == true){
            console.log("Sergio: ", $scope.ngDialogData.pagos[$scope.ngDialogData.index].fechaPago);
            $scope.pago.fechaPago = $scope.ngDialogData.pagos[$scope.ngDialogData.index].fechaPago;
        }


    	$scope.agregarDocumento = function(){

    		var facturaSeleccionada = $scope.pago.facturaSeleccionada;
    		for(var y = 0; y < $scope.pago.documentoRelacionado.length; y++){

    			if($scope.pago.documentoRelacionado[y].id_factura == facturaSeleccionada.id_factura){
    				Notify.alert('El documento ya fue agregado anteriormente.', {status: 'danger'});
    				$scope.pago.facturaSeleccionada = '';
    				return;
    			}
    		}

    		var documentoAgregar = {
        			facturaLbl: facturaSeleccionada.iddoc.serie + facturaSeleccionada.noFactura,
        			id_factura: facturaSeleccionada.id_factura,
        			total: facturaSeleccionada.totales.VlrPagar,
        			moneda: facturaSeleccionada.totales.moneda,
        			uuid: facturaSeleccionada.iddoc.uUID,
        			parcialidad: 1,
        			saldoAnterior: 0,
        			pago: 0,
        			saldoInsoluto: 0,
        			tipoCambio: '',
                pagoReal: 0,
                equivalencia:0
        		};

    		$scope.pago.documentoRelacionado.push(documentoAgregar);

    		$scope.pago.totalPago += Number(documentoAgregar.total);

    		$scope.obtenerImportePagado(documentoAgregar.uuid, documentoAgregar);

    		$scope.pago.facturaSeleccionada = '';
    	};

    	$scope.borrarDocumento = function($index){
    		$scope.pago.documentoRelacionado.splice($index, 1);
    	};

        $scope.borrarRetencion = function(index, indexDocumento){
            $scope.pago.documentoRelacionado[indexDocumento].impuestos.impuestosRetenidos.splice(index, 1);
        };

        $scope.borrarTraslado = function(index, indexDocumento){
            $scope.pago.documentoRelacionado[indexDocumento].impuestos.impuestosTrasladados.splice(index, 1);
        };

        $scope.agregarImpuesto = function(indexDocumento, tipo){

            const impuesto = {
                'factor' : '',
                'tipoImp': '002',
                'tasaImp': '',
                'tipo': '',
                'base':0,
                'montoImp': 0
            }

            if($scope.pago.documentoRelacionado[indexDocumento].impuestos === undefined){
                $scope.pago.documentoRelacionado[indexDocumento].impuestos = {
                    impuestosTrasladados: [],
                    impuestosRetenidos: []
                }
            }

            if(tipo === 'traslado'){

                if($scope.pago.documentoRelacionado[indexDocumento].impuestos.impuestosTrasladados.length >= 2)
                    return;
                $scope.pago.documentoRelacionado[indexDocumento].impuestos.impuestosTrasladados.push(impuesto);
            }
            else{

                if($scope.pago.documentoRelacionado[indexDocumento].impuestos.impuestosRetenidos.length >= 3)
                    return;
                $scope.pago.documentoRelacionado[indexDocumento].impuestos.impuestosRetenidos.push(impuesto);
            }

        };



    	$scope.aplicarCambios = function(){

    		if($scope.pago.formaPago == null || $scope.pago.formaPago == ''){
    			Notify.alert('Debe seleccionar una forma de pago.', {status: 'danger'});
    			$("#formaDePagoP").focus();
    			return;
    		}

    		if($scope.pago.moneda == null || $scope.pago.moneda == ''){
    			Notify.alert('Debe seleccionar una moneda de pago.', {status: 'danger'});
    			$("#monedaP").focus();
    			return;
    		}

    		if($scope.pago.banco != undefined && $scope.pago.banco != '' && $scope.pago.banco.length > 0){

	    		var re = /^[0-9]*$/;
	    		if( $scope.pago.cuenta != '' && !re.test($scope.pago.cuenta) ){
	    			Notify.alert('El número de cuenta debe contener sólo números.', {status: 'danger'});
	    			$("#cuenta").focus();
	    			return;
	    		}

	    		if( $scope.pago.cuenta != '' ){

	    		    if($scope.pago.formaPago == '02'){
                        if( !($scope.pago.cuenta.length == 11 || $scope.pago.cuenta.length == 18) ){
                            Notify.alert('Si el método de pago es con cheque, la cuenta debe ser de 11 o 18 dígitos.', {status: 'danger'});
                            $("#cuenta").focus();
                            return;
                        }
                    }

                    if($scope.pago.formaPago == '03'){
                        if( !($scope.pago.cuenta.length == 10 || $scope.pago.cuenta.length == 16 || $scope.pago.cuenta.length == 18) ){
                            Notify.alert('Si el método de pago es con cheque, la cuenta debe ser de 10, 16 o 18 dígitos.', {status: 'danger'});
                            $("#cuenta").focus();
                            return;
                        }
                    }
	    		}

	    		var listOfValidPayments = '02030428';
	    		if( $scope.pago.cuenta != '' && listOfValidPayments.indexOf($scope.pago.formaPago) == -1 ){
	    			Notify.alert('Sólo debe indicar cuenta cuando es pago por transferencia, tarjeta, o cheque..', {status: 'danger'});
	    			$("#cuenta").focus();
	    			return;
	    		}
    		}


    		if($scope.pago.moneda == 'USD'){

                var tmp = $scope.pago.tipoCambio;
                if(isNaN(tmp)){
                    tmp = $scope.pago.tipoCambio.replace(',', '');
                    tmp = Number(tmp);
                }

    			if(tmp == 0 || isNaN(tmp)){
    				Notify.alert('Debe ingrear un tipo de cambio mayor a 0.', {status: 'danger'});
        			$("#tipoCambioP").focus();
        			return;
    			}

    			$scope.pago.tipoCambio = tmp;

    		}

    		if($scope.pago.documentoRelacionado.length == 0){
    			Notify.alert('Debe agregar al menos una factura pagada.', {status: 'danger'});
    			return;
    		}

    		$scope.pago.totalPago = 0;

    		for(var x = 0; x < $scope.pago.documentoRelacionado.length; x++){

                let tmpParcialdiad = Number($scope.pago.documentoRelacionado[x].parcialidad);
                let tmpSaldo = Number($scope.pago.documentoRelacionado[x].saldoAnterior);
                let tmpPago = Number($scope.pago.documentoRelacionado[x].pago);
                let tmpMoneda = $scope.pago.documentoRelacionado[x].moneda;
                let objetoImp = $scope.pago.documentoRelacionado[x].objetoImp;

    			if(tmpParcialdiad == 0 || isNaN(tmpParcialdiad)){
    				Notify.alert('El no. de parcialidad debe ser numérico y mayor a 0.', {status: 'danger'});
        			return;
    			}

    			if(tmpSaldo == 0 || isNaN(tmpSaldo)){
    				Notify.alert('El saldo anterior debe ser numérico y mayor a 0.', {status: 'danger'});
        			return;
    			}

    			if(tmpPago == 0 || isNaN(tmpPago)){
    				Notify.alert('El pago realizado debe ser numérico y mayor a 0.', {status: 'danger'});
        			return;
    			}

                if($scope.pago.moneda == 'USD' && tmpMoneda == 'MXN'){
                    if(isNaN($scope.pago.documentoRelacionado[x].tipoCambioDR)
                        || Number($scope.pago.documentoRelacionado[x].tipoCambioDR) < 2){
                        Notify.alert('El tipo de cambio del pago debes ser mayor a 0', {status: 'danger'});
                        return;
                    }
                }

                if($scope.pago.moneda == 'MXN' && tmpMoneda == 'USD'){
                    if(isNaN($scope.pago.documentoRelacionado[x].montoPagoMoneda)
                        || Number($scope.pago.documentoRelacionado[x].montoPagoMoneda) <= 0){
                        Notify.alert('El monto en moneda real del pago debes ser mayor a 0', {status: 'danger'});
                        return;
                    }
                }

                if($scope.pago.documentoRelacionado[x].objetoImp === undefined || $scope.pago.documentoRelacionado[x].objetoImp.length === 0 ){
                    Notify.alert('Debe seleccionar si la factura '+$scope.pago.documentoRelacionado[x].facturaLbl+' es objeto de impuesto.', {status: 'danger'});
                    return;
                }

                if($scope.pago.moneda == 'MXN' && tmpMoneda == 'USD'){
                    $scope.pago.totalPago += Number($scope.pago.documentoRelacionado[x].montoPagoMoneda);
                }else{
                    $scope.pago.totalPago += tmpPago;
                }
    		}


            if($scope.pago.impuestosTrasladados === undefined){
				$scope.calculoImpuestos();
			}else{
				$scope.sumaCalculosResumen();
			}


    		if($scope.ngDialogData.edit == true){
    			$scope.ngDialogData.pagos[$scope.ngDialogData.index] = $scope.pago;
    		}else{
    			$scope.ngDialogData.pagos.push($scope.pago);
    		}


    		$scope.closeThisDialog(true);
    	};


    	$scope.cancelar = function(){
    		$scope.closeThisDialog();
    	};


    	$scope.obtenerImportePagado = function(uuid, documentoAgregar){

    		$scope.loadingWare = "whirl double-up";

    		$http.post('/api/admin/facturacion/obtenerAbonosFactura', {
				user : $rootScope.user,
				uuid: uuid
			}).then(function(res) {
				var response = res['data'];
				if (response['success']) {

					documentoAgregar.saldoAnterior = Number(documentoAgregar.total) - Number(response.importePagado);
					documentoAgregar.pago = documentoAgregar.saldoAnterior;
					documentoAgregar.parcialidad = response.noPago;
                    documentoAgregar.objetoImp = response.tieneImpuestos ? '02' : '01';
                    documentoAgregar.impuestos = response.impuestosEnFactura;

                    $scope.calculoImpuestos();
				}

				$scope.loadingWare = "";

			}, function errorCallback(response) {
				$scope.loadingWare = "";
			});

    	};

    	$scope.calcularRestantePago = function(index){

    		var documento = $scope.pago.documentoRelacionado[index];
    		documento.pago = String(documento.pago).replace(',', '');
    		documento.saldoInsoluto = documento.saldoAnterior - Number(documento.pago);

    		$scope.pago.totalPago = 0;
    		for(let x = 0; x < $scope.pago.documentoRelacionado.length; x++){
    			$scope.pago.totalPago += Number($scope.pago.documentoRelacionado[x].pago);
    		}

            $scope.calculoImpuestos(true);
    	};

        $scope.calculoImpuestos = function (recalcular = false){

            $scope.calcularBase();

            for(let x = 0; x < $scope.pago.documentoRelacionado.length; x++){
                for(let y = 0; y < $scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados.length; y++){
                    if($scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y].factor === 'Tasa'){
                        let impuesto = $scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y];
						if(impuesto.base === undefined || impuesto.base <= 0 || recalcular) {
							impuesto.base = $scope.pago.documentoRelacionado[x].calculoMontoBase;
							impuesto.montoImp = ($scope.pago.documentoRelacionado[x].calculoMontoBase * Number(impuesto.tasaImp)).toFixed(2);
						}
                    }else if($scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y].factor === 'Cuota'){

                        $scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y].montoImp =
                            Number($scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y].tasaImp).toFixed(2);
                    }else if($scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y].factor === 'Exento'){
                        $scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y].montoImp = 0;
                        $scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y].tasaImp = 0;
                    }
                }

                for(let y = 0; y < $scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos.length; y++){
                    if($scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y].factor === 'Tasa'){
                        let impuesto = $scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y];
						if(impuesto.base === undefined || impuesto.base <= 0 || recalcular) {
							impuesto.base = $scope.pago.documentoRelacionado[x].calculoMontoBase;
							impuesto.montoImp = ($scope.pago.documentoRelacionado[x].calculoMontoBase * Number(impuesto.tasaImp)).toFixed(2);
						}
                    }else if($scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y].factor === 'Cuota'){

                        $scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y].montoImp =
                            Number($scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y].tasaImp).toFixed(2);
                    }else if($scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y].factor === 'Exento'){
                        $scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y].montoImp = 0;
                        $scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y].tasaImp = 0;
                    }
                }
            }

            $scope.calculoResumenImpuestos();

        }


        $scope.calcularBase = function (){

            $scope.usdToMxn = false;

            for(let x = 0; x < $scope.pago.documentoRelacionado.length; x++){
                let porcentajeBase = 0;
                let impuestoCuota = 0;

                if($scope.pago.documentoRelacionado[x].impuestos === undefined){
                    $scope.pago.documentoRelacionado[x].impuestos = {
                        impuestosTrasladados: [],
                        impuestosRetenidos: [],
                    }
                }

                for(let y = 0; y < $scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados.length; y++){
                    if($scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y].factor === 'Tasa'){
                        let impuesto = $scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y];
                        porcentajeBase += Number(impuesto.tasaImp);
                    }else if($scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y].factor === 'Cuota'){
                        impuestoCuota += Number($scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y].tasaImp);
                    }
                }

                for(let y = 0; y < $scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos.length; y++){
                    if($scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y].factor === 'Tasa'){
                        let impuesto = $scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y];
                        porcentajeBase -= Number(impuesto.tasaImp);
                    }else if($scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y].factor === 'Cuota'){
                        impuestoCuota -= Number(impuesto.tasaImp);
                    }
                }

                let montoBase = $scope.pago.documentoRelacionado[x].pago - impuestoCuota;

                if($scope.pago.moneda == 'MXN' && $scope.pago.documentoRelacionado[x].moneda == 'USD'){
                    montoBase = $scope.pago.documentoRelacionado[x].montoPagoMoneda - impuestoCuota;
                    $scope.usdToMxn = true;
                }

                let basePagoReal = 0;
                if(porcentajeBase !== 0){
                    if($scope.pago.documentoRelacionado[x].montoPagoMoneda > 0){
                        basePagoReal = $scope.pago.documentoRelacionado[x].montoPagoMoneda / (1 + porcentajeBase);
                        montoBase = $scope.pago.documentoRelacionado[x].pago / (1 + porcentajeBase);
                    }else{
                        basePagoReal = montoBase = $scope.pago.documentoRelacionado[x].pago / (1 + porcentajeBase);
                    }
                }

                $scope.pago.documentoRelacionado[x].calculoMontoBase = montoBase.toFixed(2);
                $scope.pago.documentoRelacionado[x].calculoMontoRealBase = basePagoReal.toFixed(2);
            }

        }

        $scope.calculoResumenImpuestos = function (){

            $scope.pago.impuestosTrasladados = [];
            $scope.pago.impuestosRetenidos = [];
            let baseImpuestos = 0;

            //Agrupar impuestos globales trasladados
            for(let x = 0; x < $scope.pago.documentoRelacionado.length; x++){

                if($scope.pago.moneda == 'MXN' && $scope.pago.documentoRelacionado[x].moneda == 'USD'){
                    $scope.pago.documentoRelacionado[x].equivalencia =
                        $rootScope.truncateNumbersV2 (
                            Number($scope.pago.documentoRelacionado[x].pago) / Number($scope.pago.documentoRelacionado[x].montoPagoMoneda), 6);


                    let z = 0;

                    while($scope.pago.documentoRelacionado[x].pago / $scope.pago.documentoRelacionado[x].equivalencia
                    > $scope.pago.documentoRelacionado[x].montoPagoMoneda){

                        $scope.pago.documentoRelacionado[x].equivalencia += 0.000001;
                        z++;
                        if(z > 20){
                            break;
                        }

                    }
                }

                baseImpuestos += Number($scope.pago.documentoRelacionado[x].calculoMontoRealBase);

                let y = 0;
                for(y = 0; y < $scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados.length; y++){

                    let existImpuesto = false;
                    for(let z = 0; z < $scope.pago.impuestosTrasladados.length; z++){
                        if($scope.pago.impuestosTrasladados[z].factor == $scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y].factor &&
                            $scope.pago.impuestosTrasladados[z].tasaImp == $scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y].tasaImp &&
                            $scope.pago.impuestosTrasladados[z].tipoImp == $scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y].tipoImp){

                            existImpuesto = true;
                            $scope.pago.impuestosTrasladados[z].base = Number($scope.pago.impuestosTrasladados[z].base) + Number($scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y].base);
                            $scope.pago.impuestosTrasladados[z].montoImp = Number($scope.pago.impuestosTrasladados[z].montoImp) + Number($scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y].montoImp);
                            $scope.pago.impuestosTrasladados[z].baseMonedaReal = Number($scope.pago.impuestosTrasladados[z].base) / Number($scope.pago.documentoRelacionado[x].equivalencia);
                            $scope.pago.impuestosTrasladados[z].montoImpMonedaReal = Number($scope.pago.impuestosTrasladados[z].montoImp) / Number($scope.pago.documentoRelacionado[x].equivalencia);
                        }
                    }

                    if(!existImpuesto){
                        const impuesto = angular.copy($scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y]);
                        impuesto.baseMonedaReal = Number(impuesto.base) / Number($scope.pago.documentoRelacionado[x].equivalencia);
                        impuesto.montoImpMonedaReal = Number(impuesto.montoImp) / Number($scope.pago.documentoRelacionado[x].equivalencia);
                        $scope.pago.impuestosTrasladados.push(impuesto);
                    }
                }
            }

            //Agrupar impuestos globales retenidos
            for(let x = 0; x < $scope.pago.documentoRelacionado.length; x++){

                for(let y = 0; y < $scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos.length; y++){
                    let existImpuesto = false;
                    for(let z = 0; z < $scope.pago.impuestosRetenidos.length; z++){
                        if($scope.pago.impuestosRetenidos[z].factor == $scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y].factor &&
                            $scope.pago.impuestosRetenidos[z].tasaImp == $scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y].tasaImp ){

                            existImpuesto = true;
                            $scope.pago.impuestosRetenidos[z].base = Number($scope.pago.impuestosRetenidos[z].base) + Number($scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y].base);
                            $scope.pago.impuestosRetenidos[z].montoImp = Number($scope.pago.impuestosRetenidos[z].montoImp) + Number($scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y].montoImp);
                            $scope.pago.impuestosRetenidos[z].baseMonedaReal = Number($scope.pago.impuestosRetenidos[z].base) / Number($scope.pago.documentoRelacionado[x].equivalencia);
                            $scope.pago.impuestosRetenidos[z].montoImpMonedaReal = Number($scope.pago.impuestosRetenidos[z].montoImp) / Number($scope.pago.documentoRelacionado[x].equivalencia);
                        }
                    }

                    if(!existImpuesto){
                        const impuesto = angular.copy($scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y]);
                        impuesto.baseMonedaReal = Number((impuesto.base) / Number($scope.pago.documentoRelacionado[x].equivalencia).toFixed(2));
                        impuesto.montoImpMonedaReal = Number(impuesto.montoImp) / Number($scope.pago.documentoRelacionado[x].equivalencia);
                        $scope.pago.impuestosRetenidos.push(impuesto);
                    }
                }
            }

            if($scope.usdToMxn === true){

                for(let y = 0; y < $scope.pago.impuestosTrasladados.length; y++){
                    if($scope.pago.impuestosTrasladados[y].factor === 'Tasa'){
                        let impuesto = $scope.pago.impuestosTrasladados[y];
                        impuesto.base = $rootScope.truncateNumbers(impuesto.baseMonedaReal);
                        impuesto.montoImp = $rootScope.toFixedNumber(impuesto.montoImpMonedaReal, 2);
                    }else if($scope.pago.impuestosTrasladados[y].factor === 'Cuota'){

                        $scope.pago.impuestosTrasladados[y].montoImp =
                            Number($scope.pago.impuestosTrasladados[y].tasaImp).toFixed(2);
                    }else if($scope.pago.impuestosTrasladados[y].factor === 'Exento'){
                        $scope.pago.impuestosTrasladados[y].montoImp = 0;
                        $scope.pago.impuestosTrasladados[y].tasaImp = 0;
                    }
                }

                for(let y = 0; y < $scope.pago.impuestosRetenidos.length; y++){
                    if($scope.pago.impuestosRetenidos[y].factor === 'Tasa'){
                        let impuesto = $scope.pago.impuestosRetenidos[y];
                        impuesto.base = $rootScope.truncateNumbers(impuesto.baseMonedaReal);
                        impuesto.montoImp = $rootScope.toFixedNumber(impuesto.montoImpMonedaReal, 2);
                    }else if($scope.pago.impuestosRetenidos[y].factor === 'Cuota'){
                        $scope.pago.impuestosRetenidos[y].montoImp =
                            Number($scope.pago.impuestosRetenidos[y].tasaImp).toFixed(2);
                    }else if($scope.pago.impuestosRetenidos[y].factor === 'Exento'){
                        $scope.pago.impuestosRetenidos[y].montoImp = 0;
                        $scope.pago.impuestosRetenidos[y].tasaImp = 0;
                    }
                }
            }
        }







		$scope.sumaCalculosResumen = function (){

			$scope.pago.impuestosTrasladados = [];
			$scope.pago.impuestosRetenidos = [];
			let baseImpuestos = 0;

			//Agrupar impuestos globales trasladados
			for(let x = 0; x < $scope.pago.documentoRelacionado.length; x++){

				if($scope.pago.moneda == 'MXN' && $scope.pago.documentoRelacionado[x].moneda == 'USD'){
					$scope.pago.documentoRelacionado[x].equivalencia =
						$rootScope.truncateNumbersV2 (
							Number($scope.pago.documentoRelacionado[x].pago) / Number($scope.pago.documentoRelacionado[x].montoPagoMoneda), 6);


					let z = 0;

					while($scope.pago.documentoRelacionado[x].pago / $scope.pago.documentoRelacionado[x].equivalencia
					> $scope.pago.documentoRelacionado[x].montoPagoMoneda){

						$scope.pago.documentoRelacionado[x].equivalencia += 0.000001;
						z++;
						if(z > 20){
							break;
						}

					}
				}

				baseImpuestos += Number($scope.pago.documentoRelacionado[x].calculoMontoRealBase);

				let y = 0;
				for(y = 0; y < $scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados.length; y++){

					let existImpuesto = false;
					for(let z = 0; z < $scope.pago.impuestosTrasladados.length; z++){
						if($scope.pago.impuestosTrasladados[z].factor == $scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y].factor &&
							$scope.pago.impuestosTrasladados[z].tasaImp == $scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y].tasaImp &&
							$scope.pago.impuestosTrasladados[z].tipoImp == $scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y].tipoImp){

							existImpuesto = true;
							$scope.pago.impuestosTrasladados[z].base = Number($scope.pago.impuestosTrasladados[z].base) + Number($scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y].base);
							$scope.pago.impuestosTrasladados[z].montoImp = Number($scope.pago.impuestosTrasladados[z].montoImp) + Number($scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y].montoImp);
							$scope.pago.impuestosTrasladados[z].baseMonedaReal = Number($scope.pago.impuestosTrasladados[z].base) / Number($scope.pago.documentoRelacionado[x].equivalencia);
							$scope.pago.impuestosTrasladados[z].montoImpMonedaReal = Number($scope.pago.impuestosTrasladados[z].montoImp) / Number($scope.pago.documentoRelacionado[x].equivalencia);
						}
					}

					if(!existImpuesto){
						const impuesto = angular.copy($scope.pago.documentoRelacionado[x].impuestos.impuestosTrasladados[y]);
						impuesto.baseMonedaReal = Number(impuesto.base) / Number($scope.pago.documentoRelacionado[x].equivalencia);
						impuesto.montoImpMonedaReal = Number(impuesto.montoImp) / Number($scope.pago.documentoRelacionado[x].equivalencia);
						$scope.pago.impuestosTrasladados.push(impuesto);
					}
				}
			}

			//Agrupar impuestos globales retenidos
			for(let x = 0; x < $scope.pago.documentoRelacionado.length; x++){

				for(let y = 0; y < $scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos.length; y++){
					let existImpuesto = false;
					for(let z = 0; z < $scope.pago.impuestosRetenidos.length; z++){
						if($scope.pago.impuestosRetenidos[z].factor == $scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y].factor &&
							$scope.pago.impuestosRetenidos[z].tasaImp == $scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y].tasaImp ){

							existImpuesto = true;
							$scope.pago.impuestosRetenidos[z].base = Number($scope.pago.impuestosRetenidos[z].base) + Number($scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y].base);
							$scope.pago.impuestosRetenidos[z].montoImp = Number($scope.pago.impuestosRetenidos[z].montoImp) + Number($scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y].montoImp);
							$scope.pago.impuestosRetenidos[z].baseMonedaReal = Number($scope.pago.impuestosRetenidos[z].base) / Number($scope.pago.documentoRelacionado[x].equivalencia);
							$scope.pago.impuestosRetenidos[z].montoImpMonedaReal = Number($scope.pago.impuestosRetenidos[z].montoImp) / Number($scope.pago.documentoRelacionado[x].equivalencia);
						}
					}

					if(!existImpuesto){
						const impuesto = angular.copy($scope.pago.documentoRelacionado[x].impuestos.impuestosRetenidos[y]);
						impuesto.baseMonedaReal = Number((impuesto.base) / Number($scope.pago.documentoRelacionado[x].equivalencia).toFixed(2));
						impuesto.montoImpMonedaReal = Number(impuesto.montoImp) / Number($scope.pago.documentoRelacionado[x].equivalencia);
						$scope.pago.impuestosRetenidos.push(impuesto);
					}
				}
			}

			if($scope.usdToMxn === true){

				for(let y = 0; y < $scope.pago.impuestosTrasladados.length; y++){
					if($scope.pago.impuestosTrasladados[y].factor === 'Tasa'){
						let impuesto = $scope.pago.impuestosTrasladados[y];
						impuesto.base = $rootScope.truncateNumbers(impuesto.baseMonedaReal);
						impuesto.montoImp = $rootScope.toFixedNumber(impuesto.montoImpMonedaReal, 2);
					}else if($scope.pago.impuestosTrasladados[y].factor === 'Cuota'){

						$scope.pago.impuestosTrasladados[y].montoImp =
							Number($scope.pago.impuestosTrasladados[y].tasaImp).toFixed(2);
					}else if($scope.pago.impuestosTrasladados[y].factor === 'Exento'){
						$scope.pago.impuestosTrasladados[y].montoImp = 0;
						$scope.pago.impuestosTrasladados[y].tasaImp = 0;
					}
				}

				for(let y = 0; y < $scope.pago.impuestosRetenidos.length; y++){
					if($scope.pago.impuestosRetenidos[y].factor === 'Tasa'){
						let impuesto = $scope.pago.impuestosRetenidos[y];
						impuesto.base = $rootScope.truncateNumbers(impuesto.baseMonedaReal);
						impuesto.montoImp = $rootScope.toFixedNumber(impuesto.montoImpMonedaReal, 2);
					}else if($scope.pago.impuestosRetenidos[y].factor === 'Cuota'){
						$scope.pago.impuestosRetenidos[y].montoImp =
							Number($scope.pago.impuestosRetenidos[y].tasaImp).toFixed(2);
					}else if($scope.pago.impuestosRetenidos[y].factor === 'Exento'){
						$scope.pago.impuestosRetenidos[y].montoImp = 0;
						$scope.pago.impuestosRetenidos[y].tasaImp = 0;
					}
				}
			}

			console.log("sergi pago: ", $scope.pago);
		}











    	$scope.procesoInicial = function(){

    		if($scope.ngDialogData.edit == true){
    			$scope.pago = angular.copy($scope.ngDialogData.pagos[$scope.ngDialogData.index]);
    		}else{
	    		if($scope.ngDialogData.facturasCliente.length == 1){
	        		$scope.pago.facturaSeleccionada = $scope.ngDialogData.facturasCliente[0];
	        		$scope.agregarDocumento();
	        	}
    		}
    	};

        $scope.truncarDosDecimales = function(numero) {
            return Math.trunc(numero * 100) / 100;
        }

    	$scope.procesoInicial();


    }
})();



(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('ImpuestoConceptoController', ImpuestoConceptoController);

    ImpuestoConceptoController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function ImpuestoConceptoController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {


    	$scope.concepto = angular.copy($scope.ngDialogData.concepto);


    	$scope.impTrasladados = [{
	       	 impuesto: 'IVA',
	       	 codigo: '002',
	       	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0, 0.16, 0.06, 0.08] }}, {label: 'Exento', options: {isSelect: false}}]
	        },
	        {
	       	 impuesto: 'IEPS',
	       	 codigo: '003',
	       	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0,0.03,0.06,0.07,0.08,0.09,0.25,0.265,0.3,0.304,0.50,0.53,1.60] }}, {label: 'Exento', options: {isSelect: false}}]
	        },
	        {
	       	 impuesto: 'ISH',
	       	 codigo: 'XXX',
	       	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
	    }];

    	$scope.impRetenidos = [{
	       	 impuesto: 'IVA',
	       	 codigo: '002',
	       	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 0.16 }}, {label: 'Exento', options: {isSelect: false}}]
	        },
	        {
	       	 impuesto: 'IEPS',
	       	 codigo: '003',
	       	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0.03,0.06,0.07,0.08,0.09,0.25,0.265,0.3,0.304,0.50,0.53,1.60] }}, {label: 'Cuota', options: {isSelect: false, min: 0, max: 43.77}}, {label: 'Exento', options: {isSelect: false}}]
	        },
	        {
	       	 impuesto: 'ISR',
	       	 codigo: '001',
	       	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 0.35 }}, {label: 'Cuota', options: {isSelect: false, min: 0, max: 43.77}}, {label: 'Exento', options: {isSelect: false}}]
	        },
	        {
                impuesto: 'RTP',
                codigo: 'XXX',
                factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            },
            {
                impuesto: 'Ret 5 al millar',
                codigo: 'XXX',
                factor: [{label: 'Cuota', options: {isSelect: false, min: 0, max: 99999999999999}}, {label: 'Tasa', options: {isSelect: false, min: 0, max: 1 }}]
            },
            {
                impuesto: 'Ret 2 al millar',
                codigo: 'XXX',
                factor: [{label: 'Cuota', options: {isSelect: false, min: 0, max: 99999999999999}}, {label: 'Tasa', options: {isSelect: false, min: 0, max: 1 }}]
            },
            {
                impuesto: 'Retención del 1% al millar',
                codigo: 'XXX',
                factor: [{label: 'Cuota', options: {isSelect: false, min: 0, max: 99999999999999}}, {label: 'Tasa', options: {isSelect: false, min: 0, max: 1 }}]
            },
            {
                impuesto: '.63% AL MILLAR INSPECCIÓN Y VIGILANCIA',
                codigo: 'XXX',
                factor: [{label: 'Cuota', options: {isSelect: false, min: 0, max: 99999999999999}}, {label: 'Tasa', options: {isSelect: false, min: 0, max: 99999999999999}}]
            },
            {
                impuesto: 'Deducible',
                codigo: 'XXX',
                factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 99999999999999}}]
            },
            {
                impuesto: 'CEDULAR',
                codigo: 'XXX',
                factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            }];

		$scope.traslado = {
			impuesto: '',
			factor: '',
			valor: ''
		};

		$scope.retencion = {
			impuesto: '',
			factor: '',
			valor: ''
		};


		$scope.agregarTraslado = function(){

    		if($scope.traslado.impuesto == '' || $scope.traslado.impuesto == null){
    			Notify.alert('Debe seleccionar un impuesto del listado.', {status: 'danger'});
    			return;
    		}

    		if($scope.traslado.factor == '' || $scope.traslado.factor == null){
    			Notify.alert('Debe seleccionar tasa/cuota/excento.', {status: 'danger'});
    			return;
    		}

    		if($scope.traslado.factor.label != 'Exento' && ($scope.traslado.valor === '' || $scope.traslado.valor === null)){
    			Notify.alert('Debe seleccionar/ingresar el valor del impuesto.', {status: 'danger'});
    			return;
    		}


    		$scope.traslado.valor = Number($scope.traslado.valor);
    		$scope.traslado.valor = $scope.traslado.valor.toFixed(6);

    		var nuevoImpuesto = {
    				factor:  $scope.traslado.factor.label,
    				impuesto:  $scope.traslado.impuesto.codigo,
    				label: $scope.traslado.impuesto.impuesto,
    				valor: $scope.traslado.valor
    		}

    		if(nuevoImpuesto.factor == 'Exento')
    			nuevoImpuesto.valor = 0;

    		console.log(nuevoImpuesto);

    		$scope.concepto.impuestosTrasladados.push(nuevoImpuesto);

    		$scope.traslado = {
            		impuesto: '',
            		factor: '',
            		valor: ''
            	};

    		$scope.validarImpuestosActuales();

    	};

    	$scope.agregarRetencion = function(){


    		if($scope.retencion.impuesto == '' || $scope.retencion.impuesto == null){
    			Notify.alert('Debe seleccionar un impuesto del listado.', {status: 'danger'});
    			return;
    		}

    		if($scope.retencion.factor == '' || $scope.retencion.factor == null){
    			Notify.alert('Debe seleccionar tasa/cuota/excento.', {status: 'danger'});
    			return;
    		}

    		if($scope.retencion.factor.label != 'Exento' && ($scope.retencion.valor == '' || $scope.retencion.valor == null)){
    			Notify.alert('Debe seleccionar/ingresar el valor del impuesto.', {status: 'danger'});
    			return;
    		}

    		if($scope.retencion.factor.options.isSelect == false){
    			if($scope.retencion.valor < $scope.retencion.factor.options.min || $scope.retencion.valor > $scope.retencion.factor.options.max){
    				Notify.alert('El valor del impuesto debe ser entre '+$rootScope.addCommas($scope.retencion.factor.options.min,3)+' y ' + $rootScope.addCommas($scope.retencion.factor.options.max,3), {status: 'danger'});
        			return;
    			}
    		}

    		$scope.retencion.valor = Number($scope.retencion.valor);
    		$scope.retencion.valor = $scope.retencion.valor.toFixed(6);


    		var nuevoImpuesto = {
    				factor:  $scope.retencion.factor.label,
    				impuesto:  $scope.retencion.impuesto.codigo,
    				label: $scope.retencion.impuesto.impuesto,
    				valor: $scope.retencion.valor
    		}

    		if(nuevoImpuesto.factor == 'Exento')
    			nuevoImpuesto.valor = 0;


    		$scope.concepto.impuestosRetenidos.push(nuevoImpuesto);

    		$scope.retencion = {
            		impuesto: '',
            		factor: '',
            		valor: ''
            	};

    		$scope.validarImpuestosActuales();
    	};

    	$scope.validarImpuestosActuales = function(){

    		$scope.impTrasladados = [{
           	 impuesto: 'IVA',
           	 codigo: '002',
           	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0, 0.16, 0.06, 0.08] }}, {label: 'Exento', options: {isSelect: false}}]
            },
            {
           	 impuesto: 'IEPS',
           	 codigo: '003',
           	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0,0.03,0.06,0.07,0.08,0.09,0.25,0.265,0.3,0.304,0.50,0.53,1.60] }}, {label: 'Exento', options: {isSelect: false}}]
            },
            {
           	 impuesto: 'ISH',
           	 codigo: 'XXX',
           	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            }];

    		$scope.impRetenidos = [{
           	 impuesto: 'IVA',
           	 codigo: '002',
           	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 0.16 }}, {label: 'Exento', options: {isSelect: false}}]
            },
            {
           	 impuesto: 'IEPS',
           	 codigo: '003',
           	 factor: [{label: 'Tasa', options: {isSelect: true, values: [0.03,0.06,0.07,0.08,0.09,0.25,0.265,0.3,0.304,0.50,0.53,1.60] }}, {label: 'Cuota', options: {isSelect: false, min: 0, max: 43.77}}, {label: 'Exento', options: {isSelect: false}}]
            },
            {
           	 impuesto: 'ISR',
           	 codigo: '001',
           	 factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 0.35 }}, {label: 'Cuota', options: {isSelect: false, min: 0, max: 43.77}}, {label: 'Exento', options: {isSelect: false}}]
            },
            {
              impuesto: 'CEDULAR',
              codigo: 'XXX',
              factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            },
            {
             impuesto: 'ISH',
             codigo: 'XXX',
             factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            },
            {
             impuesto: 'Amortización por devolución de anticipo',
             codigo: 'XXX',
             factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            },
            {
             impuesto: 'Por garantía de obra',
             codigo: 'XXX',
             factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            },
            {
                impuesto: 'RTP',
                codigo: 'XXX',
                factor: [{label: 'Tasa', options: {isSelect: false, min: 0, max: 100 }}]
            }];

    		for(var x = 0; x < $scope.concepto.impuestosRetenidos.length; x++){
    			for(var y = 0; y < $scope.impRetenidos.length; y++){
    				if($scope.concepto.impuestosRetenidos[x].impuesto == $scope.impRetenidos[y].codigo){
    					$scope.impRetenidos.splice(y, 1);
    					break;
    				}
    			}
    		}

    		for(var x = 0; x < $scope.concepto.impuestosTrasladados.length; x++){
    			for(var y = 0; y < $scope.impTrasladados.length; y++){
    				if($scope.concepto.impuestosTrasladados[x].impuesto == $scope.impTrasladados[y].codigo){
    					$scope.impTrasladados.splice(y, 1);
    					break;
    				}
    			}
    		}

    	}

    	$scope.borrarImpuesto = function(index, tipoImp){

    		if(tipoImp == 1){
    			$scope.concepto.impuestosTrasladados.splice(index, 1);
    		}else{
    			$scope.concepto.impuestosRetenidos.splice(index, 1);
    		}

    		$scope.validarImpuestosActuales();
    	};

    	$scope.aplicarCambios = function(){
    		$scope.closeThisDialog($scope.concepto);
    	};


    }
})();


(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('DetallesAlumnoController', DetallesAlumnoController);

    DetallesAlumnoController.$inject = ['$scope', '$http', '$state', '$stateParams',
        'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function DetallesAlumnoController($scope, $http, $state, $stateParams, Notify,
                                        $rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {

        $scope.alumno = {
            curp: '',
            autRVOE: '',
            nivelEducativo: 'Primaria',
            nombreAlumno: '',
            rfcPago: '',
        }

        if($scope.ngDialogData.alumno){
            $scope.alumno = angular.copy($scope.ngDialogData.alumno);
        }

        $scope.guardarAlumno = function(){


            if(!curpValida($scope.alumno.curp.toUpperCase())){
                Notify.alert('La CURP ingresada no es correcta.', {status: 'danger'});
                return;
            }

            if($scope.alumno.nombreAlumno.length < 3){
                Notify.alert('Debe ingresar un nombre de alumno.', {status: 'danger'});
                return;
            }

            if($scope.alumno.autRVOE.length < 1){
                Notify.alert('Debe ingresar la clave del centro de trabajo.', {status: 'danger'});
                return;
            }

            $scope.closeThisDialog($scope.alumno);
        }

        function curpValida(curp) {
            var re = /^([A-Z][AEIOUX][A-Z]{2}\d{2}(?:0[1-9]|1[0-2])(?:0[1-9]|[12]\d|3[01])[HM](?:AS|B[CS]|C[CLMSH]|D[FG]|G[TR]|HG|JC|M[CNS]|N[ETL]|OC|PL|Q[TR]|S[PLR]|T[CSL]|VZ|YN|ZS)[B-DF-HJ-NP-TV-Z]{3}[A-Z\d])(\d)$/,
                validado = curp.match(re);

            if (!validado)  //Coincide con el formato general?
                return false;

            //Validar que coincida el dígito verificador
            function digitoVerificador(curp17) {
                //Fuente https://consultas.curp.gob.mx/CurpSP/
                var diccionario  = "0123456789ABCDEFGHIJKLMNÑOPQRSTUVWXYZ",
                    lngSuma      = 0.0,
                    lngDigito    = 0.0;
                for(var i=0; i<17; i++)
                    lngSuma = lngSuma + diccionario.indexOf(curp17.charAt(i)) * (18 - i);
                lngDigito = 10 - lngSuma % 10;
                if (lngDigito == 10) return 0;
                return lngDigito;
            }

            if (validado[2] != digitoVerificador(validado[1]))
                return false;

            return true; //Validado
        }

    }
})();




(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('NuevaFacturaGasolinaController', NuevaFacturaGasolinaController);

    NuevaFacturaGasolinaController.$inject = ['$scope', '$http', '$state', '$stateParams',
                                			'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function NuevaFacturaGasolinaController($scope, $http, $state, $stateParams, Notify,
			$rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {
        var vm = this;

        vm.clientes = [];
        vm.formasDePago = [];
        vm.productos = [];
        vm.unidadesMedida = [];
		vm.clavesProducto = [];
		vm.usosCFDI = [];
		vm.usosCFDITmp = [];
		vm.searchTextCustomer = '';
		vm.series = [];
        vm.factura = {
        		tipoDocumento: 'I',
        		id_cliente: '',
            	decimales: '2',
        		guardarProd: false,
        		moneda: 'MXN',
        		tipoCambio: 1.0,
        		detalles: [],
        		descuento: 0,
        		facturasRelacionadas: {
            		tipoRelacion: '',
            		noFactura: '',
            		uuids: []

            	},
        		cuentaPredial: '',
        		formaPago: '',
        		lugarExpedicion: '',
        		serie: 'A',
        		metodoDePago: 'PUE'
        }
        vm.productoAgregar = '';
        vm.tipoRelaciones = [
                             {value: '01', label: 'Nota de crédito de los documentos relacionados'},
                             {value: '02', label: 'Nota de débito de los documentos relacionados'},
                             {value: '03', label: 'Devolución de mercancía sobre facturas o traslados previos'},
                             {value: '04', label: 'Sustitución de los CFDI previos'},
                             {value: '05', label: 'Traslados de mercancias facturados previamente'},
                             {value: '06', label: 'Factura generada por los traslados previos'},
                             {value: '07', label: 'CFDI por aplicación de anticipo'}
                            ];
        vm.productos = [{clave: '15101506', codigo: '01', descripcion: 'Gasolina magna', nombre: 'Gasolina magna', precioU: 15800.66207, unidad: 'MTQ', id_producto: 0,
        					impuestosTrasladados: [{base: 0, factor: 'Tasa', impuesto: '002', label: 'IVA', total: 0, valor: "0.160000"}]},
                        {clave: '15101506', codigo: '02', descripcion: 'Gasolina premium', nombre: 'Gasolina premium', precioU: 17070.51624, unidad: 'MTQ', id_producto: 0,
                        	impuestosTrasladados: [{base: 0, factor: 'Tasa', impuesto: '002', label: 'IVA', total: 0, valor: "0.160000"}]},
                        {clave: '15101505', codigo: '03', descripcion: 'Diesel', nombre: 'Diesel', precioU: 16456.875, unidad: 'MTQ', id_producto: 0,
                        	impuestosTrasladados: [{base: 0, factor: 'Tasa', impuesto: '002', label: 'IVA', total: 0, valor: "0.160000"}]},
                        {clave: '78121603', codigo: '04', descripcion: 'Flete', nombre: 'Flete', precioU: 1000, unidad: 'E48', id_producto: 0,
                        	impuestosTrasladados: [{base: 0, factor: 'Tasa', impuesto: '002', label: 'IVA', total: 0, valor: "0.160000"}]}];
        vm.metodosDePago = [{codigo: 'PUE', descripcion: 'Pago en una sola exhibición'}, {codigo: 'PPD', descripcion: 'Pago en parcialidades o diferido'}];

        vm.cambiarTipoDocumento = function(tipo){
        	vm.factura.tipoDocumento = tipo;
        	if(vm.factura.tipoDocumento == 'P')
        		$state.transitionTo('app.nuevoPago');
        };

        activate();

        ////////////////

        function activate() {

        	vm.obtenerNombreTipoRelacion = function(){
        		for(var x = 0; x < vm.tipoRelaciones.length; x++){
        			if(vm.tipoRelaciones[x].value == vm.factura.facturasRelacionadas.tipoRelacion){
        				return vm.tipoRelaciones[x].label;
        			}
        		}
        	};


        	vm.obtenerDatos = function(){

        		if($stateParams.tipoDocumento != undefined && $stateParams.tipoDocumento != ''){
        			vm.factura.tipoDocumento = $stateParams.tipoDocumento;
        		}

	        	vm.loading = "whirl double-up";

	        	$http.post('/api/admin/facturacion/datosFacturar', {
					user : $rootScope.user
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						vm.loading = "";
						vm.clientes = response.clientes;
						vm.formasDePago = response.formasDePago;
						vm.unidadesMedida = response.unidadesMedida;
						vm.clavesProducto = response.clavesProducto;
						vm.usosCFDI = response.usosCFDI;
						vm.series = response.series;
						vm.factura.lugarExpedicion = response.proveedor.domicilio.codigoPostal;
						vm.usosCFDITmp = response.usosCFDI;
                        vm.regimenesFiscales = response.regimenesFiscales;
                        vm.tieneCartaPorte = response.tieneCartaPorte;
                        vm.tieneEscuelas = response.tieneEscuelas;

					}

				}, function errorCallback(response) {
					vm.obtenerDatos();
				  });
        	};


        	vm.opcionesFactura = function(){

                ngDialog.openConfirm({
                    template: 'opcionesFactura',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'OpcionesFacturaController',
                    data: {factura: vm.factura}
                }).then(function (buscar) {

                }, function (factura) {

                	if(factura.tipoDocumento != undefined){
                		vm.factura.impuestosTrasladados = factura.impuestosTrasladados;
                		vm.factura.impuestosRetenidos = factura.impuestosRetenidos;
                		vm.factura.cuentaPredial = factura.cuentaPredial;
                		vm.factura.moneda = factura.moneda;
                		vm.factura.tipoCambio = factura.tipoCambio;
                        if(factura.norma !== undefined){
                            vm.factura.norma = factura.norma;
                            vm.factura.leyenda = factura.leyenda;
                        }
                	}

                	vm.calcularTotales();
                });

            };



            vm.facturaRelacionada = function(){

            	vm.factura.facturasRelacionadas.noFactura = '';

                ngDialog.openConfirm({
                    template: 'facturasRelacionadas',
                    className: 'ngdialog-theme-default',
                    controller: 'FacturasRelacionadasController',
                    data: {tipoRelaciones: vm.tipoRelaciones, facturasRelacionadas: vm.factura.facturasRelacionadas}
                }).then(function (documento) {

                }, function (documento) {
                	if(documento.tipoRelacion != undefined){
                		vm.factura.facturasRelacionadas = documento;
                	}
                });

            };


            vm.impuestosConcepto = function(index){

            	var concepto = vm.factura.detalles[index];

                ngDialog.openConfirm({
                    template: 'impuestosConcepto',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'ImpuestoConceptoController',
                    data: {concepto: concepto}
                }).then(function (concepto) {

                }, function (concepto) {
                	if(concepto.qty != undefined && concepto.qty > 0){
                		vm.factura.detalles[index] = concepto;
                		vm.calcularTotales();
                	}
                });

            };

            vm.agregrProdExistente = function(){
            	if(vm.productoAgregar.id_producto != undefined){
            		vm.productoAgregar.precioU = Number(vm.productoAgregar.precioU);
            		vm.productoAgregar.qty = 1;
            		vm.productoAgregar.descuento = 0;
            		vm.productoAgregar.impuestosTrasladados = vm.productoAgregar.impuestosTrasladados;
            		vm.productoAgregar.impuestosRetenidos = [];
            		vm.factura.detalles.push(angular.copy(vm.productoAgregar));
            		vm.productoAgregar = '';
            	}

            	vm.calcularTotales();
            };


            vm.agregrProdNuevo = function(){
            		var productoNuevo = {
            			codigo: '1',
            			clave: '',
            			nombre: '',
            			unidad: '',
            			qty: 1,
            			precioU: 1.00,
            			descuento: 0,
            			impuestosTrasladados: [],
            			impuestosRetenidos : []
            		};
            		vm.factura.detalles.push(productoNuevo);
            		vm.productoAgregar = '';

            	vm.calcularTotales();
            };

            vm.calcularTotales = function(){

            	vm.factura.subtotal = 0;
            	vm.factura.total = 0;
            	vm.factura.base = 0;
            	vm.factura.descuento = 0;
            	vm.factura.totalTraslados = 0;
            	vm.factura.totalRetenciones = 0;
            	vm.factura.impuestosTrasladados = [];
            	vm.factura.impuestosRetenidos = [];


            	for(var x = 0; x < vm.factura.detalles.length; x++){

            		for(var y = 0; y < vm.factura.detalles[x].impuestosTrasladados.length; y++){
            			vm.factura.detalles[x].impuestosTrasladados[y].total = 0;
                	}

                	for(var y = 0; y < vm.factura.detalles[x].impuestosRetenidos.length; y++){
                		vm.factura.detalles[x].impuestosRetenidos[y].total = 0;
                	}

            		vm.factura.detalles[x].precioU = $rootScope.toFixedNumber(vm.factura.detalles[x].precioU,5);
            		vm.factura.detalles[x].descuento = $rootScope.toFixedNumber(vm.factura.detalles[x].descuento);

            		vm.factura.subtotal += $rootScope.toFixedNumber((vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU));
            		vm.factura.detalles[x].base = (vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU - vm.factura.detalles[x].descuento);
            		vm.factura.descuento += Number(vm.factura.detalles[x].descuento);

            		var litros = vm.factura.detalles[x].qty * 1000;
            		var baseCalcIva = vm.factura.detalles[x].base;
            		if(vm.factura.detalles[x].codigo == '01'){
            			baseCalcIva = baseCalcIva - (litros * 0.4052);
            		}else if(vm.factura.detalles[x].codigo == '02'){
            			baseCalcIva = baseCalcIva - (litros * 0.4944);
            		}else if(vm.factura.detalles[x].codigo == '03'){
            			baseCalcIva = baseCalcIva - (litros * 0.3363);
            		}


            		for(var y = 0; y < vm.factura.detalles[x].impuestosTrasladados.length; y++){

            			var tmp1 = vm.factura.detalles[x].impuestosTrasladados[y];
            			vm.factura.detalles[x].impuestosTrasladados[y].base = baseCalcIva;

            			var valorImpuesto = 0;
                		if(vm.factura.detalles[x].impuestosTrasladados[y].factor == 'Tasa'){
                			valorImpuesto = $rootScope.toFixedNumber(vm.factura.detalles[x].impuestosTrasladados[y].valor * vm.factura.detalles[x].impuestosTrasladados[y].base);
                		}else{
                			valorImpuesto = $rootScope.toFixedNumber(vm.factura.detalles[x].impuestosTrasladados[y].valor);
                		}
                		vm.factura.detalles[x].impuestosTrasladados[y].total = valorImpuesto;
                		vm.factura.totalTraslados += valorImpuesto ;

                		var addNewTax = true;

                		for(var z = 0; z < vm.factura.impuestosTrasladados.length; z++){

                			var tmp2 = vm.factura.impuestosTrasladados[z];

                			if(vm.factura.impuestosTrasladados[z].impuesto == vm.factura.detalles[x].impuestosTrasladados[y].impuesto
                					&& vm.factura.impuestosTrasladados[z].factor == vm.factura.detalles[x].impuestosTrasladados[y].factor
                						&& vm.factura.impuestosTrasladados[z].valor == vm.factura.detalles[x].impuestosTrasladados[y].valor){

                				vm.factura.impuestosTrasladados[z].total += valorImpuesto;
                				addNewTax = false;
                			}
                		}

                		if(addNewTax){
                			vm.factura.impuestosTrasladados.push(angular.copy(vm.factura.detalles[x].impuestosTrasladados[y]));
                		}

                	}


            		for(var y = 0; y < vm.factura.detalles[x].impuestosRetenidos.length; y++){

            			var valorImpuesto = 0;
            			vm.factura.detalles[x].impuestosRetenidos[y].base = vm.factura.detalles[x].base;

                		if(vm.factura.detalles[x].impuestosRetenidos[y].factor == 'Tasa'){
                			valorImpuesto = $rootScope.toFixedNumber(vm.factura.detalles[x].impuestosRetenidos[y].valor * vm.factura.detalles[x].impuestosRetenidos[y].base);
                		}else{
                			valorImpuesto = $rootScope.toFixedNumber(vm.factura.detalles[x].impuestosRetenidos[y].valor);
                		}
                		vm.factura.detalles[x].impuestosRetenidos[y].total += valorImpuesto;
                		vm.factura.totalRetenciones += valorImpuesto;

                		var addNewTax = true;

                		for(var z = 0; z < vm.factura.impuestosRetenidos.length; z++){
                			if(vm.factura.impuestosRetenidos[z].impuesto == vm.factura.detalles[x].impuestosRetenidos[y].impuesto
                					&& vm.factura.impuestosRetenidos[z].factor == vm.factura.detalles[x].impuestosRetenidos[y].factor
                						&& vm.factura.impuestosRetenidos[z].valor == vm.factura.detalles[x].impuestosRetenidos[y].valor){

                				vm.factura.impuestosRetenidos[z].total += valorImpuesto;
                				addNewTax = false;
                			}
                		}

                		if(addNewTax){
                			vm.factura.impuestosRetenidos.push(angular.copy(vm.factura.detalles[x].impuestosRetenidos[y]));
                		}
                	}

            	}

            	vm.factura.total = vm.factura.base = vm.factura.subtotal - vm.factura.descuento;
            	vm.factura.total += (vm.factura.totalTraslados - vm.factura.totalRetenciones);
            	vm.factura.total = $rootScope.toFixedNumber(vm.factura.total);

            };

            vm.borrarConcepto = function(index){
            	vm.factura.detalles.splice(index, 1);
            	vm.calcularTotales();
            };


            /////Funcionalidad select de mobile para customer
            vm.getMatchesCustomer = function(searchText) {
				if(searchText == "" || searchText == null)
					return vm.clientes;
		            var states = vm.clientes.filter(function(customer) {
		            	var pordChane = customer.nmbRecep + " " + customer.rFCRecep;
		                return (pordChane.toUpperCase().match(searchText.toUpperCase()));
		            });

		        return states;
		    }

            vm.selectedCustomer = function(cliente){
				if(typeof(cliente) != 'undefined' && typeof(cliente.id_cliente) != 'undefined'){
					vm.factura.id_cliente = cliente;
					vm.obtenerPaises();
				}else{
					vm.factura.id_cliente = 0;
				}
			};
			////////////////////////////

			vm.obtenerPaises = function(){

				vm.usosCFDITmp = [];

				if(isNaN(Number(vm.factura.id_cliente.rFCRecep.charAt(3)))){

					vm.usosCFDITmp = vm.usosCFDI;

				}else{
					for(var x = 0; x < vm.usosCFDI.length; x++){
						if(vm.usosCFDI[x].validMoral == 1){
							vm.usosCFDITmp.push(vm.usosCFDI[x]);
						}
					}
				}

				vm.factura.formaPago = vm.factura.id_cliente.metodoPago;
				vm.factura.usoCFDI = vm.factura.id_cliente.usoCFDI

				if( vm.factura.id_cliente!= null && vm.factura.id_cliente.rFCRecep == 'XEXX010101000'){

					$http.post('/api/admin/facturacion/obtenerPaises', {
						user : $rootScope.user
					}).then(function(res) {
						var response = res['data'];
						if (response['success']) {

							vm.loading = "";
							vm.paises = response.paises;
						}

					}, function errorCallback(response) {
						vm.obtenerDatos();
					  });

				}
			};

			vm.borrarFacturaRelacionada = function(index){
				vm.factura.facturasRelacionadas.uuids.splice(index, 1);
			};


			vm.seleccionarMetodoPago = function(){
				if(vm.factura.metodoDePago == 'PPD'){
					vm.factura.formaPago = '99';
					$("#formaPago").trigger("chosen:updated");
				}
			};


			vm.facturar = function(){

				if(vm.factura.id_cliente == '' || vm.factura.id_cliente == null){
					Notify.alert('Debe seleccionar un cliente.', {status: 'danger'});
					$('#id_cliente').trigger('chosen:activate');
					return;
				}

				if(vm.factura.formaPago == '' || vm.factura.formaPago == null){
					Notify.alert('Debe seleccionar una forma de pago.', {status: 'danger'});
					$('#formaPago').trigger('chosen:activate');
					$('#formaPago').focus();
					return;
				}


				if(vm.factura.lugarExpedicion == '' || vm.factura.lugarExpedicion == null || vm.factura.lugarExpedicion.length < 5 ){
					Notify.alert('Debe ingresar un lugar de expedición correcto (C.P.)', {status: 'danger'});
					$('#lugarExpedicion').focus();
					return;
				}


				if(vm.factura.usoCFDI == '' || vm.factura.usoCFDI == null){
					Notify.alert('Debe seleccionar el uso del CFDI.', {status: 'danger'});
					$('#usoCFDI').trigger('chosen:activate');
					$('#usoCFDI').focus();
					return;
				}

				if(vm.factura.detalles.length == 0){
					Notify.alert('Debe agregar al menos un producto.', {status: 'danger'});
					return;
				}

				for(var x = 0; x < vm.factura.detalles.length; x++){

					var concepto = vm.factura.detalles[x];

					if(concepto.clave == ''){
						Notify.alert('Debe seleccionar una clave para cada concepto.', {status: 'danger'});
						$('#clave' + x).focus();
						$('#clave' + x).trigger('chosen:activate');
						return;
					}

					if(concepto.nombre == ''){
						Notify.alert('Debe agregar una descripción para cada concepto.', {status: 'danger'});
						$('#nombre' + x).focus();
						return;
					}

					if(concepto.qty == null || concepto.qty < 0.00001){
						Notify.alert('La cantidad por concepto debe ser al mayor a 0.', {status: 'danger'});
						$('#qty' + x).focus();
						return;
					}

					if(concepto.precioU == null){
						Notify.alert('Debe ingresar un precio unitario.', {status: 'danger'});
						$('#precioU' + x).focus();
						return;
					}

				}

				vm.loading = "whirl double-up";

                let urlFacturar = 'facturarPorConcepto';
                if(vm.factura.versionF == '4.0')
                    urlFacturar = 'facturarPorConcepto40';

				$http.post('/api/admin/facturacion/'+urlFacturar, {
					user : $rootScope.user,
					factura: vm.factura
				}).then(function(res) {
					var response = res['data'];
					if (response['success']) {

						SweetAlert.swal('Éxito!', 'Se generó su factura de forma correcta con el No. ' + response.facturaResult, 'success');
						$state.transitionTo('app.listadoFacturas');

					}else{
						SweetAlert.swal('Error!', response.errorCode + ' - ' + response.errortext + ' <br>' + response.nombreArchivo, 'error');
					}

					vm.loading = "";

				}, function errorCallback(response) {
					vm.loading = "";
				});



			};



        	vm.obtenerDatos();



        }
    }
})();


(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('NuevaCartaPorteController', NuevaCartaPorteController);

    NuevaCartaPorteController.$inject = ['$scope', '$http', '$state', '$stateParams',
        'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function NuevaCartaPorteController($scope, $http, $state, $stateParams, Notify,
                                    $rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {
        var vm = this;

        vm.clientes = [];
        vm.formasDePago = [];
        vm.productos = [];
        vm.unidadesMedida = [];
        vm.clavesProducto = [];
        vm.usosCFDI = [];
        vm.addendas = [];
        vm.usosCFDITmp = [];
        vm.searchTextCustomer = '';
        vm.series = [];
        vm.factura = {
            tipoDocumento: 'I',
            id_cliente: '',
            decimales: '2',
            impuestosRetenidos : [],
            guardarProd: false,
            impuestosTrasladados : [{factor: 'Tasa', valor: 0.16, impuesto: '002', label: 'IVA'}],
            moneda: 'MXN',
            tipoCambio: 1.0,
            detalles: [],
            descuento: 0,
            facturasRelacionadas: {
                tipoRelacion: '',
                noFactura: '',
                uuids: []
            },
            cuentaPredial: '',
            formaPago: '',
            lugarExpedicion: '',
            serie: 'A',
            metodoDePago: 'PUE',
            truncar: '0',
            exportacion: '01',
            versionF: '4.0',
            cartaPorte:{
                ubicaciones: [{
                    tipoUbicacion: 'Origen',
                    rFCRemitenteDestinatario: '',
					nombreDestinatario: '',
                    numRegIdTrib: '',
                    fechaHoraSalidaLlegada: '',
                    calle: '',
                    numeroExterior: '',
                    numeroInterior: '',
                    colonia: '',
                    municipio: '',
                    estado: '',
                    pais: '',
                    codigoPostal: '',
                    totalDistRec: '',
                },
                    {
                        tipoUbicacion: 'Destino',
                        rFCRemitenteDestinatario: '',
						nombreDestinatario: '',
                        numRegIdTrib: '',
                        fechaHoraSalidaLlegada: '',
                        calle: '',
                        numeroExterior: '',
                        numeroInterior: '',
                        colonia: '',
                        municipio: '',
                        estado: '',
                        pais: '',
                        codigoPostal: '',
                        totalDistRec: '',
                    }],
                mercancias: [{
                    cantidad: '',
                    peso: '',
                    claveUnidad: '',
                    descripcion: '',
                    moneda: 'MXN',
                    valorMercancia: ''
                }],
                viaEntradaSalida: '01',
                transpInternac: 'No',
                entradaSalidaMerc: '',
                paisOrigenDestino: '',
                figurasTransporte: [
                    {
                        tipoFigura: '01',
                        rFCFigura: '',
                        numLicencia: '',
                        nombreFigura: '',
                        numRegIdTribFigura: '',
                    }
                ],
                autotransporte: {
                    remolques: [],
                    pesoBrutoVehicular: ''
                }
            }
        }
        vm.productoAgregar = '';
        vm.clavesProductoServicio = [];
        vm.tipoRelaciones = [
            {value: '01', label: 'Nota de crédito de los documentos relacionados'},
            {value: '02', label: 'Nota de débito de los documentos relacionados'},
            {value: '03', label: 'Devolución de mercancía sobre facturas o traslados previos'},
            {value: '04', label: 'Sustitución de los CFDI previos'},
            {value: '05', label: 'Traslados de mercancias facturados previamente'},
            {value: '06', label: 'Factura generada por los traslados previos'},
            {value: '07', label: 'CFDI por aplicación de anticipo'}
        ];
        vm.clavesProductoServicioCarta = [
            {clave: {codigo: '78101500',  descripcion: 'Transporte de carga aérea'}},
            {clave: {codigo: '78101600',  descripcion: 'Transporte de carga por ferrocarril'}},
            {clave: {codigo: '78101700',  descripcion: 'Transporte de carga por mar'}},
            {clave: {codigo: '78101800',  descripcion: 'Transporte de carga por carretera'}},
            {clave: {codigo: '78101801',  descripcion: 'Servicios de transporte de carga por carretera (en camión) en área local'}},
			{clave: {codigo: '78101806',  descripcion: 'Servicios transporte de carga por carretera a nivel internacional'}},
            {clave: {codigo: '78101900',  descripcion: 'Transporte de carga intermodal'}},
            {clave: {codigo: '78102200',  descripcion: 'Servicios postales de paqueteo y courrier'}},
            {clave: {codigo: '78121603',  descripcion: 'Tarifa de los fletes'}},
            {clave: {codigo: '78141500',  descripcion: 'Servicios de organización de transportes'}},
            {clave: {codigo: '92121800',  descripcion: 'Servicios de Carros blindados y transporte de valores'}},
            {clave: {codigo: '78101802',  descripcion: 'Servicios transporte de carga por carretera (en camión) a nivel regional y nacional'}}
        ];
        vm.metodosDePago = [{codigo: 'PUE', descripcion: 'Pago en una sola exhibición'}, {codigo: 'PPD', descripcion: 'Pago en parcialidades o diferido'}];

        vm.cambiarTipoDocumento = function(tipo){
            vm.factura.tipoDocumento = tipo;
            if(vm.factura.tipoDocumento == 'P')
                $state.transitionTo('app.nuevoPago');
            else if(vm.factura.tipoDocumento == 'T')
                $state.transitionTo('app.cartaPorteTraslado');

            if(vm.factura.tipoDocumento == 'I'){
                vm.clavesProductoServicio = vm.clavesProductoServicioCarta;
            }else if(vm.factura.tipoDocumento == 'T'){
                vm.clavesProductoServicio = vm.clavesProducto;
            }
        };

        activate();

        ////////////////

        function activate() {

            vm.clavesProductoServicio = vm.clavesProductoServicioCarta;

            if($rootScope.user.id_proveedor == 943){
                console.log("Si entro acá");
            }

            vm.obtenerNombreTipoRelacion = function(){
                for(var x = 0; x < vm.tipoRelaciones.length; x++){
                    if(vm.tipoRelaciones[x].value == vm.factura.facturasRelacionadas.tipoRelacion){
                        return vm.tipoRelaciones[x].label;
                    }
                }
            };


            vm.obtenerDatos = function(){

                if($stateParams.tipoDocumento != undefined && $stateParams.tipoDocumento != ''){
                    vm.factura.tipoDocumento = $stateParams.tipoDocumento;
                }

                vm.loading = "whirl double-up";

                $http.post('/api/admin/facturacion/datosFacturar', {
                    user : $rootScope.user,
					cartaPorte: 1
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {

                        vm.loading = "";
                        vm.clientes = response.clientes;
                        vm.formasDePago = response.formasDePago;
                        vm.productos = response.productos;
                        vm.unidadesMedida = response.unidadesMedida;
                        vm.clavesProducto = response.clavesProducto;
                        vm.usosCFDI = response.usosCFDI;
                        vm.series = response.series;
                        vm.factura.lugarExpedicion = response.proveedor.domicilio.codigoPostal;
                        vm.usosCFDITmp = response.usosCFDI;
                        vm.addendas = response.addendas;
                        vm.regimenesFiscales = response.regimenesFiscales;
                        vm.tipoPermisos = response.tipoPermisos;
                        vm.configTransportes = response.configTransportes;
                        vm.subTiposRem = response.subTiposRem;
                        vm.tieneCartaPorte = response.tieneCartaPorte;
                        vm.tieneEscuelas = response.tieneEscuelas;
						vm.figurasTransporteBase = response.figurasTransporteBase;
						vm.ubicacionesBase = response.ubicacionesBase;
						vm.autotransportesBase = response.autotransportesBase;

                    }

                }, function errorCallback(response) {

                });
            };


            vm.opcionesFactura = function(){

                ngDialog.openConfirm({
                    template: 'opcionesFactura',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'OpcionesFacturaController',
                    data: {factura: vm.factura}
                }).then(function (buscar) {

                }, function (factura) {

                    if(factura.tipoDocumento != undefined){
                        vm.factura.impuestosTrasladados = factura.impuestosTrasladados;
                        vm.factura.impuestosRetenidos = factura.impuestosRetenidos;
                        vm.factura.cuentaPredial = factura.cuentaPredial;
                        vm.factura.moneda = factura.moneda;
                        vm.factura.tipoCambio = factura.tipoCambio;
                        vm.factura.truncar = factura.truncar;
                        if(factura.norma !== undefined){
                            vm.factura.norma = factura.norma;
                            vm.factura.leyenda = factura.leyenda;
                        }
                    }

                    vm.calcularTotales();
                });

            };



            vm.facturaRelacionada = function(){

                vm.factura.facturasRelacionadas.noFactura = '';

                ngDialog.openConfirm({
                    template: 'facturasRelacionadas',
                    className: 'ngdialog-theme-default',
                    controller: 'FacturasRelacionadasController',
                    data: {tipoRelaciones: vm.tipoRelaciones, facturasRelacionadas: vm.factura.facturasRelacionadas}
                }).then(function (documento) {

                }, function (documento) {
                    console.log(documento);
                    if(documento.tipoRelacion != undefined){
                        vm.factura.facturasRelacionadas = documento;
                    }
                });

            };

            vm.agregrProdExistente = function(){
                if(vm.productoAgregar.id_producto != undefined){
                    vm.productoAgregar.precioU = Number(vm.productoAgregar.precioU);
                    vm.productoAgregar.qty = 1;
                    vm.productoAgregar.descuento = 0;
                    vm.productoAgregar.peso = '';
                    vm.productoAgregar.objetoImp = '02';
                    vm.factura.detalles.push(angular.copy(vm.productoAgregar));
                    vm.productoAgregar = '';
                }

                vm.calcularTotales();
            };


            vm.agregrProdNuevo = function(){
                var productoNuevo = {
                    codigo: '1',
                    clave: '',
                    nombre: '',
                    unidad: '',
                    qty: 1,
                    precioU: 1.00,
                    descuento: 0,
                    objetoImp: '02',
                    peso: ''
                };
                vm.factura.detalles.push(productoNuevo);
                vm.productoAgregar = '';

                vm.calcularTotales();
            };

            vm.calcularTotales = function(){

                vm.factura.subtotal = 0;
                vm.factura.total = 0;
                vm.factura.base = 0;
                vm.factura.descuento = 0;
                vm.factura.totalTraslados = 0;
                vm.factura.totalRetenciones = 0;

                for(var y = 0; y < vm.factura.impuestosTrasladados.length; y++){
                    vm.factura.impuestosTrasladados[y].total = 0;
                }

                for(var y = 0; y < vm.factura.impuestosRetenidos.length; y++){
                    vm.factura.impuestosRetenidos[y].total = 0;
                }

                for(var x = 0; x < vm.factura.detalles.length; x++){

                    vm.factura.detalles[x].precioU = $rootScope.toFixedNumber(vm.factura.detalles[x].precioU);
                    vm.factura.detalles[x].descuento = $rootScope.toFixedNumber(vm.factura.detalles[x].descuento);

                    var baseItem = $rootScope.toFixedNumberSpecial((vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU))
                    vm.factura.subtotal += baseItem;
                    vm.factura.detalles[x].base = baseItem - vm.factura.detalles[x].descuento;
                    vm.factura.descuento += Number(vm.factura.detalles[x].descuento);

                    for(var y = 0; y < vm.factura.impuestosTrasladados.length; y++){

                        var valorImpuesto = 0;
                        if(vm.factura.impuestosTrasladados[y].factor == 'Tasa'){
                            valorImpuesto = vm.factura.impuestosTrasladados[y].valor * vm.factura.detalles[x].base;
                        }else{
                            valorImpuesto = vm.factura.impuestosTrasladados[y].valor;
                        }

                        if(vm.factura.truncar == '1'){
                            valorImpuesto = $rootScope.truncateNumbers(valorImpuesto);
                        }else{
                            valorImpuesto = $rootScope.toFixedNumberSpecial(valorImpuesto);
                        }

                        vm.factura.impuestosTrasladados[y].total += valorImpuesto;
                        vm.factura.totalTraslados += valorImpuesto ;
                    }


                    for(var y = 0; y < vm.factura.impuestosRetenidos.length; y++){

                        var valorImpuesto = 0;
                        if(vm.factura.impuestosRetenidos[y].factor == 'Tasa'){
                            var valorImpRet = vm.factura.impuestosRetenidos[y].valor;
                            var valorBaseProd = vm.factura.detalles[x].base;

                            valorImpuesto = valorImpRet * valorBaseProd;
                        }else{
                            valorImpuesto = vm.factura.impuestosRetenidos[y].valor;
                        }

                        if(vm.factura.truncar == '1'){
                            valorImpuesto = $rootScope.truncateNumbers(valorImpuesto);
                        }else{
                            valorImpuesto = $rootScope.toFixedNumberSpecial(valorImpuesto);
                        }

                        vm.factura.impuestosRetenidos[y].total += valorImpuesto;
                        vm.factura.totalRetenciones += valorImpuesto ;
                    }

                }

                vm.factura.total = vm.factura.base = vm.factura.subtotal - vm.factura.descuento;
                vm.factura.total += (vm.factura.totalTraslados - vm.factura.totalRetenciones);
                vm.factura.total = $rootScope.toFixedNumber(vm.factura.total);

            };


            vm.calcularTotalesEspecial = function(){

                vm.factura.subtotal = 0;
                vm.factura.total = 0;
                vm.factura.base = 0;
                vm.factura.descuento = 0;
                vm.factura.totalTraslados = 0;
                vm.factura.totalRetenciones = 0;

                for(var x = 0; x < vm.factura.detalles.length; x++){

                    vm.factura.detalles[x].precioU = $rootScope.toFixedNumber(vm.factura.detalles[x].precioU);
                    vm.factura.detalles[x].descuento = $rootScope.toFixedNumber(vm.factura.detalles[x].descuento);

                    var baseItem = $rootScope.toFixedNumberSpecial((vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU))
                    vm.factura.subtotal += baseItem;
                    vm.factura.detalles[x].base = baseItem - vm.factura.detalles[x].descuento;
                    vm.factura.descuento += Number(vm.factura.detalles[x].descuento);

                    for(var y = 0; y < vm.factura.impuestosTrasladados.length; y++){

                        valorImpuesto = Number(vm.factura.impuestosTrasladados[y].total);
                        vm.factura.impuestosTrasladados[y].total = valorImpuesto;
                        vm.factura.totalTraslados += valorImpuesto ;
                    }


                    for(var y = 0; y < vm.factura.impuestosRetenidos.length; y++){

                        var valorImpuesto = Number(vm.factura.impuestosRetenidos[y].total);
                        vm.factura.impuestosRetenidos[y].total = valorImpuesto;
                        vm.factura.totalRetenciones += valorImpuesto ;
                    }

                }

                vm.factura.total = vm.factura.base = vm.factura.subtotal - vm.factura.descuento;
                vm.factura.total += (vm.factura.totalTraslados - vm.factura.totalRetenciones);
                vm.factura.total = $rootScope.toFixedNumber(vm.factura.total);

            };

            vm.cleanValue = function(){
                for(let x = 0; x < vm.factura.cartaPorte.mercancias.length; x++){
                    vm.factura.cartaPorte.mercancias[x].valorMercancia = vm.factura.cartaPorte.mercancias[x].valorMercancia.replace(/[^\d.]/g, '');
                }
            }

            vm.borrarConcepto = function(index){
                vm.factura.detalles.splice(index, 1);
                vm.calcularTotales();
            };


            /////Funcionalidad select de mobile para customer
            vm.getMatchesCustomer = function(searchText) {
                if(searchText == "" || searchText == null)
                    return vm.clientes;
                var states = vm.clientes.filter(function(customer) {
                    var pordChane = customer.nmbRecep + " " + customer.rFCRecep;
                    return (pordChane.toUpperCase().match(searchText.toUpperCase()));
                });

                return states;
            }

            vm.selectedCustomer = function(cliente){
                if(typeof(cliente) != 'undefined' && typeof(cliente.id_cliente) != 'undefined'){
                    vm.factura.id_cliente = cliente;
                    vm.obtenerPaises();
                }else{
                    vm.factura.id_cliente = 0;
                }
            };
            ////////////////////////////

            function rfcValido(rfc, aceptarGenerico = true) {

                var   validado = /^[A-Z&Ñ]{3,4}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]$/.test(rfc)

                return validado;
            }

            vm.obtenerPaises = function(){

                vm.usosCFDITmp = [];

                if(isNaN(Number(vm.factura.id_cliente.rFCRecep.charAt(3)))){

                    vm.usosCFDITmp = vm.usosCFDI;

                }else{
                    for(var x = 0; x < vm.usosCFDI.length; x++){
                        if(vm.usosCFDI[x].validMoral == 1){
                            vm.usosCFDITmp.push(vm.usosCFDI[x]);
                        }
                    }
                }

                vm.factura.formaPago = vm.factura.id_cliente.metodoPago;
                vm.factura.usoCFDI = vm.factura.id_cliente.usoCFDI;
                vm.obtenerRegimenesFiscales();

                if( vm.factura.id_cliente!= null && vm.factura.id_cliente.rFCRecep == 'XEXX010101000'){

                    $http.post('/api/admin/facturacion/obtenerPaises', {
                        user : $rootScope.user
                    }).then(function(res) {
                        var response = res['data'];
                        if (response['success']) {

                            vm.loading = "";
                            vm.paises = response.paises;
                        }

                    }, function errorCallback(response) {
                        vm.obtenerDatos();
                    });

                }


            };

            vm.borrarFacturaRelacionada = function(index){
                vm.factura.facturasRelacionadas.uuids.splice(index, 1);
            };


            vm.seleccionarMetodoPago = function(){
                if(vm.factura.metodoDePago == 'PPD'){
                    vm.factura.formaPago = '99';
                    $("#formaPago").trigger("chosen:updated");
                }
            };

            vm.updateTotalPeso = function(){
                let totalAmount = 0;
                for(let x = 0; x < vm.factura.cartaPorte.mercancias.length; x++){
                    totalAmount += Number(vm.factura.cartaPorte.mercancias[x].peso);
                }
                vm.factura.cartaPorte.pesoBrutoTotal = totalAmount;
            }


            vm.facturar = function(){

                if(vm.factura.id_cliente == '' || vm.factura.id_cliente == null){
                    Notify.alert('Debe seleccionar un cliente.', {status: 'danger'});
                    $('#id_cliente').trigger('chosen:activate');
                    return;
                }

                if(vm.factura.versionF == '4.0'){

                    if(vm.factura.id_cliente.regimenFiscalReceptor == null
                        || vm.factura.id_cliente.regimenFiscalReceptor == ''){
                        Notify.alert('Debe seleccionar el regimen fiscal.', {status: 'danger'});
                        $('#regimenFiscalReceptor').trigger('chosen:activate');
                        return;
                    }

                    if(vm.factura.id_cliente.codigoPostal == null
                        || vm.factura.id_cliente.codigoPostal.length < 5){
                        Notify.alert('Debe ingresar el codigo postal del receptor.', {status: 'danger'});
                        $('#codigoPostalR').trigger('chosen:activate');
                        return;
                    }
                }

                if(vm.factura.formaPago == '' || vm.factura.formaPago == null){
                    Notify.alert('Debe seleccionar una forma de pago.', {status: 'danger'});
                    $('#formaPago').trigger('chosen:activate');
                    $('#formaPago').focus();
                    return;
                }


                if(vm.factura.lugarExpedicion == '' || vm.factura.lugarExpedicion == null || vm.factura.lugarExpedicion.length < 5 ){
                    Notify.alert('Debe ingresar un lugar de expedición correcto (C.P.)', {status: 'danger'});
                    $('#lugarExpedicion').focus();
                    return;
                }


                if(vm.factura.usoCFDI == '' || vm.factura.usoCFDI == null || vm.factura.usoCFDI == '0'){
                    Notify.alert('Debe seleccionar el uso del CFDI.', {status: 'danger'});
                    $('#usoCFDI').trigger('chosen:activate');
                    $('#usoCFDI').focus();
                    return;
                }

                if(vm.factura.detalles.length == 0){
                    Notify.alert('Debe agregar al menos un producto.', {status: 'danger'});
                    return;
                }

                for(var x = 0; x < vm.factura.detalles.length; x++){

                    var concepto = vm.factura.detalles[x];

                    if(concepto.clave == ''){
                        Notify.alert('Debe seleccionar una clave para cada concepto.', {status: 'danger'});
                        $('#clave' + x).focus();
                        $('#clave' + x).trigger('chosen:activate');
                        return;
                    }

                    if(concepto.nombre == ''){
                        Notify.alert('Debe agregar una descripción para cada concepto.', {status: 'danger'});
                        $('#nombre' + x).focus();
                        return;
                    }

                    if(concepto.unidad == null || concepto.unidad == ''){
                        Notify.alert('Debe seleccionar una unidad para cada concepto.', {status: 'danger'});
                        $('#unidad' + x).focus();
                        $('#unidad' + x).trigger('chosen:activate');
                        return;
                    }

                    if(concepto.qty == null || concepto.qty < 0.00001){
                        Notify.alert('La cantidad por concepto debe ser al mayor a 0.', {status: 'danger'});
                        $('#qty' + x).focus();
                        return;
                    }

                    if(concepto.precioU == null){
                        Notify.alert('Debe ingresar un precio unitario.', {status: 'danger'});
                        $('#precioU' + x).focus();
                        return;
                    }
                }

                if(vm.factura.cartaPorte.transpInternac === 'Si' && vm.factura.cartaPorte.paisOrigenDestino.length == 0){
                    Notify.alert('Debe seleccionar el país de origen o destino.', {status: 'danger'});
                    $('#paisOrigenDestino').focus();
                    return;
                }

                if(vm.factura.cartaPorte.viaEntradaSalida.length == 0){
                    Notify.alert('Debe seleccionar la via de entrada o salida.', {status: 'danger'});
                    $('#entradaSalidaMerc').focus();
                    return;
                }

                if(vm.factura.cartaPorte.pesoBrutoTotal === undefined || Number(vm.factura.cartaPorte.pesoBrutoTotal) <= 0){
                    Notify.alert('Debe ingresar el peso bruto total.', {status: 'danger'});
                    $('#pesoBrutoTotal').focus();
                    return;
                }

                if(vm.factura.cartaPorte.unidadPeso === undefined || vm.factura.cartaPorte.unidadPeso.length == 0){
                    Notify.alert('Debe seleccionar unidad de peso.', {status: 'danger'});
                    $('#unidadPesoBruto').focus();
                    $('#unidadPesoBruto').trigger('chosen:activate');
                    return;
                }

                if(vm.factura.cartaPorte.ubicaciones.length < 2){
                    Notify.alert('La carta porte debe tener al menos 2 ubicaciones, uno tipo Origen y uno tipo Destino.', {status: 'danger'});
                    $('#buttonUbicacion' + x).focus();
                    return;
                }

                if(vm.factura.cartaPorte.mercancias.length === 0){
                    Notify.alert('Debe agregar al menos una mercancía.', {status: 'danger'});
                    return
                }

                for(let x = 0; x < vm.factura.cartaPorte.mercancias.length; x++){
                    if(!(/^\d+$/.test(vm.factura.cartaPorte.mercancias[x].cantidad))){
                        Notify.alert('Debe indicar la cantidad de mercancías con sólo números.', {status: 'danger'});
                        $("#cantidadM"+x).focus();
                        return
                    }

                    if(!(/^\d+$/.test(vm.factura.cartaPorte.mercancias[x].peso))){
                        Notify.alert('Debe indicar el peso de mercancías con sólo números.', {status: 'danger'});
                        $("#pesoM"+x).focus();
                        return
                    }

                    if(vm.factura.cartaPorte.mercancias[x].descripcion.length === 0){
                        Notify.alert('Debe agregar la descripción de la mercancía.', {status: 'danger'});
                        $("#descripcionM"+x).focus();
                        return
                    }

                    if(vm.factura.cartaPorte.transpInternac == 'Sí'){

                        if((vm.factura.cartaPorte.mercancias[x].fraccionArancelaria == undefined
                                || vm.factura.cartaPorte.mercancias[x].fraccionArancelaria.length === 0)){
                            Notify.alert('Debe agregar la fracción aranceleraria de la mercancía.', {status: 'danger'});
                            $("#fraccionArancelaria"+x).focus();
                            return
                        }

                        /*
                        if((vm.factura.cartaPorte.mercancias[x].pedimento == undefined
                                || vm.factura.cartaPorte.mercancias[x].pedimento.length === 0)){
                            Notify.alert('Debe agregar la fracción aranceleraria de la mercancía.', {status: 'danger'});
                            $("#pedimento"+x).focus();
                            return
                        }*/

                        vm.factura.cartaPorte.mercancias[x].fraccionArancelaria = vm.factura.cartaPorte.mercancias[x].fraccionArancelaria.trim();
                        vm.factura.cartaPorte.mercancias[x].pedimento = (vm.factura.cartaPorte.mercancias[x].pedimento === undefined) ? '' : vm.factura.cartaPorte.mercancias[x].pedimento.trim();
                    }



                }


                let hasOrigen = false;
                let hasDestino = false;
                for(let x = 0; x < vm.factura.cartaPorte.ubicaciones.length; x++){
                    if(vm.factura.cartaPorte.ubicaciones[x].tipoUbicacion == 'Origen')
                        hasOrigen = true;

                    if(vm.factura.cartaPorte.ubicaciones[x].tipoUbicacion == 'Destino')
                        hasDestino = true;

                    if(!rfcValido(vm.factura.cartaPorte.ubicaciones[x].rFCRemitenteDestinatario)){
                        Notify.alert('El RFC ingresado en las ubicaciones es incorrecto.', {status: 'danger'});
                        return
                    }
                }
                if(!hasOrigen){
                    Notify.alert('Debe agregar una ubicación tipo Origen.', {status: 'danger'});
                    return;
                }

                if(!hasOrigen){
                    Notify.alert('Debe agregar una ubicación tipo Destino.', {status: 'danger'});
                    return;
                }

                let hasOrigenOperador = false;
                for(let x = 0; x < vm.factura.cartaPorte.figurasTransporte.length; x++){

                    if(!rfcValido(vm.factura.cartaPorte.figurasTransporte[x].rFCFigura)){
                        Notify.alert('El RFC ingresado en la figura de transporte es incorrecto.', {status: 'danger'});
                        return
                    }

                    if(vm.factura.cartaPorte.figurasTransporte[x].tipoFigura == '01'){
                        hasOrigenOperador = true;
                        break;
                    }
                }
                if(!hasOrigenOperador){
                    Notify.alert('En Figuras de trasnporte debe existir al menos uno de tipo Operador.', {status: 'danger'});
                    $('#buttonFiguras' + x).focus();
                    return;
                }

                if(vm.factura.cartaPorte.viaEntradaSalida == '01'){
                    if(vm.factura.cartaPorte.autotransporte.pesoBrutoVehicular === undefined || Number(vm.factura.cartaPorte.autotransporte.pesoBrutoVehicular) <= 0){
                        Notify.alert('Debe ingresar las toneladas permitidas para el vehículo.', {status: 'danger'});
                        $('#pesoBrutoVehicular').focus();
                        return;
                    }
                }

                vm.loading = "whirl double-up";


                let urlFacturar = 'facturar';
                if(vm.factura.versionF == '4.0')
                    urlFacturar = 'facturar40';

                $http.post('/api/admin/facturacion/'+urlFacturar, {
                    user : $rootScope.user,
                    factura: vm.factura
                }).then(function(res) {
                    let response = res['data'];
                    if (response['success']) {

                        SweetAlert.swal('Éxito!', 'Se generó su factura de forma correcta con el No. ' + response.facturaResult, 'success');
                        $state.transitionTo('app.listadoFacturas');

                    }else{
                        if(response.errorCode == 10009){
                            vm.factura.id_cliente.nmbRecep = response.extraInfo;
                        }
                        SweetAlert.swal('Error', response.errortext , 'error');
                    }

                    vm.loading = "";

                }, function errorCallback(response) {
                    vm.loading = "";
                });



            };

            vm.toUpperCase = function(value){
                value = value.toUpperCase();
            }

            vm.facturarTest = function(){

                if(vm.factura.id_cliente == '' || vm.factura.id_cliente == null){
                    Notify.alert('Debe seleccionar un cliente.', {status: 'danger'});
                    $('#id_cliente').trigger('chosen:activate');
                    return;
                }

                if(vm.factura.formaPago == '' || vm.factura.formaPago == null){
                    Notify.alert('Debe seleccionar una forma de pago.', {status: 'danger'});
                    $('#formaPago').trigger('chosen:activate');
                    $('#formaPago').focus();
                    return;
                }


                if(vm.factura.lugarExpedicion == '' || vm.factura.lugarExpedicion == null || vm.factura.lugarExpedicion.length < 5 ){
                    Notify.alert('Debe ingresar un lugar de expedición correcto (C.P.)', {status: 'danger'});
                    $('#lugarExpedicion').focus();
                    return;
                }


                if(vm.factura.usoCFDI == '' || vm.factura.usoCFDI == null || vm.factura.usoCFDI == '0'){
                    Notify.alert('Debe seleccionar el uso del CFDI.', {status: 'danger'});
                    $('#usoCFDI').trigger('chosen:activate');
                    $('#usoCFDI').focus();
                    return;
                }

                if(vm.factura.detalles.length == 0){
                    Notify.alert('Debe agregar al menos un producto.', {status: 'danger'});
                    return;
                }

                for(var x = 0; x < vm.factura.detalles.length; x++){

                    var concepto = vm.factura.detalles[x];

                    if(concepto.clave == ''){
                        Notify.alert('Debe seleccionar una clave para cada concepto.', {status: 'danger'});
                        $('#clave' + x).focus();
                        $('#clave' + x).trigger('chosen:activate');
                        return;
                    }

                    if(concepto.nombre == ''){
                        Notify.alert('Debe agregar una descripción para cada concepto.', {status: 'danger'});
                        $('#nombre' + x).focus();
                        return;
                    }

                    if(concepto.unidad == null || concepto.unidad == ''){
                        Notify.alert('Debe seleccionar una unidad para cada concepto.', {status: 'danger'});
                        $('#unidad' + x).focus();
                        $('#unidad' + x).trigger('chosen:activate');
                        return;
                    }

                    if(concepto.qty == null || concepto.qty < 0.00001){
                        Notify.alert('La cantidad por concepto debe ser al mayor a 0.', {status: 'danger'});
                        $('#qty' + x).focus();
                        return;
                    }

                    if(concepto.precioU == null){
                        Notify.alert('Debe ingresar un precio unitario.', {status: 'danger'});
                        $('#precioU' + x).focus();
                        return;
                    }

                }

                vm.loading = "whirl double-up";


                $http.post('/api/admin/facturacion/facturarTest', {
                    user : $rootScope.user,
                    factura: vm.factura
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {

                        SweetAlert.swal('Éxito!', 'Se generó su factura de forma correcta con el No. ' + response.facturaResult, 'success');
                        $state.transitionTo('app.listadoFacturas');

                    }else{
                        SweetAlert.swal('Error!', response.errorCode + ' - ' + response.errortext + ' <br>' + response.nombreArchivo, 'error');
                    }

                    vm.loading = "";

                }, function errorCallback(response) {
                    vm.loading = "";
                });



            };

            vm.obtenerRegimenesFiscales = function (){
                vm.regimenesFiscalesList = [];
                for(let x = 0; x < vm.regimenesFiscales.length; x++){
                    if(vm.regimenesFiscales[x].tipo == vm.factura.id_cliente.tipoPersona || vm.regimenesFiscales[x].tipo == 3){
                        vm.regimenesFiscalesList.push(vm.regimenesFiscales[x]);
                    }
                }
            };

            vm.agregarMercancia = function(){
                vm.factura.cartaPorte.mercancias.push({
                    cantidad: '',
                    peso: '',
                    claveUnidad: '',
                    descripcion: '',
                    moneda: 'MXN',
                    valorMercancia: '',
                    bienesTransp: '',
                    fraccionArancelaria: '',
                    pedimento: ''
                });
            }

            vm.eliminarMercancia = function(index){
                vm.factura.cartaPorte.mercancias.splice(index, 1);
            }


            vm.agregarUbicacion = function(){

                vm.factura.cartaPorte.ubicaciones.push({
                    tipoUbicacion: '',
                    rFCRemitenteDestinatario: '',
					nombreDestinatario: '',
                    numRegIdTrib: '',
                    fechaHoraSalidaLlegada: '',
                    calle: '',
                    numeroExterior: '',
                    numeroInterior: '',
                    colonia: '',
                    municipio: '',
                    estado: '',
                    pais: '',
                    codigoPostal: '',
                    totalDistRec: '',
                });
            }


            vm.eliminarUbicacion = function (index){
                vm.factura.cartaPorte.ubicaciones.splice(index, 1);
            }

            vm.agregarRemolque = function(){
                vm.factura.cartaPorte.autotransporte.remolques.push({
                    subTipoRem: '',
                    placa: ''
                });
            }

            vm.eliminarRemolque = function (index){
                vm.factura.cartaPorte.autotransporte.remolques.splice(index, 1);
            }

            vm.agregarFigura = function(){
                vm.factura.cartaPorte.figurasTransporte.push({
                    tipoFigura: '',
                    rFCFigura: '',
                    numLicencia: '',
                    nombreFigura: '',
                    numRegIdTribFigura: '',
                });
            }

            vm.eliminarFigura = function (index){
                vm.factura.cartaPorte.figurasTransporte.splice(index, 1);
            }



            vm.getEstados = function(index, listObjects){
                vm.loading = "whirl double-up";
                $http.post('/api/admin/facturacion/getEstados', {
                    user : $rootScope.user,
                    country: vm.factura.cartaPorte.ubicaciones[index].pais
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {
                        vm.loading = "";
                        listObjects[index].estados = response.estados;
                    }
                }, function errorCallback(response) {
                });
            };

            vm.getMunicipio = function(index){
                vm.loading = "whirl double-up";
                $http.post('/api/admin/facturacion/getMunicipio', {
                    user : $rootScope.user,
                    estado: vm.factura.cartaPorte.ubicaciones[index].estado
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {
                        vm.loading = "";
                        vm.factura.cartaPorte.ubicaciones[index].municipios = response.municipios;
                    }
                }, function errorCallback(response) {
                });
            };

			vm.selectUbicacion = function(item, ubicacion){
				ubicacion.tipoUbicacion = item.tipoUbicacion;
				ubicacion.rFCRemitenteDestinatario = item.rFCRemitenteDestinatario;
				ubicacion.nombreDestinatario = item.nombreDestinatario;
				ubicacion.numRegIdTrib = item.numRegIdTrib;
				ubicacion.calle = item.calle;
				ubicacion.numeroExterior = item.numeroExterior;
				ubicacion.numeroInterior = item.numeroInterior;
				ubicacion.colonia = item.colonia;
				ubicacion.municipio = item.municipio;
				ubicacion.estado = item.estado;
				ubicacion.pais = item.pais;
				ubicacion.codigoPostal = item.codigoPostal;
			}



            vm.obtenerDatos();

        }
    }
})();








(function() {
    'use strict';

    angular
        .module('app.charts')
        .controller('CartaPorteTrasladoController', CartaPorteTrasladoController);

    CartaPorteTrasladoController.$inject = ['$scope', '$http', '$state', '$stateParams',
        'Notify', '$rootScope', 'SweetAlert', 'DTOptionsBuilder', 'DTColumnDefBuilder', 'ngDialog'];

    function CartaPorteTrasladoController($scope, $http, $state, $stateParams, Notify,
                                       $rootScope, SweetAlert, DTOptionsBuilder, DTColumnDefBuilder, ngDialog) {
        var vm = this;

        vm.clientes = [];
        vm.formasDePago = [];
        vm.productos = [];
        vm.unidadesMedida = [];
        vm.clavesProducto = [];
        vm.usosCFDI = [];
        vm.addendas = [];
        vm.usosCFDITmp = [];
        vm.searchTextCustomer = '';
        vm.series = [];
        vm.factura = {
            tipoDocumento: 'T',
            id_cliente: '',
            decimales: '2',
            impuestosRetenidos : [],
            guardarProd: false,
            impuestosTrasladados : [],
            moneda: 'MXN',
            usoCFDI: 'S01',
            tipoCambio: 1.0,
            detalles: [],
            descuento: 0,
            facturasRelacionadas: {
                tipoRelacion: '',
                noFactura: '',
                uuids: []
            },
            cuentaPredial: '',
            formaPago: '',
            lugarExpedicion: '',
            serie: 'A',
            metodoDePago: 'PUE',
            truncar: '0',
            exportacion: '01',
            versionF: '4.0',
            cartaPorte:{
                ubicaciones: [{
                    tipoUbicacion: 'Origen',
                    rFCRemitenteDestinatario: '',
					nombreDestinatario: '',
                    numRegIdTrib: '',
                    fechaHoraSalidaLlegada: '',
                    calle: '',
                    numeroExterior: '',
                    numeroInterior: '',
                    colonia: '',
                    municipio: '',
                    estado: '',
                    pais: '',
                    codigoPostal: '',
                    totalDistRec: '',
					idUbicacion: '',
                },
                    {
                        tipoUbicacion: 'Destino',
                        rFCRemitenteDestinatario: '',
						nombreDestinatario: '',
                        numRegIdTrib: '',
                        fechaHoraSalidaLlegada: '',
                        calle: '',
                        numeroExterior: '',
                        numeroInterior: '',
                        colonia: '',
                        municipio: '',
                        estado: '',
                        pais: '',
                        codigoPostal: '',
                        totalDistRec: '',
						idUbicacion: '',
                    }],
                viaEntradaSalida: '01',
                transpInternac: 'No',
                entradaSalidaMerc: '',
                paisOrigenDestino: '',
                figurasTransporte: [
                    {
                        tipoFigura: '01',
                        rFCFigura: '',
                        numLicencia: '',
                        nombreFigura: '',
                        numRegIdTribFigura: '',
                    }
                ],
                autotransporte: {
                    remolques: [],
                }
            }
        }
        vm.productoAgregar = '';
        vm.clavesProductoServicio = [];
        vm.tipoRelaciones = [
            {value: '01', label: 'Nota de crédito de los documentos relacionados'},
            {value: '02', label: 'Nota de débito de los documentos relacionados'},
            {value: '03', label: 'Devolución de mercancía sobre facturas o traslados previos'},
            {value: '04', label: 'Sustitución de los CFDI previos'},
            {value: '05', label: 'Traslados de mercancias facturados previamente'},
            {value: '06', label: 'Factura generada por los traslados previos'},
            {value: '07', label: 'CFDI por aplicación de anticipo'}
        ];
        vm.clavesProductoServicioCarta = [
            {clave: {codigo: '78101500',  descripcion: 'Transporte de carga aérea'}},
            {clave: {codigo: '78101600',  descripcion: 'Transporte de carga por ferrocarril'}},
            {clave: {codigo: '78101700',  descripcion: 'Transporte de carga por mar'}},
            {clave: {codigo: '78101800',  descripcion: 'Transporte de carga por carretera'}},
			{clave: {codigo: '78101806',  descripcion: 'Servicios transporte de carga por carretera a nivel internacional'}},
            {clave: {codigo: '78101900',  descripcion: 'Transporte de carga intermodal'}},
            {clave: {codigo: '78102200',  descripcion: 'Servicios postales de paqueteo y courrier'}},
            {clave: {codigo: '78121603',  descripcion: 'Tarifa de los fletes'}},
            {clave: {codigo: '78141500',  descripcion: 'Servicios de organización de transportes'}},
            {clave: {codigo: '92121800',  descripcion: 'Servicios de Carros blindados y transporte de valores'}}
        ];
        vm.metodosDePago = [{codigo: 'PUE', descripcion: 'Pago en una sola exhibición'}, {codigo: 'PPD', descripcion: 'Pago en parcialidades o diferido'}];

        vm.cambiarTipoDocumento = function(tipo){
            vm.factura.tipoDocumento = tipo;
            if(vm.factura.tipoDocumento == 'P')
                $state.transitionTo('app.nuevoPago');
            else if(vm.factura.tipoDocumento == 'T')
                $state.transitionTo('app.cartaPorteTraslado');
            else if(vm.factura.tipoDocumento == 'I'){
                vm.clavesProductoServicio = vm.clavesProductoServicioCarta;
            }else if(vm.factura.tipoDocumento == 'T'){
                vm.clavesProductoServicio = vm.clavesProducto;
            }
        };

        activate();

        ////////////////

        function activate() {

            if($rootScope.user.id_proveedor == 943){
                console.log("Si entro acá");
            }

            vm.obtenerNombreTipoRelacion = function(){
                for(var x = 0; x < vm.tipoRelaciones.length; x++){
                    if(vm.tipoRelaciones[x].value == vm.factura.facturasRelacionadas.tipoRelacion){
                        return vm.tipoRelaciones[x].label;
                    }
                }
            };


            vm.obtenerDatos = function(){

                if($stateParams.tipoDocumento != undefined && $stateParams.tipoDocumento != ''){
                    vm.factura.tipoDocumento = $stateParams.tipoDocumento;
                }

                vm.loading = "whirl double-up";

                $http.post('/api/admin/facturacion/datosFacturar', {
                    user : $rootScope.user,
					cartaPorte: 1
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {

                        vm.loading = "";
                        vm.clientes = response.clientes;
                        vm.formasDePago = response.formasDePago;
                        vm.productos = response.productos;
                        vm.unidadesMedida = response.unidadesMedida;
                        vm.clavesProducto = response.clavesProducto;
                        vm.usosCFDI = response.usosCFDI;
                        vm.series = response.series;
                        vm.factura.lugarExpedicion = response.proveedor.domicilio.codigoPostal;
                        vm.usosCFDITmp = response.usosCFDI;
                        vm.addendas = response.addendas;
                        vm.regimenesFiscales = response.regimenesFiscales;
                        vm.tipoPermisos = response.tipoPermisos;
                        vm.configTransportes = response.configTransportes;
                        vm.subTiposRem = response.subTiposRem;
                        vm.tieneCartaPorte = response.tieneCartaPorte;
                        vm.tieneEscuelas = response.tieneEscuelas;
                        vm.clavesProductoServicio = response.clavesProducto;
						vm.figurasTransporteBase = response.figurasTransporteBase;
						vm.ubicacionesBase = response.ubicacionesBase;
						vm.autotransportesBase = response.autotransportesBase;

                    }

                }, function errorCallback(response) {

                });
            };


            vm.opcionesFactura = function(){

                ngDialog.openConfirm({
                    template: 'opcionesFactura',
                    className: 'ngdialog-theme-default large-ngDialog',
                    controller: 'OpcionesFacturaController',
                    data: {factura: vm.factura}
                }).then(function (buscar) {

                }, function (factura) {

                    if(factura.tipoDocumento != undefined){
                        vm.factura.impuestosTrasladados = factura.impuestosTrasladados;
                        vm.factura.impuestosRetenidos = factura.impuestosRetenidos;
                        vm.factura.cuentaPredial = factura.cuentaPredial;
                        vm.factura.moneda = factura.moneda;
                        vm.factura.tipoCambio = factura.tipoCambio;
                        vm.factura.truncar = factura.truncar;
                        if(factura.norma !== undefined){
                            vm.factura.norma = factura.norma;
                            vm.factura.leyenda = factura.leyenda;
                        }
                    }

                    vm.calcularTotales();
                });

            };



            vm.facturaRelacionada = function(){

                vm.factura.facturasRelacionadas.noFactura = '';

                ngDialog.openConfirm({
                    template: 'facturasRelacionadas',
                    className: 'ngdialog-theme-default',
                    controller: 'FacturasRelacionadasController',
                    data: {tipoRelaciones: vm.tipoRelaciones, facturasRelacionadas: vm.factura.facturasRelacionadas}
                }).then(function (documento) {

                }, function (documento) {
                    console.log(documento);
                    if(documento.tipoRelacion != undefined){
                        vm.factura.facturasRelacionadas = documento;
                    }
                });

            };

			vm.selectUbicacion = function(item, ubicacion){
				ubicacion.tipoUbicacion = item.tipoUbicacion;
				ubicacion.rFCRemitenteDestinatario = item.rFCRemitenteDestinatario;
				ubicacion.nombreDestinatario = item.nombreDestinatario;
				ubicacion.numRegIdTrib = item.numRegIdTrib;
				ubicacion.calle = item.calle;
				ubicacion.numeroExterior = item.numeroExterior;
				ubicacion.numeroInterior = item.numeroInterior;
				ubicacion.colonia = item.colonia;
				ubicacion.municipio = item.municipio;
				ubicacion.estado = item.estado;
				ubicacion.pais = item.pais;
				ubicacion.codigoPostal = item.codigoPostal;
			}

            vm.agregrProdExistente = function(){
                if(vm.productoAgregar.id_producto != undefined){
                    vm.productoAgregar.precioU = Number(vm.productoAgregar.precioU);
                    vm.productoAgregar.qty = 1;
                    vm.productoAgregar.descuento = 0;
                    vm.productoAgregar.peso = 1;
                    vm.productoAgregar.objetoImp = '01';
                    vm.factura.detalles.push(angular.copy(vm.productoAgregar));
                    vm.productoAgregar = '';
                }

                vm.calcularTotales();
            };


            vm.agregrProdNuevo = function(){
                var productoNuevo = {
                    codigo: '1',
                    clave: '',
                    nombre: '',
                    unidad: '',
                    qty: 1,
                    precioU: 1.00,
                    descuento: 0,
                    objetoImp: '01',
                    peso: ''
                };
                vm.factura.detalles.push(productoNuevo);
                vm.productoAgregar = '';

                vm.calcularTotales();
            };

            vm.calcularTotales = function(){

                vm.factura.subtotal = 0;
                vm.factura.total = 0;
                vm.factura.base = 0;
                vm.factura.descuento = 0;
                vm.factura.totalTraslados = 0;
                vm.factura.totalRetenciones = 0;

                for(var y = 0; y < vm.factura.impuestosTrasladados.length; y++){
                    vm.factura.impuestosTrasladados[y].total = 0;
                }

                for(var y = 0; y < vm.factura.impuestosRetenidos.length; y++){
                    vm.factura.impuestosRetenidos[y].total = 0;
                }

                for(var x = 0; x < vm.factura.detalles.length; x++){

                    vm.factura.detalles[x].precioU = $rootScope.toFixedNumber(vm.factura.detalles[x].precioU);
                    vm.factura.detalles[x].descuento = $rootScope.toFixedNumber(vm.factura.detalles[x].descuento);

                    var baseItem = $rootScope.toFixedNumberSpecial((vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU))
                    vm.factura.subtotal += baseItem;
                    vm.factura.detalles[x].base = baseItem - vm.factura.detalles[x].descuento;
                    vm.factura.descuento += Number(vm.factura.detalles[x].descuento);

                    for(var y = 0; y < vm.factura.impuestosTrasladados.length; y++){

                        var valorImpuesto = 0;
                        if(vm.factura.impuestosTrasladados[y].factor == 'Tasa'){
                            valorImpuesto = vm.factura.impuestosTrasladados[y].valor * vm.factura.detalles[x].base;
                        }else{
                            valorImpuesto = vm.factura.impuestosTrasladados[y].valor;
                        }

                        if(vm.factura.truncar == '1'){
                            valorImpuesto = $rootScope.truncateNumbers(valorImpuesto);
                        }else{
                            valorImpuesto = $rootScope.toFixedNumberSpecial(valorImpuesto);
                        }

                        vm.factura.impuestosTrasladados[y].total += valorImpuesto;
                        vm.factura.totalTraslados += valorImpuesto ;
                    }


                    for(var y = 0; y < vm.factura.impuestosRetenidos.length; y++){

                        var valorImpuesto = 0;
                        if(vm.factura.impuestosRetenidos[y].factor == 'Tasa'){
                            var valorImpRet = vm.factura.impuestosRetenidos[y].valor;
                            var valorBaseProd = vm.factura.detalles[x].base;

                            valorImpuesto = valorImpRet * valorBaseProd;
                        }else{
                            valorImpuesto = vm.factura.impuestosRetenidos[y].valor;
                        }

                        if(vm.factura.truncar == '1'){
                            valorImpuesto = $rootScope.truncateNumbers(valorImpuesto);
                        }else{
                            valorImpuesto = $rootScope.toFixedNumberSpecial(valorImpuesto);
                        }

                        vm.factura.impuestosRetenidos[y].total += valorImpuesto;
                        vm.factura.totalRetenciones += valorImpuesto ;
                    }

                }

                vm.factura.subtotal = '0.00';
                vm.factura.total = '0.00';
            };

            vm.cleanValue = function(){
                for(let x = 0; x < vm.factura.cartaPorte.mercancias.length; x++){
                    vm.factura.cartaPorte.mercancias[x].valorMercancia = vm.factura.cartaPorte.mercancias[x].valorMercancia.replace(/[^\d.]/g, '');
                }
            }


            vm.calcularTotalesEspecial = function(){

                vm.factura.subtotal = 0;
                vm.factura.total = 0;
                vm.factura.base = 0;
                vm.factura.descuento = 0;
                vm.factura.totalTraslados = 0;
                vm.factura.totalRetenciones = 0;

                for(var x = 0; x < vm.factura.detalles.length; x++){

                    vm.factura.detalles[x].precioU = $rootScope.toFixedNumber(vm.factura.detalles[x].precioU);
                    vm.factura.detalles[x].descuento = $rootScope.toFixedNumber(vm.factura.detalles[x].descuento);

                    var baseItem = $rootScope.toFixedNumberSpecial((vm.factura.detalles[x].qty * vm.factura.detalles[x].precioU))
                    vm.factura.subtotal += baseItem;
                    vm.factura.detalles[x].base = baseItem - vm.factura.detalles[x].descuento;
                    vm.factura.descuento += Number(vm.factura.detalles[x].descuento);

                    for(var y = 0; y < vm.factura.impuestosTrasladados.length; y++){

                        valorImpuesto = Number(vm.factura.impuestosTrasladados[y].total);
                        vm.factura.impuestosTrasladados[y].total = valorImpuesto;
                        vm.factura.totalTraslados += valorImpuesto ;
                    }


                    for(var y = 0; y < vm.factura.impuestosRetenidos.length; y++){

                        var valorImpuesto = Number(vm.factura.impuestosRetenidos[y].total);
                        vm.factura.impuestosRetenidos[y].total = valorImpuesto;
                        vm.factura.totalRetenciones += valorImpuesto ;
                    }

                }

                vm.factura.subtotal = '0.00';
                vm.factura.total = '0.00';
            };

            vm.borrarConcepto = function(index){
                vm.factura.detalles.splice(index, 1);
                vm.calcularTotales();
            };


            /////Funcionalidad select de mobile para customer
            vm.getMatchesCustomer = function(searchText) {
                if(searchText == "" || searchText == null)
                    return vm.clientes;
                var states = vm.clientes.filter(function(customer) {
                    var pordChane = customer.nmbRecep + " " + customer.rFCRecep;
                    return (pordChane.toUpperCase().match(searchText.toUpperCase()));
                });

                return states;
            }

            vm.selectedCustomer = function(cliente){
                if(typeof(cliente) != 'undefined' && typeof(cliente.id_cliente) != 'undefined'){
                    vm.factura.id_cliente = cliente;
                    vm.obtenerPaises();
                }else{
                    vm.factura.id_cliente = 0;
                }
            };
            ////////////////////////////

            function rfcValido(rfc, aceptarGenerico = true) {

                var   validado = /^[A-Z&Ñ]{3,4}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]$/.test(rfc)

                return validado;
            }

            vm.obtenerPaises = function(){

                vm.usosCFDITmp = [];

                if(isNaN(Number(vm.factura.id_cliente.rFCRecep.charAt(3)))){

                    vm.usosCFDITmp = vm.usosCFDI;

                }else{
                    for(var x = 0; x < vm.usosCFDI.length; x++){
                        if(vm.usosCFDI[x].validMoral == 1){
                            vm.usosCFDITmp.push(vm.usosCFDI[x]);
                        }
                    }
                }

                vm.factura.formaPago = vm.factura.id_cliente.metodoPago;
                vm.factura.usoCFDI = 'S01';
                vm.obtenerRegimenesFiscales();

                if( vm.factura.id_cliente!= null && vm.factura.id_cliente.rFCRecep == 'XEXX010101000'){

                    $http.post('/api/admin/facturacion/obtenerPaises', {
                        user : $rootScope.user
                    }).then(function(res) {
                        var response = res['data'];
                        if (response['success']) {

                            vm.loading = "";
                            vm.paises = response.paises;
                        }

                    }, function errorCallback(response) {
                        vm.obtenerDatos();
                    });

                }


            };

            vm.borrarFacturaRelacionada = function(index){
                vm.factura.facturasRelacionadas.uuids.splice(index, 1);
            };


            vm.seleccionarMetodoPago = function(){
                if(vm.factura.metodoDePago == 'PPD'){
                    vm.factura.formaPago = '99';
                    $("#formaPago").trigger("chosen:updated");
                }
            };

            vm.updateTotalPeso = function(){
                let totalAmount = 0;
                for(let x = 0; x < vm.factura.cartaPorte.mercancias.length; x++){
                    totalAmount += Number(vm.factura.cartaPorte.mercancias[x].peso);
                }
                vm.factura.cartaPorte.pesoBrutoTotal = totalAmount;
            }


            vm.facturar = function(){

                if(vm.factura.id_cliente == '' || vm.factura.id_cliente == null){
                    Notify.alert('Debe seleccionar un cliente.', {status: 'danger'});
                    $('#id_cliente').trigger('chosen:activate');
                    return;
                }

                if(vm.factura.versionF == '4.0'){

                    if(vm.factura.id_cliente.regimenFiscalReceptor == null
                        || vm.factura.id_cliente.regimenFiscalReceptor == ''){
                        Notify.alert('Debe seleccionar el regimen fiscal.', {status: 'danger'});
                        $('#regimenFiscalReceptor').trigger('chosen:activate');
                        return;
                    }

                    if(vm.factura.id_cliente.codigoPostal == null
                        || vm.factura.id_cliente.codigoPostal.length < 5){
                        Notify.alert('Debe ingresar el codigo postal del receptor.', {status: 'danger'});
                        $('#codigoPostalR').trigger('chosen:activate');
                        return;
                    }
                }

                if(vm.factura.formaPago == '' || vm.factura.formaPago == null){
                    Notify.alert('Debe seleccionar una forma de pago.', {status: 'danger'});
                    $('#formaPago').trigger('chosen:activate');
                    $('#formaPago').focus();
                    return;
                }


                if(vm.factura.lugarExpedicion == '' || vm.factura.lugarExpedicion == null || vm.factura.lugarExpedicion.length < 5 ){
                    Notify.alert('Debe ingresar un lugar de expedición correcto (C.P.)', {status: 'danger'});
                    $('#lugarExpedicion').focus();
                    return;
                }


                if(vm.factura.usoCFDI == '' || vm.factura.usoCFDI == null || vm.factura.usoCFDI == '0'){
                    Notify.alert('Debe seleccionar el uso del CFDI.', {status: 'danger'});
                    $('#usoCFDI').trigger('chosen:activate');
                    $('#usoCFDI').focus();
                    return;
                }

                if(vm.factura.detalles.length == 0){
                    Notify.alert('Debe agregar al menos un producto.', {status: 'danger'});
                    return;
                }

                vm.factura.cartaPorte.mercancias = [];

                for(var x = 0; x < vm.factura.detalles.length; x++){

                    var concepto = vm.factura.detalles[x];

                    if(concepto.clave == ''){
                        Notify.alert('Debe seleccionar una clave para cada concepto.', {status: 'danger'});
                        $('#clave' + x).focus();
                        $('#clave' + x).trigger('chosen:activate');
                        return;
                    }

                    if(concepto.nombre == ''){
                        Notify.alert('Debe agregar una descripción para cada concepto.', {status: 'danger'});
                        $('#nombre' + x).focus();
                        return;
                    }

                    if(concepto.unidad == null || concepto.unidad == ''){
                        Notify.alert('Debe seleccionar una unidad para cada concepto.', {status: 'danger'});
                        $('#unidad' + x).focus();
                        $('#unidad' + x).trigger('chosen:activate');
                        return;
                    }

                    if(concepto.peso == null || concepto.peso == '' || isNaN(concepto.peso) ){
                        Notify.alert('Debe indicar el peso en kilogramos y con solo números.', {status: 'danger'});
                        $('#peso' + x).focus();
                        return;
                    }

                    if(concepto.qty == null || concepto.qty < 0.00001){
                        Notify.alert('La cantidad por concepto debe ser al mayor a 0.', {status: 'danger'});
                        $('#qty' + x).focus();
                        return;
                    }

                    if(concepto.precioU == null){
                        Notify.alert('Debe ingresar un precio unitario.', {status: 'danger'});
                        $('#precioU' + x).focus();
                        return;
                    }


                    vm.factura.cartaPorte.mercancias.push({
                        cantidad: concepto.qty,
                        peso: concepto.peso,
                        claveUnidad: concepto.unidad,
                        descripcion: concepto.nombre,
                        moneda: vm.factura.moneda,
                        valorMercancia: concepto.base,
                        bienesTransp: concepto.clave,
                        pedimento: '',
                        fraccionArancelaria: ''
                    });
                }

                if(vm.factura.cartaPorte.transpInternac === 'Si' && vm.factura.cartaPorte.paisOrigenDestino.length == 0){
                    Notify.alert('Debe seleccionar el país de origen o destino.', {status: 'danger'});
                    $('#paisOrigenDestino').focus();
                    return;
                }

                if(vm.factura.cartaPorte.viaEntradaSalida.length == 0){
                    Notify.alert('Debe seleccionar la via de entrada o salida.', {status: 'danger'});
                    $('#entradaSalidaMerc').focus();
                    return;
                }

                if(vm.factura.cartaPorte.pesoBrutoTotal === undefined || Number(vm.factura.cartaPorte.pesoBrutoTotal) <= 0){
                    Notify.alert('Debe ingresar el peso bruto total.', {status: 'danger'});
                    $('#pesoBrutoTotal').focus();
                    return;
                }

                if(vm.factura.cartaPorte.unidadPeso === undefined || vm.factura.cartaPorte.unidadPeso.length == 0){
                    Notify.alert('Debe seleccionar unidad de peso.', {status: 'danger'});
                    $('#unidadPesoBruto').focus();
                    $('#unidadPesoBruto').trigger('chosen:activate');
                    return;
                }

                if(vm.factura.cartaPorte.ubicaciones.length < 2){
                    Notify.alert('La carta porte debe tener al menos 2 ubicaciones, uno tipo Origen y uno tipo Destino.', {status: 'danger'});
                    $('#buttonUbicacion' + x).focus();
                    return;
                }

                if(vm.factura.cartaPorte.mercancias.length === 0){
                    Notify.alert('Debe agregar al menos una mercancía.', {status: 'danger'});
                    return
                }


                let hasOrigen = false;
                let hasDestino = false;
                for(let x = 0; x < vm.factura.cartaPorte.ubicaciones.length; x++){
                    if(vm.factura.cartaPorte.ubicaciones[x].tipoUbicacion == 'Origen')
                        hasOrigen = true;

                    if(vm.factura.cartaPorte.ubicaciones[x].tipoUbicacion == 'Destino')
                        hasDestino = true;

                    if(!rfcValido(vm.factura.cartaPorte.ubicaciones[x].rFCRemitenteDestinatario)){
                        Notify.alert('El RFC ingresado en las ubicaciones es incorrecto.', {status: 'danger'});
                        return
                    }
                }
                if(!hasOrigen){
                    Notify.alert('Debe agregar una ubicación tipo Origen.', {status: 'danger'});
                    return;
                }

                if(!hasOrigen){
                    Notify.alert('Debe agregar una ubicación tipo Destino.', {status: 'danger'});
                    return;
                }

                let hasOrigenOperador = false;
                for(let x = 0; x < vm.factura.cartaPorte.figurasTransporte.length; x++){

                    if(!rfcValido(vm.factura.cartaPorte.figurasTransporte[x].rFCFigura)){
                        Notify.alert('El RFC ingresado en la figura de transporte es incorrecto.', {status: 'danger'});
                        return
                    }

                    if(vm.factura.cartaPorte.figurasTransporte[x].tipoFigura == '01'){
                        hasOrigenOperador = true;
                        break;
                    }
                }
                if(!hasOrigenOperador){
                    Notify.alert('En Figuras de trasnporte debe existir al menos uno de tipo Operador.', {status: 'danger'});
                    $('#buttonFiguras' + x).focus();
                    return;
                }



                vm.loading = "whirl double-up";


                let urlFacturar = 'facturar';
                if(vm.factura.versionF == '4.0')
                    urlFacturar = 'facturar40';

                $http.post('/api/admin/facturacion/'+urlFacturar, {
                    user : $rootScope.user,
                    factura: vm.factura
                }).then(function(res) {
                    let response = res['data'];
                    if (response['success']) {

                        SweetAlert.swal('Éxito!', 'Se generó su factura de forma correcta con el No. ' + response.facturaResult, 'success');
                        $state.transitionTo('app.listadoFacturas');

                    }else{
                        if(response.errorCode == 10009){
                            vm.factura.id_cliente.nmbRecep = response.extraInfo;
                        }
                        SweetAlert.swal('Error', response.errortext , 'error');
                    }

                    vm.loading = "";

                }, function errorCallback(response) {
                    vm.loading = "";
                });



            };

            vm.toUpperCase = function(value){
                value = value.toUpperCase();
            }

            vm.facturarTest = function(){

                if(vm.factura.id_cliente == '' || vm.factura.id_cliente == null){
                    Notify.alert('Debe seleccionar un cliente.', {status: 'danger'});
                    $('#id_cliente').trigger('chosen:activate');
                    return;
                }

                if(vm.factura.formaPago == '' || vm.factura.formaPago == null){
                    Notify.alert('Debe seleccionar una forma de pago.', {status: 'danger'});
                    $('#formaPago').trigger('chosen:activate');
                    $('#formaPago').focus();
                    return;
                }


                if(vm.factura.lugarExpedicion == '' || vm.factura.lugarExpedicion == null || vm.factura.lugarExpedicion.length < 5 ){
                    Notify.alert('Debe ingresar un lugar de expedición correcto (C.P.)', {status: 'danger'});
                    $('#lugarExpedicion').focus();
                    return;
                }


                if(vm.factura.usoCFDI == '' || vm.factura.usoCFDI == null || vm.factura.usoCFDI == '0'){
                    Notify.alert('Debe seleccionar el uso del CFDI.', {status: 'danger'});
                    $('#usoCFDI').trigger('chosen:activate');
                    $('#usoCFDI').focus();
                    return;
                }

                if(vm.factura.detalles.length == 0){
                    Notify.alert('Debe agregar al menos un producto.', {status: 'danger'});
                    return;
                }

                for(var x = 0; x < vm.factura.detalles.length; x++){

                    var concepto = vm.factura.detalles[x];

                    if(concepto.clave == ''){
                        Notify.alert('Debe seleccionar una clave para cada concepto.', {status: 'danger'});
                        $('#clave' + x).focus();
                        $('#clave' + x).trigger('chosen:activate');
                        return;
                    }

                    if(concepto.nombre == ''){
                        Notify.alert('Debe agregar una descripción para cada concepto.', {status: 'danger'});
                        $('#nombre' + x).focus();
                        return;
                    }

                    if(concepto.unidad == null || concepto.unidad == ''){
                        Notify.alert('Debe seleccionar una unidad para cada concepto.', {status: 'danger'});
                        $('#unidad' + x).focus();
                        $('#unidad' + x).trigger('chosen:activate');
                        return;
                    }

                    if(concepto.qty == null || concepto.qty < 0.00001){
                        Notify.alert('La cantidad por concepto debe ser al mayor a 0.', {status: 'danger'});
                        $('#qty' + x).focus();
                        return;
                    }

                    if(concepto.precioU == null){
                        Notify.alert('Debe ingresar un precio unitario.', {status: 'danger'});
                        $('#precioU' + x).focus();
                        return;
                    }

                }

                vm.loading = "whirl double-up";


                $http.post('/api/admin/facturacion/facturarTest', {
                    user : $rootScope.user,
                    factura: vm.factura
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {

                        SweetAlert.swal('Éxito!', 'Se generó su factura de forma correcta con el No. ' + response.facturaResult, 'success');
                        $state.transitionTo('app.listadoFacturas');

                    }else{
                        SweetAlert.swal('Error!', response.errorCode + ' - ' + response.errortext + ' <br>' + response.nombreArchivo, 'error');
                    }

                    vm.loading = "";

                }, function errorCallback(response) {
                    vm.loading = "";
                });



            };

            vm.obtenerRegimenesFiscales = function (){
                vm.regimenesFiscalesList = [];
                for(let x = 0; x < vm.regimenesFiscales.length; x++){
                    if(vm.regimenesFiscales[x].tipo == vm.factura.id_cliente.tipoPersona || vm.regimenesFiscales[x].tipo == 3){
                        vm.regimenesFiscalesList.push(vm.regimenesFiscales[x]);
                    }
                }
            };

            vm.agregarMercancia = function(){
                vm.factura.cartaPorte.mercancias.push({
                    cantidad: '',
                    peso: '',
                    claveUnidad: '',
                    descripcion: '',
                    moneda: 'MXN',
                    valorMercancia: '',
                    bienesTransp: ''
                });
            }

            vm.eliminarMercancia = function(index){
                vm.factura.cartaPorte.mercancias.splice(index, 1);
            }


            vm.agregarUbicacion = function(){

                vm.factura.cartaPorte.ubicaciones.push({
                    tipoUbicacion: '',
                    rFCRemitenteDestinatario: '',
					nombreDestinatario: '',
                    numRegIdTrib: '',
                    fechaHoraSalidaLlegada: '',
                    calle: '',
                    numeroExterior: '',
                    numeroInterior: '',
                    colonia: '',
                    municipio: '',
                    estado: '',
                    pais: '',
                    codigoPostal: '',
                    totalDistRec: '',
                });
            }


            vm.eliminarUbicacion = function (index){
                vm.factura.cartaPorte.ubicaciones.splice(index, 1);
            }

            vm.agregarRemolque = function(){
                vm.factura.cartaPorte.autotransporte.remolques.push({
                    subTipoRem: '',
                    placa: ''
                });
            }

            vm.eliminarRemolque = function (index){
                vm.factura.cartaPorte.autotransporte.remolques.splice(index, 1);
            }

            vm.agregarFigura = function(){
                vm.factura.cartaPorte.figurasTransporte.push({
                    tipoFigura: '',
                    rFCFigura: '',
                    numLicencia: '',
                    nombreFigura: '',
                    numRegIdTribFigura: '',
                });
            }

            vm.eliminarFigura = function (index){
                vm.factura.cartaPorte.figurasTransporte.splice(index, 1);
            }



            vm.getEstados = function(index, listObjects){
                vm.loading = "whirl double-up";
                $http.post('/api/admin/facturacion/getEstados', {
                    user : $rootScope.user,
                    country: vm.factura.cartaPorte.ubicaciones[index].pais
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {
                        vm.loading = "";
                        listObjects[index].estados = response.estados;
                    }
                }, function errorCallback(response) {
                });
            };

            vm.getMunicipio = function(index){
                vm.loading = "whirl double-up";
                $http.post('/api/admin/facturacion/getMunicipio', {
                    user : $rootScope.user,
                    estado: vm.factura.cartaPorte.ubicaciones[index].estado
                }).then(function(res) {
                    var response = res['data'];
                    if (response['success']) {
                        vm.loading = "";
                        vm.factura.cartaPorte.ubicaciones[index].municipios = response.municipios;
                    }
                }, function errorCallback(response) {
                });
            };



            vm.obtenerDatos();

        }
    }
})();
