<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class Concepto extends Model {

	protected $table = 'Detalle';

	public $timestamps = false;

	protected $primaryKey = 'id_detalle';

	public function impuestos() {
		return $this->hasMany('App\Models\ExImpuestos', 'id_detalle', 'id_detalle');
	}

	public function clavec(){
		return $this->hasOne('App\Models\ClaveProdServ', 'codigo', 'clave');
	}

	public function unidadc(){
		return $this->hasOne('App\Models\UnidadMedida', 'codigo', 'unmdItem');
	}

    public function alumno(){
        return $this->hasOne('App\Models\AlumnoDetalle', 'id_detalle', 'id_detalle');
    }

}
