<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class Account extends Model {

	protected $table = 'Account';

	public $timestamps = false;

	protected $primaryKey = 'id';
	
	public function costCenter(){
		return $this->hasOne('App\Models\CostCenter', 'id', 'id_costCenter');
	}
	
	public function providersSimple(){
		return $this->belongsToMany('App\Models\Provider', 'AccountProvider', 'id_account', 'id_provider');
	}
	
	public function providers(){
		return $this->hasMany('App\Models\AccountProvider', 'id_account', 'id');
	}
}
?>