<?php

namespace App\Http\Controllers;

use App\Models\Cliente;
use App\Models\ContactoReceptor;
use App\Models\DomFiscalRcp;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Response;
use App\Commands\Utils;
use App\Models\AdicionalesCancelacion;
use App\Models\AsociadosProveedor;
use App\Models\CatalogoRegimenFiscal;
use App\Models\CertificadoProveedor;
use App\Models\ContactoEmisor;
use App\Models\Factura;
use App\Models\PaqueteAsignado;
use App\Models\Proveedor;
use Illuminate\Support\Facades\DB;
use App\Models\DomFiscal;
use App\Models\Multiusuario;
use App\Models\PaqueteAsignadoAsociado;
use SoapClient;

class ProveedorController extends BaseController {
	public function login(Request $request) {
		$user = $request->input ( 'user' );

		$provedorData = array (
				'rfc' => '',
				'id_proveedor' => 0,
				'accessStatus' => false
		);

		$proveedor = Proveedor::where ( 'rFCEmisor', '=', $user ['rfc'] )->where ( 'password', '=', $user ['password'] )->where ( 'status', '=', 1 )->first ();

		if (is_object ( $proveedor ) && $proveedor->id_proveedor > 0) {
			if ($proveedor->token == '') {
				$random = Utils::randomPass ();
				$proveedor->token = $random;
				$proveedor->save ();
			}

			$provedorData ['rfc'] = $proveedor->rFCEmisor;
			$provedorData ['token'] = $proveedor->token;
			$provedorData ['id_proveedor'] = $proveedor->id_proveedor;
			$provedorData ['accessStatus'] = true;
		}

		return Response::json ( array (
				'success' => true,
				'login' => $provedorData
		) );
	}

	public function home(Request $request) {

		$user = $request->input ( 'user' );
		$id_proveedorPrincipal = $user['id_proveedorPrincipal'];

		$fechaInicial = date ( 'Y-m-01 00:00:00' );
		$fechaFinal = date ( 'Y-m-t 23:59:59' );

		$noFacturasActivas = Factura::whereBetween ( 'timeStamp', [
				$fechaInicial,
				$fechaFinal
		] )->where ( 'status', '=', 1 )->where ( 'id_proveedor', '=', $user ['id_proveedor'] )->count ();
		$noFacturasCanceladas = Factura::whereBetween ( 'timeStamp', [
				$fechaInicial,
				$fechaFinal
		] )->where ( 'status', '=', 0 )->where ( 'id_proveedor', '=', $user ['id_proveedor'] )->count ();

		$sumaAnioFacturacion = DB::select ( "SELECT SUM(t.VlrPagar) as total, MONTH( f.timeStamp ) AS mes FROM Factura f JOIN Totales t ON f.id_factura = t.id_factura
				WHERE f.status = 1 AND f.timeStamp BETWEEN '" . date ( 'Y-01-01 00:00:00' ) . "' AND '$fechaFinal' AND f.id_proveedor = " . $user ['id_proveedor'] . "
				AND f.tipoDeComprobante = 'I' GROUP BY MONTH(f.timeStamp)" );

		$noElementos = count ( $sumaAnioFacturacion );
		$mesActualTotal = 0;

		if($noElementos > 0){
			$mesActual = $sumaAnioFacturacion [$noElementos - 1];
			$mesActualTotal = $mesActual->total;
		}

		$resultadosMesActual = array (
				'totalFacturado' => $mesActualTotal,
				'facturasActivas' => $noFacturasActivas,
				'facturasCanceladas' => $noFacturasCanceladas
		);



		$noFacturasContratadas = PaqueteAsignado::where('id_proveedor', '=', $id_proveedorPrincipal)->where('status', '=', 1)->where('tipo', '=', 1)->sum('noFolios');

		$proveedoresRelacionados = DB::select("SELECT p.id_proveedor, p.rFCEmisor FROM Proveedor p
				JOIN `Multiusuario` m ON p.id_proveedor = m.`id_proveedorRel` AND m.status = 1 WHERE m.id_proveedor = " . $id_proveedorPrincipal . " ORDER BY p.rFCEmisor");

		$idProveedores = [];
		$idProveedores[] = $id_proveedorPrincipal;
		if(count($proveedoresRelacionados) > 0){
		    foreach ($proveedoresRelacionados as $proveedoreRelacionado){
		        $idProveedores[] = $proveedoreRelacionado->id_proveedor;
		    }
		}

		$noFacturasUsadas = Factura::whereIn('id_proveedor', $idProveedores)->count();
		$facturasRestantes = ($noFacturasContratadas - $noFacturasUsadas);



		return Response::json ( array (
				'success' => true,
				'resultadosMesActual' => $resultadosMesActual,
				'sumaAnioFacturacion' => $sumaAnioFacturacion,
		    'foliosAsignados' => $noFacturasContratadas,
		    'noFacturasEmitidas' => $noFacturasUsadas,
				'noFacturasRestantes' => $facturasRestantes
		) );
	}
	public function misDatos(Request $request) {
		$user = $request->input ( 'user' );
		$id_proveedor = $user ['id_proveedor'];

		$proveedor = Proveedor::with ( 'contacto', 'paquetes', 'certificados', 'domicilio' )->find ( $id_proveedor );
		$catalogoRegimen = CatalogoRegimenFiscal::where ( 'tipo', '=', $proveedor->tipoPersona )->orWhere ( 'tipo', '=', 3 )->where ( 'status', '=', 1 )->get ();

		if(!is_object($proveedor->domicilio)){

			$domFiscal = DomFiscal();
			$domFiscal->id_proveedor = $id_proveedor;
			$domFiscal->save();


		}


		return Response::json ( array (
				'success' => true,
				'proveedor' => $proveedor->toArray (),
				'catalogoregimenfiscal' => $catalogoRegimen->toArray ()
		) );
	}
	public function guardarMisDatos(Request $request) {

		$user = $request->input ( 'user' );
		$proveedor = $request->input ( 'proveedor' );
		$isNuevo = false;
		$pass = '';

		if(isset($proveedor ['id_proveedor'])){
			$proveedorObj = Proveedor::with('domicilio')->find ( $proveedor ['id_proveedor'] );
		}else{
			$proveedorObj = new Proveedor();
			$proveedorObj->rFCEmisor = $proveedor['rFCEmisor'];
			$isNuevo = true;
		}


		$proveedorObj->nmbEmisor = $proveedor ['nmbEmisor'];
		$proveedorObj->tipoPersona = $proveedor ['tipoPersona'];
		$proveedorObj->regimenFiscal33 = $proveedor ['regimenFiscal33'];
		$proveedorObj->asociado = isset($proveedor['asociado']) ? $proveedor['asociado'] : 0;
		$proveedorObj->status = 1;

		if($isNuevo){
		    $pass = Utils::randomPass(6);
		    $proveedorObj->password = $pass;
		}

		if(isset($proveedor ['id_proveedor'])){
			$proveedorObj->domicilio->curp = $proveedor['domicilio']['curp'];
            $proveedorObj->domicilio->direccion = $proveedor['domicilio']['direccion'] ?? '';
			$proveedorObj->domicilio->codigoPostal = $proveedor['domicilio']['codigoPostal'];
			$proveedorObj->domicilio->save();
		}

		$proveedorObj->save ();

		if($isNuevo){
		    if(1 == 0){

		        $paquete = new PaqueteAsignado();
		        $paquete->id_proveedor = $proveedorObj->id_proveedor;
		        $paquete->id_proveedorCrea = $user['id_proveedorPrincipal'];
		        $paquete->noFolios = $proveedor['noFolios'];
		        $paquete->fechaVigencia = date ( "Y-m-d H:i:s", strtotime ( '+364days' ) );
		        $paquete->fechaCreacion = date('Y-m-d');
		        $paquete->tipo = 1;
		        $paquete->status = 1;
		        $paquete->save();

		        $paqueteAsociado = PaqueteAsignadoAsociado::find($user['id_proveedorPrincipal']);
		        $paqueteAsociado->foliosAsignados += $proveedor['noFolios'];
		        $paqueteAsociado->save();

		    }
		}

		if(!isset($proveedor ['id_proveedor'])){
			$domicilio = new DomFiscal();
			$domicilio->id_proveedor = $proveedorObj->id_proveedor;
			$domicilio->curp = $proveedor['domicilio']['curp'];
			$domicilio->codigoPostal = $proveedor['domicilio']['codigoPostal'];
			$domicilio->save();
		}

		$contacto = ContactoEmisor::find ( $proveedorObj->id_proveedor );
		if(!is_object($contacto)){
			$contacto = new ContactoEmisor();
			$contacto->id_proveedor = $proveedorObj->id_proveedor;
		}
		$contacto->email = $proveedor ['contacto'] ['email'];
		$contacto->telefono = isset($proveedor ['contacto'] ['telefono']) ? $proveedor ['contacto'] ['telefono'] : '';
		$contacto->save ();

		if(!isset($proveedor ['id_proveedor'])){
			$asociado = new AsociadosProveedor();
			$asociado->id_proveedorAsociado = $user ['id_proveedor'];
			$asociado->id_proveedor = $proveedorObj->id_proveedor;
			$asociado->fechaAlta = date('Y-m-d H:i:s');
			$asociado->status = 1;
			$asociado->save();
		}

		$multiusuario = Multiusuario::where('id_proveedor', '=', $user['id_proveedorPrincipal'])->
		where('id_proveedorRel', '=', $proveedorObj->id_proveedor)->first();

		if(!is_object($multiusuario) && isset($proveedor['compartirCon']) && $proveedor['compartirCon'] > 0){
			$multiusuario = new Multiusuario();
			$multiusuario->id_proveedor = $user['id_proveedorPrincipal'];
			$multiusuario->id_proveedorRel = $proveedorObj->id_proveedor;
			$multiusuario->status = 1;
			$multiusuario->fechaAlta = date('Y-m-d');
			$multiusuario->save();

			$proveedorObj->status = 1;
			$proveedorObj->save();

		}else if(is_object($multiusuario)){
			$multiusuario->status = 1;
			$multiusuario->save();
		}

        Utils::registrarUsuario($proveedorObj->rFCEmisor);

		return Response::json ( array (
			'success' => true,
			'id_proveedor' => $proveedorObj->id_proveedor,
		    'pass' => $pass,
		    'isNuevo' => $isNuevo

		));
	}
	public function obtenerRegimenesFiscales(Request $request) {
		$tipo = $request->input ( 'tipo' );

		$catalogoRegimen = CatalogoRegimenFiscal::where ( 'tipo', '=', $tipo )->orWhere ( 'tipo', '=', 3 )->where ( 'status', '=', 1 )->get ();

		return Response::json ( array (
				'success' => true,
				'catalogoregimenfiscal' => $catalogoRegimen->toArray ()
		) );
	}
	public function actualizarCertificado(Request $request) {

		$id_proveedor = $request->input ( 'id_proveedor' );
		$token = $request->input ( 'token' );

		$proveedor = Proveedor::where ( 'token', "=", $token )->where ( 'id_proveedor', "=", $id_proveedor )->first ();

		if (! is_object ( $proveedor ) || empty ( $token )) {
			return Response::json ( array (
					'success' => false,
					'errorText' => 'Token incorrecto'
			) );
		}

		$id_proveedorAsoc = $request->input('id_proveedorAsoc');

		if($id_proveedorAsoc != null && $id_proveedorAsoc > 0){
			$proveedor = Proveedor::where ( 'id_proveedor', "=", $id_proveedorAsoc )->first ();
		}

		$password = $request->input ( 'password' );

		$cerFile = $request->file( 'cerFile' );
		$keyFile = $request->file ( 'keyFile' );

		$nameFile = $proveedor->rFCEmisor . '-' . date ( "YmdHis" );
		$cerFileName = $nameFile . '.cer';
		$keyFileName = $nameFile . '.key';

		$up1Success = $cerFile->move ( env('DIR_CERTS') .'/', $cerFileName );
		$up2Success = $keyFile->move ( env('DIR_CERTS') .'/', $keyFileName );

		$outputNoCerFile = '';

		\exec ( "openssl x509 -inform DER -in ".env('DIR_CERTS')."/$cerFileName -serial", $outputNoCerFile );

        \exec ( "openssl x509 -inform DER -outform PEM -in ".env('DIR_CERTS')."/" . $cerFileName . " -pubkey -out ".env('DIR_CERTS')."/$cerFileName.pem", $output );

        \exec ( "openssl pkcs8 -inform DER -in ".env('DIR_CERTS')."/$keyFileName -passin pass:$password -out ".env('DIR_CERTS')."/$keyFileName.pem", $output );

		$response = array (
				'success' => true,
				'errorCode' => 1001,
				'message' => 'Error al cargar el certificado'
		);

		$fileExist = file_exists ( env('DIR_CERTS')."/$keyFileName.pem" );

		if ($fileExist) {

			$keyFileSize = filesize ( env('DIR_CERTS')."/$keyFileName.pem" );

			if ($keyFileSize > 10) {

				$isValidSTDin = Utils::validateCerVsKeyFile ( $cerFileName, $keyFileName );

				if ($isValidSTDin) {

						// Obtener no. de certificado
						$noCertificado = str_replace ( "serial=", "", $outputNoCerFile [0] );
						$size = strlen ( $noCertificado );
						$position = 0;
						for($x = 1; $x <= ($size / 2); $x ++) {
							$noCertificado = substr_replace ( $noCertificado, "", $position, 1 );
							$position ++;
						}

						// Obtener certificado PEM
						$certificadoPemString = env('DIR_CERTS').'/' . $cerFileName . ".pem";
						$certificadoPemFile = fopen ( $certificadoPemString, "r" );
						$certificadoPem = fread ( $certificadoPemFile, filesize ( $certificadoPemString ) );
						fclose ( $certificadoPemFile );

						$certificadoPem = str_replace ( "-----BEGIN CERTIFICATE-----", "", $certificadoPem );
						$certificadoPem = str_replace ( "-----END CERTIFICATE-----", "", $certificadoPem );
						$certificadoPem = trim ( $certificadoPem );
						$certificadoPem = str_replace ( chr ( 10 ), "", $certificadoPem );
						$certificadoPem = str_replace ( chr ( 13 ), "", $certificadoPem );

						DB::table ( 'AdicionalesCancelacion' )->where ( 'id_proveedor', $id_proveedor )->update ( [
								'status' => 0
						] );

						DB::table ( 'CertificadosProveedor' )->where ( 'id_proveedor', $id_proveedor )->update ( [
								'status' => 0
						] );

						$proveedor->noCertificado = $noCertificado;
						$proveedor->certificado = $certificadoPem;
						$proveedor->keypem = "$keyFileName.pem";
						$proveedor->save ();

						$adicionalesCancelacion = AdicionalesCancelacion::where ( 'id_proveedor', '=', $id_proveedor )->first ();

						if(!is_object(!$adicionalesCancelacion)){
						    $adicionalesCancelacion = new AdicionalesCancelacion();
						    $adicionalesCancelacion->id_proveedor = $id_proveedor;
						}

						$adicionalesCancelacion->cerPem = "$cerFileName.pem";
						$adicionalesCancelacion->keyPem = "$keyFileName.pem";
						$adicionalesCancelacion->cerFile = $cerFileName;
						$adicionalesCancelacion->keyFile = $keyFileName;
						$adicionalesCancelacion->password = $password;
						$adicionalesCancelacion->status = 1;
						$adicionalesCancelacion->save ();

						$nuevoCertificado = new CertificadoProveedor ();
						$nuevoCertificado->id_adicionalesCancelacion = $adicionalesCancelacion->id_adicionalesCancelacion;
						$nuevoCertificado->certificado = $certificadoPem;
						$nuevoCertificado->noCertificado = $noCertificado;
						$nuevoCertificado->id_proveedor = $id_proveedor;
						$nuevoCertificado->fechaAlta = date ( "Y-m-d H:i:s" );
						$nuevoCertificado->status = 1;
						$nuevoCertificado->save ();

						$response ['errorCode'] = 0;
						$response ['message'] = 'La actualizacion del certificado se realizó de forma correcta.';
						$response ['cerFile'] = $cerFileName;
						$response ['keyFile'] = $keyFileName;

				} else {
					$response ['errorCode'] = 1003;
					$response ['message'] = 'El archivo .cer y .key no coinciden.';
				}
			} else {
				$response ['errorCode'] = 1004;
				$response ['message'] = 'La contraseña ingresada no es correcta.';
				$response ['keyFile'] = $keyFileName;
				$response ['cerFile'] = $cerFileName;
			}
		} else {
			$response ['errorCode'] = 1004;
			$response ['message'] = 'La contraseña ingresada no es correcta2.';
			$response ['keyFile'] = $keyFileName;
			$response ['cerFile'] = $cerFileName;
		}

		return Response::json ( $response );
	}


	public function getDataMultiusuario(Request $request) {

		$id_proveedor = $request->input ( 'id_proveedor' );

		$provedorData = array (
				'rfc' => '',
				'id_proveedor' => 0,
				'accessStatus' => false
		);

		$proveedor = Proveedor::find($id_proveedor);

		if ($proveedor->token == '') {
			$random = Utils::randomPass ();
			$proveedor->token = $random;
			$proveedor->save ();
		}

		$provedorData ['rfc'] = $proveedor->rFCEmisor;
		$provedorData ['token'] = $proveedor->token;
		$provedorData ['id_proveedor'] = $proveedor->id_proveedor;
		$provedorData ['accessStatus'] = true;

		return Response::json ( array (
				'success' => true,
				'login' => $provedorData
		) );
	}

    public function copiarClientes() {

        $id_proveedor = 871;
        $id_proveedorNuevo = 1373;

        $clientesObj = Cliente::with('contacto', 'domicilio')->where('id_proveedor', '=', $id_proveedor)
            ->where('status', 1)->get();

        foreach ($clientesObj as $clienteObj){

            $clienteObjTmp = Cliente::where('rFCRecep', '=', $clienteObj->rFCRecep)->where('id_proveedor', '=', $id_proveedorNuevo)->where('status', '=', 1)->first();
            if(!(is_object($clienteObjTmp) && $clienteObjTmp->id_cliente > 0)) {


                $clienteObjTmp = new Cliente();
                $clienteObjTmp->id_proveedor = $id_proveedorNuevo;
                $clienteObjTmp->rFCRecep = $clienteObj->rFCRecep;
                $clienteObjTmp->nmbRecep = $clienteObj->nmbRecep;
                $clienteObjTmp->metodoPago = $clienteObj->metodoPago;
                $clienteObjTmp->cuenta = $clienteObj->cuenta;
                $clienteObjTmp->usoCFDI = $clienteObj->usoCFDI;
                $clienteObjTmp->tipoPersona = $clienteObj->tipoPersona;
                $clienteObjTmp->regimenFiscalReceptor = $clienteObj->regimenFiscalReceptor;
                $clienteObjTmp->direccion = $clienteObj->direccion;
                $clienteObjTmp->status = 1;
                $clienteObjTmp->save();

                $contactoTmp = new ContactoReceptor();
                $contactoTmp->id_cliente = $clienteObjTmp->id_cliente;
                $contactoTmp->tipo = $clienteObj->contacto->tipo;
                $contactoTmp->nombre = $clienteObj->contacto->nombre;
                $contactoTmp->telefono = $clienteObj->contacto->telefono;
                $contactoTmp->save();

                $domicilioTmp = new DomFiscalRcp();
                $domicilioTmp->id_cliente = $clienteObjTmp->id_cliente;
                if($clienteObj->domicilio != null) {
                    $domicilioTmp->calle = $clienteObj->domicilio->calle;
                    $domicilioTmp->nroExterior = $clienteObj->domicilio->nroExterior;
                    $domicilioTmp->nroInterior = $clienteObj->domicilio->nroInterior;
                    $domicilioTmp->colonia = $clienteObj->domicilio->colonia;
                    $domicilioTmp->municipio = $clienteObj->domicilio->municipio;
                    $domicilioTmp->localidad = $clienteObj->domicilio->localidad;
                    $domicilioTmp->estado = $clienteObj->domicilio->estado;
                    $domicilioTmp->pais = $clienteObj->domicilio->pais;
                    $domicilioTmp->referencia = $clienteObj->domicilio->referencia;
                    $domicilioTmp->codigoPostal = $clienteObj->domicilio->codigoPostal;
                }
                $domicilioTmp->save();

            }
        }
    }
}

