<?php

namespace App\Http\Controllers;

use App\Commands\Utils;
use App\Commands\XMLUtils;
use App\Models\Arrendamiento;
use App\Models\CatalogoRegimenContratacion;
use App\Models\CatalogoRiesgoPuesto;
use App\Models\CertificadoProveedor;
use App\Models\AdicionalNomina;
use App\Models\Concepto;
use App\Models\DoctoRelacionado;
use App\Models\Empleado;
use App\Models\EmpleadoFac;
use App\Models\ExImpuestos;
use App\Models\Factura;
use App\Models\FacturasRelacionadas;
use App\Models\FormaPago;
use App\Models\IdDoc;
use App\Models\Pago;
use App\Models\Pais;
use App\Models\PeriodoNomina;
use App\Models\Producto;
use App\Models\Proveedor;
use App\Models\Serie;
use App\Models\Totales;
use App\Models\UsoCFDI;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Response;
use SoapClient;
use App\Models\ComercioE;
use App\Models\DomFiscalFact;
use App\Models\DomFiscalRcpFact;
use SWServices\Stamp\StampService;

class FacturacionSWController extends BaseController {

	public function facturar(Request $request) {
		ini_set ( 'default_socket_timeout', 300 );
		ini_set ( 'max_execution_time', 300 );
		set_time_limit ( 300 );

		$factura = $request->input ( 'factura' );
		$user = $request->input ( 'user' );
		$proveedor = Proveedor::with('domicilio')->find ( $user ['id_proveedor'] );
		$nombreArchivo = '';

		$rfcHoraAntes = array (
				592,
				589
		);
		$textLess = '-2 minutes';
		if (in_array ( $user ['id_proveedor'], $rfcHoraAntes ))
			$textLess = '-70 hours';

		$timeStamp = date ( "Y-m-d H:i:s", strtotime ( $textLess ) );
		$noFactura = DB::select ( "SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $user ['id_proveedor'] . " AND i.serie = '" . $factura ['serie'] . "'" ) [0];
		$noFactura->noFactura ++;
		$certificadoHaUsar = CertificadoProveedor::where ( 'id_proveedor', '=', $user ['id_proveedor'] )->where ( 'status', '=', 1 )->first ();

		$datosFactura = new \stdClass ();
		$datosFactura->timeStamp = $timeStamp;
		$datosFactura->tipoDeComprobante = $factura ['tipoDocumento'];
		$datosFactura->serie = $factura ['serie'];
		$datosFactura->folio = $noFactura->noFactura;
		$datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
		$datosFactura->certificado = $certificadoHaUsar->certificado;
		$datosFactura->mntBase = $factura ['base'];
		$datosFactura->subtotal = $factura ['subtotal'];
		$datosFactura->moneda = $factura ['moneda'];
		$datosFactura->total = $factura ['total'];
		$datosFactura->formaPago = $factura ['formaPago'];
		$datosFactura->descuento = $factura ['descuento'];
		$datosFactura->precission = $factura ['decimales'];
		$datosFactura->tipoCambio = $factura ['tipoCambio'];
		$datosFactura->lugarExpedicion = Utils::deleteExtraSpaces ( $factura ['lugarExpedicion'] );
		$datosFactura->usoCFDI = $factura ['usoCFDI'];
		$datosFactura->metodoDePago = $factura ['metodoDePago'];
		$datosFactura->condicionesDePago = (isset ( $factura ['condicionesPago'] )) ? Utils::deleteExtraSpaces ( $factura ['condicionesPago'] ) : '';
		$datosFactura->cuentaPredial = (isset ( $factura ['cuentaPredial'] )) ? Utils::deleteExtraSpaces ( $factura ['cuentaPredial'] ) : '';
		$datosFactura->tipoFacturasRelacionadas = $factura ['facturasRelacionadas'] ['tipoRelacion'];
		$datosFactura->rFCEmisor = $proveedor->rFCEmisor;
		$datosFactura->nmbEmisor = $proveedor->nmbEmisor;
		$datosFactura->rFCRecep = $factura ['id_cliente'] ['rFCRecep'];
		$datosFactura->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
		$datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
		$datosFactura->numRegIdTrib = isset ( $factura ['numRegIdTrib'] ) ? $factura ['numRegIdTrib'] : '';
		$datosFactura->pais = isset ( $factura ['pais'] ) ? $factura ['pais'] : '';
		$datosFactura->tipoPersona = $proveedor->tipoPersona;

		$datosFactura->conceptos = [ ];
		$datosFactura->impuestosTrasladados = [ ];
		$datosFactura->impuestosRetenidos = [ ];
		$datosFactura->impuestosTrasladadosLcl = [ ];
		$datosFactura->impuestosTrasladadosLclTotal = 0;
		$datosFactura->impuestosRetenidosLcl = [ ];
		$datosFactura->impuestosRetenidosLclTotal = 0;
		$totalImpRetenidos = 0;
		$totalImpTrasladados = 0;

		foreach ( $factura ['detalles'] as $detalle ) {

			$concepto = new \stdClass ();
			$concepto->clave = $detalle ['clave'];
			$concepto->id_producto = isset ( $detalle ['id_producto'] ) ? $detalle ['id_producto'] : 0;
			$concepto->cdgItem = Utils::deleteExtraSpaces ( $detalle ['codigo'] );
			$concepto->dscItem = Utils::deleteExtraSpaces ( $detalle ['nombre'] );
			$concepto->unmdItem = (isset ( $detalle ['unidad'] )) ? $detalle ['unidad'] : '';
			$concepto->fracArancelaria = (isset ( $detalle ['fracArancelaria'] )) ? $detalle ['fracArancelaria'] : '';
			$concepto->qtyItem = $detalle ['qty'];
			$concepto->montoNetoItem = $detalle ['precioU'];
			$concepto->prcNetoItem = $detalle ['qty'] * $detalle ['precioU'];
			$concepto->descuento = $detalle ['descuento'];

			$concepto->impuestosTrasladados = [ ];

			$base = Utils::formatNumber ( (($detalle ['qty'] * $detalle ['precioU']) - $detalle ['descuento']), $factura ['decimales'] );
			foreach ( $factura ['impuestosTrasladados'] as $traslado ) {

				if ($traslado ['impuesto'] == 'XXX') {

					$impuestoLcl = new \stdClass ();
					$impuestoLcl->tipoImp = $traslado ['label'];
					$impuestoLcl->tasaImp = $traslado ['valor'];
					$impuestoLcl->tipo = 1;

					$importeImp = 0;
					if ($traslado ['factor'] == 'Tasa') {
						$importeImp = $traslado ['valor'] * $base;
					} else if ($traslado ['factor'] == 'Cuota') {
						$importeImp = $traslado ['valor'];
					}

					$importeImp = Utils::formatNumber ( $importeImp, $factura ['decimales'] );

					$impuestoLcl->montoImp = $importeImp;

					$datosFactura->impuestosTrasladadosLclTotal += $importeImp;
					$datosFactura->impuestosTrasladadosLcl [] = $impuestoLcl;
				} else {

					$impuesto = new \stdClass ();
					$impuesto->base = $base;
					$impuesto->factor = $traslado ['factor'];
					$impuesto->tipoImp = $traslado ['impuesto'];
					$impuesto->tasaImp = $traslado ['valor'];
					$impuesto->tipo = 1;

					$importeImp = 0;
					if ($traslado ['factor'] == 'Tasa') {
						$importeImp = $traslado ['valor'] * $impuesto->base;
					} else if ($traslado ['factor'] == 'Cuota') {
						$importeImp = $traslado ['valor'];
					}

					$importeImp = Utils::formatNumber ( $importeImp, $factura ['decimales'] );

					$impuesto->montoImp = $importeImp;

					$totalImpTrasladados += $importeImp;

					$concepto->impuestosTrasladados [] = $impuesto;

					$isNuevo = true;
					if (count ( $datosFactura->impuestosTrasladados ))
						foreach ( $datosFactura->impuestosTrasladados as $impuestoGeneral ) {

							if ($impuesto->tipoImp == $impuestoGeneral->impuesto && $impuesto->factor == $impuestoGeneral->tipoFactor && $impuesto->tasaImp == $impuestoGeneral->tasaOCuota) {
								$isNuevo = false;
								$impuestoGeneral->importe += $impuesto->montoImp;
								break;
							}
						}

					if ($isNuevo && $traslado ['factor'] != 'Exento') {
						$impuestoGeneral = new \stdClass ();
						$impuestoGeneral->importe = $impuesto->montoImp;
						$impuestoGeneral->impuesto = $impuesto->tipoImp;
						$impuestoGeneral->tipoFactor = $traslado ['factor'];
						$impuestoGeneral->tasaOCuota = $traslado ['valor'];
						$datosFactura->impuestosTrasladados [] = $impuestoGeneral;
					}
				}
			}

			$concepto->impuestosRetenidos = [ ];

			foreach ( $factura ['impuestosRetenidos'] as $retencion ) {

				if ($retencion ['impuesto'] == 'XXX') {

					$impuestoLcl = new \stdClass ();
					$impuestoLcl->tipoImp = $retencion ['label'];

					if ($retencion ['factor'] == 'Cuota') {
						$impuestoLcl->tasaImp = 0.00;
					}else{
						$impuestoLcl->tasaImp = $retencion ['valor'];
					}

					$impuestoLcl->tipo = 0;

					$importeImp = 0;
					if ($retencion ['factor'] == 'Tasa') {
						$importeImp = $retencion ['valor'] * $base;
					} else if ($retencion ['factor'] == 'Cuota') {
						$importeImp = $retencion ['total'];
					}

					$importeImp = Utils::formatNumber ( $importeImp, $factura ['decimales'] );

					$impuestoLcl->montoImp = $importeImp;

					$datosFactura->impuestosRetenidosLclTotal += $importeImp;
					$datosFactura->impuestosRetenidosLcl [] = $impuestoLcl;
				} else {

					$impuesto = new \stdClass ();
					$impuesto->base = $base;
					$impuesto->factor = $retencion ['factor'];
					$impuesto->tipoImp = $retencion ['impuesto'];
					$impuesto->tasaImp = $retencion ['valor'];
					$impuesto->tipo = 0;

					$importeImp = 0;
					if ($retencion ['factor'] == 'Tasa') {
						$importeImp = $retencion ['valor'] * $impuesto->base;
					} else if ($retencion ['factor'] == 'Cuota') {
						$importeImp = $retencion ['valor'];
					}

					$importeImp = Utils::formatNumber ( $importeImp, $factura ['decimales'] );

					$impuesto->montoImp = $importeImp;

					$totalImpRetenidos += $importeImp;

					$concepto->impuestosRetenidos [] = $impuesto;

					$isNuevo = true;
					if (count ( $datosFactura->impuestosRetenidos ))
						foreach ( $datosFactura->impuestosRetenidos as $impuestoGeneral ) {
							if ($impuesto->tipoImp == $impuestoGeneral->impuesto) {
								$isNuevo = false;
								$impuestoGeneral->importe += $impuesto->montoImp;
								break;
							}
						}

					if ($isNuevo && $retencion ['factor'] != 'Exento') {
						$impuestoGeneral = new \stdClass ();
						$impuestoGeneral->importe = $impuesto->montoImp;
						$impuestoGeneral->impuesto = $impuesto->tipoImp;
						$datosFactura->impuestosRetenidos [] = $impuestoGeneral;
					}
				}
			}

			$datosFactura->conceptos [] = $concepto;
		}

		$datosFactura->totalImpRetenidos = $totalImpRetenidos;
		$datosFactura->totalImpTrasladados = $totalImpTrasladados;

		$datosFactura->facturasRelacionadas = [ ];

		if (count ( $factura ['facturasRelacionadas'] ['uuids'] ))
			foreach ( $factura ['facturasRelacionadas'] ['uuids'] as $facturaRelacionada ) {

				$relacionObj = new \stdClass ();
				$relacionObj->uuid = $facturaRelacionada ['uUID'];
				$datosFactura->facturasRelacionadas [] = $relacionObj;
			}



		$datosFactura->comercio = null;

		if(isset($factura['isComercio']) && $factura['isComercio'] == 1){

			$datosFactura->comercio = new \stdClass();

			$comercio = $factura['comercio'];

			$comercioEObj = new \stdClass();
			$comercioEObj->Incoterm = $comercio['incoterm'];
			$comercioEObj->clavePedimento = $comercio['pedimento'];
			$comercioEObj->tipoOperacion = $comercio['tipoOperacion'];
			$comercioEObj->rfcExtranjero = $comercio['rfcExtranjero'];
			if(is_object($proveedor->domicilio)){
				$comercioEObj->curp = $proveedor->domicilio->curp;
			}else{
				$comercioEObj->curp = '';
			}

			$emisor = $comercio['emisor'];

			$domicilioEmisor = new \stdClass();
			$domicilioEmisor->calle = $emisor['calle'];
			$domicilioEmisor->nroExterior = isset($emisor['nroExterior'])?$emisor['nroExterior']:'';
			$domicilioEmisor->nroInterior = isset($emisor['nroInterior'])?$emisor['nroInterior']:'';
			$domicilioEmisor->colonia = isset($emisor['colonia'])?$emisor['colonia']:'';
			$domicilioEmisor->municipio = isset($emisor['municipio'])?$emisor['municipio'] : '';
			$domicilioEmisor->estado = $emisor['estado'];
			$domicilioEmisor->pais = $emisor['pais'];
			$domicilioEmisor->codigoPostal = $emisor['codigoPostal'];

			$receptor = $comercio['receptor'];

			$domicilioReceptor = new \stdClass();
			$domicilioReceptor->calle = $receptor['calle'];
			$domicilioReceptor->nroExterior = isset($receptor['nroExterior'])? $receptor['nroExterior'] : '';
			$domicilioReceptor->nroInterior = isset($receptor['nroInterior'])? $receptor['nroInterior'] : '';
			$domicilioReceptor->colonia = isset($receptor['colonia'])? $receptor['colonia'] : '';
			$domicilioReceptor->municipio = isset($receptor['municipio'])? trim($receptor['municipio']) : '';
			$domicilioReceptor->estado = $receptor['estado'];
			$domicilioReceptor->pais = $receptor['pais'];
			$domicilioReceptor->codigoPostal = $receptor['codigoPostal'];


			$datosFactura->comercio->datos = $comercioEObj;
			$datosFactura->comercio->emisor = $domicilioEmisor;
			$datosFactura->comercio->receptor = $domicilioReceptor;

		}

		$xml = XMLUtils::createXML33 ( $datosFactura, $proveedor );

		$sello = $xml->query ( '//cfdi:Comprobante' ) [0]->getAttribute ( 'Sello' );

		$nombreArchivo = "$proveedor->rFCEmisor-" . date ( 'YmdHis' );

		file_put_contents ( "tmp/$nombreArchivo.xml", $xml );

		if ($proveedor->id_proveedor == 943) {
			$params = array(
				"url"=>"http://services.test.sw.com.mx",
				"token"=>"T2lYQ0t4L0RHVkR4dHZ5Nkk1VHNEakZ3Y0J4Nk9GODZuRyt4cE1wVm5tbXB3YVZxTHdOdHAwVXY2NTdJb1hkREtXTzE3dk9pMmdMdkFDR2xFWFVPUXpTUm9mTG1ySXdZbFNja3FRa0RlYURqbzdzdlI2UUx1WGJiKzViUWY2dnZGbFloUDJ6RjhFTGF4M1BySnJ4cHF0YjUvbmRyWWpjTkVLN3ppd3RxL0dJPQ.T2lYQ0t4L0RHVkR4dHZ5Nkk1VHNEakZ3Y0J4Nk9GODZuRyt4cE1wVm5tbFlVcU92YUJTZWlHU3pER1kySnlXRTF4alNUS0ZWcUlVS0NhelhqaXdnWTRncklVSWVvZlFZMWNyUjVxYUFxMWFxcStUL1IzdGpHRTJqdS9Zakw2UGRiMTFPRlV3a2kyOWI5WUZHWk85ODJtU0M2UlJEUkFTVXhYTDNKZVdhOXIySE1tUVlFdm1jN3kvRStBQlpLRi9NeWJrd0R3clhpYWJrVUMwV0Mwd3FhUXdpUFF5NW5PN3J5cklMb0FETHlxVFRtRW16UW5ZVjAwUjdCa2g0Yk1iTExCeXJkVDRhMGMxOUZ1YWlIUWRRVC8yalFTNUczZXdvWlF0cSt2UW0waFZKY2gyaW5jeElydXN3clNPUDNvU1J2dm9weHBTSlZYNU9aaGsvalpQMUxrSkhlVUY2aXpLNWZkaHZlcDFtMWFhWkJpdGFxSFpRMXZSWUp5QUZsalZWd2huVWx3NUM3dVF6aWxJaGJqUU9QbFdWZW0zMTQxTmd6dUJ3dHR0SDlvTjhLUzFoT3VsMnRXWFlTWGFOUDNaeEhmUklFOWVEZjB6OE9QVGhzWnZ1bjRzWkUyeWd3UXlFMUtENVRXQ1pxRjg9.6Us1aA5VkXQTHyEBeaq-98l_5NTADHRAayJXQPT9qIA"
			);
		}

		$params = array(
				"url"=>"http://services.test.sw.com.mx",
				"token"=>"T2lYQ0t4L0RHVkR4dHZ5Nkk1VHNEakZ3Y0J4Nk9GODZuRyt4cE1wVm5tbXB3YVZxTHdOdHAwVXY2NTdJb1hkREtXTzE3dk9pMmdMdkFDR2xFWFVPUXpTUm9mTG1ySXdZbFNja3FRa0RlYURqbzdzdlI2UUx1WGJiKzViUWY2dnZGbFloUDJ6RjhFTGF4M1BySnJ4cHF0YjUvbmRyWWpjTkVLN3ppd3RxL0dJPQ.T2lYQ0t4L0RHVkR4dHZ5Nkk1VHNEakZ3Y0J4Nk9GODZuRyt4cE1wVm5tbFlVcU92YUJTZWlHU3pER1kySnlXRTF4alNUS0ZWcUlVS0NhelhqaXdnWTRncklVSWVvZlFZMWNyUjVxYUFxMWFxcStUL1IzdGpHRTJqdS9Zakw2UGRiMTFPRlV3a2kyOWI5WUZHWk85ODJtU0M2UlJEUkFTVXhYTDNKZVdhOXIySE1tUVlFdm1jN3kvRStBQlpLRi9NeWJrd0R3clhpYWJrVUMwV0Mwd3FhUXdpUFF5NW5PN3J5cklMb0FETHlxVFRtRW16UW5ZVjAwUjdCa2g0Yk1iTExCeXJkVDRhMGMxOUZ1YWlIUWRRVC8yalFTNUczZXdvWlF0cSt2UW0waFZKY2gyaW5jeElydXN3clNPUDNvU1J2dm9weHBTSlZYNU9aaGsvalpQMUxrSkhlVUY2aXpLNWZkaHZlcDFtMWFhWkJpdGFxSFpRMXZSWUp5QUZsalZWd2huVWx3NUM3dVF6aWxJaGJqUU9QbFdWZW0zMTQxTmd6dUJ3dHR0SDlvTjhLUzFoT3VsMnRXWFlTWGFOUDNaeEhmUklFOWVEZjB6OE9QVGhzWnZ1bjRzWkUyeWd3UXlFMUtENVRXQ1pxRjg9.6Us1aA5VkXQTHyEBeaq-98l_5NTADHRAayJXQPT9qIA"
		);

		$stamp = StampService::Set($params);
		$resultado = $stamp::StampV3($xml);

		$logToSave = print_r ( $resultado, true );

		$log = env ( 'DIR_LOGS' ) . "/" . date ( "Y-m-d" ) . ".log";
		$fp = fopen ( $log, "a" );
		fwrite ( $fp, "\n\n===" . date ( "Y-m-d:H:i:s" ) . "\n\n" );
		fwrite ( $fp, "\n\n$nombreArchivo\n\n" );
		fwrite ( $fp, $logToSave );
		fwrite ( $fp, "\n\n===" );
		fclose ( $fp );

		$success = false;
		$errorCode = 0;
		$errortext = '';
		$facturaResult = '';

		if (is_object ( $resultado ) && isset ( $resultado->data ) && isset ( $resultado->data->cfdi )) {
			$success = true;

			$xmlTimbrado = new \DOMDocument ( "1.0", "uft-8" );
			$xmlTimbrado->loadXML ( $resultado->data->cfdi );

			$idDoc = new IdDoc ();

			$timbreFiscal = $xmlTimbrado->getElementsByTagName ( 'TimbreFiscalDigital' );

			foreach ( $timbreFiscal as $timbreFiscal ) {

				$fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$fechaTimbradoArray = explode ( ".", $fechaTimbrado );

				$idDoc->version = $timbreFiscal->getAttribute ( 'Version' );
				$idDoc->fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$idDoc->selloCFD = $timbreFiscal->getAttribute ( 'SelloCFD' );
				$idDoc->noCertificadoSAT = $timbreFiscal->getAttribute ( 'NoCertificadoSAT' );
				$idDoc->selloSAT = $timbreFiscal->getAttribute ( 'SelloSAT' );
				$idDoc->uUID = $timbreFiscal->getAttribute ( 'UUID' );
				$idDoc->sello = $sello;
				$idDoc->rfcProvCertif = $timbreFiscal->getAttribute ( 'RfcProvCertif' );
			}

			$isPagado = 0;
			if ($factura ['metodoDePago'] == 'PUE')
				$isPagado = 1;

			$facturaObj = new Factura ();
			$facturaObj->id_proveedor = $user ['id_proveedor'];
			$facturaObj->id_cliente = $factura ['id_cliente'] ['id_cliente'];
			$facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
			$facturaObj->nmbEmisor = $proveedor->nmbEmisor;
			$facturaObj->rFCEmisor = $proveedor->rFCEmisor;
			$facturaObj->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
			$facturaObj->rFCRecep = $factura ['id_cliente'] ['rFCRecep'];
			$facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
			$facturaObj->timeStamp = $timeStamp;
			$facturaObj->noFactura = $noFactura->noFactura;
			$facturaObj->version = "3.3";
			$facturaObj->generadoPor = 4;
			$facturaObj->nota = (isset ( $factura ['comentario'] )) ? Utils::deleteExtraSpaces ( $factura ['comentario'] ) : '';
			$facturaObj->tipoDeComprobante = $factura ['tipoDocumento'];
			$facturaObj->precission = $factura ['decimales'];
			$facturaObj->status = 1;
			$facturaObj->isPagado = $isPagado;
			$facturaObj->numRegIdTrib = $datosFactura->numRegIdTrib;
			$facturaObj->pais = $datosFactura->pais;
			$facturaObj->save ();

			$idDoc->id_factura = $facturaObj->id_factura;
			$idDoc->serie = $factura ['serie'];
			$idDoc->folio = $noFactura->noFactura;
			$idDoc->formaPago = $factura ['formaPago'];
			$idDoc->condicionesDePago = (isset ( $factura ['condicionesPago'] )) ? Utils::deleteExtraSpaces ( $factura ['condicionesPago'] ) : '';
			$idDoc->lugarExpedicion = Utils::deleteExtraSpaces ( $factura ['lugarExpedicion'] );
			$idDoc->usoCFDI = $factura ['usoCFDI'];
			$idDoc->metodoDePago = $factura ['metodoDePago'];
			$idDoc->sello = $sello;
			$idDoc->tipoFacturasRelacionadas = $datosFactura->tipoFacturasRelacionadas;
			$idDoc->save ();

			$totales = new Totales ();
			$totales->id_factura = $facturaObj->id_factura;
			$totales->moneda = $factura ['moneda'];
			$totales->tipoCambio = $factura ['tipoCambio'];
			$totales->subTotal = $factura ['subtotal'];
			$totales->mntBase = $factura ['base'];
			$totales->vlrPagar = $factura ['total'];
			$totales->descuento = $factura ['descuento'];
			$totales->save ();

			$detalles = array ();

			foreach ( $datosFactura->conceptos as $concepto ) {

				$conceptoObj = new Concepto ();
				$conceptoObj->clave = $concepto->clave;
				$conceptoObj->cdgItem = $concepto->cdgItem;
				$conceptoObj->dscItem = $concepto->dscItem;
				$conceptoObj->unmdItem = $concepto->unmdItem;
				$conceptoObj->qtyItem = $concepto->qtyItem;
				$conceptoObj->montoNetoItem = $concepto->montoNetoItem;
				$conceptoObj->prcNetoItem = $concepto->prcNetoItem;
				$conceptoObj->descuento = $concepto->descuento;
				$conceptoObj->fracArancelaria = $concepto->fracArancelaria;
				$conceptoObj->id_factura = $facturaObj->id_factura;
				$conceptoObj->save ();

				if (isset ( $factura ['guardarProd'] ) && $factura ['guardarProd'] == true) {

					if ($concepto->id_producto > 0) {
						$concepto2Obj = Producto::find ( $concepto->id_producto );
					} else {
						$concepto2Obj = new Producto ();
					}

					$concepto2Obj->id_proveedor = $user ['id_proveedor'];
					$concepto2Obj->clave = $concepto->clave;
					$concepto2Obj->nombre = $concepto->dscItem;
					$concepto2Obj->precioU = $concepto->montoNetoItem;
					$concepto2Obj->unidad = $concepto->unmdItem;
					$concepto2Obj->codigo = $concepto->cdgItem;
					$concepto2Obj->status = 1;
					$concepto2Obj->save ();
				}

				foreach ( $concepto->impuestosTrasladados as $impuesto ) {

					$impuestoObj = new ExImpuestos ();
					$impuestoObj->base = $impuesto->base;
					$impuestoObj->factor = $impuesto->factor;
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_detalle = $conceptoObj->id_detalle;
					$impuestoObj->save ();
				}

				foreach ( $concepto->impuestosRetenidos as $impuesto ) {

					$impuestoObj = new ExImpuestos ();
					$impuestoObj->base = $impuesto->base;
					$impuestoObj->factor = $impuesto->factor;
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_detalle = $conceptoObj->id_detalle;
					$impuestoObj->save ();
				}
			}

			foreach ( $datosFactura->facturasRelacionadas as $facturaRelacionada ) {

				$facturaRelacionadaObj = new FacturasRelacionadas ();
				$facturaRelacionadaObj->id_factura = $facturaObj->id_factura;
				$facturaRelacionadaObj->uuid = $facturaRelacionada->uuid;
				$facturaRelacionadaObj->save ();
			}

			if (count ( $datosFactura->impuestosRetenidosLcl ) > 0)
				foreach ( $datosFactura->impuestosRetenidosLcl as $impuesto ) {

					$impuestoObj = new ExImpuestos ();
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_factura = $facturaObj->id_factura;
					$impuestoObj->save ();
				}

			if (count ( $datosFactura->impuestosTrasladadosLcl ) > 0)
				foreach ( $datosFactura->impuestosTrasladadosLcl as $impuesto ) {

					$impuestoObj = new ExImpuestos ();
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_factura = $facturaObj->id_factura;
					$impuestoObj->save ();
				}

			if ($datosFactura->cuentaPredial != '') {

				$arrendamiento = new Arrendamiento ();
				$arrendamiento->id_factura = $facturaObj->id_factura;
				$arrendamiento->cuentaPredial = $datosFactura->cuentaPredial;
				$arrendamiento->save ();
			}


			if($datosFactura->comercio != null){

				$comercioEObjS = new ComercioE();
				$comercioEObjS->id_factura = $facturaObj->id_factura;
				$comercioEObjS->Incoterm = $datosFactura->comercio->datos->Incoterm;
				$comercioEObjS->clavePedimento = $datosFactura->comercio->datos->clavePedimento;
				$comercioEObjS->tipoOperacion = $datosFactura->comercio->datos->tipoOperacion;
				$comercioEObjS->rfcExtranjero = $datosFactura->comercio->datos->rfcExtranjero;
				$comercioEObjS->curp = $datosFactura->comercio->datos->curp;
				$comercioEObjS->save();

				$emisor = $comercio['emisor'];

				$domicilioEmisorObjS = new DomFiscalFact();
				$domicilioEmisorObjS->id_factura = $facturaObj->id_factura;
				$domicilioEmisorObjS->calle = $datosFactura->comercio->emisor->calle;
				$domicilioEmisorObjS->nroExterior = $datosFactura->comercio->emisor->nroExterior;
				$domicilioEmisorObjS->nroInterior = $datosFactura->comercio->emisor->nroInterior;
				$domicilioEmisorObjS->colonia = $datosFactura->comercio->emisor->colonia;
				$domicilioEmisorObjS->municipio = $datosFactura->comercio->emisor->municipio;
				$domicilioEmisorObjS->estado = $datosFactura->comercio->emisor->estado;
				$domicilioEmisorObjS->pais = $datosFactura->comercio->emisor->pais;
				$domicilioEmisorObjS->codigoPostal = $datosFactura->comercio->emisor->codigoPostal;
				$domicilioEmisorObjS->save();


				$domicilioReceptorObjS = new DomFiscalRcpFact();
				$domicilioReceptorObjS->id_factura = $facturaObj->id_factura;
				$domicilioReceptorObjS->calle = $datosFactura->comercio->receptor->calle;
				$domicilioReceptorObjS->nroExterior = $datosFactura->comercio->receptor->nroExterior;
				$domicilioReceptorObjS->nroInterior = $datosFactura->comercio->receptor->nroInterior;
				$domicilioReceptorObjS->colonia = $datosFactura->comercio->receptor->colonia;
				$domicilioReceptorObjS->municipio = $datosFactura->comercio->receptor->municipio;
				$domicilioReceptorObjS->estado = $datosFactura->comercio->receptor->estado;
				$domicilioReceptorObjS->pais = $datosFactura->comercio->receptor->pais;
				$domicilioReceptorObjS->codigoPostal = $datosFactura->comercio->receptor->codigoPostal;
				$domicilioReceptorObjS->save();


			}

			$facturaResult = $datosFactura->serie . $datosFactura->folio;
		} else {

			$errorCode = 10001;
			$errorMsg = 'Hubo un error al crear su factura. Vuelva a intentarlo.';

			if (is_object ( $resultado ) && isset ( $resultado->stampResult ) && isset ( $resultado->stampResult->Incidencias )
					&& isset ( $resultado->stampResult->Incidencias->Incidencia )) {

						$errorMsg = $resultado->stampResult->Incidencias->Incidencia->MensajeIncidencia;
			}

			$errortext = $errorMsg;
		}

		return Response::json ( array (
				'success' => $success,
				'errorCode' => $errorCode,
				'errortext' => $errortext,
				'facturaResult' => $facturaResult,
				'nombreArchivo' => $nombreArchivo
		) );
	}
	public function facturarPorConcepto(Request $request) {
		ini_set ( 'default_socket_timeout', 250 );

		$factura = $request->input ( 'factura' );
		$user = $request->input ( 'user' );
		$proveedor = Proveedor::find ( $user ['id_proveedor'] );
		$nombreArchivo = '';

		$timeStamp = date ( "Y-m-d H:i:s", strtotime ( "-2 minutes" ) );
		$noFactura = DB::select ( "SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $user ['id_proveedor'] . " AND i.serie = '" . $factura ['serie'] . "'" ) [0];
		$noFactura->noFactura ++;
		$certificadoHaUsar = CertificadoProveedor::where ( 'id_proveedor', '=', $user ['id_proveedor'] )->where ( 'status', '=', 1 )->first ();

		$datosFactura = new \stdClass ();
		$datosFactura->timeStamp = $timeStamp;
		$datosFactura->tipoDeComprobante = $factura ['tipoDocumento'];
		$datosFactura->serie = $factura ['serie'];
		$datosFactura->folio = $noFactura->noFactura;
		$datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
		$datosFactura->certificado = $certificadoHaUsar->certificado;
		$datosFactura->mntBase = $factura ['base'];
		$datosFactura->subtotal = $factura ['subtotal'];
		$datosFactura->moneda = $factura ['moneda'];
		$datosFactura->total = $factura ['total'];
		$datosFactura->formaPago = $factura ['formaPago'];
		$datosFactura->descuento = $factura ['descuento'];
		$datosFactura->precission = $factura ['decimales'];
		$datosFactura->tipoCambio = $factura ['tipoCambio'];
		$datosFactura->lugarExpedicion = Utils::deleteExtraSpaces ( $factura ['lugarExpedicion'] );
		$datosFactura->usoCFDI = $factura ['usoCFDI'];
		$datosFactura->metodoDePago = $factura ['metodoDePago'];
		$datosFactura->condicionesDePago = (isset ( $factura ['condicionesPago'] )) ? Utils::deleteExtraSpaces ( $factura ['condicionesPago'] ) : '';
		$datosFactura->cuentaPredial = (isset ( $factura ['cuentaPredial'] )) ? Utils::deleteExtraSpaces ( $factura ['cuentaPredial'] ) : '';
		$datosFactura->tipoFacturasRelacionadas = $factura ['facturasRelacionadas'] ['tipoRelacion'];
		$datosFactura->rFCEmisor = $proveedor->rFCEmisor;
		$datosFactura->nmbEmisor = $proveedor->nmbEmisor;
		$datosFactura->rFCRecep = $factura ['id_cliente'] ['rFCRecep'];
		$datosFactura->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
		$datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
		$datosFactura->numRegIdTrib = isset ( $factura ['numRegIdTrib'] ) ? $factura ['numRegIdTrib'] : '';
		$datosFactura->pais = isset ( $factura ['pais'] ) ? $factura ['pais'] : '';
		$datosFactura->tipoPersona = $proveedor->tipoPersona;

		$datosFactura->conceptos = [ ];
		$datosFactura->impuestosTrasladados = [ ];
		$datosFactura->impuestosRetenidos = [ ];
		$datosFactura->impuestosTrasladadosLcl = [ ];
		$datosFactura->impuestosTrasladadosLclTotal = 0;
		$datosFactura->impuestosRetenidosLcl = [ ];
		$datosFactura->impuestosRetenidosLclTotal = 0;
		$totalImpRetenidos = 0;
		$totalImpTrasladados = 0;

		foreach ( $factura ['detalles'] as $detalle ) {

			$concepto = new \stdClass ();
			$concepto->clave = $detalle ['clave'];
			$concepto->id_producto = isset ( $detalle ['id_producto'] ) ? $detalle ['id_producto'] : 0;
			$concepto->cdgItem = Utils::deleteExtraSpaces ( $detalle ['codigo'] );
			$concepto->dscItem = Utils::deleteExtraSpaces ( $detalle ['nombre'] );
			$concepto->unmdItem = (isset ( $detalle ['unidad'] )) ? $detalle ['unidad'] : '';
			$concepto->qtyItem = $detalle ['qty'];
			$concepto->montoNetoItem = $detalle ['precioU'];
			$concepto->prcNetoItem = $detalle ['qty'] * $detalle ['precioU'];
			$concepto->descuento = $detalle ['descuento'];

			$concepto->impuestosTrasladados = [ ];

			$base = Utils::formatNumber ( (($detalle ['qty'] * $detalle ['precioU']) - $detalle ['descuento']), $factura ['decimales'] );
			foreach ( $detalle ['impuestosTrasladados'] as $traslado ) {

				if ($traslado ['impuesto'] == 'XXX') {

					$impuestoLcl = new \stdClass ();
					$impuestoLcl->tipoImp = $traslado ['label'];
					$impuestoLcl->tasaImp = $traslado ['valor'];
					$impuestoLcl->tipo = 1;

					$importeImp = Utils::formatNumber ( $traslado ['total'], $factura ['decimales'] );

					$impuestoLcl->montoImp = $importeImp;

					$datosFactura->impuestosTrasladadosLclTotal += $importeImp;
					$datosFactura->impuestosTrasladadosLcl [] = $impuestoLcl;
				} else {

					$impuesto = new \stdClass ();
					$impuesto->base = $traslado ['base'];
					$impuesto->factor = $traslado ['factor'];
					$impuesto->tipoImp = $traslado ['impuesto'];
					$impuesto->tasaImp = $traslado ['valor'];
					$impuesto->tipo = 1;

					$importeImp = Utils::formatNumber ( $traslado ['total'], $factura ['decimales'] );

					$impuesto->montoImp = $importeImp;

					$totalImpTrasladados += $importeImp;

					$concepto->impuestosTrasladados [] = $impuesto;

					$isNuevo = true;
					if (count ( $datosFactura->impuestosTrasladados ))
						foreach ( $datosFactura->impuestosTrasladados as $impuestoGeneral ) {

							if ($impuesto->tipoImp == $impuestoGeneral->impuesto && $impuesto->factor == $impuestoGeneral->tipoFactor && $impuesto->tasaImp == $impuestoGeneral->tasaOCuota) {
								$isNuevo = false;
								$impuestoGeneral->importe += $impuesto->montoImp;
								break;
							}
						}

					if ($isNuevo && $traslado ['factor'] != 'Exento') {
						$impuestoGeneral = new \stdClass ();
						$impuestoGeneral->importe = $impuesto->montoImp;
						$impuestoGeneral->impuesto = $impuesto->tipoImp;
						$impuestoGeneral->tipoFactor = $traslado ['factor'];
						$impuestoGeneral->tasaOCuota = $traslado ['valor'];
						$datosFactura->impuestosTrasladados [] = $impuestoGeneral;
					}
				}
			}

			$concepto->impuestosRetenidos = [ ];

			foreach ( $detalle ['impuestosRetenidos'] as $retencion ) {

				if ($retencion ['impuesto'] == 'XXX') {

					$impuestoLcl = new \stdClass ();
					$impuestoLcl->tipoImp = $retencion ['label'];
					$impuestoLcl->tasaImp = $retencion ['valor'];
					$impuestoLcl->tipo = 0;

					$importeImp = Utils::formatNumber ( $retencion ['total'], $factura ['decimales'] );

					$impuestoLcl->montoImp = $importeImp;

					$datosFactura->impuestosRetenidosLclTotal += $importeImp;
					$datosFactura->impuestosRetenidosLcl [] = $impuestoLcl;
				} else {

					$impuesto = new \stdClass ();
					$impuesto->base = $retencion ['base'];
					$impuesto->factor = $retencion ['factor'];
					$impuesto->tipoImp = $retencion ['impuesto'];
					$impuesto->tasaImp = $retencion ['valor'];
					$impuesto->tipo = 0;

					$importeImp = Utils::formatNumber ( $retencion ['total'], $factura ['decimales'] );

					$impuesto->montoImp = $importeImp;

					$totalImpRetenidos += $importeImp;

					$concepto->impuestosRetenidos [] = $impuesto;

					$isNuevo = true;
					if (count ( $datosFactura->impuestosRetenidos ))
						foreach ( $datosFactura->impuestosRetenidos as $impuestoGeneral ) {
							if ($impuesto->tipoImp == $impuestoGeneral->impuesto) {
								$isNuevo = false;
								$impuestoGeneral->importe += $impuesto->montoImp;
								break;
							}
						}

					if ($isNuevo && $retencion ['factor'] != 'Exento') {
						$impuestoGeneral = new \stdClass ();
						$impuestoGeneral->importe = $impuesto->montoImp;
						$impuestoGeneral->impuesto = $impuesto->tipoImp;
						$datosFactura->impuestosRetenidos [] = $impuestoGeneral;
					}
				}
			}

			$datosFactura->conceptos [] = $concepto;
		}

		$datosFactura->totalImpRetenidos = $totalImpRetenidos;
		$datosFactura->totalImpTrasladados = $totalImpTrasladados;

		$datosFactura->facturasRelacionadas = [ ];

		if (count ( $factura ['facturasRelacionadas'] ['uuids'] ))
			foreach ( $factura ['facturasRelacionadas'] ['uuids'] as $facturaRelacionada ) {

				$relacionObj = new \stdClass ();
				$relacionObj->uuid = $facturaRelacionada ['uUID'];
				$datosFactura->facturasRelacionadas [] = $relacionObj;
			}

		$xml = XMLUtils::createXML33 ( $datosFactura, $proveedor );

		$sello = $xml->query ( '//cfdi:Comprobante' ) [0]->getAttribute ( 'Sello' );

		$nombreArchivo = "$proveedor->rFCEmisor-" . date ( 'YmdHis' );

		file_put_contents ( "tmp/$nombreArchivo.xml", $xml );

		$urlTimbrado = "https://72.172.186.11/servicios/soap/stamp.wsdl";
		$usuarioInt = "saul.flores@soliat.com";
		$passwordInt = "S3rgio.Fl0res";

		if ($proveedor->id_proveedor == 943) {

			$urlTimbrado = "https://demo-facturacion.finkok.com/servicios/soap/stamp.wsdl";
			$usuarioInt = "saul.flores@soliat.com";
			$passwordInt = "S3rgio.Fl0res";
		}

		$params = array ();
		$params ['xml'] = $xml;
		$params ['username'] = $usuarioInt;
		$params ['password'] = $passwordInt;

		$client = new SoapClient ( $urlTimbrado, array (
				'encoding' => 'UTF-8',
				"connection_timeout" => 250
		) );
		$client->soap_defencoding = "UTF-8";
		$resultado = $client->__soapCall ( 'stamp', array (
				$params
		) );

		$logToSave = print_r ( $resultado, true );

		$log = env ( 'DIR_LOGS' ) . "/" . date ( "Y-m-d" ) . ".log";
		$fp = fopen ( $log, "a" );
		fwrite ( $fp, "\n\n===" . date ( "Y-m-d:H:i:s" ) . "\n\n" );
		fwrite ( $fp, "\n\n$nombreArchivo\n\n" );
		fwrite ( $fp, $logToSave );
		fwrite ( $fp, "\n\n===" );
		fclose ( $fp );

		$success = false;
		$errorCode = 0;
		$errortext = '';
		$facturaResult = '';

		if (is_object ( $resultado ) && isset ( $resultado->stampResult ) && isset ( $resultado->stampResult->xml )) {
			$success = true;

			$xmlTimbrado = new \DOMDocument ( "1.0", "uft-8" );
			$xmlTimbrado->loadXML ( $resultado->stampResult->xml );

			$idDoc = new IdDoc ();

			$timbreFiscal = $xmlTimbrado->getElementsByTagName ( 'TimbreFiscalDigital' );

			foreach ( $timbreFiscal as $timbreFiscal ) {

				$fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$fechaTimbradoArray = explode ( ".", $fechaTimbrado );

				$idDoc->version = $timbreFiscal->getAttribute ( 'Version' );
				$idDoc->fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$idDoc->selloCFD = $timbreFiscal->getAttribute ( 'SelloCFD' );
				$idDoc->noCertificadoSAT = $timbreFiscal->getAttribute ( 'NoCertificadoSAT' );
				$idDoc->selloSAT = $timbreFiscal->getAttribute ( 'SelloSAT' );
				$idDoc->uUID = $timbreFiscal->getAttribute ( 'UUID' );
				$idDoc->sello = $sello;
				$idDoc->rfcProvCertif = $timbreFiscal->getAttribute ( 'RfcProvCertif' );
			}

			$isPagado = 0;
			if ($factura ['metodoDePago'] == 'PUE')
				$isPagado = 1;

			$facturaObj = new Factura ();
			$facturaObj->id_proveedor = $user ['id_proveedor'];
			$facturaObj->id_cliente = $factura ['id_cliente'] ['id_cliente'];
			$facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
			$facturaObj->nmbEmisor = $proveedor->nmbEmisor;
			$facturaObj->rFCEmisor = $proveedor->rFCEmisor;
			$facturaObj->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
			$facturaObj->rFCRecep = $factura ['id_cliente'] ['rFCRecep'];
			$facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
			$facturaObj->timeStamp = $timeStamp;
			$facturaObj->noFactura = $noFactura->noFactura;
			$facturaObj->version = "3.3";
			$facturaObj->generadoPor = 4;
			$facturaObj->nota = (isset ( $factura ['comentario'] )) ? Utils::deleteExtraSpaces ( $factura ['comentario'] ) : '';
			$facturaObj->tipoDeComprobante = $factura ['tipoDocumento'];
			$facturaObj->precission = $factura ['decimales'];
			$facturaObj->status = 1;
			$facturaObj->isPagado = $isPagado;
			$facturaObj->save ();

			$idDoc->id_factura = $facturaObj->id_factura;
			$idDoc->serie = $factura ['serie'];
			$idDoc->folio = $noFactura->noFactura;
			$idDoc->formaPago = $factura ['formaPago'];
			$idDoc->condicionesDePago = (isset ( $factura ['condicionesPago'] )) ? Utils::deleteExtraSpaces ( $factura ['condicionesPago'] ) : '';
			$idDoc->lugarExpedicion = Utils::deleteExtraSpaces ( $factura ['lugarExpedicion'] );
			$idDoc->usoCFDI = $factura ['usoCFDI'];
			$idDoc->metodoDePago = $factura ['metodoDePago'];
			$idDoc->sello = $sello;
			$idDoc->tipoFacturasRelacionadas = $datosFactura->tipoFacturasRelacionadas;
			$idDoc->save ();

			$totales = new Totales ();
			$totales->id_factura = $facturaObj->id_factura;
			$totales->moneda = $factura ['moneda'];
			$totales->tipoCambio = $factura ['tipoCambio'];
			$totales->subTotal = $factura ['subtotal'];
			$totales->mntBase = $factura ['base'];
			$totales->vlrPagar = $factura ['total'];
			$totales->descuento = $factura ['descuento'];
			$totales->save ();

			$detalles = array ();

			foreach ( $datosFactura->conceptos as $concepto ) {

				$conceptoObj = new Concepto ();
				$conceptoObj->clave = $concepto->clave;
				$conceptoObj->cdgItem = $concepto->cdgItem;
				$conceptoObj->dscItem = $concepto->dscItem;
				$conceptoObj->unmdItem = $concepto->unmdItem;
				$conceptoObj->qtyItem = $concepto->qtyItem;
				$conceptoObj->montoNetoItem = $concepto->montoNetoItem;
				$conceptoObj->prcNetoItem = $concepto->prcNetoItem;
				$conceptoObj->descuento = $concepto->descuento;
				$conceptoObj->id_factura = $facturaObj->id_factura;
				$conceptoObj->save ();

				if (isset ( $factura ['guardarProd'] ) && $factura ['guardarProd'] == true) {

					if ($concepto->id_producto > 0) {
						$concepto2Obj = Producto::find ( $concepto->id_producto );
					} else {
						$concepto2Obj = new Producto ();
					}

					$concepto2Obj->id_proveedor = $user ['id_proveedor'];
					$concepto2Obj->clave = $concepto->clave;
					$concepto2Obj->nombre = $concepto->dscItem;
					$concepto2Obj->precioU = $concepto->montoNetoItem;
					$concepto2Obj->unidad = $concepto->unmdItem;
					$concepto2Obj->codigo = $concepto->cdgItem;
					$concepto2Obj->status = 1;
					$concepto2Obj->save ();
				}

				foreach ( $concepto->impuestosTrasladados as $impuesto ) {

					$impuestoObj = new ExImpuestos ();
					$impuestoObj->base = $impuesto->base;
					$impuestoObj->factor = $impuesto->factor;
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_detalle = $conceptoObj->id_detalle;
					$impuestoObj->save ();
				}

				foreach ( $concepto->impuestosRetenidos as $impuesto ) {

					$impuestoObj = new ExImpuestos ();
					$impuestoObj->base = $impuesto->base;
					$impuestoObj->factor = $impuesto->factor;
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_detalle = $conceptoObj->id_detalle;
					$impuestoObj->save ();
				}
			}

			foreach ( $datosFactura->facturasRelacionadas as $facturaRelacionada ) {

				$facturaRelacionadaObj = new FacturasRelacionadas ();
				$facturaRelacionadaObj->id_factura = $facturaObj->id_factura;
				$facturaRelacionadaObj->uuid = $facturaRelacionada->uuid;
				$facturaRelacionadaObj->save ();
			}

			if (count ( $datosFactura->impuestosRetenidosLcl ) > 0)
				foreach ( $datosFactura->impuestosRetenidosLcl as $impuesto ) {

					$impuestoObj = new ExImpuestos ();
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_factura = $facturaObj->id_factura;
					$impuestoObj->save ();
				}

			if (count ( $datosFactura->impuestosTrasladadosLcl ) > 0)
				foreach ( $datosFactura->impuestosTrasladadosLcl as $impuesto ) {

					$impuestoObj = new ExImpuestos ();
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_factura = $facturaObj->id_factura;
					$impuestoObj->save ();
				}

			if ($datosFactura->cuentaPredial != '') {

				$arrendamiento = new Arrendamiento ();
				$arrendamiento->id_factura = $facturaObj->id_factura;
				$arrendamiento->cuentaPredial = $datosFactura->cuentaPredial;
				$arrendamiento->save ();
			}

			$facturaResult = $datosFactura->serie . $datosFactura->folio;
		} else {
			$errorCode = $resultado [6];
			$errortext = $resultado [7];
		}

		return Response::json ( array (
				'success' => $success,
				'errorCode' => $errorCode,
				'errortext' => $errortext,
				'facturaResult' => $facturaResult,
				'nombreArchivo' => $nombreArchivo
		) );
	}
	public function facturarPago(Request $request) {
		ini_set ( 'default_socket_timeout', 300 );
		ini_set ( 'max_execution_time', 300 );
		set_time_limit ( 300 );

		$factura = $request->input ( 'factura' );
		$user = $request->input ( 'user' );
		$proveedor = Proveedor::find ( $user ['id_proveedor'] );

		$timeStamp = date ( "Y-m-d H:i:s", strtotime ( "-2 minutes" ) );
		$noFactura = DB::select ( "SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $user ['id_proveedor'] . " AND i.serie = '" . $factura ['serie'] . "'" ) [0];
		$noFactura->noFactura ++;
		$certificadoHaUsar = CertificadoProveedor::where ( 'id_proveedor', '=', $user ['id_proveedor'] )->where ( 'status', '=', 1 )->first ();

		$datosFactura = new \stdClass ();
		$datosFactura->timeStamp = $timeStamp;
		$datosFactura->tipoDeComprobante = 'P';
		$datosFactura->serie = $factura ['serie'];
		$datosFactura->folio = $noFactura->noFactura;
		$datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
		$datosFactura->certificado = $certificadoHaUsar->certificado;
		$datosFactura->mntBase = 0;
		$datosFactura->subtotal = 0;
		$datosFactura->moneda = 'XXX';
		$datosFactura->total = 0;
		$datosFactura->formaPago = '';
		$datosFactura->condicionesDePago = '';
		$datosFactura->descuento = 0;
		$datosFactura->precission = 0;
		$datosFactura->tipoCambio = 1;
		$datosFactura->lugarExpedicion = Utils::deleteExtraSpaces ( $factura ['lugarExpedicion'] );
		$datosFactura->usoCFDI = 'P01';
		$datosFactura->metodoDePago = '';
		$datosFactura->condicionesDePago = '';
		$datosFactura->tipoFacturasRelacionadas = $factura ['facturasRelacionadas'] ['tipoRelacion'];
		$datosFactura->rFCEmisor = $proveedor->rFCEmisor;
		$datosFactura->nmbEmisor = $proveedor->nmbEmisor;
		$datosFactura->rFCRecep = $factura ['id_cliente'] ['rFCRecep'];
		$datosFactura->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
		$datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
		$datosFactura->numRegIdTrib = isset ( $factura ['numRegIdTrib'] ) ? $factura ['numRegIdTrib'] : '';
		$datosFactura->pais = isset ( $factura ['pais'] ) ? $factura ['pais'] : '';
		$datosFactura->tipoPersona = $proveedor->tipoPersona;

		$datosFactura->conceptos = [ ];
		$datosFactura->impuestosTrasladados = [ ];
		$datosFactura->impuestosRetenidos = [ ];
		$totalImpRetenidos = 0;
		$totalImpTrasladados = 0;

		$detalle = array (
				'clave' => '84111506',
				'codigo' => '',
				'nombre' => 'Pago',
				'unidad' => 'ACT',
				'qty' => 1,
				'precioU' => 0,
				'descuento' => 0
		);
		$factura ['detalles'] = [ ];
		$factura ['detalles'] [] = $detalle;

		foreach ( $factura ['detalles'] as $detalle ) {

			$concepto = new \stdClass ();
			$concepto->clave = $detalle ['clave'];
			$concepto->cdgItem = Utils::deleteExtraSpaces ( $detalle ['codigo'] );
			$concepto->dscItem = Utils::deleteExtraSpaces ( $detalle ['nombre'] );
			$concepto->unmdItem = (isset ( $detalle ['unidad'] )) ? $detalle ['unidad'] : '';
			$concepto->qtyItem = $detalle ['qty'];
			$concepto->montoNetoItem = $detalle ['precioU'];
			$concepto->prcNetoItem = $detalle ['qty'] * $detalle ['precioU'];
			$concepto->descuento = $detalle ['descuento'];

			$concepto->impuestosTrasladados = [ ];
			$concepto->impuestosRetenidos = [ ];
			$datosFactura->conceptos [] = $concepto;
		}

		$datosFactura->pagos = [ ];
		foreach ( $factura ['pagos'] as $pago ) {

			$pagoObj = new \stdClass ();
			$pagoObj->FechaPago = $pago ['fechaPago'];
			$pagoObj->FormaDePagoP = $pago ['formaPago'];
			$pagoObj->MonedaP = $pago ['moneda'];
			$pagoObj->TipoCambioP = $pago ['tipoCambio'];
			$pagoObj->Monto = $pago ['totalPago'];

			$pagoObj->documentosRelacionado = [ ];

			foreach ( $pago ['documentoRelacionado'] as $documentoRelacionado ) {

				$doctoRelacionado = new \stdClass ();
				$doctoRelacionado->IdDocumento = $documentoRelacionado ['uuid'];
				$doctoRelacionado->MonedaDR = $documentoRelacionado ['moneda'];
				$doctoRelacionado->TipoCambioDR = $documentoRelacionado ['tipoCambio'];
				$doctoRelacionado->MetodoDePagoDR = 'PPD';
				$doctoRelacionado->NumParcialidad = $documentoRelacionado ['parcialidad'];
				$doctoRelacionado->ImpSaldoAnt = $documentoRelacionado ['saldoAnterior'];
				$doctoRelacionado->ImpPagado = $documentoRelacionado ['pago'];
				$doctoRelacionado->ImpSaldoInsoluto = $documentoRelacionado ['saldoInsoluto'];

				$pagoObj->documentosRelacionado [] = $doctoRelacionado;
			}

			$datosFactura->pagos [] = $pagoObj;
		}

		$datosFactura->totalImpRetenidos = $totalImpRetenidos;
		$datosFactura->totalImpTrasladados = $totalImpTrasladados;

		$datosFactura->facturasRelacionadas = [ ];

		if (count ( $factura ['facturasRelacionadas'] ['uuids'] ))
			foreach ( $factura ['facturasRelacionadas'] ['uuids'] as $facturaRelacionada ) {

				$relacionObj = new \stdClass ();
				$relacionObj->uuid = $facturaRelacionada ['uUID'];
				$datosFactura->facturasRelacionadas [] = $relacionObj;
			}

		$xml = XMLUtils::createXML33 ( $datosFactura, $proveedor );

		$sello = $xml->query ( '//cfdi:Comprobante' ) [0]->getAttribute ( 'Sello' );

		$nombreArchivo = "$proveedor->rFCEmisor-" . date ( 'YmdHis' );

		file_put_contents ( "tmp/$nombreArchivo.xml", $xml );

		$urlTimbrado = "https://72.172.186.11/servicios/soap/stamp.wsdl";
		$usuarioInt = "saul.flores@soliat.com";
		$passwordInt = "S3rgio.Fl0res";

		if ($proveedor->id_proveedor == 943) {

			$urlTimbrado = "https://demo-facturacion.finkok.com/servicios/soap/stamp.wsdl";
			$usuarioInt = "saul.flores@soliat.com";
			$passwordInt = "S3rgio.Fl0res";
		}

		$params = array ();
		$params ['xml'] = $xml;
		$params ['username'] = $usuarioInt;
		$params ['password'] = $passwordInt;

		$client = new SoapClient ( $urlTimbrado, array (
				'encoding' => 'UTF-8',
				"connection_timeout" => 250
		) );
		$client->soap_defencoding = "UTF-8";
		$resultado = $client->__soapCall ( 'stamp', array (
				$params
		) );

		$logToSave = print_r ( $resultado, true );

		$log = env ( 'DIR_LOGS' ) . "/" . date ( "Y-m-d" ) . ".log";
		$fp = fopen ( $log, "a" );
		fwrite ( $fp, "\n\n===" . date ( "Y-m-d:H:i:s" ) . "\n\n" );
		fwrite ( $fp, "\n\n$nombreArchivo\n\n" );
		fwrite ( $fp, $logToSave );
		fwrite ( $fp, "\n\n===" );
		fclose ( $fp );

		$success = false;
		$errorCode = 0;
		$errortext = '';
		$facturaResult = '';

		if (is_object ( $resultado ) && isset ( $resultado->stampResult ) && isset ( $resultado->stampResult->xml )) {
			$success = true;

			$xmlTimbrado = new \DOMDocument ( "1.0", "uft-8" );
			$xmlTimbrado->loadXML ( $resultado->stampResult->xml );

			$idDoc = new IdDoc ();

			$timbreFiscal = $xmlTimbrado->getElementsByTagName ( 'TimbreFiscalDigital' );

			foreach ( $timbreFiscal as $timbreFiscal ) {

				$fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$fechaTimbradoArray = explode ( ".", $fechaTimbrado );

				$idDoc->version = $timbreFiscal->getAttribute ( 'Version' );
				$idDoc->fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$idDoc->selloCFD = $timbreFiscal->getAttribute ( 'SelloCFD' );
				$idDoc->noCertificadoSAT = $timbreFiscal->getAttribute ( 'NoCertificadoSAT' );
				$idDoc->selloSAT = $timbreFiscal->getAttribute ( 'SelloSAT' );
				$idDoc->uUID = $timbreFiscal->getAttribute ( 'UUID' );
				$idDoc->sello = $sello;
				$idDoc->rfcProvCertif = $timbreFiscal->getAttribute ( 'RfcProvCertif' );
			}

			$facturaObj = new Factura ();
			$facturaObj->id_proveedor = $user ['id_proveedor'];
			$facturaObj->id_cliente = $factura ['id_cliente'] ['id_cliente'];
			$facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
			$facturaObj->nmbEmisor = $proveedor->nmbEmisor;
			$facturaObj->rFCEmisor = $proveedor->rFCEmisor;
			$facturaObj->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
			$facturaObj->rFCRecep = $factura ['id_cliente'] ['rFCRecep'];
			$facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
			$facturaObj->timeStamp = $timeStamp;
			$facturaObj->noFactura = $noFactura->noFactura;
			$facturaObj->version = "3.3";
			$facturaObj->generadoPor = 4;
			$facturaObj->nota = (isset ( $factura ['comentario'] )) ? Utils::deleteExtraSpaces ( $factura ['comentario'] ) : '';
			$facturaObj->tipoDeComprobante = $factura ['tipoDocumento'];
			$facturaObj->precission = $factura ['decimales'];
			$facturaObj->status = 1;
			$facturaObj->save ();

			$idDoc->id_factura = $facturaObj->id_factura;
			$idDoc->serie = $factura ['serie'];
			$idDoc->folio = $noFactura->noFactura;
			$idDoc->formaPago = '';
			$idDoc->condicionesDePago = (isset ( $factura ['condicionesPago'] )) ? Utils::deleteExtraSpaces ( $factura ['condicionesPago'] ) : '';
			$idDoc->lugarExpedicion = Utils::deleteExtraSpaces ( $factura ['lugarExpedicion'] );
			$idDoc->usoCFDI = 'P01';
			$idDoc->metodoDePago = '';
			$idDoc->sello = $sello;
			$idDoc->tipoFacturasRelacionadas = $datosFactura->tipoFacturasRelacionadas;
			$idDoc->save ();

			$totales = new Totales ();
			$totales->id_factura = $facturaObj->id_factura;
			$totales->moneda = 'XXX';
			$totales->tipoCambio = 0;
			$totales->subTotal = 0;
			$totales->mntBase = 0;
			$totales->vlrPagar = 0;
			$totales->descuento = 0;
			$totales->save ();

			$detalles = array ();

			foreach ( $datosFactura->conceptos as $concepto ) {

				$conceptoObj = new Concepto ();
				$conceptoObj->clave = $concepto->clave;
				$conceptoObj->cdgItem = $concepto->cdgItem;
				$conceptoObj->dscItem = $concepto->dscItem;
				$conceptoObj->unmdItem = $concepto->unmdItem;
				$conceptoObj->qtyItem = $concepto->qtyItem;
				$conceptoObj->montoNetoItem = $concepto->montoNetoItem;
				$conceptoObj->prcNetoItem = $concepto->prcNetoItem;
				$conceptoObj->descuento = $concepto->descuento;
				$conceptoObj->id_factura = $facturaObj->id_factura;
				$conceptoObj->save ();

				foreach ( $concepto->impuestosTrasladados as $impuesto ) {

					$impuestoObj = new ExImpuestos ();
					$impuestoObj->base = $impuesto->base;
					$impuestoObj->factor = $impuesto->factor;
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_detalle = $conceptoObj->id_detalle;
					$impuestoObj->save ();
				}

				foreach ( $concepto->impuestosRetenidos as $impuesto ) {

					$impuestoObj = new ExImpuestos ();
					$impuestoObj->base = $impuesto->base;
					$impuestoObj->factor = $impuesto->factor;
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_detalle = $conceptoObj->id_detalle;
					$impuestoObj->save ();
				}
			}

			foreach ( $datosFactura->facturasRelacionadas as $facturaRelacionada ) {

				$facturaRelacionadaObj = new FacturasRelacionadas ();
				$facturaRelacionadaObj->id_factura = $facturaObj->id_factura;
				$facturaRelacionadaObj->uuid = $facturaRelacionada->uuid;
				$facturaRelacionadaObj->save ();
			}

			foreach ( $datosFactura->pagos as $pago ) {

				$pagoObj = new Pago ();
				$pagoObj->FechaPago = $pago->FechaPago;
				$pagoObj->FormaDePagoP = $pago->FormaDePagoP;
				$pagoObj->MonedaP = $pago->MonedaP;
				$pagoObj->TipoCambioP = $pago->TipoCambioP;
				$pagoObj->Monto = $pago->Monto;
				$pagoObj->id_factura = $facturaObj->id_factura;
				$pagoObj->save ();

				foreach ( $pago->documentosRelacionado as $doctoRelacionado ) {

					$doctoRelacionadoObj = new DoctoRelacionado ();
					$doctoRelacionadoObj->IdDocumento = $doctoRelacionado->IdDocumento;
					$doctoRelacionadoObj->MonedaDR = $doctoRelacionado->MonedaDR;
					$doctoRelacionadoObj->TipoCambioDR = $doctoRelacionado->TipoCambioDR;
					$doctoRelacionadoObj->MetodoDePagoDR = $doctoRelacionado->MetodoDePagoDR;
					$doctoRelacionadoObj->NumParcialidad = $doctoRelacionado->NumParcialidad;
					$doctoRelacionadoObj->ImpSaldoAnt = $doctoRelacionado->ImpSaldoAnt;
					$doctoRelacionadoObj->ImpPagado = $doctoRelacionado->ImpPagado;
					$doctoRelacionadoObj->ImpSaldoInsoluto = $doctoRelacionado->ImpSaldoInsoluto;
					$doctoRelacionadoObj->id_pago = $pagoObj->id;
					$doctoRelacionadoObj->save ();

					if ($doctoRelacionadoObj->ImpSaldoInsoluto <= 0) {

						$idDocObj = IdDoc::where ( 'uUID', '=', $doctoRelacionado->IdDocumento )->with ( 'factura' )->first ();
						$facturaIdDoc = $idDocObj->factura;
						$facturaIdDoc->isPagado = 1;
						$facturaIdDoc->save ();
					}
				}
			}

			$facturaResult = $datosFactura->serie . $datosFactura->folio;
		} else {

			$errorCode = 10001;
			$errorMsg = 'Hubo un error al crear su factura. Vuelva a intentarlo.';

			if (isset ( $resultado [6] )) {

				$errorCode = $resultado [6];
				switch ($resultado [6]) {
					case 330037 :
						$errorMsg = "Este RFC del receptor no existe en la lista de RFC inscritos no cancelados del SAT. Puede que su cliente tenga algún bloqueo.";
						break;
					case 330007 :
						$errorMsg = "Es necesario que agregue vaya a la sección de Mis Datos y actualice su régimen fiscal.";
						break;
					case 330171 :
						$errorMsg = "Se debe seleccionar un Uso de CFDI para realizar la factura.";
						break;
					case 305 :
						$errorMsg = "Su certificado de sellos digitales ha vencido, es necesario que genere uno nuevo en el portal del SAT.";
						break;
					default :
						$errorMsg = $resultado [7];
				}
			}

			$errortext = $errorMsg;
		}

		return Response::json ( array (
				'success' => $success,
				'errorCode' => $errorCode,
				'errortext' => $errortext,
				'facturaResult' => $facturaResult
		) );
	}
	public function cancelarFacturaFinkok(Request $request) {
		$factura = $request->input ( 'factura' );
		$user = $request->input ( 'user' );

		$proveedor = Proveedor::with ( 'certificados' )->where ( 'password', '=', $factura ['password'] )->where ( 'rFCEmisor', '=', $user ['rfc'] )->first ();

		$passCorrecto = false;
		$seraCancelado = false;

		if (is_object ( $proveedor )) {

			$key_content = file_get_contents ( env ( 'DIR_CERTS' ) . "/" . $proveedor->certificados->keyPem );
			$cer_content = file_get_contents ( env ( 'DIR_CERTS' ) . "/" . $proveedor->certificados->cerPem );

			$username = 'saul.flores@soliat.com';
			$password = 'S3rgio.Fl0res';
			$taxpayer_id = $proveedor->rFCEmisor; // The RFC of the Emisor
			$invoices = array (
					$factura ['uUID']
			); // A list of UUIDs

			$url = "https://72.172.186.11/servicios/soap/cancel.wsdl";
			if ($proveedor->id_proveedor == 943) {
				$url = "https://demo-facturacion.finkok.com/servicios/soap/cancel.wsdl";
			}

			$client = new SoapClient ( $url );
			$params = array (
					"UUIDS" => array (
							'uuids' => $invoices
					),
					"username" => $username,
					"password" => $password,
					"taxpayer_id" => $taxpayer_id,
					"cer" => $cer_content,
					"key" => $key_content
			);
			$response = $client->__soapCall ( "cancel", array (
					$params
			) );

			$seraCancelado = false;

			//print_r($response);

			if (is_object ( $response ) && isset ( $response->cancelResult ) && isset ( $response->cancelResult->Folios ) && $response->cancelResult->Folios->Folio->UUID == $factura ['uUID']) {
				$seraCancelado = true;
				Factura::where ( 'id_factura', '=', $factura ['id_factura'] )->update ( [
						'status' => 0
				] );
			}

			$passCorrecto = true;
		}

		return Response::json ( array (
				'success' => true,
				'passCorrecto' => $passCorrecto,
				'seraCancelado' => $seraCancelado
		) );
	}
	public function cancelarFactura(Request $request) {
		$factura = $request->input ( 'factura' );
		$user = $request->input ( 'user' );

		$proveedor = Proveedor::with ( 'certificados' )->where ( 'password', '=', $factura ['password'] )->where ( 'rFCEmisor', '=', $user ['rfc'] )->first ();

		$passCorrecto = false;
		$seraCancelado = false;

		if (is_object ( $proveedor )) {

			$key_content = file_get_contents ( env ( 'DIR_CERTS' ) . "/" . $proveedor->certificados->keyPem );
			$cer_content = file_get_contents ( env ( 'DIR_CERTS' ) . "/" . $proveedor->certificados->cerPem );

			$username = 'saul.flores@soliat.com';
			$password = 'S3rgio.Fl0res';
			$taxpayer_id = $proveedor->rFCEmisor; // The RFC of the Emisor
			$invoices = array (
					$factura ['uUID']
			); // A list of UUIDs

			$url = "https://demo-facturacion.finkok.com/servicios/soap/cancel.wsdl";
			$client = new SoapClient ( $url );
			$params = array (
					"UUIDS" => array (
							'uuids' => $invoices
					),
					"username" => $username,
					"password" => $password,
					"taxpayer_id" => $taxpayer_id,
					"cer" => $cer_content,
					"key" => $key_content
			);
			$response = $client->__soapCall ( "cancel", array (
					$params
			) );

			$seraCancelado = false;

			if (is_object ( $response ) && isset ( $response->cancelResult ) && isset ( $response->cancelResult->Folios ) && $response->cancelResult->Folios->Folio->UUID == $factura ['uUID']) {
				$seraCancelado = true;
				Factura::where ( 'id_factura', '=', $factura ['id_factura'] )->update ( [
						'status' => 0
				] );
			}

			$passCorrecto = true;
		}

		return Response::json ( array (
				'success' => true,
				'passCorrecto' => $passCorrecto,
				'seraCancelado' => $seraCancelado
		) );
	}
	public function timbrarNomina(Request $request) {
		ini_set ( 'default_socket_timeout', 300 );
		ini_set ( 'max_execution_time', 300 );
		set_time_limit ( 300 );

		$id_empleadoFac = $request->input ( 'id_empleadoFac' );
		$id_periodo = $request->input ( 'id_periodo' );
		$user = $request->input ( 'user' );

		$periodo = PeriodoNomina::find ( $id_periodo );
		$empleado = EmpleadoFac::with ( 'empleado.cliente', 'percepciones.tipopd', 'deducciones.tipopd' )->find ( $id_empleadoFac );
		$proveedor = Proveedor::find ( $user ['id_proveedor'] );
		$adicionalNomina = AdicionalNomina::find ( $user ['id_proveedor'] );

		$cliente = $empleado->empleado->cliente;

		$curp = '';
		if (is_object ( $proveedor->domicilio )) {
			$domicilio = $proveedor->domicilio;
			$curp = $domicilio->curp;
		}

		$rfcHoraAntes = array ();
		$textLess = '-2 minutes';
		if (in_array ( $user ['id_proveedor'], $rfcHoraAntes ))
			$textLess = '-24 hours';

		$timeStamp = date ( "Y-m-d H:i:s", strtotime ( $textLess ) );
		$noFactura = DB::select ( "SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $user ['id_proveedor'] . " AND i.serie = '" . $adicionalNomina->serie . "'" ) [0];
		$noFactura->noFactura ++;
		$certificadoHaUsar = CertificadoProveedor::where ( 'id_proveedor', '=', $user ['id_proveedor'] )->where ( 'status', '=', 1 )->first ();

		$totalDeduccion = 0;
		$totalImpuestosRetenidos = 0;
		$totalOtrasDeducciones = 0;

		$totalPercepcionGravado = 0;
		$totalPercepcionExcento = 0;
		$totalPercepciones = 0;
		$totalOtrosPagos = 0;
		$totalSueldos = 0;
		$totalSeparacionIndemnizacion = 0;
		$totalJubilacionPension = 0;

		$listadoPercepciones = [ ];
		$listadoDeducciones = [ ];
		$listadoOtrosPagos = [ ];
		$listadoIncapacidades = [ ];

		if (count ( $empleado->percepciones ) > 0)
			foreach ( $empleado->percepciones as $percepcion ) {

				if ($percepcion->tipopd->subTipo == 1) {

					$totalPercepcionExcento += $percepcion->importeExcento;
					$totalPercepcionGravado += $percepcion->importeGravado;

					if ($percepcion->tipopd->clave == '022' || $percepcion->tipopd->clave == '023' || $percepcion->tipopd->clave == '025') {
						$totalSeparacionIndemnizacion += $percepcion->importeExcento + $percepcion->importeGravado;
					} else if ($percepcion->tipopd->clave == '039' || $percepcion->tipopd->clave == '044') {
						$totalJubilacionPension += $percepcion->importeExcento + $percepcion->importeGravado;
					} else {
						$totalSueldos += $percepcion->importeExcento + $percepcion->importeGravado;
					}

					$listadoPercepciones [] = array (
							'TipoPercepcion' => $percepcion->tipopd->clave,
							'Clave' => $percepcion->tipopd->clave,
							'Concepto' => $percepcion->tipopd->descripcion,
							'ImporteGravado' => Utils::formatNumber ( $percepcion->importeGravado ),
							'ImporteExento' => Utils::formatNumber ( $percepcion->importeExcento ),
							'Dias' => $percepcion->noDiasHoras,
							'TipoHoras' => $percepcion->tipoHoras,
							'HorasExtra' => $percepcion->noHoras,
							'ImportePagado' => Utils::formatNumber ( $percepcion->importeExcento + $percepcion->importeGravado )
					);
				} else {

					$totalOtrosPagos += $percepcion->importeExcento + $percepcion->importeGravado;

					$listadoOtrosPagos [] = array (
							'TipoOtroPago' => $percepcion->tipopd->clave,
							'Clave' => $percepcion->tipopd->clave,
							'Concepto' => $percepcion->tipopd->descripcion,
							'Importe' => Utils::formatNumber ( $percepcion->importeGravado + $percepcion->importeExcento )
					);
				}
			}

		if (count ( $empleado->deducciones ) > 0)
			foreach ( $empleado->deducciones as $deduccion ) {

				if ($deduccion->id_tipoPercepcionDeduccion == 34) {
					// Incapacidades
					$listadoIncapacidades [] = array (
							'DiasIncapacidad' => $deduccion->noDiasHoras,
							'TipoIncapacidad' => $deduccion->tipoHoras,
							'ImporteMonetario' => Utils::formatNumber ( $deduccion->importeExcento + $deduccion->importeGravado )
					);
				}

				$totalDeduccion += $deduccion->importeExcento + $deduccion->importeGravado;

				if ($deduccion->tipopd->clave == '002') {
					$totalImpuestosRetenidos += $deduccion->importeExcento + $deduccion->importeGravado;
				} else {
					$totalOtrasDeducciones += $deduccion->importeExcento + $deduccion->importeGravado;
				}

				$listadoDeducciones [] = array (
						'TipoDeduccion' => $deduccion->tipopd->clave,
						'Clave' => $deduccion->tipopd->clave,
						'Concepto' => $deduccion->tipopd->descripcion,
						'Importe' => Utils::formatNumber ( $deduccion->importeExcento + $deduccion->importeGravado )
				);
			}

		$totalPercepciones = Utils::formatNumber ( $totalPercepcionGravado + $totalPercepcionExcento );
		$subTotal = $empleado->totalPercepciones = Utils::formatNumber ( $totalPercepciones + $totalOtrosPagos );
		$empleado->totalAPercibir = $subTotal - $totalDeduccion;

		$datosFactura = new \stdClass ();
		$datosFactura->timeStamp = $timeStamp;
		$datosFactura->tipoDeComprobante = 'N';
		$datosFactura->serie = $adicionalNomina->serie;
		$datosFactura->folio = $noFactura->noFactura;
		$datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
		$datosFactura->certificado = $certificadoHaUsar->certificado;
		$datosFactura->mntBase = $subTotal;
		$datosFactura->subtotal = $subTotal;
		$datosFactura->moneda = 'MXN';
		$datosFactura->total = $empleado->totalAPercibir;
		$datosFactura->formaPago = '99';
		$datosFactura->condicionesDePago = '';
		$datosFactura->descuento = $totalDeduccion;
		$datosFactura->precission = 2;
		$datosFactura->tipoCambio = 1;
		$datosFactura->lugarExpedicion = $periodo->lugarExpedicion;
		$datosFactura->usoCFDI = 'G03';
		$datosFactura->metodoDePago = 'PUE';
		$datosFactura->condicionesDePago = '';
		$datosFactura->tipoFacturasRelacionadas = '';
		$datosFactura->rFCEmisor = $proveedor->rFCEmisor;
		$datosFactura->nmbEmisor = $proveedor->nmbEmisor;
		$datosFactura->rFCRecep = $empleado->empleado->cliente->rFCRecep;
		$datosFactura->nmbRecep = $empleado->empleado->cliente->nmbRecep;
		$datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
		$datosFactura->numRegIdTrib = '';
		$datosFactura->pais = '';
		$datosFactura->curp = $curp;
		$datosFactura->tipoPersona = $proveedor->tipoPersona;

		$datosFactura->facturasRelacionadas = [ ];
		$datosFactura->conceptos = [ ];
		$datosFactura->impuestosTrasladados = [ ];
		$datosFactura->impuestosRetenidos = [ ];
		$datosFactura->impuestosTrasladadosLcl = [ ];
		$datosFactura->impuestosTrasladadosLclTotal = 0;
		$datosFactura->impuestosRetenidosLcl = [ ];
		$datosFactura->impuestosRetenidosLclTotal = 0;

		$totalImpRetenidos = 0;
		$totalImpTrasladados = 0;

		$detalle = array (
				'clave' => '84111505',
				'codigo' => '',
				'nombre' => 'Pago de nómina',
				'unidad' => 'ACT',
				'qty' => 1,
				'precioU' => $subTotal,
				'descuento' => $totalDeduccion
		);
		$factura ['detalles'] = [ ];
		$factura ['detalles'] [] = $detalle;

		foreach ( $factura ['detalles'] as $detalle ) {

			$concepto = new \stdClass ();
			$concepto->clave = $detalle ['clave'];
			$concepto->cdgItem = Utils::deleteExtraSpaces ( $detalle ['codigo'] );
			$concepto->dscItem = Utils::deleteExtraSpaces ( $detalle ['nombre'] );
			$concepto->unmdItem = (isset ( $detalle ['unidad'] )) ? $detalle ['unidad'] : '';
			$concepto->qtyItem = $detalle ['qty'];
			$concepto->montoNetoItem = $detalle ['precioU'];
			$concepto->prcNetoItem = $detalle ['qty'] * $detalle ['precioU'];
			$concepto->descuento = $detalle ['descuento'];

			$concepto->impuestosTrasladados = [ ];
			$concepto->impuestosRetenidos = [ ];
			$datosFactura->conceptos [] = $concepto;
		}

		$nomina = array (
				'Version' => '1.2',
				'FechaPago' => $periodo->fechaPago,
				'FechaInicialPago' => $periodo->fechaInicio,
				'FechaFinalPago' => $periodo->fechaFin,
				'NumDiasPagados' => $empleado->noDiasPagados,
				'TipoNomina' => $periodo->TipoNomina,
				'TotalDeducciones' => Utils::formatNumber ( $totalDeduccion ),
				'TotalOtrosPagos' => Utils::formatNumber ( $totalOtrosPagos ),
				'TotalPercepciones' => $totalPercepciones,
				'Emisor' => array (
						'RegistroPatronal' => $adicionalNomina->registroPatronal
				),
				'Percepciones' => array (
						'totalPercepcion' => Utils::formatNumber ( $totalPercepcionGravado + $totalPercepcionExcento ),
						'totalPercepcionGravado' => $totalPercepcionGravado,
						'totalPercepcionExcento' => $totalPercepcionExcento,
						'totalSueldos' => $totalSueldos,
						'totalSeparacionIndemnizacion' => $totalSeparacionIndemnizacion,
						'totalJubilacionPension' => $totalJubilacionPension,
						'listadoPercepciones' => $listadoPercepciones
				),
				'Deducciones' => array (
						'totalDeduccion' => $totalDeduccion,
						'totalImpuestosRetenidos' => $totalImpuestosRetenidos,
						'totalOtrasDeducciones' => $totalOtrasDeducciones,
						'listadoDeducciones' => $listadoDeducciones
				),
				'OtrosPagos' => array (
						'listadoOtrosPagos' => $listadoOtrosPagos
				),
				'Incapacidades' => array (
						'listadoIncapacidades' => $listadoIncapacidades
				)
		);

		$receptorN = [ ];

		if (! empty ( $empleado->curp ))
			$receptorN ['Curp'] = trim ( $empleado->curp );

		if (! empty ( $empleado->tipoContrato ))
			$receptorN ['TipoContrato'] = trim ( $empleado->tipoContrato );

		if (! empty ( $empleado->id_catalogoRegimenContratacion )) {
			$rg = CatalogoRegimenContratacion::find ( $empleado->id_catalogoRegimenContratacion );
			$receptorN ['TipoRegimen'] = trim ( $rg->clave );
		}

		if (! empty ( $empleado->noEmpleado ))
			$receptorN ['NumEmpleado'] = trim ( $empleado->noEmpleado );

		if (! empty ( $empleado->periodicidadPago ))
			$receptorN ['PeriodicidadPago'] = trim ( $empleado->periodicidadPago );

		if (! empty ( $empleado->ClaveEntFed ))
			$receptorN ['ClaveEntFed'] = trim ( $empleado->ClaveEntFed );

		if (! empty ( $empleado->nss ))
			$receptorN ['NumSeguridadSocial'] = preg_replace ( '/\D/', '', trim ( $empleado->nss ) );

		if (! empty ( $empleado->fechaInicioRelLaboral ) && $empleado->fechaInicioRelLaboral != '0000-00-00')
			$receptorN ['FechaInicioRelLaboral'] = trim ( $empleado->fechaInicioRelLaboral );

		$datetime1 = new \DateTime ( $empleado->fechaInicioRelLaboral );
		$datetime2 = new \DateTime ( $periodo->fechaFin );
		$interval = $datetime1->diff ( $datetime2 );
		$antiguedad = $interval->format ( '%R%a días' );
		$antiguedad = str_replace ( '+', '', $antiguedad );
		$antiguedad = $antiguedad / 7;
		$antiguedad = floor ( $antiguedad );

		if ($empleado->fechaInicioRelLaboral != '0000-00-00')
			$receptorN ['Antigüedad'] = "P" . $antiguedad . "W";

		if (! empty ( $empleado->puesto ))
			$receptorN ['Puesto'] = trim ( $empleado->puesto );

		if (! empty ( $empleado->salarioBase ))
			$receptorN ['SalarioBaseCotApor'] = Utils::formatNumber ( $empleado->salarioBase );

		if (! empty ( $empleado->salarioDiarioIntegrado ))
			$receptorN ['SalarioDiarioIntegrado'] = Utils::formatNumber ( $empleado->salarioDiarioIntegrado );

		if (! empty ( $empleado->id_catalogoRiesgoPuesto )) {
			$rg = CatalogoRiesgoPuesto::find ( $empleado->id_catalogoRiesgoPuesto );
			$receptorN ['RiesgoPuesto'] = trim ( $rg->clave );
		}

		$nomina ['Receptor'] = $receptorN;

		$datosFactura->nomina = $nomina;

		$xml = XMLUtils::createXML33 ( $datosFactura, $proveedor );

		$sello = $xml->query ( '//cfdi:Comprobante' ) [0]->getAttribute ( 'Sello' );

		$nombreArchivo = "$proveedor->rFCEmisor-" . date ( 'YmdHis' );

		file_put_contents ( "tmp/$nombreArchivo.xml", $xml );

		$urlTimbrado = "https://72.172.186.11/servicios/soap/stamp.wsdl";
		$usuarioInt = "saul.flores@soliat.com";
		$passwordInt = "S3rgio.Fl0res";

		if ($proveedor->id_proveedor == 943) {

			$urlTimbrado = "https://demo-facturacion.finkok.com/servicios/soap/stamp.wsdl";
			$usuarioInt = "saul.flores@soliat.com";
			$passwordInt = "S3rgio.Fl0res";
		}

		$params = array ();
		$params ['xml'] = $xml;
		$params ['username'] = $usuarioInt;
		$params ['password'] = $passwordInt;

		$client = new SoapClient ( $urlTimbrado, array (
				'encoding' => 'UTF-8',
				"connection_timeout" => 250
		) );
		$client->soap_defencoding = "UTF-8";
		$resultado = $client->__soapCall ( 'stamp', array (
				$params
		) );

		$logToSave = print_r ( $resultado, true );

		$log = env ( 'DIR_LOGS' ) . "/" . date ( "Y-m-d" ) . ".log";
		$fp = fopen ( $log, "a" );
		fwrite ( $fp, "\n\n===" . date ( "Y-m-d:H:i:s" ) . "\n\n" );
		fwrite ( $fp, "\n\n$nombreArchivo\n\n" );
		fwrite ( $fp, $logToSave );
		fwrite ( $fp, "\n\n===" );
		fclose ( $fp );

		$success = false;
		$errorCode = 0;
		$errortext = '';
		$facturaResult = '';

		if (is_object ( $resultado ) && isset ( $resultado->stampResult ) && isset ( $resultado->stampResult->xml )) {
			$success = true;

			$xmlTimbrado = new \DOMDocument ( "1.0", "uft-8" );
			$xmlTimbrado->loadXML ( $resultado->stampResult->xml );

			$idDoc = new IdDoc ();

			$timbreFiscal = $xmlTimbrado->getElementsByTagName ( 'TimbreFiscalDigital' );

			foreach ( $timbreFiscal as $timbreFiscal ) {

				$fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$fechaTimbradoArray = explode ( ".", $fechaTimbrado );

				$idDoc->version = $timbreFiscal->getAttribute ( 'Version' );
				$idDoc->fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$idDoc->selloCFD = $timbreFiscal->getAttribute ( 'SelloCFD' );
				$idDoc->noCertificadoSAT = $timbreFiscal->getAttribute ( 'NoCertificadoSAT' );
				$idDoc->selloSAT = $timbreFiscal->getAttribute ( 'SelloSAT' );
				$idDoc->uUID = $timbreFiscal->getAttribute ( 'UUID' );
				$idDoc->sello = $sello;
				$idDoc->rfcProvCertif = $timbreFiscal->getAttribute ( 'RfcProvCertif' );
			}

			$facturaObj = new Factura ();
			$facturaObj->id_proveedor = $user ['id_proveedor'];
			$facturaObj->id_cliente = $empleado->id_cliente;
			$facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
			$facturaObj->nmbEmisor = $proveedor->nmbEmisor;
			$facturaObj->rFCEmisor = $proveedor->rFCEmisor;
			$facturaObj->nmbRecep = $datosFactura->nmbRecep;
			$facturaObj->rFCRecep = $datosFactura->rFCRecep;
			$facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
			$facturaObj->timeStamp = $timeStamp;
			$facturaObj->noFactura = $noFactura->noFactura;
			$facturaObj->version = "3.3";
			$facturaObj->generadoPor = 4;
			$facturaObj->nota = '';
			$facturaObj->tipoDeComprobante = 'N';
			$facturaObj->precission = 2;
			$facturaObj->status = 1;
			$facturaObj->isPagado = 1;
			$facturaObj->numRegIdTrib = '';
			$facturaObj->pais = '';
			$facturaObj->save ();

			$empleado = EmpleadoFac::find ( $id_empleadoFac );
			$empleado->id_factura = $facturaObj->id_factura;
			$empleado->registroPatronal = $adicionalNomina->registroPatronal;
			$empleado->save ();

			$idDoc->id_factura = $facturaObj->id_factura;
			$idDoc->serie = $datosFactura->serie;
			$idDoc->folio = $noFactura->noFactura;
			$idDoc->formaPago = $datosFactura->formaPago;
			$idDoc->condicionesDePago = '';
			$idDoc->lugarExpedicion = $datosFactura->lugarExpedicion;
			$idDoc->usoCFDI = $datosFactura->usoCFDI;
			$idDoc->metodoDePago = $datosFactura->metodoDePago;
			$idDoc->sello = $sello;
			$idDoc->tipoFacturasRelacionadas = '';
			$idDoc->save ();

			$totales = new Totales ();
			$totales->id_factura = $facturaObj->id_factura;
			$totales->moneda = $datosFactura->moneda;
			$totales->tipoCambio = 1;
			$totales->subTotal = $datosFactura->subtotal;
			$totales->mntBase = $datosFactura->mntBase;
			$totales->vlrPagar = $datosFactura->total;
			$totales->descuento = $datosFactura->descuento;
			$totales->save ();

			$detalles = array ();

			foreach ( $datosFactura->conceptos as $concepto ) {

				$conceptoObj = new Concepto ();
				$conceptoObj->clave = $concepto->clave;
				$conceptoObj->cdgItem = $concepto->cdgItem;
				$conceptoObj->dscItem = $concepto->dscItem;
				$conceptoObj->unmdItem = $concepto->unmdItem;
				$conceptoObj->qtyItem = $concepto->qtyItem;
				$conceptoObj->montoNetoItem = $concepto->montoNetoItem;
				$conceptoObj->prcNetoItem = $concepto->prcNetoItem;
				$conceptoObj->descuento = $concepto->descuento;
				$conceptoObj->id_factura = $facturaObj->id_factura;
				$conceptoObj->save ();
			}

			$facturaResult = $datosFactura->serie . $datosFactura->folio;
		} else {

			$errorCode = 10001;
			$errorMsg = 'Hubo un error al crear su factura. Vuelva a intentarlo.';

			if (isset ( $resultado [6] )) {

				$errorCode = $resultado [6];
				switch ($resultado [6]) {
					case 330037 :
						$errorMsg = "Este RFC del receptor no existe en la lista de RFC inscritos no cancelados del SAT. Puede que su cliente tenga algún bloqueo.";
						break;
					case 330007 :
						$errorMsg = "Es necesario que agregue vaya a la sección de Mis Datos y actualice su régimen fiscal.";
						break;
					case 330171 :
						$errorMsg = "Se debe seleccionar un Uso de CFDI para realizar la factura.";
						break;
					case 305 :
						$errorMsg = "Su certificado de sellos digitales ha vencido, es necesario que genere uno nuevo en el portal del SAT.";
						break;
					default :
						$errorMsg = $resultado [7];
				}
			}

			$errortext = $errorMsg;
		}

		return Response::json ( array (
				'success' => true,
				'errorCode' => $errorCode,
				'errortext' => $errortext,
				'facturaResult' => $facturaResult,
				'nombreArchivo' => $nombreArchivo
		) );
	}
	public function registrarUsuario(Request $request) {
		//$proveedores = Proveedor::where ( 'status', '=', 1 )->skip ( 900 )->take ( 200 )->get ();

		$id_proveedor = $request->input("id_proveedor");
		$proveedor = Proveedor::find($id_proveedor);


		echo "<pre>";
		//foreach ( $proveedores as $proveedor ) {

			// Username and Password, assigned by FINKOK
			$usuarioInt = "saul.flores@soliat.com";
			$passwordInt = "S3rgio.Fl0res";
			$taxpayer_id = $proveedor->rFCEmisor;

			$url = "https://72.172.186.11/servicios/soap/registration.wsdl";
			$client = new SoapClient ( $url, array (
					'trace' => 1
			) );

			$params = array (
					"reseller_username" => $usuarioInt,
					"reseller_password" => $passwordInt,
					"taxpayer_id" => $taxpayer_id
			);
			$response = $client->__soapCall ( "add", array (
					$params
			) );
			print_r ( $response );
		//}
	}
}


