<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Response;
use SoapClient;

use App\Commands\XMLUtils;
use App\Models\Concepto;
use App\Models\ExImpuestos;
use App\Models\Factura;
use App\Models\FormaPago;
use App\Models\Producto;
use App\Models\UnidadMedida;
use App\Models\UnidadMedidaProveedor;
use App\Models\ClaveProdServProveedor;
use App\Models\Proveedor;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use App\Models\UsoCFDI;
use App\Models\Pais;
use App\Models\Serie;
use App\Commands\Utils;
use App\Models\CertificadoProveedor;
use App\Models\IdDoc;
use App\Models\Totales;
use App\Models\FacturasRelacionadas;
use Vsmoraes\Pdf\PdfFacade as PDF;
use App\Models\CatalogoRegimenFiscal;
use App\Commands\NumeroLetra;
use App\Models\ContactoReceptor;
use Illuminate\Support\Facades\Mail;
use App\Models\DoctoRelacionado;
use App\Models\Pago;
use App\Models\ContactoEmisor;
use App\Models\Arrendamiento;
use App\Models\Multiusuario;
use PHPExcel_IOFactory;
use PHPExcel;
use Illuminate\Support\Facades\Log;


class FacturacionFacController extends BaseController {


	public function listadoFacturas(Request $request){

		$user = $request->input('user');
		$filtro = $request->input('filtro');
		$fechaInicial = $filtro['initialS'] . ' 00:00:00';
		$fechaFinal = $filtro['endS'] . ' 23:59:59';
		$rfc = $filtro['rfc'];
		$estatusDocumento = $filtro['estatusDocumento'];
		$id_proveedorPrincipal = $request->input('id_proveedorPrincipal');


		$facturas = Factura::with('iddoc', 'totales', 'pagos')->where('id_proveedor', '=', $user['id_proveedor'])->where('Factura.rFCRecep', 'like', "%$rfc%")
		->whereBetween('Factura.timeStamp', [$fechaInicial, $fechaFinal])->where('status', '=', $estatusDocumento);

		if($filtro['tipoDocumento'] != '')
			$facturas->where('tipoDeComprobante', '=', $filtro['tipoDocumento']);

		$facturas = $facturas->get();

		if(is_object($facturas)){

			foreach ($facturas as $factura){
				$sumaPago = 0;
				if(count($factura->pagos) > 0)
				foreach ($factura->pagos as $pago){
					$sumaPago +=$pago->Monto;
				}

				$factura->sumaPago = $sumaPago;
			}

			$facturas = $facturas->toArray();
		}

		$proveedoresRelacionados = DB::select("SELECT p.id_proveedor, p.rFCEmisor FROM Proveedor p
				JOIN `Multiusuario` m ON p.id_proveedor = m.`id_proveedorRel` AND m.status = 1 WHERE m.id_proveedor = " . $id_proveedorPrincipal . " ORDER BY p.rFCEmisor");


			/*
			 $facturas = DB::select("SELECT Factura.id_factura, IdDoc.serie, Factura.noFactura, Factura.nmbRecep, Factura.rFCRecep, Factura.timeStamp, Totales.VlrPagar
				FROM Factura
			 	JOIN IdDoc ON IdDoc.id_factura = Factura.id_factura
			 	JOIN Totales ON Totales.id_factura = Factura.id_factura
			 	WHERE Factura.id_proveedor = ".$user['id_proveedor'] . " AND Factura.timeStamp BETWEEN '$fechaInicial' AND '$fechaFinal' AND Factura.rFCRecep LIKE '%$rfc%'");

			 	*/

		return Response::json ( array (
			'success' => true,
			'facturas' => $facturas,
			'proveedoresRelacionados' => $proveedoresRelacionados
		));

	}

	public function test(){

		/*

		$html = view('pdf.diseno2', ['algo' => 1234])->render();

			PDF::load($html)->filename("tmp/algo.pdf")->download();

			*/

		//Migrar divisiones

		/*
		$excelFile = 'tmp/buenodivisiones.xlsx';
		if (File::exists($excelFile)) {
			Excel::load($excelFile, function ($reader) use (&$excel) {

				$objExcel = $reader->getExcel();
				$sheet = $objExcel->getSheet(0);
				$highestRow = $sheet->getHighestRow();

				$last = '';
				echo "<pre>";
				//  Loop through each row of the worksheet in turn
				for ($row = 1; $row <= $highestRow; $row++) {
					$id = $sheet->getCellByColumnAndRow(0, $row)->getValue();
					$descripcion = trim($sheet->getCellByColumnAndRow(1, $row)->getValue());

					//Producto = 1
					//Servicio = 2

					$tipo = 1;
					if($id >= 70101500){
						$tipo = 2;
					}

					$current = $descripcion;
					if($last != $descripcion ){
						$last = $descripcion;

						$division = new Division();
						$division->tipo = $tipo;
						$division->descripcion = $descripcion;
						$division->status = 1;
						$division->save();

						print_r($division->toArray());

					}


				}

				echo "</pre>";

			});
		}else{
			echo "no existe el archivo";
		}
		*/


		//Proceso para guardar grupos

		/*
		$excelFile = 'tmp/buenogrupos.xlsx';
		if (File::exists($excelFile)) {
			Excel::load($excelFile, function ($reader) use (&$excel) {

				$objExcel = $reader->getExcel();
				$sheet = $objExcel->getSheet(0);
				$highestRow = $sheet->getHighestRow();

				$divisiones = Division::where('status', '=', 1)->get();

				$last = '';
				$index = 0;
				//  Loop through each row of the worksheet in turn
				for ($row = 1; $row <= $highestRow; $row++) {

					$id = $sheet->getCellByColumnAndRow(0, $row)->getValue();
					$descripcion = trim($sheet->getCellByColumnAndRow(1, $row)->getValue());
					$descripcionGrupo = trim($sheet->getCellByColumnAndRow(2, $row)->getValue());

					$division = $divisiones[$index];

					if($division->descripcion != $descripcion ){
						$index++;
						$division = $divisiones[$index];
					}

					if($division->descripcion == $descripcion ){

						if($last != $descripcionGrupo){
							$last = $descripcionGrupo;
							$inicial = trim($sheet->getCellByColumnAndRow(0, $row)->getValue());
						}

						$nextDescripcion = trim($sheet->getCellByColumnAndRow(2, $row + 1)->getValue());

						if($nextDescripcion != $last){
							$hasta = trim($sheet->getCellByColumnAndRow(0, $row)->getValue());

							$grupo = new Grupo();
							$grupo->id_division = $division->id;
							$grupo->descripcion = $descripcionGrupo;
							$grupo->desde = $inicial;
							$grupo->hasta = $hasta;
							$grupo->status = 1;
							$grupo->save();

							echo "Grupo: $descripcionGrupo IdDivision: $division->id Desde: $inicial Hasta: $hasta <br />";
						}
					}
				}

			});
		}else{
			echo "no existe el archivo";
		}

		*/


		//Carga de productos

		/*
		$excelFile = 'tmp/buenoproductos.xlsx';
		if (File::exists($excelFile)) {
			Excel::load($excelFile, function ($reader) use (&$excel) {

				$objExcel = $reader->getExcel();
				$sheet = $objExcel->getSheet(0);
				$highestRow = $sheet->getHighestRow();

				$last = '';
				//  Loop through each row of the worksheet in turn
				for ($row = 1; $row <= $highestRow; $row++) {

					$id = $sheet->getCellByColumnAndRow(0, $row)->getValue();
					$descripcion = trim($sheet->getCellByColumnAndRow(1, $row)->getValue());

					$producto = new ClaveProdServ();
					$producto->codigo = $id;
					$producto->descripcion = $descripcion;
					$producto->status = 1;
					$producto->save();

				}

			});
		}else{
			echo "no existe el archivo";
		}

		*/


		//Cargar id_grupo a productos

		/*
		$grupos = Grupo::get();
		$productos = ClaveProdServ::where('status', '=', 1)->get();

		$desde = 0;
		$hasta = 0;
		$id_grupo = 0;

		echo "<pre>";

		foreach($productos as $producto){

			if(!($producto->codigo >= $desde && $producto->codigo <= $hasta)){

				$continue = true;
				$x = 0;

				while($continue){

					//echo $producto->codigo ." >= ".$grupos[$x]->desde." && " . $producto->codigo." <= ".$grupos[$x]->hasta . "<br>";

					if($producto->codigo >= $grupos[$x]->desde && $producto->codigo <= $grupos[$x]->hasta){
						$desde = $grupos[$x]->desde;
						$hasta = $grupos[$x]->hasta;
						$id_grupo = $grupos[$x]->id;
						$continue = false;
					}

					$x++;

				}

			}

			$producto->id_grupo = $id_grupo;
			$producto->save();

			print_r($producto->toArray());
		}

		echo "</pre>";
		*/


		  //Cargar unidades de medida

		/*
		$excelFile = 'tmp/unidad-medida.xlsx';
		if (File::exists($excelFile)) {
			Excel::load($excelFile, function ($reader) use (&$excel) {

				$objExcel = $reader->getExcel();
				$sheet = $objExcel->getSheet(0);
				$highestRow = $sheet->getHighestRow();

				//  Loop through each row of the worksheet in turn
				echo "<pre>";
				for ($row = 1; $row <= $highestRow; $row++) {

					$codigo = $sheet->getCellByColumnAndRow(0, $row)->getValue();
					$descripcion = trim($sheet->getCellByColumnAndRow(1, $row)->getValue());
					$simbolo = trim($sheet->getCellByColumnAndRow(2, $row)->getValue());

					$um = new UnidadMedida();
					$um->codigo = $codigo;
					$um->descripcion = $descripcion;
					$um->simbolo = $simbolo;
					$um->status = 1;
					$um->save();

					print_r($um->toArray());


				}

				echo "</pre>";

			});
		}else{
			echo "no existe el archivo";
		}
		*/

		/*
		 * //Paises


		$excelFile = 'tmp/paises.xlsx';
		if (File::exists($excelFile)) {
			Excel::load($excelFile, function ($reader) use (&$excel) {

				$objExcel = $reader->getExcel();
				$sheet = $objExcel->getSheet(0);
				$highestRow = $sheet->getHighestRow();

				//  Loop through each row of the worksheet in turn
				echo "<pre>";
				for ($row = 1; $row <= $highestRow; $row++) {

					$codigo = $sheet->getCellByColumnAndRow(0, $row)->getValue();
					$descripcion = trim($sheet->getCellByColumnAndRow(1, $row)->getValue());

					$pais = new Pais();
					$pais->codigo = $codigo;
					$pais->nombre = $descripcion;
					$pais->status = 1;
					$pais->save();

					print_r($pais->toArray());


				}

				echo "</pre>";

			});
		}else{
			echo "no existe el archivo";
		}

		*/

		/*

		// Ruta al archivo XSLT
		$xslFile = "xslt/xslt33/cadenaoriginal_3_3.xslt";


		$xsl = new \DOMDocument();
		$xsl->load($xslFile);

		$proc = new \XSLTProcessor();
		$proc->importStyleSheet($xsl);

		*/

		/*
		$emails = [];

		$contactos = ContactoEmisor::where('email', '!=', '')->get();

		foreach ($contactos as $contacto)
			$emails[] = $contacto->email;

		$emails = array_unique($emails);

		$list = '';
		foreach ($emails as $mail){
			echo "$mail <br>";
		}

				*/
		/*
		exec ( "openssl x509 -in certificados/FOOS851205PH8-20171024174154.cer.pem -text -noout", $outputNoCerFile );

		echo "<pre>";
		print_r($outputNoCerFile[39]);
		echo "</pre>";
		*/


		//echo round (152.415, 2);

        $datetime1 = new \DateTime ( '2020-01-01 00:00:00' );
        $datetime2 = new \DateTime ( '2020-05-01 00:00:00' );
        $interval = $datetime1->diff ( $datetime2 );
        $antiguedad = $interval->format ( '%R%a días' );
        $antiguedad = str_replace ( '+', '', $antiguedad );
        $antiguedad = $antiguedad / 7;
        $antiguedad = floor ( $antiguedad );
        echo $antiguedad;


	}


	public function getXML(Request $request){

		$user = $request->input('user');
		$id_factura = $request->input('id_factura');
		$id_proveedor = $user['id_proveedor'];

		$query = "
		SELECT
		f.id_factura AS id_factura,
		f.nmbEmisor AS nmbEmisor,
		f.rFCEmisor AS rFCEmisor,
		f.nmbRecep AS nmbRecep,
		f.rFCRecep AS rFCRecep,
		f.regimenFiscal AS regimenFiscal,
		f.timeStamp AS timeStamp,
		f.noFactura AS noFactura,
		f.comentario AS comentario,
		f.version AS version,
		f.tipo AS tipo,
		f.precission AS precission,
		f.nota AS nota,
		f.domicilio AS domicilio,

		idoc.anoAprob AS anoAprob,
		idoc.nroAprob AS nroAprob,
		idoc.serie AS serie,
		idoc.folio AS folio,
		idoc.numeroInterno AS numeroInterno,
		idoc.fechaEmis AS fechaEmis,
		idoc.formaPago AS formaPago,
		idoc.condicionesDePago AS condicionesDePago,
		idoc.cuenta AS cuenta,
		idoc.lugarExpedicion AS lugarExpedicion,
		idoc.metodoDePago AS metodoDePago,
		idoc.fechaTimbrado AS fechaTimbrado,
		idoc.selloCFD AS selloCFD,
		idoc.noCertificadoSAT AS noCertificadoSAT,
		idoc.selloSAT AS selloSAT,
		idoc.uUID AS uUID,
		idoc.sello AS sello,
		idoc.unidadMedida AS unidadMedida,
		idoc.milisegundos AS milisegundos,
		idoc.version AS version2,

		df.calle AS calle,
		df.nroExterior AS nroExterior,
		df.nroInterior AS nroInterior,
		df.colonia AS colonia,
		df.localidad AS localidad,
		df.municipio AS municipio,
		df.estado AS estado,
		df.pais AS pais,
		df.codigoPostal AS codigoPostal,

		dfr.calle AS calleR,
		dfr.nroExterior AS nroExteriorR,
		dfr.nroInterior AS nroInteriorR,
		dfr.colonia AS coloniaR,
		dfr.localidad AS localidadR,
		dfr.municipio AS municipioR,
		dfr.estado AS estadoR,
		dfr.pais AS paisR,
		dfr.codigoPostal AS codigoPostalR,
		dfr.referencia AS referencia,

		dfs.calle AS calleS,
		dfs.nroExterior AS nroExteriorS,
		dfs.nroInterior AS nroInteriorS,
		dfs.colonia AS coloniaS,
		dfs.localidad AS localidadS,
		dfs.municipio AS municipioS,
		dfs.estado AS estadoS,
		dfs.pais AS paisS,
		dfs.codigoPostal AS codigoPostalS,

		t.moneda AS moneda,
		t.subTotal AS subTotal,
		t.mntDcto AS mntDcto,
		t.pctDcto AS pctDcto,
		t.mntBase AS mntBase,
		t.mntImp AS mntImp,
		t.descuento AS descuento,
		t.vlrPagar AS total,
		t.vlrPalabras AS vlrPalabras,
		t.motivoDescuento,

		cp.certificado AS certificado,
		cp.noCertificado AS noCertificado,

		arr.cuentaPredial

		FROM Factura f
		JOIN DomFiscalFact df ON f.id_factura = df.id_factura
		JOIN DomFiscalRcpFact dfr ON f.id_factura = dfr.id_factura
		JOIN IdDoc idoc ON f.id_factura = idoc.id_factura
		JOIN Totales t ON f.id_factura = t.id_factura
		JOIN CertificadosProveedor cp ON f.id_certificadoProveedor = cp.id
		LEFT JOIN DomFiscalSucursalFac dfs ON f.id_factura = dfs.id_factura
		LEFT JOIN Arrendamiento arr ON f.id_factura = arr.id_factura
		WHERE f.id_factura = $id_factura AND f.id_proveedor = $id_proveedor";

		$dataFactura = DB::select($query)[0];

		$dataFactura->impuestos = ExImpuestos::where('id_factura', '=', $id_factura)->orderBy('tipo')->get();
		$dataFactura->conceptos = Concepto::where('id_factura', '=', $id_factura)->get();

		$xml = XMLUtils::createXML32($dataFactura);

		$xmlName = "$dataFactura->rFCEmisor-$dataFactura->uUID.xml";

		//return response()->attachment($xml, $xmlName);

		return response($xml, 200)
		->header('Content-Type', 'text/xml');


	}

	public function datosFacturar(Request $request){

		$user = $request->input('user');

		$proveedor = Proveedor::with ( 'domicilio' )->find ( $user ['id_proveedor'] );

		$clientes = DB::table('Cliente')->select('id_cliente','rFCRecep', 'nmbRecep', 'usoCFDI', 'metodoPago')->where('status', '=', 1)->where('id_proveedor', '=', $user['id_proveedor'])->orderBy('nmbRecep')->get();
		$formasDePago = FormaPago::get();
		$productos = Producto::where('status', '=', 1)->where('id_proveedor', '=', $user['id_proveedor'])->orderBy('nombre')->get();

		$unidadesMedida = UnidadMedidaProveedor::where('id_proveedor', '=', $user['id_proveedor'])->with('unidad')->get();
		$clavesProducto = ClaveProdServProveedor::where('id_proveedor', '=', $user['id_proveedor'])->with('clave')->get();
		$series = Serie::where('id_proveedor', '=', $user['id_proveedor'])->get();
		$usosCFDI = UsoCFDI::get();

		return Response::json ( array (
				'success' => true,
				'clientes' => $clientes,
				'formasDePago' => $formasDePago->toArray(),
				'productos' => $productos->toArray(),
				'unidadesMedida' => $unidadesMedida->toArray(),
				'clavesProducto' => $clavesProducto->toArray(),
				'usosCFDI' => $usosCFDI->toArray(),
				'proveedor' => $proveedor->toArray(),
				'series' => $series->toArray()
		));

	}


	public function obtenerFacturasRel(Request $request){

		$user = $request->input('user');
		$noFactura = $request->input('noFactura');

		$facturas = DB::table('Factura')
		->join('IdDoc', 'IdDoc.id_factura', '=', 'Factura.id_factura')
		->where('Factura.id_proveedor', '=', $user['id_proveedor'])
		->where('noFactura', 'like', "%$noFactura%")
		->select(DB::raw('Factura.id_factura, IdDoc.serie, Factura.noFactura, IdDoc.uUID, Factura.rFCRecep'))->get();



		return Response::json ( array (
			'success' => true,
			'facturas' => $facturas
		));
	}


	public function obtenerPaises(){

		$paises = Pais::where('status', '=', 1)->get();

		return Response::json ( array (
				'success' => true,
				'paises' => $paises->toArray()
		));
	}


	public function facturar(Request $request){

		ini_set('default_socket_timeout', 250);

		$factura = $request->input('factura');
		$user = $request->input('user');
		$proveedor = Proveedor::find($user['id_proveedor']);
		$nombreArchivo = '';


		$timeStamp = date("Y-m-d H:i:s" , strtotime("-2 minutes"));
		$noFactura = DB::select("SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $user['id_proveedor'] . " AND i.serie = '" . $factura['serie'] ."'")[0];
		$noFactura->noFactura++;
		$certificadoHaUsar = CertificadoProveedor::where('id_proveedor', '=', $user['id_proveedor'])->where('status', '=', 1)->first();

		$datosFactura = new \stdClass();
		$datosFactura->timeStamp = $timeStamp;
		$datosFactura->tipoDeComprobante = $factura['tipoDocumento'];
		$datosFactura->serie = $factura['serie'];
		$datosFactura->folio = $noFactura->noFactura;
		$datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
		$datosFactura->certificado = $certificadoHaUsar->certificado;
		$datosFactura->mntBase = $factura['base'];
		$datosFactura->subtotal = $factura['subtotal'];
		$datosFactura->moneda = $factura['moneda'];
		$datosFactura->total = $factura['total'];
		$datosFactura->formaPago = $factura['formaPago'];
		$datosFactura->descuento = $factura['descuento'];
		$datosFactura->precission = $factura['decimales'];
		$datosFactura->tipoCambio = $factura['tipoCambio'];
		$datosFactura->lugarExpedicion = Utils::deleteExtraSpaces($factura['lugarExpedicion']);
		$datosFactura->usoCFDI = $factura['usoCFDI'];
		$datosFactura->metodoDePago = $factura['metodoDePago'];
		$datosFactura->condicionesDePago = (isset($factura['condicionesPago']))? Utils::deleteExtraSpaces($factura['condicionesPago']) : '';
		$datosFactura->cuentaPredial = (isset($factura['cuentaPredial']))? Utils::deleteExtraSpaces($factura['cuentaPredial']) : '';
		$datosFactura->tipoFacturasRelacionadas = $factura['facturasRelacionadas']['tipoRelacion'];
		$datosFactura->rFCEmisor = $proveedor->rFCEmisor;
		$datosFactura->nmbEmisor = $proveedor->nmbEmisor;
		$datosFactura->rFCRecep = $factura['id_cliente']['rFCRecep'];
		$datosFactura->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
		$datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
		$datosFactura->numRegIdTrib = isset($factura['numRegIdTrib'])? $factura['numRegIdTrib'] : '';
		$datosFactura->pais = isset($factura['pais'])? $factura['pais'] : '';
		$datosFactura->tipoPersona = $proveedor->tipoPersona;


		$datosFactura->conceptos = [ ];
		$datosFactura->impuestosTrasladados = [ ];
		$datosFactura->impuestosRetenidos = [ ];
		$datosFactura->impuestosTrasladadosLcl = [ ];
		$datosFactura->impuestosTrasladadosLclTotal = 0;
		$datosFactura->impuestosRetenidosLcl = [ ];
		$datosFactura->impuestosRetenidosLclTotal = 0;
		$totalImpRetenidos = 0;
		$totalImpTrasladados = 0;

		foreach ( $factura ['detalles'] as $detalle ) {

			$concepto = new \stdClass ();
			$concepto->clave = $detalle ['clave'];
			$concepto->id_producto = isset($detalle ['id_producto'])? $detalle ['id_producto'] : 0;
			$concepto->cdgItem = Utils::deleteExtraSpaces ( $detalle ['codigo'] );
			$concepto->dscItem = Utils::deleteExtraSpaces ( $detalle ['nombre'] );
			$concepto->unmdItem = (isset ( $detalle ['unidad'] )) ? $detalle ['unidad'] : '';
			$concepto->qtyItem = $detalle ['qty'];
			$concepto->montoNetoItem = $detalle ['precioU'];
			$concepto->prcNetoItem = $detalle ['qty'] * $detalle ['precioU'];
			$concepto->descuento = $detalle ['descuento'];

			$concepto->impuestosTrasladados = [ ];

			$base = Utils::formatNumber((($detalle ['qty'] * $detalle ['precioU']) - $detalle ['descuento']), $factura['decimales']);
            foreach ( $factura ['impuestosTrasladados'] as $traslado ) {

				if ($traslado ['impuesto'] == 'XXX') {

					$impuestoLcl = new \stdClass ();
					$impuestoLcl->tipoImp = $traslado ['label'];
					$impuestoLcl->tasaImp = $traslado ['valor'];
					$impuestoLcl->tipo = 1;

					$importeImp = 0;
					if ($traslado ['factor'] == 'Tasa') {
					    $importeImp = $traslado ['valor'] * $base;
					} else if ($traslado ['factor'] == 'Cuota') {
						$importeImp = $traslado ['valor'];
					}

					$importeImp = Utils::formatNumber($importeImp, $factura['decimales']);

					$impuestoLcl->montoImp = $importeImp;


					$datosFactura->impuestosTrasladadosLclTotal += $importeImp;
					$datosFactura->impuestosTrasladadosLcl[] = $impuestoLcl;

				} else {

					$impuesto = new \stdClass ();
					$impuesto->base = $base;
					$impuesto->factor = $traslado ['factor'];
					$impuesto->tipoImp = $traslado ['impuesto'];
					$impuesto->tasaImp = $traslado ['valor'];
					$impuesto->tipo = 1;

					$importeImp = 0;
					if ($traslado ['factor'] == 'Tasa') {
						$importeImp = $traslado ['valor'] * $impuesto->base;
					} else if ($traslado ['factor'] == 'Cuota') {
						$importeImp = $traslado ['valor'];
					}

					$importeImp = Utils::formatNumber($importeImp, $factura['decimales']);

					$impuesto->montoImp = $importeImp;

					$totalImpTrasladados += $importeImp;

				$concepto->impuestosTrasladados[] = $impuesto;

				$isNuevo = true;
				if(count($datosFactura->impuestosTrasladados))
				foreach($datosFactura->impuestosTrasladados as $impuestoGeneral){


					if($impuesto->tipoImp == $impuestoGeneral->impuesto && $impuesto->factor == $impuestoGeneral->tipoFactor && $impuesto->tasaImp == $impuestoGeneral->tasaOCuota){
						$isNuevo = false;
						$impuestoGeneral->importe += $impuesto->montoImp;
						break;
					}
				}

				if($isNuevo && $traslado['factor'] != 'Exento'){
					$impuestoGeneral = new \stdClass();
					$impuestoGeneral->importe = $impuesto->montoImp;
					$impuestoGeneral->impuesto = $impuesto->tipoImp;
					$impuestoGeneral->tipoFactor = $traslado['factor'];
					$impuestoGeneral->tasaOCuota = $traslado['valor'];
					$datosFactura->impuestosTrasladados[] = $impuestoGeneral;
				}

				}
			}

			$concepto->impuestosRetenidos = [];

			foreach ($factura['impuestosRetenidos'] as $retencion){


				if ($retencion ['impuesto'] == 'XXX') {

					$impuestoLcl = new \stdClass ();
					$impuestoLcl->tipoImp = $retencion ['label'];
					$impuestoLcl->tasaImp = $retencion ['valor'];
					$impuestoLcl->tipo = 0;

					$importeImp = 0;
					if ($retencion ['factor'] == 'Tasa') {
					    $importeImp = $retencion ['valor'] * $base;
					} else if ($retencion ['factor'] == 'Cuota') {
						$importeImp = $retencion ['valor'];
					}

					$importeImp = Utils::formatNumber($importeImp, $factura['decimales']);

					$impuestoLcl->montoImp = $importeImp;

					$datosFactura->impuestosRetenidosLclTotal += $importeImp;
					$datosFactura->impuestosRetenidosLcl[] = $impuestoLcl;

				}else{

					$impuesto = new \stdClass();
					$impuesto->base = $base;
					$impuesto->factor = $retencion['factor'];
					$impuesto->tipoImp = $retencion['impuesto'];
					$impuesto->tasaImp = $retencion['valor'];
					$impuesto->tipo = 0;

					$importeImp = 0;
					if($retencion['factor'] == 'Tasa'){
						$importeImp = $retencion['valor'] * $impuesto->base;
					}else if($retencion['factor'] == 'Cuota'){
						$importeImp = $retencion['valor'];
					}

					$importeImp = Utils::formatNumber($importeImp, $factura['decimales']);

					$impuesto->montoImp = $importeImp;

					$totalImpRetenidos += $importeImp;

					$concepto->impuestosRetenidos[] = $impuesto;

					$isNuevo = true;
					if(count($datosFactura->impuestosRetenidos))
						foreach($datosFactura->impuestosRetenidos as $impuestoGeneral){
							if($impuesto->tipoImp == $impuestoGeneral->impuesto){
								$isNuevo = false;
								$impuestoGeneral->importe += $impuesto->montoImp;
								break;
							}
					}

					if($isNuevo && $retencion['factor'] != 'Exento'){
						$impuestoGeneral = new \stdClass();
						$impuestoGeneral->importe = $impuesto->montoImp;
						$impuestoGeneral->impuesto = $impuesto->tipoImp;
						$datosFactura->impuestosRetenidos[] = $impuestoGeneral;
					}

				}


			}

			$datosFactura->conceptos[] = $concepto;
		}


		$datosFactura->totalImpRetenidos = $totalImpRetenidos;
		$datosFactura->totalImpTrasladados = $totalImpTrasladados;

		$datosFactura->facturasRelacionadas = [];

		if(count($factura['facturasRelacionadas']['uuids']))
		foreach ($factura['facturasRelacionadas']['uuids'] as $facturaRelacionada){

			$relacionObj = new \stdClass();
			$relacionObj->uuid = $facturaRelacionada['uUID'];
			$datosFactura->facturasRelacionadas[] = $relacionObj;

		}

		$xml = XMLUtils::createXML33($datosFactura, $proveedor);

		$sello = $xml->query('//cfdi:Comprobante')[0]->getAttribute('Sello');

		$nombreArchivo = "$proveedor->rFCEmisor-" .date('YmdHis');

		file_put_contents("tmp/$nombreArchivo.xml", $xml);

		$base64Comprobante = base64_encode($xml);

		require_once('Commands/lib/nusoap.php');

		$urlTimbrado = "https://timbracfdi33.mx:1443/Timbrado.asmx?wsdl";
		$usuarioIntegrador = "vb9+kzunCtCXL+WQEvBsCQ==";

		if($proveedor->id_proveedor == 3){

			$urlTimbrado = "https://stagecfdi.facturadorelectronico.com/wstimbrado/timbrado.asmx?WSDL";
			$usuarioIntegrador = "test";
			$password = "TEST";
		}

		$params = array();
		$params['Usuario'] = $usuarioIntegrador;
		$params['CFDIcliente'] = $xml;
		$params['password'] = $password;


		$client = new SoapClient($urlTimbrado, array('encoding'=>'UTF-8', "connection_timeout" => 250));
		$client->soap_defencoding = "UTF-8";
		$result = $client->__soapCall ( 'obtenerTimbrado', $params);

		print_r($result);
		exit;

		$resultado = $result->TimbraCFDIResult->anyType;


		$logToSave = print_r($resultado, true);

		Log::error($logToSave);

		$log = env('DIR_LOGS')."/" . date ( "Y-m-d" ) . ".log";
		$fp = fopen ( $log, "a" );
		fwrite ( $fp, "\n\n===".date("Y-m-d:H:i:s"). "\n\n" );
		fwrite ( $fp, "\n\n$nombreArchivo\n\n" );
		fwrite ( $fp, $logToSave );
		fwrite ( $fp, "\n\n===" );
		fclose ( $fp );

		$success = false;
		$errorCode = 0;
		$errortext = '';
		$facturaResult = '';

		if($resultado[1] == '0'){
			$success = true;


			$xmlTimbrado = new \DOMDocument("1.0", "uft-8");
			$xmlTimbrado->loadXML($resultado[3]);

			$idDoc = new IdDoc();

			$timbreFiscal = $xmlTimbrado->getElementsByTagName ( 'TimbreFiscalDigital' );

			foreach ( $timbreFiscal as $timbreFiscal ) {

				$fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$fechaTimbradoArray = explode(".",$fechaTimbrado);

				$idDoc->version = $timbreFiscal->getAttribute ( 'Version' );
				$idDoc->fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$idDoc->selloCFD = $timbreFiscal->getAttribute ( 'SelloCFD' );
				$idDoc->noCertificadoSAT = $timbreFiscal->getAttribute ( 'NoCertificadoSAT' );
				$idDoc->selloSAT = $timbreFiscal->getAttribute ( 'SelloSAT' );
				$idDoc->uUID = $timbreFiscal->getAttribute ( 'UUID' );
				$idDoc->sello = $sello;
				$idDoc->rfcProvCertif = $timbreFiscal->getAttribute ( 'RfcProvCertif' );
			}

			$isPagado = 0;
			if($factura['metodoDePago'] == 'PUE')
				$isPagado = 1;

			$facturaObj = new Factura();
			$facturaObj->id_proveedor = $user['id_proveedor'];
			$facturaObj->id_cliente = $factura['id_cliente']['id_cliente'];
			$facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
			$facturaObj->nmbEmisor = $proveedor->nmbEmisor;
			$facturaObj->rFCEmisor = $proveedor->rFCEmisor;
			$facturaObj->nmbRecep = $factura['id_cliente']['nmbRecep'];
			$facturaObj->rFCRecep = $factura['id_cliente']['rFCRecep'];
			$facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
			$facturaObj->timeStamp = $timeStamp;
			$facturaObj->noFactura = $noFactura->noFactura;
			$facturaObj->version = "3.3";
			$facturaObj->generadoPor = 3;
			$facturaObj->nota = (isset($factura['comentario']))? Utils::deleteExtraSpaces($factura['comentario']) : '';
			$facturaObj->tipoDeComprobante = $factura['tipoDocumento'];
			$facturaObj->precission = $factura['decimales'];
			$facturaObj->status = 1;
			$facturaObj->isPagado = $isPagado;
			$facturaObj->numRegIdTrib = $datosFactura->numRegIdTrib;
			$facturaObj->pais = $datosFactura->pais;
			$facturaObj->save();


			$idDoc->id_factura = $facturaObj->id_factura;
			$idDoc->serie = $factura['serie'];
			$idDoc->folio = $noFactura->noFactura;
			$idDoc->formaPago = $factura['formaPago'];
			$idDoc->condicionesDePago = (isset($factura['condicionesPago']))? Utils::deleteExtraSpaces($factura['condicionesPago']) : '';
			$idDoc->lugarExpedicion = Utils::deleteExtraSpaces($factura['lugarExpedicion']);
			$idDoc->usoCFDI = $factura['usoCFDI'];
			$idDoc->metodoDePago = $factura['metodoDePago'];
			$idDoc->sello = $sello;
			$idDoc->tipoFacturasRelacionadas = $datosFactura->tipoFacturasRelacionadas;
			$idDoc->save();


			$totales = new Totales();
			$totales->id_factura = $facturaObj->id_factura;
			$totales->moneda = $factura['moneda'];
			$totales->tipoCambio = $factura['tipoCambio'];
			$totales->subTotal = $factura['subtotal'];
			$totales->mntBase = $factura['base'];
			$totales->vlrPagar = $factura['total'];
			$totales->descuento = $factura['descuento'];
			$totales->save();

			$detalles = array();

			foreach ($datosFactura->conceptos as $concepto){

				$conceptoObj = new Concepto();
				$conceptoObj->clave = $concepto->clave;
				$conceptoObj->cdgItem = $concepto->cdgItem;
				$conceptoObj->dscItem = $concepto->dscItem;
				$conceptoObj->unmdItem = $concepto->unmdItem;
				$conceptoObj->qtyItem = $concepto->qtyItem;
				$conceptoObj->montoNetoItem = $concepto->montoNetoItem;
				$conceptoObj->prcNetoItem = $concepto->prcNetoItem;
				$conceptoObj->descuento = $concepto->descuento;
				$conceptoObj->id_factura = $facturaObj->id_factura;
				$conceptoObj->save();

				if(isset($factura['guardarProd']) && $factura['guardarProd'] == true){

					if($concepto->id_producto > 0){
						$concepto2Obj = Producto::find($concepto->id_producto);
					}else{
						$concepto2Obj = new Producto();
					}

				    $concepto2Obj->id_proveedor = $user['id_proveedor'];
				    $concepto2Obj->clave = $concepto->clave;
				    $concepto2Obj->nombre = $concepto->dscItem;
				    $concepto2Obj->precioU = $concepto->montoNetoItem;
				    $concepto2Obj->unidad = $concepto->unmdItem;
				    $concepto2Obj->codigo = $concepto->cdgItem;
				    $concepto2Obj->status = 1;
				    $concepto2Obj->save();

				}


				foreach ($concepto->impuestosTrasladados as $impuesto){

					$impuestoObj = new ExImpuestos();
					$impuestoObj->base = $impuesto->base;
					$impuestoObj->factor = $impuesto->factor;
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_detalle = $conceptoObj->id_detalle;
					$impuestoObj->save();
				}

				foreach ($concepto->impuestosRetenidos as $impuesto){

					$impuestoObj = new ExImpuestos();
					$impuestoObj->base = $impuesto->base;
					$impuestoObj->factor = $impuesto->factor;
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_detalle = $conceptoObj->id_detalle;
					$impuestoObj->save();
				}
			}

			foreach ($datosFactura->facturasRelacionadas as $facturaRelacionada){

				$facturaRelacionadaObj = new FacturasRelacionadas();
				$facturaRelacionadaObj->id_factura = $facturaObj->id_factura;
				$facturaRelacionadaObj->uuid = $facturaRelacionada->uuid;
				$facturaRelacionadaObj->save();

			}


			if(count($datosFactura->impuestosRetenidosLcl) > 0)
			foreach ($datosFactura->impuestosRetenidosLcl as $impuesto){

				$impuestoObj = new ExImpuestos();
				$impuestoObj->tipoImp = $impuesto->tipoImp;
				$impuestoObj->tasaImp = $impuesto->tasaImp;
				$impuestoObj->tipo = $impuesto->tipo;
				$impuestoObj->montoImp = $impuesto->montoImp;
				$impuestoObj->id_factura = $facturaObj->id_factura;
				$impuestoObj->save();
			}

			if(count($datosFactura->impuestosTrasladadosLcl) > 0)
			foreach ($datosFactura->impuestosTrasladadosLcl as $impuesto){

				$impuestoObj = new ExImpuestos();
				$impuestoObj->tipoImp = $impuesto->tipoImp;
				$impuestoObj->tasaImp = $impuesto->tasaImp;
				$impuestoObj->tipo = $impuesto->tipo;
				$impuestoObj->montoImp = $impuesto->montoImp;
				$impuestoObj->id_factura = $facturaObj->id_factura;
				$impuestoObj->save();
			}

			if($datosFactura->cuentaPredial != ''){

				$arrendamiento = new Arrendamiento();
				$arrendamiento->id_factura = $facturaObj->id_factura;
				$arrendamiento->cuentaPredial = $datosFactura->cuentaPredial;
				$arrendamiento->save();

			}


			$facturaResult = $datosFactura->serie . $datosFactura->folio;


		}else{


			$errorCode = 10001;
			$errorMsg = 'Hubo un error al crear su factura. Vuelva a intentarlo.';

			if(isset($resultado[6])){

					$errorCode = $resultado[6];
					switch ($resultado[6]){
						case 330037:
							$errorMsg = "Este RFC del receptor no existe en la lista de RFC inscritos no cancelados del SAT. Puede que su cliente tenga algún bloqueo.";
							break;
						case 330007:
							$errorMsg = "Es necesario que agregue vaya a la sección de Mis Datos y actualice su régimen fiscal.";
							break;
						case 330171:
							$errorMsg = "Se debe seleccionar un Uso de CFDI para realizar la factura.";
							break;
						case 305:
							$errorMsg = "Su certificado de sellos digitales ha vencido, es necesario que genere uno nuevo en el portal del SAT.";
							break;
						default:
							$errorMsg = $resultado[7];
				}
			}

			$errortext = $errorMsg;
		}





		return Response::json ( array (
			'success' => $success,
			'errorCode' => $errorCode,
			'errortext' => $errortext,
			'facturaResult' => $facturaResult,
		    'nombreArchivo' => $nombreArchivo
		));

	}




	public function facturarPorConcepto(Request $request){

		ini_set('default_socket_timeout', 250);

		$factura = $request->input('factura');
		$user = $request->input('user');
		$proveedor = Proveedor::find($user['id_proveedor']);
		$nombreArchivo = '';


		$timeStamp = date("Y-m-d H:i:s" , strtotime("-2 minutes"));
		$noFactura = DB::select("SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $user['id_proveedor'] . " AND i.serie = '" . $factura['serie'] ."'")[0];
		$noFactura->noFactura++;
		$certificadoHaUsar = CertificadoProveedor::where('id_proveedor', '=', $user['id_proveedor'])->where('status', '=', 1)->first();

		$datosFactura = new \stdClass();
		$datosFactura->timeStamp = $timeStamp;
		$datosFactura->tipoDeComprobante = $factura['tipoDocumento'];
		$datosFactura->serie = $factura['serie'];
		$datosFactura->folio = $noFactura->noFactura;
		$datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
		$datosFactura->certificado = $certificadoHaUsar->certificado;
		$datosFactura->mntBase = $factura['base'];
		$datosFactura->subtotal = $factura['subtotal'];
		$datosFactura->moneda = $factura['moneda'];
		$datosFactura->total = $factura['total'];
		$datosFactura->formaPago = $factura['formaPago'];
		$datosFactura->descuento = $factura['descuento'];
		$datosFactura->precission = $factura['decimales'];
		$datosFactura->tipoCambio = $factura['tipoCambio'];
		$datosFactura->lugarExpedicion = Utils::deleteExtraSpaces($factura['lugarExpedicion']);
		$datosFactura->usoCFDI = $factura['usoCFDI'];
		$datosFactura->metodoDePago = $factura['metodoDePago'];
		$datosFactura->condicionesDePago = (isset($factura['condicionesPago']))? Utils::deleteExtraSpaces($factura['condicionesPago']) : '';
		$datosFactura->cuentaPredial = (isset($factura['cuentaPredial']))? Utils::deleteExtraSpaces($factura['cuentaPredial']) : '';
		$datosFactura->tipoFacturasRelacionadas = $factura['facturasRelacionadas']['tipoRelacion'];
		$datosFactura->rFCEmisor = $proveedor->rFCEmisor;
		$datosFactura->nmbEmisor = $proveedor->nmbEmisor;
		$datosFactura->rFCRecep = $factura['id_cliente']['rFCRecep'];
		$datosFactura->nmbRecep = $factura ['id_cliente'] ['nmbRecep'];
		$datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
		$datosFactura->numRegIdTrib = isset($factura['numRegIdTrib'])? $factura['numRegIdTrib'] : '';
		$datosFactura->pais = isset($factura['pais'])? $factura['pais'] : '';
		$datosFactura->tipoPersona = $proveedor->tipoPersona;

		$datosFactura->conceptos = [ ];
		$datosFactura->impuestosTrasladados = [ ];
		$datosFactura->impuestosRetenidos = [ ];
		$datosFactura->impuestosTrasladadosLcl = [ ];
		$datosFactura->impuestosTrasladadosLclTotal = 0;
		$datosFactura->impuestosRetenidosLcl = [ ];
		$datosFactura->impuestosRetenidosLclTotal = 0;
		$totalImpRetenidos = 0;
		$totalImpTrasladados = 0;

		foreach ( $factura ['detalles'] as $detalle ) {

			$concepto = new \stdClass ();
			$concepto->clave = $detalle ['clave'];
			$concepto->id_producto = isset($detalle ['id_producto'])? $detalle ['id_producto'] : 0;
			$concepto->cdgItem = Utils::deleteExtraSpaces ( $detalle ['codigo'] );
			$concepto->dscItem = Utils::deleteExtraSpaces ( $detalle ['nombre'] );
			$concepto->unmdItem = (isset ( $detalle ['unidad'] )) ? $detalle ['unidad'] : '';
			$concepto->qtyItem = $detalle ['qty'];
			$concepto->montoNetoItem = $detalle ['precioU'];
			$concepto->prcNetoItem = $detalle ['qty'] * $detalle ['precioU'];
			$concepto->descuento = $detalle ['descuento'];

			$concepto->impuestosTrasladados = [ ];

			$base = Utils::formatNumber((($detalle ['qty'] * $detalle ['precioU']) - $detalle ['descuento']), $factura['decimales']);
			foreach ( $detalle ['impuestosTrasladados'] as $traslado ) {

				if ($traslado ['impuesto'] == 'XXX') {

					$impuestoLcl = new \stdClass ();
					$impuestoLcl->tipoImp = $traslado ['label'];
					$impuestoLcl->tasaImp = $traslado ['valor'];
					$impuestoLcl->tipo = 1;


					$importeImp = Utils::formatNumber($traslado['total'], $factura['decimales']);

					$impuestoLcl->montoImp = $importeImp;

					$datosFactura->impuestosTrasladadosLclTotal += $importeImp;
					$datosFactura->impuestosTrasladadosLcl[] = $impuestoLcl;

				} else {

					$impuesto = new \stdClass ();
					$impuesto->base = $traslado ['base'];
					$impuesto->factor = $traslado ['factor'];
					$impuesto->tipoImp = $traslado ['impuesto'];
					$impuesto->tasaImp = $traslado ['valor'];
					$impuesto->tipo = 1;

					$importeImp = Utils::formatNumber($traslado['total'], $factura['decimales']);

					$impuesto->montoImp = $importeImp;

					$totalImpTrasladados += $importeImp;

					$concepto->impuestosTrasladados[] = $impuesto;

					$isNuevo = true;
					if(count($datosFactura->impuestosTrasladados))
						foreach($datosFactura->impuestosTrasladados as $impuestoGeneral){


							if($impuesto->tipoImp == $impuestoGeneral->impuesto && $impuesto->factor == $impuestoGeneral->tipoFactor && $impuesto->tasaImp == $impuestoGeneral->tasaOCuota){
								$isNuevo = false;
								$impuestoGeneral->importe += $impuesto->montoImp;
								break;
							}
					}

					if($isNuevo && $traslado['factor'] != 'Exento'){
						$impuestoGeneral = new \stdClass();
						$impuestoGeneral->importe = $impuesto->montoImp;
						$impuestoGeneral->impuesto = $impuesto->tipoImp;
						$impuestoGeneral->tipoFactor = $traslado['factor'];
						$impuestoGeneral->tasaOCuota = $traslado['valor'];
						$datosFactura->impuestosTrasladados[] = $impuestoGeneral;
					}

				}
			}

			$concepto->impuestosRetenidos = [];

			foreach ($detalle['impuestosRetenidos'] as $retencion){


				if ($retencion ['impuesto'] == 'XXX') {

					$impuestoLcl = new \stdClass ();
					$impuestoLcl->tipoImp = $retencion ['label'];
					$impuestoLcl->tasaImp = $retencion ['valor'];
					$impuestoLcl->tipo = 0;

					$importeImp = Utils::formatNumber($retencion ['total'], $factura['decimales']);

					$impuestoLcl->montoImp = $importeImp;

					$datosFactura->impuestosRetenidosLclTotal += $importeImp;
					$datosFactura->impuestosRetenidosLcl[] = $impuestoLcl;

				}else{

					$impuesto = new \stdClass();
					$impuesto->base = $retencion ['base'];
					$impuesto->factor = $retencion['factor'];
					$impuesto->tipoImp = $retencion['impuesto'];
					$impuesto->tasaImp = $retencion['valor'];
					$impuesto->tipo = 0;

					$importeImp = Utils::formatNumber($retencion ['total'], $factura['decimales']);

					$impuesto->montoImp = $importeImp;

					$totalImpRetenidos += $importeImp;

					$concepto->impuestosRetenidos[] = $impuesto;

					$isNuevo = true;
					if(count($datosFactura->impuestosRetenidos))
						foreach($datosFactura->impuestosRetenidos as $impuestoGeneral){
							if($impuesto->tipoImp == $impuestoGeneral->impuesto){
								$isNuevo = false;
								$impuestoGeneral->importe += $impuesto->montoImp;
								break;
							}
					}

					if($isNuevo && $retencion['factor'] != 'Exento'){
						$impuestoGeneral = new \stdClass();
						$impuestoGeneral->importe = $impuesto->montoImp;
						$impuestoGeneral->impuesto = $impuesto->tipoImp;
						$datosFactura->impuestosRetenidos[] = $impuestoGeneral;
					}

				}


			}

			$datosFactura->conceptos[] = $concepto;
		}


		$datosFactura->totalImpRetenidos = $totalImpRetenidos;
		$datosFactura->totalImpTrasladados = $totalImpTrasladados;

		$datosFactura->facturasRelacionadas = [];

		if(count($factura['facturasRelacionadas']['uuids']))
			foreach ($factura['facturasRelacionadas']['uuids'] as $facturaRelacionada){

				$relacionObj = new \stdClass();
				$relacionObj->uuid = $facturaRelacionada['uUID'];
				$datosFactura->facturasRelacionadas[] = $relacionObj;

		}

		$xml = XMLUtils::createXML33($datosFactura, $proveedor);

		$sello = $xml->query('//cfdi:Comprobante')[0]->getAttribute('Sello');

		$nombreArchivo = "$proveedor->rFCEmisor-" .date('YmdHis');

		file_put_contents("tmp/$nombreArchivo.xml", $xml);

		$base64Comprobante = base64_encode($xml);

		$urlTimbrado = "https://timbracfdi33.mx:1443/Timbrado.asmx?wsdl";
		$usuarioIntegrador = "vb9+kzunCtCXL+WQEvBsCQ==";

		if($proveedor->id_proveedor == 17){

			$urlTimbrado = "https://cfdi33-pruebas.buzoncfdi.mx:1443/Timbrado.asmx?wsdl";
			$usuarioIntegrador = "mvpNUXmQfK8=";

		}

		$params = array();
		$params['usuarioIntegrador'] = $usuarioIntegrador;
		$params['xmlComprobanteBase64'] = $base64Comprobante;
		$params['idComprobante'] = rand(5, 999999);


		$client = new SoapClient($urlTimbrado, array('encoding'=>'UTF-8', "connection_timeout" => 250));
		$client->soap_defencoding = "UTF-8";
		$result = $client->__soapCall ( 'TimbraCFDI',array('parameters' => $params) );

		$resultado = $result->TimbraCFDIResult->anyType;


		$logToSave = print_r($resultado, true);

		$log = env('DIR_LOGS')."/" . date ( "Y-m-d" ) . ".log";
		$fp = fopen ( $log, "a" );
		fwrite ( $fp, "\n\n===".date("Y-m-d:H:i:s"). "\n\n" );
		fwrite ( $fp, "\n\n$nombreArchivo\n\n" );
		fwrite ( $fp, $logToSave );
		fwrite ( $fp, "\n\n===" );
		fclose ( $fp );

		$success = false;
		$errorCode = 0;
		$errortext = '';
		$facturaResult = '';

		if($resultado[1] == '0'){
			$success = true;


			$xmlTimbrado = new \DOMDocument("1.0", "uft-8");
			$xmlTimbrado->loadXML($resultado[3]);

			$idDoc = new IdDoc();

			$timbreFiscal = $xmlTimbrado->getElementsByTagName ( 'TimbreFiscalDigital' );

			foreach ( $timbreFiscal as $timbreFiscal ) {

				$fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$fechaTimbradoArray = explode(".",$fechaTimbrado);

				$idDoc->version = $timbreFiscal->getAttribute ( 'Version' );
				$idDoc->fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$idDoc->selloCFD = $timbreFiscal->getAttribute ( 'SelloCFD' );
				$idDoc->noCertificadoSAT = $timbreFiscal->getAttribute ( 'NoCertificadoSAT' );
				$idDoc->selloSAT = $timbreFiscal->getAttribute ( 'SelloSAT' );
				$idDoc->uUID = $timbreFiscal->getAttribute ( 'UUID' );
				$idDoc->sello = $sello;
				$idDoc->rfcProvCertif = $timbreFiscal->getAttribute ( 'RfcProvCertif' );
			}

			$isPagado = 0;
			if($factura['metodoDePago'] == 'PUE')
				$isPagado = 1;

				$facturaObj = new Factura();
				$facturaObj->id_proveedor = $user['id_proveedor'];
				$facturaObj->id_cliente = $factura['id_cliente']['id_cliente'];
				$facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
				$facturaObj->nmbEmisor = $proveedor->nmbEmisor;
				$facturaObj->rFCEmisor = $proveedor->rFCEmisor;
				$facturaObj->nmbRecep = $factura['id_cliente']['nmbRecep'];
				$facturaObj->rFCRecep = $factura['id_cliente']['rFCRecep'];
				$facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
				$facturaObj->timeStamp = $timeStamp;
				$facturaObj->noFactura = $noFactura->noFactura;
				$facturaObj->version = "3.3";
				$facturaObj->generadoPor = 3;
				$facturaObj->nota = (isset($factura['comentario']))? Utils::deleteExtraSpaces($factura['comentario']) : '';
				$facturaObj->tipoDeComprobante = $factura['tipoDocumento'];
				$facturaObj->precission = $factura['decimales'];
				$facturaObj->status = 1;
				$facturaObj->isPagado = $isPagado;
				$facturaObj->save();


				$idDoc->id_factura = $facturaObj->id_factura;
				$idDoc->serie = $factura['serie'];
				$idDoc->folio = $noFactura->noFactura;
				$idDoc->formaPago = $factura['formaPago'];
				$idDoc->condicionesDePago = (isset($factura['condicionesPago']))? Utils::deleteExtraSpaces($factura['condicionesPago']) : '';
				$idDoc->lugarExpedicion = Utils::deleteExtraSpaces($factura['lugarExpedicion']);
				$idDoc->usoCFDI = $factura['usoCFDI'];
				$idDoc->metodoDePago = $factura['metodoDePago'];
				$idDoc->sello = $sello;
				$idDoc->tipoFacturasRelacionadas = $datosFactura->tipoFacturasRelacionadas;
				$idDoc->save();


				$totales = new Totales();
				$totales->id_factura = $facturaObj->id_factura;
				$totales->moneda = $factura['moneda'];
				$totales->tipoCambio = $factura['tipoCambio'];
				$totales->subTotal = $factura['subtotal'];
				$totales->mntBase = $factura['base'];
				$totales->vlrPagar = $factura['total'];
				$totales->descuento = $factura['descuento'];
				$totales->save();

				$detalles = array();

				foreach ($datosFactura->conceptos as $concepto){

					$conceptoObj = new Concepto();
					$conceptoObj->clave = $concepto->clave;
					$conceptoObj->cdgItem = $concepto->cdgItem;
					$conceptoObj->dscItem = $concepto->dscItem;
					$conceptoObj->unmdItem = $concepto->unmdItem;
					$conceptoObj->qtyItem = $concepto->qtyItem;
					$conceptoObj->montoNetoItem = $concepto->montoNetoItem;
					$conceptoObj->prcNetoItem = $concepto->prcNetoItem;
					$conceptoObj->descuento = $concepto->descuento;
					$conceptoObj->id_factura = $facturaObj->id_factura;
					$conceptoObj->save();

					if(isset($factura['guardarProd']) && $factura['guardarProd'] == true){

						if($concepto->id_producto > 0){
							$concepto2Obj = Producto::find($concepto->id_producto);
						}else{
							$concepto2Obj = new Producto();
						}

						$concepto2Obj->id_proveedor = $user['id_proveedor'];
						$concepto2Obj->clave = $concepto->clave;
						$concepto2Obj->nombre = $concepto->dscItem;
						$concepto2Obj->precioU = $concepto->montoNetoItem;
						$concepto2Obj->unidad = $concepto->unmdItem;
						$concepto2Obj->codigo = $concepto->cdgItem;
						$concepto2Obj->status = 1;
						$concepto2Obj->save();

					}


					foreach ($concepto->impuestosTrasladados as $impuesto){

						$impuestoObj = new ExImpuestos();
						$impuestoObj->base = $impuesto->base;
						$impuestoObj->factor = $impuesto->factor;
						$impuestoObj->tipoImp = $impuesto->tipoImp;
						$impuestoObj->tasaImp = $impuesto->tasaImp;
						$impuestoObj->tipo = $impuesto->tipo;
						$impuestoObj->montoImp = $impuesto->montoImp;
						$impuestoObj->id_detalle = $conceptoObj->id_detalle;
						$impuestoObj->save();
					}

					foreach ($concepto->impuestosRetenidos as $impuesto){

						$impuestoObj = new ExImpuestos();
						$impuestoObj->base = $impuesto->base;
						$impuestoObj->factor = $impuesto->factor;
						$impuestoObj->tipoImp = $impuesto->tipoImp;
						$impuestoObj->tasaImp = $impuesto->tasaImp;
						$impuestoObj->tipo = $impuesto->tipo;
						$impuestoObj->montoImp = $impuesto->montoImp;
						$impuestoObj->id_detalle = $conceptoObj->id_detalle;
						$impuestoObj->save();
					}
				}

				foreach ($datosFactura->facturasRelacionadas as $facturaRelacionada){

					$facturaRelacionadaObj = new FacturasRelacionadas();
					$facturaRelacionadaObj->id_factura = $facturaObj->id_factura;
					$facturaRelacionadaObj->uuid = $facturaRelacionada->uuid;
					$facturaRelacionadaObj->save();

				}


				if(count($datosFactura->impuestosRetenidosLcl) > 0)
					foreach ($datosFactura->impuestosRetenidosLcl as $impuesto){

						$impuestoObj = new ExImpuestos();
						$impuestoObj->tipoImp = $impuesto->tipoImp;
						$impuestoObj->tasaImp = $impuesto->tasaImp;
						$impuestoObj->tipo = $impuesto->tipo;
						$impuestoObj->montoImp = $impuesto->montoImp;
						$impuestoObj->id_factura = $facturaObj->id_factura;
						$impuestoObj->save();
				}

				if(count($datosFactura->impuestosTrasladadosLcl) > 0)
					foreach ($datosFactura->impuestosTrasladadosLcl as $impuesto){

						$impuestoObj = new ExImpuestos();
						$impuestoObj->tipoImp = $impuesto->tipoImp;
						$impuestoObj->tasaImp = $impuesto->tasaImp;
						$impuestoObj->tipo = $impuesto->tipo;
						$impuestoObj->montoImp = $impuesto->montoImp;
						$impuestoObj->id_factura = $facturaObj->id_factura;
						$impuestoObj->save();
				}

				if($datosFactura->cuentaPredial != ''){

					$arrendamiento = new Arrendamiento();
					$arrendamiento->id_factura = $facturaObj->id_factura;
					$arrendamiento->cuentaPredial = $datosFactura->cuentaPredial;
					$arrendamiento->save();

				}


				$facturaResult = $datosFactura->serie . $datosFactura->folio;


		}else{
			$errorCode = $resultado[6];
			$errortext = $resultado[7];
		}





		return Response::json ( array (
				'success' => $success,
				'errorCode' => $errorCode,
				'errortext' => $errortext,
				'facturaResult' => $facturaResult,
				'nombreArchivo' => $nombreArchivo
		));

	}




	public function facturarPago(Request $request){


		ini_set('default_socket_timeout', 250);

		$factura = $request->input('factura');
		$user = $request->input('user');
		$proveedor = Proveedor::find($user['id_proveedor']);


		$timeStamp = date("Y-m-d H:i:s" , strtotime("-2 minutes"));
		$noFactura = DB::select("SELECT MAX(noFactura) as noFactura FROM Factura f JOIN IdDoc i ON f.id_factura = i.id_factura WHERE id_proveedor = " . $user['id_proveedor'] . " AND i.serie = '" . $factura['serie'] ."'")[0];
		$noFactura->noFactura++;
		$certificadoHaUsar = CertificadoProveedor::where('id_proveedor', '=', $user['id_proveedor'])->where('status', '=', 1)->first();

		$datosFactura = new \stdClass();
		$datosFactura->timeStamp = $timeStamp;
		$datosFactura->tipoDeComprobante = 'P';
		$datosFactura->serie = $factura['serie'];
		$datosFactura->folio = $noFactura->noFactura;
		$datosFactura->noCertificado = $certificadoHaUsar->noCertificado;
		$datosFactura->certificado = $certificadoHaUsar->certificado;
		$datosFactura->mntBase = 0;
		$datosFactura->subtotal = 0;
		$datosFactura->moneda = 'XXX';
		$datosFactura->total = 0;
		$datosFactura->formaPago = '';
		$datosFactura->condicionesDePago = '';
		$datosFactura->descuento = 0;
		$datosFactura->precission = 0;
		$datosFactura->tipoCambio = 1;
		$datosFactura->lugarExpedicion = Utils::deleteExtraSpaces($factura['lugarExpedicion']);
		$datosFactura->usoCFDI = 'P01';
		$datosFactura->metodoDePago = '';
		$datosFactura->condicionesDePago = '';
		$datosFactura->tipoFacturasRelacionadas = $factura['facturasRelacionadas']['tipoRelacion'];
		$datosFactura->rFCEmisor = $proveedor->rFCEmisor;
		$datosFactura->nmbEmisor = $proveedor->nmbEmisor;
		$datosFactura->rFCRecep = $factura['id_cliente']['rFCRecep'];
		$datosFactura->nmbRecep = $factura['id_cliente']['nmbRecep'];
		$datosFactura->regimenFiscal = $proveedor->regimenFiscal33;
		$datosFactura->numRegIdTrib = isset($factura['numRegIdTrib'])? $factura['numRegIdTrib'] : '';
		$datosFactura->pais = isset($factura['pais'])? $factura['pais'] : '';
		$datosFactura->tipoPersona = $proveedor->tipoPersona;


		$datosFactura->conceptos = [];
		$datosFactura->impuestosTrasladados = [];
		$datosFactura->impuestosRetenidos = [];
		$totalImpRetenidos = 0;
		$totalImpTrasladados = 0;

		$detalle =  array('clave' => '84111506', 'codigo' => '', 'nombre' => 'Pago', 'unidad' => 'ACT', 'qty' => 1, 'precioU' => 0, 'descuento' => 0);
		$factura['detalles'] = [];
		$factura['detalles'][] = $detalle;

		foreach ($factura['detalles'] as $detalle){

			$concepto = new \stdClass();
			$concepto->clave = $detalle['clave'];
			$concepto->cdgItem = Utils::deleteExtraSpaces($detalle['codigo']);
			$concepto->dscItem = Utils::deleteExtraSpaces($detalle['nombre']);
			$concepto->unmdItem = (isset($detalle['unidad']))? $detalle['unidad'] : '';
			$concepto->qtyItem = $detalle['qty'];
			$concepto->montoNetoItem = $detalle['precioU'];
			$concepto->prcNetoItem = $detalle['qty'] * $detalle['precioU'];
			$concepto->descuento = $detalle['descuento'];

			$concepto->impuestosTrasladados = [];
			$concepto->impuestosRetenidos = [];
			$datosFactura->conceptos[] = $concepto;
		}

		$datosFactura->pagos = [];
		foreach ($factura['pagos'] as $pago){

			$pagoObj = new \stdClass();
			$pagoObj->FechaPago = $pago['fechaPago'];
			$pagoObj->FormaDePagoP = $pago['formaPago'];
			$pagoObj->MonedaP = $pago['moneda'];
			$pagoObj->TipoCambioP = $pago['tipoCambio'];
			$pagoObj->Monto = $pago['totalPago'];

			$pagoObj->documentosRelacionado = [];

			foreach ($pago['documentoRelacionado'] as $documentoRelacionado){

				$doctoRelacionado = new \stdClass();
				$doctoRelacionado->IdDocumento = $documentoRelacionado['uuid'];
				$doctoRelacionado->MonedaDR = $documentoRelacionado['moneda'];
				$doctoRelacionado->TipoCambioDR = $documentoRelacionado['tipoCambio'];
				$doctoRelacionado->MetodoDePagoDR = 'PPD';
				$doctoRelacionado->NumParcialidad = $documentoRelacionado['parcialidad'];
				$doctoRelacionado->ImpSaldoAnt = $documentoRelacionado['saldoAnterior'];
				$doctoRelacionado->ImpPagado = $documentoRelacionado['pago'];
				$doctoRelacionado->ImpSaldoInsoluto = $documentoRelacionado['saldoInsoluto'];

				$pagoObj->documentosRelacionado[] = $doctoRelacionado;

			}

			$datosFactura->pagos[] = $pagoObj;
		}


		$datosFactura->totalImpRetenidos = $totalImpRetenidos;
		$datosFactura->totalImpTrasladados = $totalImpTrasladados;

		$datosFactura->facturasRelacionadas = [];

		if(count($factura['facturasRelacionadas']['uuids']))
			foreach ($factura['facturasRelacionadas']['uuids'] as $facturaRelacionada){

				$relacionObj = new \stdClass();
				$relacionObj->uuid = $facturaRelacionada['uUID'];
				$datosFactura->facturasRelacionadas[] = $relacionObj;

		}

		$xml = XMLUtils::createXML33($datosFactura, $proveedor);


		$sello = $xml->query('//cfdi:Comprobante')[0]->getAttribute('Sello');

		$nombreArchivo = "$proveedor->rFCEmisor-" .date('YmdHis');

		file_put_contents("tmp/$nombreArchivo.xml", $xml);

		$base64Comprobante = base64_encode($xml);

		$urlTimbrado = "https://timbracfdi33.mx:1443/Timbrado.asmx?wsdl";
		$usuarioIntegrador = "vb9+kzunCtCXL+WQEvBsCQ==";

		if($proveedor->id_proveedor == 17){

			$urlTimbrado = "https://cfdi33-pruebas.buzoncfdi.mx:1443/Timbrado.asmx?wsdl";
			$usuarioIntegrador = "mvpNUXmQfK8=";

		}

		$params = array();
		$params['usuarioIntegrador'] = $usuarioIntegrador;
		$params['xmlComprobanteBase64'] = $base64Comprobante;
		$params['idComprobante'] = rand(5, 999999);


		$client = new SoapClient($urlTimbrado, array('encoding'=>'UTF-8', "connection_timeout" => 250));
		$client->soap_defencoding = "UTF-8";
		$result = $client->__soapCall ( 'TimbraCFDI',array('parameters' => $params) );

		$resultado = $result->TimbraCFDIResult->anyType;


		$logToSave = print_r($resultado, true);

		Log::error($logToSave);

		$log = env('DIR_LOGS')."/" . date ( "Y-m-d" ) . ".log";
		$fp = fopen ( $log, "a" );
		fwrite ( $fp, "\n\n===".date("Y-m-d:H:i:s"). "\n\n" );
		fwrite ( $fp, "\n\n$nombreArchivo\n\n" );
		fwrite ( $fp, $logToSave );
		fwrite ( $fp, "\n\n===" );
		fclose ( $fp );

		$success = false;
		$errorCode = 0;
		$errortext = '';
		$facturaResult = '';

		if($resultado[1] == '0'){
			$success = true;


			$xmlTimbrado = new \DOMDocument("1.0", "uft-8");
			$xmlTimbrado->loadXML($resultado[3]);

			$idDoc = new IdDoc();

			$timbreFiscal = $xmlTimbrado->getElementsByTagName ( 'TimbreFiscalDigital' );

			foreach ( $timbreFiscal as $timbreFiscal ) {

				$fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$fechaTimbradoArray = explode(".",$fechaTimbrado);

				$idDoc->version = $timbreFiscal->getAttribute ( 'Version' );
				$idDoc->fechaTimbrado = $timbreFiscal->getAttribute ( 'FechaTimbrado' );
				$idDoc->selloCFD = $timbreFiscal->getAttribute ( 'SelloCFD' );
				$idDoc->noCertificadoSAT = $timbreFiscal->getAttribute ( 'NoCertificadoSAT' );
				$idDoc->selloSAT = $timbreFiscal->getAttribute ( 'SelloSAT' );
				$idDoc->uUID = $timbreFiscal->getAttribute ( 'UUID' );
				$idDoc->sello = $sello;
				$idDoc->rfcProvCertif = $timbreFiscal->getAttribute ( 'RfcProvCertif' );
			}

			$facturaObj = new Factura();
			$facturaObj->id_proveedor = $user['id_proveedor'];
			$facturaObj->id_cliente = $factura['id_cliente']['id_cliente'];
			$facturaObj->id_certificadoProveedor = $certificadoHaUsar->id;
			$facturaObj->nmbEmisor = $proveedor->nmbEmisor;
			$facturaObj->rFCEmisor = $proveedor->rFCEmisor;
			$facturaObj->nmbRecep = $factura['id_cliente']['nmbRecep'];
			$facturaObj->rFCRecep = $factura['id_cliente']['rFCRecep'];
			$facturaObj->regimenFiscal = $proveedor->regimenFiscal33;
			$facturaObj->timeStamp = $timeStamp;
			$facturaObj->noFactura = $noFactura->noFactura;
			$facturaObj->version = "3.3";
			$facturaObj->generadoPor = 3;
			$facturaObj->nota = (isset($factura['comentario']))? Utils::deleteExtraSpaces($factura['comentario']) : '';
			$facturaObj->tipoDeComprobante = $factura['tipoDocumento'];
			$facturaObj->precission = $factura['decimales'];
			$facturaObj->status = 1;
			$facturaObj->save();


			$idDoc->id_factura = $facturaObj->id_factura;
			$idDoc->serie = $factura['serie'];
			$idDoc->folio = $noFactura->noFactura;
			$idDoc->formaPago = '';
			$idDoc->condicionesDePago = (isset($factura['condicionesPago']))? Utils::deleteExtraSpaces($factura['condicionesPago']) : '';
			$idDoc->lugarExpedicion = Utils::deleteExtraSpaces($factura['lugarExpedicion']);
			$idDoc->usoCFDI = 'P01';
			$idDoc->metodoDePago = '';
			$idDoc->sello = $sello;
			$idDoc->tipoFacturasRelacionadas = $datosFactura->tipoFacturasRelacionadas;
			$idDoc->save();


			$totales = new Totales();
			$totales->id_factura = $facturaObj->id_factura;
			$totales->moneda = 'XXX';
			$totales->tipoCambio = 0;
			$totales->subTotal = 0;
			$totales->mntBase = 0;
			$totales->vlrPagar = 0;
			$totales->descuento = 0;
			$totales->save();

			$detalles = array();

			foreach ($datosFactura->conceptos as $concepto){

				$conceptoObj = new Concepto();
				$conceptoObj->clave = $concepto->clave;
				$conceptoObj->cdgItem = $concepto->cdgItem;
				$conceptoObj->dscItem = $concepto->dscItem;
				$conceptoObj->unmdItem = $concepto->unmdItem;
				$conceptoObj->qtyItem = $concepto->qtyItem;
				$conceptoObj->montoNetoItem = $concepto->montoNetoItem;
				$conceptoObj->prcNetoItem = $concepto->prcNetoItem;
				$conceptoObj->descuento = $concepto->descuento;
				$conceptoObj->id_factura = $facturaObj->id_factura;
				$conceptoObj->save();

				foreach ($concepto->impuestosTrasladados as $impuesto){

					$impuestoObj = new ExImpuestos();
					$impuestoObj->base = $impuesto->base;
					$impuestoObj->factor = $impuesto->factor;
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_detalle = $conceptoObj->id_detalle;
					$impuestoObj->save();
				}

				foreach ($concepto->impuestosRetenidos as $impuesto){

					$impuestoObj = new ExImpuestos();
					$impuestoObj->base = $impuesto->base;
					$impuestoObj->factor = $impuesto->factor;
					$impuestoObj->tipoImp = $impuesto->tipoImp;
					$impuestoObj->tasaImp = $impuesto->tasaImp;
					$impuestoObj->tipo = $impuesto->tipo;
					$impuestoObj->montoImp = $impuesto->montoImp;
					$impuestoObj->id_detalle = $conceptoObj->id_detalle;
					$impuestoObj->save();
				}
			}

			foreach ($datosFactura->facturasRelacionadas as $facturaRelacionada){

				$facturaRelacionadaObj = new FacturasRelacionadas();
				$facturaRelacionadaObj->id_factura = $facturaObj->id_factura;
				$facturaRelacionadaObj->uuid = $facturaRelacionada->uuid;
				$facturaRelacionadaObj->save();

			}

			foreach ($datosFactura->pagos as $pago){

				$pagoObj = new Pago();
				$pagoObj->FechaPago = $pago->FechaPago;
				$pagoObj->FormaDePagoP = $pago->FormaDePagoP;
				$pagoObj->MonedaP = $pago->MonedaP;
				$pagoObj->TipoCambioP = $pago->TipoCambioP;
				$pagoObj->Monto = $pago->Monto;
				$pagoObj->id_factura = $facturaObj->id_factura;
				$pagoObj->save();

				foreach ($pago->documentosRelacionado as $doctoRelacionado ){

					$doctoRelacionadoObj = new DoctoRelacionado();
					$doctoRelacionadoObj->IdDocumento = $doctoRelacionado->IdDocumento;
					$doctoRelacionadoObj->MonedaDR = $doctoRelacionado->MonedaDR;
					$doctoRelacionadoObj->TipoCambioDR = $doctoRelacionado->TipoCambioDR;
					$doctoRelacionadoObj->MetodoDePagoDR = $doctoRelacionado->MetodoDePagoDR;
					$doctoRelacionadoObj->NumParcialidad = $doctoRelacionado->NumParcialidad;
					$doctoRelacionadoObj->ImpSaldoAnt = $doctoRelacionado->ImpSaldoAnt;
					$doctoRelacionadoObj->ImpPagado = $doctoRelacionado->ImpPagado;
					$doctoRelacionadoObj->ImpSaldoInsoluto = $doctoRelacionado->ImpSaldoInsoluto;
					$doctoRelacionadoObj->id_pago = $pagoObj->id;
					$doctoRelacionadoObj->save();


					if($doctoRelacionadoObj->ImpSaldoInsoluto <= 0){

						$idDocObj = IdDoc::where('uUID', '=', $doctoRelacionado->IdDocumento)->with('factura')->first();
						$facturaIdDoc = $idDocObj->factura;
						$facturaIdDoc->isPagado = 1;
						$facturaIdDoc->save();

					}
				}
			}


			$facturaResult = $datosFactura->serie . $datosFactura->folio;


		}else{

			$errorCode = 10001;
			$errorMsg = 'Hubo un error al crear su factura. Vuelva a intentarlo.';

			if(isset($resultado[6])){

				$errorCode = $resultado[6];
				switch ($resultado[6]){
					case 330037:
						$errorMsg = "Este RFC del receptor no existe en la lista de RFC inscritos no cancelados del SAT. Puede que su cliente tenga algún bloqueo.";
						break;
					case 330007:
						$errorMsg = "Es necesario que agregue vaya a la sección de Mis Datos y actualice su régimen fiscal.";
						break;
					case 330171:
						$errorMsg = "Se debe seleccionar un Uso de CFDI para realizar la factura.";
						break;
					case 305:
						$errorMsg = "Su certificado de sellos digitales ha vencido, es necesario que genere uno nuevo en el portal del SAT.";
						break;
					default:
						$errorMsg = $resultado[7];
				}
			}

			$errortext = $errorMsg;
		}





		return Response::json ( array (
				'success' => $success,
				'errorCode' => $errorCode,
				'errortext' => $errortext,
				'facturaResult' => $facturaResult
		));

	}



	public function getXML33(Request $request){

		header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
		header("Cache-Control: post-check=0, pre-check=0", false);
		header("Pragma: no-cache");

		$id_proveedor = $request->input ( 'id_proveedor' );
		$id_factura = $request->input('id_factura');
		$token = $request->input ( 'token' );

		$proveedor = Proveedor::where ( 'token', "=", $token )->where ( 'id_proveedor', "=", $id_proveedor )->first ();

		if (! is_object ( $proveedor ) || empty ( $token )) {
			return Response::json ( array (
					'success' => false,
					'errorText' => 'Token incorrecto'
			) );
		}


		$datosFactura = Utils::obtenerDatosFactura($id_factura, $id_proveedor);

		$xml = XMLUtils::createXML33($datosFactura, null);

		$fileName = $proveedor->rFCEmisor . date('YmdHis') . '.xml';

		file_put_contents("tmp/$fileName", $xml);

		return Response::download("tmp/$fileName", $fileName, ['Content-Type: text/xml']);

	}

	public function getPDF(Request $request){

		$id_proveedor = $request->input ( 'id_proveedor' );
		$id_factura = $request->input('id_factura');
		$token = $request->input ( 'token' );

		$proveedor = Proveedor::where ( 'token', "=", $token )->where ( 'id_proveedor', "=", $id_proveedor )->first ();

		if (! is_object ( $proveedor ) || empty ( $token )) {
			return Response::json ( array (
					'success' => false,
					'errorText' => 'Token incorrecto'
			) );
		}

		$metodosDePago = array('' => '', 'PUE' => 'PUE - Pago en una sola exhibición', 'PPD' => 'PPD - Pago en parcialidades o diferido');
		$impuestos = array('001' => 'ISR', '002' => 'IVA', '003' => 'IEPS');


		$datosFactura = Utils::obtenerDatosFactura($id_factura, $id_proveedor);
		if(trim($datosFactura->tipoFacturasRelacionadas) != ''){

		    $tipoRelaciones = array(
		        '01' => 'Nota de crédito de los documentos relacionados',
		        '02' => 'Nota de débito de los documentos relacionados',
		        '03' => 'Devolución de mercancía sobre facturas o traslados previos',
		        '04' => 'Sustitución de los CFDI previos',
		        '05' => 'Traslados de mercancias facturados previamente',
		        '06' => 'Factura generada por los traslados previos',
		        '07' => 'CFDI por aplicación de anticipo'
		    );

		    $datosFactura->labelFacturasRelacionadas = $tipoRelaciones[$datosFactura->tipoFacturasRelacionadas];

		}

		$datosFactura->noFactura = str_pad ( $datosFactura->noFactura, 5, "0", STR_PAD_LEFT );
		$datosFactura->timeStamp = date_format ( new \DateTime ( $datosFactura->timeStamp ), 'Y-m-d\TH:i:s' );

		$usoCFDI = UsoCFDI::where('codigo', '=', $datosFactura->usoCFDI)->first();
		$datosFactura->usoCFDI = "$usoCFDI->codigo - $usoCFDI->descripcion";

		$regimenFiscal = CatalogoRegimenFiscal::where('code', '=', $datosFactura->regimenFiscal)->first();
		$datosFactura->regimenFiscal = $regimenFiscal->descripcion;

		if($datosFactura->formaPago != ''){
			$formaDePago = FormaPago::where('codigo', '=', $datosFactura->formaPago)->first();
			$datosFactura->formaPago = $formaDePago->codigo . ' - ' . $formaDePago->descripcion;
		}

		if($datosFactura->metodoDePago != ''){
			$datosFactura->metodoDePago = $metodosDePago[$datosFactura->metodoDePago];
		}

		$datosFactura->total = Utils::formatNumber ( $datosFactura->total, $datosFactura->precission );

		$datosFactura->cantidadLetra = NumeroLetra::num2letras($datosFactura->total, false, false);

		$whole = floor($datosFactura->total);
		$datosFactura->decimales = $datosFactura->total - $whole;
		$datosFactura->decimales = ($datosFactura->decimales < 10)? '0' . $datosFactura->decimales : $datosFactura->decimales;

		$tiposDocumentos = [];
		$tiposDocumentos['I'] = 'Ingreso';
		$tiposDocumentos['E'] = 'Egreso';
		$tiposDocumentos['T'] = 'Traslado';
		$tiposDocumentos['P'] = 'Pago';
		$tiposDocumentos['N'] = 'Nómina';


		$adicionales = ['tipoDocumento' => $tiposDocumentos, 'impuestos' => $impuestos,
				'tipoHoras' => array('01' => 'Dobles', '02' => 'Triples', '03' => 'Simples'),
				'tipoIncapacidad' => array('01' => 'Riesgo de trabajo', '02' => 'Enfermedad en general', '03' => 'Maternidad')
		];

		$datosFactura->subtotal = Utils::formatNumber ( $datosFactura->subtotal, $datosFactura->precission );
		$datosFactura->imagen = env('DIR_LOGOS'). $proveedor->imagen;

        if( !file_exists($datosFactura->imagen) || is_dir($datosFactura->imagen)){
            $datosFactura->base64 = '';
        }else{
            $type = pathinfo($datosFactura->imagen, PATHINFO_EXTENSION);
            $data = file_get_contents($datosFactura->imagen);
            $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
            $datosFactura->base64 = $base64;
        }

		$datosFactura->color = $proveedor->color;


		if(count($datosFactura->pagos)){
			$datosFactura->totalPagos = 0;
			foreach ($datosFactura->pagos as $pago){
				$datosFactura->totalPagos += $pago->Monto;

				$pago->FechaPago = new \DateTime ( $pago->FechaPago );
				$pago->FechaPago = date_format ( $pago->FechaPago, 'Y-m-d\TH:i:s' );
			}
		}


		$total_factura = number_format($datosFactura->total,6);
		$total_factura = str_replace(",", "", $total_factura);
		$total_factura = str_pad($total_factura, 17, "0", STR_PAD_LEFT);

		$datosFactura->qr = '?re='.$datosFactura->rFCEmisor.'&rr='.$datosFactura->rFCRecep.'&tt='.$total_factura.'&id='.$datosFactura->uUID;

		$disenoFactura = 'pdf.diseno2';
		if($datosFactura->tipoDeComprobante == 'P'){
			$disenoFactura = 'pdf.pago';
		}else if($datosFactura->tipoDeComprobante == 'N'){
			$disenoFactura = 'pdf.nomina';
		}else if($proveedor->template33 != ''){
			$disenoFactura = 'pdf.' . $proveedor->template33;
		}

		$html = view($disenoFactura, ['factura' => $datosFactura, 'adicionales' => $adicionales])->render();

		$fileName = $datosFactura->rFCEmisor . "-$datosFactura->serie$datosFactura->noFactura.pdf";

		return PDF::load($html)->filename($fileName)->download();

	}

	public function obtenerEmailPorCliente (Request $request){

		$id_cliente = $request->input('id_cliente');

		$email = '';
		$contacto = ContactoReceptor::find($id_cliente);
		if(is_object($contacto))
			$email = $contacto->email;

		return Response::json ( array (
			'success' => true,
			'email' => $email
		));

	}


	public function enviarFactura(Request $request){

		$factura = $request->input('factura');
		$nota = $factura['nota'];
		$user = $request->input('user');
		$id_proveedor = $user['id_proveedor'];
		$id_factura = $factura['id_factura'];
		$email = $factura['email'];

		$metodosDePago = array('' => '', 'PUE' => 'PUE - Pago en una sola exhibición', 'PPD' => 'PPD - Pago en parcialidades o diferido');
		$impuestos = array('001' => 'ISR', '002' => 'IVA', '003' => 'IEPS');

		$proveedor = Proveedor::where ( 'id_proveedor', "=", $id_proveedor )->first ();

		$datosFactura = Utils::obtenerDatosFactura($id_factura, $id_proveedor);

		$xml = XMLUtils::createXML33($datosFactura, null);

		$datosFactura->noFactura = str_pad ( $datosFactura->noFactura, 5, "0", STR_PAD_LEFT );
		$datosFactura->timeStamp = date_format ( new \DateTime ( $datosFactura->timeStamp ), 'Y-m-d\TH:i:s' );

		$usoCFDI = UsoCFDI::where('codigo', '=', $datosFactura->usoCFDI)->first();
		$datosFactura->usoCFDI = "$usoCFDI->codigo - $usoCFDI->descripcion";

		$regimenFiscal = CatalogoRegimenFiscal::where('code', '=', $datosFactura->regimenFiscal)->first();
		$datosFactura->regimenFiscal = $regimenFiscal->descripcion;

		if($datosFactura->formaPago != ''){
			$formaDePago = FormaPago::where('codigo', '=', $datosFactura->formaPago)->first();
			$datosFactura->formaPago = $formaDePago->codigo . ' - ' . $formaDePago->descripcion;
		}

		$datosFactura->metodoDePago = $metodosDePago[$datosFactura->metodoDePago];
		$datosFactura->total = Utils::formatNumber ( $datosFactura->total, $datosFactura->precission );
		$datosFactura->cantidadLetra = NumeroLetra::num2letras($datosFactura->total, false, false);

		$whole = floor($datosFactura->total);
		$datosFactura->decimales = $datosFactura->total - $whole;
		$datosFactura->decimales = ($datosFactura->decimales < 10)? '0' . $datosFactura->decimales : $datosFactura->decimales;

		$tiposDocumentos = [];
		$tiposDocumentos['I'] = 'Ingreso';
		$tiposDocumentos['E'] = 'Egreso';
		$tiposDocumentos['T'] = 'Traslado';
		$tiposDocumentos['P'] = 'Pago';
		$tiposDocumentos['N'] = 'Nómina';

		$adicionales = ['tipoDocumento' => $tiposDocumentos, 'impuestos' => $impuestos,
				'tipoHoras' => array('01' => 'Dobles', '02' => 'Triples', '03' => 'Simples'),
				'tipoIncapacidad' => array('01' => 'Riesgo de trabajo', '02' => 'Enfermedad en general', '03' => 'Maternidad')
		];

		$datosFactura->subtotal = Utils::formatNumber ( $datosFactura->subtotal, $datosFactura->precission );
		$datosFactura->total = Utils::formatNumber ( $datosFactura->total, $datosFactura->precission );
		$datosFactura->imagen = env('DIR_LOGOS'). $proveedor->imagen;
		$datosFactura->color = $proveedor->color;

		if( !file_exists($datosFactura->imagen) || is_dir($datosFactura->imagen)){
			$datosFactura->imagen = '';
		}

		$total_factura = number_format($datosFactura->total,6);
		$total_factura = str_replace(",", "", $total_factura);
		$total_factura = str_pad($total_factura, 17, "0", STR_PAD_LEFT);

		$datosFactura->qr = '?re='.$datosFactura->rFCEmisor.'&rr='.$datosFactura->rFCRecep.'&tt='.$total_factura.'&id='.$datosFactura->uUID;

		if(count($datosFactura->pagos)){
			$datosFactura->totalPagos = 0;
			foreach ($datosFactura->pagos as $pago){
				$datosFactura->totalPagos += $pago->Monto;

				$pago->FechaPago = new \DateTime ( $pago->FechaPago );
				$pago->FechaPago = date_format ( $pago->FechaPago, 'Y-m-d\TH:i:s' );
			}
			$datosFactura->totalPagos = $datosFactura->totalPagos;
		}

		$disenoFactura = 'pdf.diseno2';
		if($datosFactura->tipoDeComprobante == 'P'){
			$disenoFactura = 'pdf.pago';
		}else if($datosFactura->tipoDeComprobante == 'N'){
			$disenoFactura = 'pdf.nomina';
		}

		$html = view($disenoFactura, ['factura' => $datosFactura, 'adicionales' => $adicionales])->render();

		$fileName = $datosFactura->rFCEmisor . date('YmdHis') . "-$datosFactura->serie$datosFactura->noFactura";

		PDF::load($html)->filename("tmp/$fileName.pdf")->output();



		file_put_contents("tmp/$fileName.xml", $xml);

		$dataEmail = array(
				'nombreEmisor' => $datosFactura->nmbEmisor,
				'rFCEmisor' => $datosFactura->rFCEmisor,
				'imagen' => $datosFactura->imagen,
				'email' => $email,
				'fecha' => $datosFactura->fechaEmis,
				'pdfFile' => "tmp/$fileName.pdf",
				'xmlFile' => "tmp/$fileName.xml",
				'nota' => $nota
		);


		Mail::send('emails.factura', $dataEmail, function ($message) use ($dataEmail) {
			$message->from('noreply@soliat.com', $dataEmail['nombreEmisor']);
			$message->to($dataEmail['email']);
			$message->subject("Envío de comprobante CFDI");
			$message->attach($dataEmail['pdfFile']);
			$message->attach($dataEmail['xmlFile']);
		});


			return Response::json ( array (
				'success' => true
			));

	}

	public function  cancelarFactura(Request $request){

		$factura = $request->input('factura');
		$user = $request->input('user');

		$proveedor = Proveedor::where('password', '=', $factura['password'])->where('rFCEmisor', '=', $user['rfc'])->first();

		$passCorrecto = false;
		$seraCancelado = false;

		if(is_object($proveedor)){

			$urlTimbrado = "https://www.timbracfdi.mx/servicioIntegracion/Timbrado.asmx?wsdl";
			$usuarioIntegrador = "vb9+kzunCtCXL+WQEvBsCQ==";

			if($proveedor->id_proveedor == 17){

				$urlTimbrado = "https://cfdi33-pruebas.buzoncfdi.mx:1443/Timbrado.asmx?wsdl";
				$usuarioIntegrador = "mvpNUXmQfK8=";

			}

			$params = array();
			$params['usuarioIntegrador'] = $usuarioIntegrador;
			$params['rfcEmisor'] = $proveedor->rFCEmisor;
			$params['folioUUID'] = $factura['uUID'];


			$client = new SoapClient($urlTimbrado, array('encoding'=>'UTF-8', "connection_timeout" => 250));
			$client->soap_defencoding = "UTF-8";
			$result = $client->__soapCall ( 'CancelaCFDI',array('parameters' => $params) );

			$resultado = $result->CancelaCFDIResult->anyType;

			$seraCancelado = false;
			if($resultado[1] == 0){
				$seraCancelado = true;
				Factura::where('id_factura', '=', $factura['id_factura'])->update(['status' => 0]);
			}

			$passCorrecto = true;

		}

		return Response::json ( array (
				'success' => true,
				'passCorrecto' => $passCorrecto,
				'seraCancelado' => $seraCancelado
		));
	}



	public function verVistaPreviaFactura(Request $request){

			$user = $request->input('user');
			$id_proveedor = $user['id_proveedor'];
			$id_factura = $request->input('id_factura');

			$metodosDePago = array('' => '', 'PUE' => 'PUE - Pago en una sola exhibición', 'PPD' => 'PPD - Pago en parcialidades o diferido');
			$impuestos = array('001' => 'ISR', '002' => 'IVA', '003' => 'IEPS');

			$proveedor = Proveedor::where ( 'id_proveedor', "=", $id_proveedor )->first ();

			$datosFactura = Utils::obtenerDatosFactura($id_factura, $id_proveedor);

			$datosFactura->noFactura = str_pad ( $datosFactura->noFactura, 5, "0", STR_PAD_LEFT );
			$datosFactura->timeStamp = date_format ( new \DateTime ( $datosFactura->timeStamp ), 'Y-m-d\TH:i:s' );

			$usoCFDI = UsoCFDI::where('codigo', '=', $datosFactura->usoCFDI)->first();
			$datosFactura->usoCFDI = "$usoCFDI->codigo - $usoCFDI->descripcion";

			$regimenFiscal = CatalogoRegimenFiscal::where('code', '=', $datosFactura->regimenFiscal)->first();
			$datosFactura->regimenFiscal = $regimenFiscal->descripcion;

			if($datosFactura->formaPago != ''){
				$formaDePago = FormaPago::where('codigo', '=', $datosFactura->formaPago)->first();
				$datosFactura->formaPago = $formaDePago->codigo . ' - ' . $formaDePago->descripcion;
			}

			if($datosFactura->metodoDePago != ''){
				$datosFactura->metodoDePago = $metodosDePago[$datosFactura->metodoDePago];
			}

			$datosFactura->total = Utils::formatNumber ( $datosFactura->total, $datosFactura->precission );

			$datosFactura->cantidadLetra = NumeroLetra::num2letras($datosFactura->total, false, false);

			$whole = floor($datosFactura->total);
			$datosFactura->decimales = $datosFactura->total - $whole;
			$datosFactura->decimales = ($datosFactura->decimales < 10)? '0' . $datosFactura->decimales : $datosFactura->decimales;

			$tiposDocumentos = [];
			$tiposDocumentos['I'] = 'Ingreso';
			$tiposDocumentos['E'] = 'Egreso';
			$tiposDocumentos['T'] = 'Traslado';
			$tiposDocumentos['P'] = 'Pago';

			$adicionales = ['tipoDocumento' => $tiposDocumentos, 'impuestos' => $impuestos];

			$datosFactura->subtotal = Utils::formatNumber ( $datosFactura->subtotal, $datosFactura->precission );
			$datosFactura->total = Utils::formatNumber ( $datosFactura->total, $datosFactura->precission );
			$datosFactura->imagen = env('DIR_LOGOS'). $proveedor->imagen;
			$datosFactura->color = $proveedor->color;

			if(count($datosFactura->pagos)){
				$datosFactura->totalPagos = 0;
				foreach ($datosFactura->pagos as $pago){
					$datosFactura->totalPagos += $pago->Monto;

					$pago->FechaPago = new \DateTime ( $pago->FechaPago );
					$pago->FechaPago = date_format ( $pago->FechaPago, 'Y-m-d\TH:i:s' );
				}
				$datosFactura->totalPagos = $datosFactura->totalPagos;
			}

			$template = 'pdf.preview';
			if($datosFactura->tipoDeComprobante == 'P')
				$template = 'pdf.previewpago';


			$total_factura = number_format($datosFactura->total,6);
			$total_factura = str_replace(",", "", $total_factura);
			$total_factura = str_pad($total_factura, 17, "0", STR_PAD_LEFT);

			$datosFactura->qr = '?re='.$datosFactura->rFCEmisor.'&rr='.$datosFactura->rFCRecep.'&tt='.$total_factura.'&id='.$datosFactura->uUID;

			$html = view($template, ['factura' => $datosFactura, 'adicionales' => $adicionales])->render();

			return Response::json ( array (
					'success' => true,
					'html' => $html
			));

	}


	public function obtenerFacturasPorCliente(Request $request){

		$id_cliente = $request->input('id_cliente');
		$user = $request->input('user');

		$facturas = Factura::with('iddoc', 'totales')
			->where('id_proveedor', '=', $user['id_proveedor'])
			->where('id_cliente', $id_cliente)->where('status', '=', 1)
			->where('isPagado', '=', 0)->where('tipoDeComprobante', '=', 'I')->get();

		if(is_object($facturas))
			$facturas = $facturas->toArray();

		return Response::json ( array (
			'success' => true,
			'facturas' => $facturas
		));
	}

	public function obtenerAbonosFactura(Request $request){

		$uuid = $request->input('uuid');

		$pagosADocumentos = DoctoRelacionado::where('IdDocumento', '=', $uuid)->get();

		$importePagado = 0;
		$noPago = 0;
		if(count($pagosADocumentos) > 0)
		foreach($pagosADocumentos as $documento){

			$importePagado += $documento->ImpPagado;
			$noPago++;
		}

		$noPago++;

		return Response::json (array (
			'success' => true,
			'importePagado' => $importePagado,
			'noPago' => $noPago
		));

	}

	public function obtenerFacturaPago(Request $request){

		$id_factura = $request->input('id_factura');

		$factura = Factura::with('iddoc', 'totales')->where('id_factura', '=', $id_factura)->first();

		$pagosADocumentos = DoctoRelacionado::where('IdDocumento', '=', $factura->iddoc->uUID)->get();

		$importePagado = 0;
		$noPago = 0;
		if(count($pagosADocumentos) > 0)
			foreach($pagosADocumentos as $documento){

				$importePagado += $documento->ImpPagado;
				$noPago++;
		}

		$noPago++;

		$factura->importePagado = $importePagado;
		$factura->noPago = $noPago;

		return Response::json (array (
				'success' => true,
				'factura' => $factura->toArray()
		));

	}


	public function exportToExcelReport(Request $request){


		$fechaInicial = $request->input ( 'fechaInicial' ) . ' 00:00:00';
		$fechaFinal = $request->input ( 'fechaFinal' ) . ' 23:59:59';
		$rfc = $request->input ( 'rfcExc' );
		$estatusDocumento = $request->input ( 'estatusDocumento' );
		$id_proveedor = $request->input ( 'id_proveedorExc' );
		$token = $request->input ( 'tokenExc' );
		$tipoDocumento = $request->input ( 'tipoDocumento' );
		$rfcBusquedaExc = $request->input ( 'rfcBusquedaExc' );



		$proveedor = Proveedor::where ( 'token', "=", $token )->where ( 'id_proveedor', "=", $id_proveedor )->first ();

		if (! is_object ( $proveedor ) || empty ( $token )) {
			return Response::json ( array (
					'success' => false,
					'errorText' => 'Token incorrecto'
			) );
		}

		$nombreMeses = array('', 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');


		$query = "SELECT f.id_factura AS id_factura, f.timeStamp AS timeStamp, f.nmbRecep AS nmbRecep, f.noFactura AS noFactura, f.generadoPor AS generadoPor, f.tipo AS tipo, t.vlrPagar AS vlrPagar, i.serie AS serie, t.descuento,
	i.uUID AS uUID, f.nmbEmisor AS nmbEmisor, f.rFCEmisor AS rFCEmisor, f.nmbRecep AS nmbRecep, f.rFCRecep AS rFCRecep, f.noFactura AS noFactura, i.fechaTimbrado as fechaTimbrado, t.subTotal AS subTotal, i.metodoDePago AS metodoDePago
	FROM Factura f
		LEFT JOIN Totales t ON t.id_factura = f.id_factura
		LEFT JOIN IdDoc i ON i.id_factura = f.id_factura
		WHERE f.status = $estatusDocumento AND f.id_proveedor = $id_proveedor AND timeStamp BETWEEN '$fechaInicial' AND '$fechaFinal' AND f.rFCRecep LIKE '%$rfcBusquedaExc%'
		ORDER BY id_factura DESC";
				$listaFactura = DB::select($query);

				// Create new PHPExcel object
				$objPHPExcel = new PhpExcel();

				// Set document properties

				$newSheet = 0;
				$sheetNo = 0;
				$row = 3;
				$anio = "";
				$mes = "";
				$ivaRetTotal = $isrRetTotal = $ivaTrasTotal = $iepsTotal = $retLocalTotal = $trasLocalTotal = $subTotalGral = $totalTotal = $descuento = 0;

				if (count($listaFactura) > 0)
					foreach ($listaFactura as $index => $factura){

						$conceptos = Concepto::with('impuestos')->where('id_factura', '=', $factura->id_factura)->get();

						$ivaRet = $isrRet = $ivaTras = $ieps = $retLocal = $trasLocal = 0;
						foreach ($conceptos as $concepto){

							$impuestos = $concepto->impuestos;
							if(count($impuestos) > 0)
								foreach ($impuestos as $impuesto){
									//Retenciones
									if($impuesto->tipo == 0){
										if($impuesto->tipoImp == "002"){
											$ivaRet += $impuesto->montoImp;
										}else if($impuesto->tipoImp == "001"){
											$isrRet += $impuesto->montoImp;
										}else{
											$retLocal += $impuesto->montoImp;
										}
									}else{
										//Traslados
										if($impuesto->tipoImp == "002"){
											$ivaTras += $impuesto->montoImp;
										}else if($impuesto->tipoImp == "003"){
											$ieps += $impuesto->montoImp;
										}else{
											$trasLocal += $impuesto->montoImp;
										}
									}
							}
						}





						//SUMA de totales
						$ivaRetTotal += $ivaRet;
						$isrRetTotal += $isrRet;
						$retLocalTotal += $retLocal;
						$ivaTrasTotal += $ivaTras;
						$iepsTotal += $ieps;
						$trasLocalTotal += $trasLocal;
						$subTotalGral += $factura->subTotal;
						$totalTotal += $factura->vlrPagar;
						$descuento += $factura->descuento;

						$fechaArray = explode("-", $factura->timeStamp);

						if($fechaArray[1] != $mes){

							$sheetNo = $newSheet;

							$anio = $fechaArray[0];
							$mes = $fechaArray[1];
							$row = 3;

							//Creating new sheets
							$objWorkSheet = $objPHPExcel->createSheet($newSheet);
							$objPHPExcel->setActiveSheetIndex($newSheet);

							// Adding headers to sheet
							$objPHPExcel->setActiveSheetIndex($sheetNo)
							->setCellValue('A1', $nombreMeses[intval($mes)] . " $anio")
							->setCellValue('A2', 'Serie')
							->setCellValue('B2', 'No. Factura')
							->setCellValue('C2', 'RFC Emisor')
							->setCellValue('D2', 'Nombre Emisor')
							->setCellValue('E2', 'Fecha emisión')
							->setCellValue('F2', 'Fecha timbrado')
							->setCellValue('G2', 'Tipo')
							->setCellValue('H2', 'Folios fiscal')
							->setCellValue('I2', 'Subtotal')
							->setCellValue('J2', 'Descuento')
							->setCellValue('K2', 'IVA retenido')
							->setCellValue('L2', 'IVA trasladado')
							->setCellValue('M2', 'ISR')
							->setCellValue('N2', 'IEPS')
							->setCellValue('O2', 'Ret. Loc.')
							->setCellValue('P2', 'Tras. Loc.')
							->setCellValue('Q2', 'Total')
							->setCellValue('R2', 'Método de pago');

							$objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true)->setSize(15);
							$objPHPExcel->getActiveSheet()->getStyle('A2:R2')->getFont()->setBold(true);
							$objPHPExcel->getActiveSheet()->setTitle($nombreMeses[intval($mes)] . " $anio");

							for($col = 'A'; $col !== 'Q'; $col++) {
								$objPHPExcel->getActiveSheet()
								->getColumnDimension($col)
								->setAutoSize(true);
							}

							$newSheet++;
						}

						$objPHPExcel->setActiveSheetIndex($sheetNo)
						->setCellValue("A$row", $factura->serie)
						->setCellValue("B$row", $factura->noFactura)
						->setCellValue("C$row", $factura->rFCRecep)
						->setCellValue("D$row", $factura->nmbRecep)
						->setCellValue("E$row", $factura->timeStamp)
						->setCellValue("F$row", $factura->fechaTimbrado)
						->setCellValue("G$row", $factura->tipo)
						->setCellValue("H$row", $factura->uUID)
						->setCellValue("I$row", $factura->subTotal)
						->setCellValue("J$row", $factura->descuento)
						->setCellValue("K$row", Utils::formatNumber($ivaRet))
						->setCellValue("L$row", Utils::formatNumber($ivaTras))
						->setCellValue("M$row", Utils::formatNumber($isrRet))
						->setCellValue("N$row", Utils::formatNumber($ieps))
						->setCellValue("O$row", Utils::formatNumber($retLocal))
						->setCellValue("P$row", Utils::formatNumber($trasLocal))
						->setCellValue("Q$row", $factura->vlrPagar)
						->setCellValue("R$row", $factura->metodoDePago);

						$row++;

						if(isset($listaFactura[$index + 1]))
							$fechaArrayTemp = explode("-", $listaFactura[$index + 1]->timeStamp);
						else
							$fechaArrayTemp = '';

						if($fechaArrayTemp != '' && $fechaArrayTemp[1] != $mes){

							$objPHPExcel->setActiveSheetIndex($sheetNo)
							->setCellValue("I$row", $subTotalGral)
							->setCellValue("J$row", $descuento)
							->setCellValue("K$row", Utils::formatNumber($ivaRetTotal))
							->setCellValue("L$row", Utils::formatNumber($ivaTrasTotal))
							->setCellValue("M$row", Utils::formatNumber($isrRetTotal))
							->setCellValue("N$row", Utils::formatNumber($iepsTotal))
							->setCellValue("O$row", Utils::formatNumber($retLocalTotal))
							->setCellValue("P$row", Utils::formatNumber($trasLocalTotal))
							->setCellValue("Q$row", $totalTotal);
							$objPHPExcel->getActiveSheet()->getStyle("A$row:R$row")->getFont()->setBold(true);

							$ivaRetTotal = $isrRetTotal = $ivaTrasTotal = $iepsTotal = $retLocalTotal = $trasLocalTotal = $subTotalGral = $totalTotal = 0;

						}

				}


				$filename = $rfc . "-reporte.xls";

				$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
				$objWriter->save('tmp2/'.$filename);

				return response()->download('tmp2/'.$filename);


	}


}


