<?php
namespace App\Http\Controllers;





use App\Commands\Utils;
use App\Models\ClaveProdServProveedor;
use App\Models\Concepto;
use App\Models\Producto;
use App\Models\UnidadMedidaProveedor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Response;

class ConceptosController extends BaseController {


	public function obtenerConceptos(Request $request){

		$user = $request->input('user');

		$conceptos = Producto::where('id_proveedor', '=', $user['id_proveedor'])->where('status', '=', 1)->with('unidadd')->get();

		return Response::json ( array (
			'success' => true,
			'conceptos' => $conceptos
		));

	}

	public function obtenerConcepto(Request $request){

		$id_concepto = $request->input('id_concepto');
		$user = $request->input('user');

		$concepto = '';

		if($id_concepto > 0){
			$concepto = Producto::find($id_concepto);
			$concepto = $concepto->toArray();
		}

		$unidadesMedida = UnidadMedidaProveedor::where('id_proveedor', '=', $user['id_proveedor'])->with('unidad')->get();
		$clavesProducto = ClaveProdServProveedor::where('id_proveedor', '=', $user['id_proveedor'])->with('clave')->get();

		return Response::json ( array (
				'success' => true,
				'concepto' => $concepto,
				'clavesProducto' => $clavesProducto->toArray(),
				'unidadesMedida' => $unidadesMedida->toArray()
		));

	}



	public function guardar(Request $request){

		$concepto = $request->input('concepto');
		$user = $request->input('user');

		if( $concepto['id_producto'] > 0){
			$conceptoObj = Producto::find($concepto['id_producto']);
		}else{
			$conceptoObj = new Producto();
		}

		$conceptoObj->id_proveedor = $user['id_proveedor'];
		$conceptoObj->clave = $concepto['clave'];
		$conceptoObj->nombre = Utils::deleteExtraSpaces($concepto['nombre']);
		$conceptoObj->precioU = Utils::deleteExtraSpaces($concepto['precioU']);
		$conceptoObj->unidad = Utils::deleteExtraSpaces($concepto['unidad']);
		$conceptoObj->codigo = Utils::deleteExtraSpaces($concepto['codigo']);
		$conceptoObj->status = 1;
		$conceptoObj->save();


		return Response::json ( array (
				'success' => true
		));

	}

	public function borrarConcepto(Request $request){

		$id_concepto = $request->input('id_concepto');

		Producto::destroy($id_concepto);

		return Response::json ( array (
				'success' => true
		));
	}
}

