<?php
namespace App\Http\Controllers;





use App\Models\CatalogoRegimenFiscal;
use App\Models\Cliente;
use App\Models\DomFiscalRcp;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;
use App\Commands\Utils;
use App\Models\ContactoReceptor;
use App\Models\FormaPago;
use App\Models\UsoCFDI;

class ClientesController extends BaseController {


	public function obtenerClientes(Request $request){

		$user = $request->input('user');

		$clientes = DB::table('Cliente')->select('id_cliente','rFCRecep', 'nmbRecep')->where('status', '=', 1)->where('id_proveedor', '=', $user['id_proveedor'])->orderBy('rFCRecep')->get();;

		return Response::json ( array (
			'success' => true,
			'clientes' => $clientes
		));

	}

	public function obtenerCliente(Request $request){

		$id_cliente = $request->input('id_cliente');

		$cliente = '';

		if($id_cliente > 0){
			$cliente = Cliente::with('contacto', 'domicilio')->find($id_cliente);
			if(is_object($cliente->domicilio)){
                $cliente->cp = $cliente->domicilio->codigoPostal;
            }else{
                $domicilioObj = new DomFiscalRcp();
                $domicilioObj->id_cliente = $cliente->id_cliente;
                $domicilioObj->save();

                $cliente->domicilio = $domicilioObj;
            }

			$cliente = $cliente->toArray();
		}

		$formaPago = FormaPago::where('status', '=', 1)->get();
		$usosCFDI =  UsoCFDI::where('status', '=', 1)->get();
        $regimenesFiscales = CatalogoRegimenFiscal::where('status', '=', 1)->get();

		return Response::json ( array (
			'success' => true,
			'cliente' => $cliente,
			'formaPago' => $formaPago->toArray(),
            'usosCFDI' => $usosCFDI->toArray(),
            'regimenesFiscales' => $regimenesFiscales->toArray()
		));

	}



	public function guardar(Request $request){

		$cliente = $request->input('cliente');
		$user = $request->input('user');

		if( $cliente['id_cliente'] > 0){
			$clienteObj = Cliente::with('domicilio')->find($cliente['id_cliente']);
			$domicilioObj = $clienteObj->domicilio;
		}else{
			$clienteObj = new Cliente();
			$domicilioObj = new DomFiscalRcp();
		}

		$clienteObj->id_proveedor = $user['id_proveedor'];
		$clienteObj->rFCRecep = Utils::deleteExtraSpaces($cliente['rFCRecep']);
		$clienteObj->nmbRecep = Utils::deleteExtraSpaces($cliente['nmbRecep']);
		$clienteObj->metodoPago = Utils::deleteExtraSpaces($cliente['metodoPago']);
		$clienteObj->usoCFDI = Utils::deleteExtraSpaces($cliente['usoCFDI']);
        $clienteObj->tipoPersona = $cliente['tipoPersona'] ?? '0';
        $clienteObj->direccion = $cliente['direccion'] ?? '0';
        $clienteObj->regimenFiscalReceptor = $cliente['regimenFiscalReceptor'] ?? '';
		$clienteObj->save();

		$domicilioObj->id_cliente = $clienteObj->id_cliente;
        $domicilioObj->codigoPostal = $cliente['cp'] ?? '';
        $domicilioObj->save();


		if( $cliente['id_cliente'] > 0){
			$contacto = ContactoReceptor::find($clienteObj->id_cliente);
			if(!is_object($contacto)){
				$contacto = new ContactoReceptor();
				$contacto->id_cliente = $clienteObj->id_cliente;
			}
		}else{
			$contacto = new ContactoReceptor();
			$contacto->id_cliente = $clienteObj->id_cliente;
		}

        if(isset($cliente['contacto'])){
            $contacto->email = $cliente['contacto']['email'];
            $contacto->telefono = $cliente['contacto']['telefono'] ?? '';
            $contacto->save();
        }



		return Response::json ( array (
				'success' => true
		));

	}

	public function borrarCliente(Request $request){

		$id_cliente = $request->input('id_cliente');

		Cliente::destroy($id_cliente);

		return Response::json ( array (
				'success' => true
		));
	}
}

