<?php

namespace App\Commands;

use App\Models\Autotransporte;
use App\Models\FigurasTransporte;
use App\Models\Ine;
use App\Models\Mercancia;
use App\Models\MercanciaComercio;
use App\Models\Remolque;
use App\Models\TotalesP;
use App\Models\Ubicacion;
use Illuminate\Support\Facades\DB;
use App\Models\Concepto;
use App\Models\ExImpuestos;
use App\Models\FacturasRelacionadas;
use App\Models\Pago;
use App\Models\EmpleadoFac;
use App\Models\Empleado;
use App\Models\PercepcionDeduccion;
use App\Models\PercepcionDeduccionFac;
use App\Models\Factura;
use App\Models\AdicionalNomina;
use App\Models\PeriodoNomina;
use App\Models\CatalogoRegimenContratacion;
use App\Models\CatalogoRiesgoPuesto;
use App\Models\Proveedor;
use App\Models\ComercioE;
use App\Models\DomFiscalFact;
use App\Models\DomFiscalRcpFact;
use App\Models\Estado;
use App\Models\Municipio;
use App\Models\Inbursa;
use SoapClient;

class Utils {

    private static $ENCRYPTION_KEY = "SergioEvaAlePau01";

	public static function randomPass($length = 12) {
		$chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789jkljaslu78ah387askjh3as5735as43jas8w3dsads547e45dsjdsdflkhjsdqas-asdajseyuauys873ah3has457a4s";
		return substr ( str_shuffle ( $chars ), 0, $length );
	}
	public static function formatNumber($number, $presission = 2, $down = false) {
		$number = str_replace ( ",", "", $number );
		$number = str_replace ( "$", "", $number );
		$number = str_replace ( "'", "", $number );
		$number = trim ( $number );

		if($down){
            $number = bcdiv ($number, 1, $presission);
		}else{
		    $number = number_format ( $number, $presission, ".", "" );
		}

		return $number;
	}

    public static function truncarDosDecimales($numero) {
        return floor($numero * 100) / 100;
    }

	public static function validateCerVsKeyFile($cerFile, $keyFile) {

		exec ( "openssl x509 -noout -modulus -in ".env('DIR_CERTS')."/$cerFile.pem | openssl md5", $outputCer );
		$stdinCer = $outputCer [0];
		$stdinCer = str_replace ( "(stdin)=", "", $stdinCer );
		$stdinCer = trim ( $stdinCer );

		exec ( "openssl rsa -noout -modulus -in ".env('DIR_CERTS')."/$keyFile.pem | openssl md5", $ouputKey );
		$stdinKey = $ouputKey [0];
		$stdinKey = str_replace ( "(stdin)=", "", $stdinKey );
		$stdinKey = trim ( $stdinKey );

		$isValid = false;

		if ($stdinCer == $stdinKey) {
			$isValid = true;
		}

		return $isValid;
	}
	public static function registrarUsuarioProFac($rfcEmisor, $cerFile, $keyFile, $contrasena) {
		$responseArr = array (
				'result' => false,
				'code' => 1001
		);

		/* Ruta del servicio de integracion */
		$ws = "https://www.timbracfdi.mx/servicioIntegracion/Timbrado.asmx?wsdl";
		$response = '';
		/* El servicio para registrar un emisor recibe 5 parámetros */

		/* Usuario Integrador */
		$usuarioIntegrador = 'vb9+kzunCtCXL+WQEvBsCQ==';

		/* Archivo .cer base64 */
		$rutaCer = env('DIR_CERTS')."/" . $cerFile;
		$base64Cer = file_get_contents ( $rutaCer );
		$base64Cer = base64_encode ( $base64Cer );

		/* Archivo .key base64 */
		$rutaKey = env('DIR_CERTS')."/" . $keyFile;
		$base64Key = file_get_contents ( $rutaKey );
		$base64Key = base64_encode ( $base64Key );

		/* Contraseña del sello */

		try {
			$params = array ();
			/* Nombre del usuario integrador asignado, para efecto de pruebas utilizaremos 'mvpNUXmQfK8=' */
			$params ['usuarioIntegrador'] = $usuarioIntegrador;
			/* Rfc emisor a registrar 64 */
			$params ['rfcEmisor'] = $rfcEmisor;
			/* Archivo .cer en base 64, sello digital del emisor */
			$params ['base64Cer'] = $base64Cer;
			/* Archivo .key en base 64, sello digital del emisor */
			$params ['base64Key'] = $base64Key;
			/* Contraseña, sello digital del emisor */
			$params ['contrasena'] = $contrasena;

			// echo "<pre>";
			// print_r($params);
			// echo "</pre>";

			$client = new \SoapClient ( $ws, $params );
			$response = $client->__soapCall ( 'RegistraEmisor', array (
					'parameters' => $params
			) );
		} catch ( \SoapFault $fault ) {
			$responseArr ['result'] = false;
			$responseArr ['code'] = 1001;
		}

		/* Obtenemos resultado del response */
		$tipoExcepcion = $response->RegistraEmisorResult->anyType [0];
		$numeroExcepcion = $response->RegistraEmisorResult->anyType [1];
		$mensajeRsp = $response->RegistraEmisorResult->anyType [2];
		$xmlTimbrado = $response->RegistraEmisorResult->anyType [3];
		$codigoQr = $response->RegistraEmisorResult->anyType [4];
		$cadenaOriginal = $response->RegistraEmisorResult->anyType [5];

		// echo '<h2>Request</h2><pre>' . htmlspecialchars($client->request, ENT_QUOTES) . '</pre>';
		// echo '<h2>Response</h2><pre>' . htmlspecialchars($client->response, ENT_QUOTES) . '</pre>';

		if ($numeroExcepcion === 0) {
			$responseArr ['result'] = true;
			$responseArr ['code'] = 0;
		} else {
			if ($numeroExcepcion == 306 || $numeroExcepcion == "306") {

				// El certificado no es CSD
				$responseArr ['result'] = false;
				$responseArr ['code'] = 1002;
			} else {
				$responseArr ['result'] = false;
				$responseArr ['code'] = 1003;
			}
		}

		return $responseArr;
	}

	public static function deleteExtraSpaces($string){

		$string = preg_replace('/\s+/', ' ', $string);
		$string = trim($string);
		return $string;

	}

	public static function obtenerDatosFactura($id_factura, $id_proveedor){

	    $query = "
		SELECT
		f.id_factura AS id_factura,
		f.id_cliente AS id_cliente,
		f.nmbEmisor AS nmbEmisor,
		f.rFCEmisor AS rFCEmisor,
		f.regimenFiscal AS regimenFiscal,
		f.nmbRecep AS nmbRecep,
		f.rFCRecep AS rFCRecep,
		f.regimenFiscal AS regimenFiscal,
		f.timeStamp AS timeStamp,
		f.noFactura AS noFactura,
		f.comentario AS comentario,
		f.version AS version,
		f.tipo AS tipo,
		f.precission AS precission,
		f.nota AS nota,
		f.tipoDeComprobante as tipoDeComprobante,
		f.pais,
		f.numRegIdTrib,
		f.domicilio AS domicilio,
		f.regimenFiscalReceptor AS regimenFiscalReceptor,
		f.exportacion AS exportacion,
		f.domicilioFiscalReceptor AS domicilioFiscalReceptor,

		idoc.usoCFDI as usoCFDI,
		idoc.serie AS serie,
		idoc.folio AS folio,
		idoc.numeroInterno AS numeroInterno,
		idoc.fechaEmis AS fechaEmis,
		idoc.formaPago AS formaPago,
		idoc.condicionesDePago AS condicionesDePago,
		idoc.cuenta AS cuenta,
		idoc.lugarExpedicion AS lugarExpedicion,
		idoc.metodoDePago AS metodoDePago,
		idoc.fechaTimbrado AS fechaTimbrado,
		idoc.selloCFD AS selloCFD,
		idoc.noCertificadoSAT AS noCertificadoSAT,
		idoc.selloSAT AS selloSAT,
		idoc.uUID AS uUID,
		idoc.sello AS sello,
		idoc.selloSAT as selloSAT,
		idoc.unidadMedida AS unidadMedida,
		idoc.milisegundos AS milisegundos,
		idoc.version AS version2,
		idoc.rfcProvCertif as rfcProvCertif,
		idoc.tipoFacturasRelacionadas,

		t.moneda AS moneda,
		t.subTotal AS subtotal,
		t.mntDcto AS mntDcto,
		t.pctDcto AS pctDcto,
		t.mntBase AS mntBase,
		t.mntImp AS mntImp,
		t.descuento AS descuento,
		t.vlrPagar AS total,
		t.vlrPalabras AS vlrPalabras,
		t.motivoDescuento,
		t.descuento,
        t.pesoTotal,
        t.tipoCambio,

		cp.certificado AS certificado,
		cp.noCertificado AS noCertificado,

		arr.cuentaPredial,

        de.noOp,

        ce.Incoterm,

		fg.Importe as ImporteFG,
		fg.PeriodoEnMeses as PeriodoEnMesesFG,
		fg.Descripcion as DescripcionFG,

		infg.anio as publiAnio,
		infg.meses as publiMeses,
		infg.periodicidad as publiPeriodicidad,

		cpo.transpInternac,
		cpo.entradaSalidaMerc,
		cpo.paisOrigenDestino,
		cpo.viaEntradaSalida,
		cpo.pesoBrutoTotal,
		cpo.unidadPeso,
		cpo.id as id_cartaPorte,
		cpo.idccp,

		lf.norma,
		lf.leyenda

		FROM Factura f
		JOIN IdDoc idoc ON f.id_factura = idoc.id_factura
		JOIN Totales t ON f.id_factura = t.id_factura
		JOIN CertificadosProveedor cp ON f.id_certificadoProveedor = cp.id
		LEFT JOIN ComercioE ce ON f.id_factura = ce.id_factura
		LEFT JOIN InformacionGlobal infg ON f.id_factura = infg.id_factura
		LEFT JOIN AddendaFondoGarantia fg ON f.id_factura = fg.id_factura
		LEFT JOIN Arrendamiento arr ON f.id_factura = arr.id_factura
        LEFT JOIN DatosEspeciales de ON f.id_factura = de.id_factura
		LEFT JOIN CartaPorte cpo ON f.id_factura = cpo.id_factura
		LEFT JOIN LeyendaFiscal lf ON f.id_factura = lf.id_factura
		WHERE f.id_factura = $id_factura AND f.id_proveedor = $id_proveedor";

	    $datosFactura = DB::select($query)[0];

	    $conceptos = Concepto::with('impuestos', 'unidadc', 'alumno', 'clavec')->where('id_factura', '=', $id_factura)->orderBy('id_detalle')->get();
	    $datosFactura->conceptos = $conceptos->toArray();
	    $impuestosLocales = ExImpuestos::where('id_factura', '=', $id_factura)->get();

        $ineObj = Ine::where('id_factura', '=', $id_factura)->first();
        if(is_object($ineObj) && !empty($ineObj->tipoProceso)){

            $ine = new \stdClass();
            $ine->tipoProceso = $ineObj->tipoProceso;
            $ine->version = $ineObj->version;
            $ine->comite = $ineObj->comite;
            $ine->ambito = $ineObj->ambito;
            $ine->claveEntidad = $ineObj->claveEntidad;
            $ine->idContabilidad = $ineObj->idContabilidad;

            $datosFactura->ine = $ine;
        }

		$datosFactura->addenda = null;

		$inbursaObj = Inbursa::where('id_factura', '=', $id_factura)->first();
		if(is_object($inbursaObj) && !empty($inbursaObj->emisor)){

			$datosFactura->addenda = new \stdClass();

			$inbursa = new \stdClass();
			$inbursa->emisor = $inbursaObj->emisor;
			$inbursa->numero = $inbursaObj->numero;
			$inbursa->afectado = $inbursaObj->afectado;
			$inbursa->deducible = $inbursaObj->deducible;
			$inbursa->descuento = $inbursaObj->descuento;
			$inbursa->manaoObra = $inbursaObj->manaoObra;
			$inbursa->refacciones = $inbursaObj->refacciones;
			$inbursa->fechaEntrega = $inbursaObj->fechaEntrega;
			
			$datosFactura->addenda->inbursa = $inbursa;
		}

	    $datosFactura->impuestosTrasladados = [];
	    $datosFactura->impuestosRetenidos = [];
	    $datosFactura->impuestosTrasladadosLcl = [ ];
	    $datosFactura->impuestosTrasladadosLclTotal = 0;
	    $datosFactura->impuestosRetenidosLcl = [ ];
	    $datosFactura->impuestosRetenidosLclTotal = 0;
	    $totalImpRetenidos = 0;
	    $totalImpTrasladados = 0;

	    foreach ($datosFactura->conceptos as &$concepto){
	        $concepto['impuestosTrasladados'] = [];
	        $concepto['impuestosRetenidos'] = [];

	        $concepto = (object)$concepto;

            if(isset($concepto->alumno) && is_array($concepto->alumno)){
                $concepto->alumno = (object)$concepto->alumno;
            }


	        if(count($concepto->impuestos) > 0)
	            foreach ($concepto->impuestos as $impuesto){
	                $impuesto = (object)$impuesto;

	                if($impuesto->tipo == 1){

	                    $concepto->impuestosTrasladados[] = $impuesto;

	                    $isNuevo = true;
	                    if(count($datosFactura->impuestosTrasladados))
	                        foreach($datosFactura->impuestosTrasladados as $impuestoGeneral){
	                            if($impuesto->tipoImp == $impuestoGeneral->impuesto && $impuesto->factor == $impuestoGeneral->tipoFactor && $impuesto->tasaImp == $impuestoGeneral->tasaOCuota){
	                                $isNuevo = false;
	                                $impuestoGeneral->importe += $impuesto->montoImp;
                                    $impuestoGeneral->base += $impuesto->base;
                                    //echo "$impuestoGeneral->base + $impuesto->base";

	                                break;
	                            }
	                    }

	                    if($isNuevo && ($impuesto->factor != 'Exento' || $datosFactura->version == '4.0')){
	                        $impuestoGeneral = new \stdClass();
	                        $impuestoGeneral->importe = $impuesto->montoImp;
	                        $impuestoGeneral->impuesto = $impuesto->tipoImp;
	                        $impuestoGeneral->tipoFactor = $impuesto->factor;
	                        $impuestoGeneral->tasaOCuota = $impuesto->tasaImp;
                            $impuestoGeneral->base = $impuesto->base;
	                        $datosFactura->impuestosTrasladados[] = $impuestoGeneral;
	                    }

	                    $totalImpTrasladados += $impuesto->montoImp;

	                }else{

	                    $concepto->impuestosRetenidos[] = $impuesto;

	                    $isNuevo = true;
	                    if(count($datosFactura->impuestosRetenidos))
	                        foreach($datosFactura->impuestosRetenidos as $impuestoGeneral){
	                            if($impuesto->tipoImp == $impuestoGeneral->impuesto){
	                                $isNuevo = false;
	                                $impuestoGeneral->importe += $impuesto->montoImp;
	                                break;
	                            }
	                    }

	                    if($isNuevo && $impuesto->factor != 'Exento'){
	                        $impuestoGeneral = new \stdClass();
	                        $impuestoGeneral->importe = $impuesto->montoImp;
	                        $impuestoGeneral->impuesto = $impuesto->tipoImp;
	                        $datosFactura->impuestosRetenidos[] = $impuestoGeneral;
	                    }

	                    $totalImpRetenidos += $impuesto->montoImp;
	                }
	        }
	    }


	    if(count($impuestosLocales) > 0)
	        foreach ($impuestosLocales as $impLocal){

	            if($impLocal->tipo == 1){
	                //Traslados
	                $datosFactura->impuestosTrasladadosLcl[] = $impLocal;
	                $datosFactura->impuestosTrasladadosLclTotal += $impLocal->montoImp;
	            }else{
	                $datosFactura->impuestosRetenidosLcl[] = $impLocal;
	                $datosFactura->impuestosRetenidosLclTotal += $impLocal->montoImp;
	            }
	    }

	    $datosFactura->totalImpRetenidos = $totalImpRetenidos;
	    $datosFactura->totalImpTrasladados = $totalImpTrasladados;


	    $datosFactura->facturasRelacionadas = FacturasRelacionadas::where('id_factura', '=', $id_factura)->get();
	    $datosFactura->pagos = Pago::with('formaPago', 'documentosRelacionado.traslados', 'documentosRelacionado.retenciones')->where('id_factura', '=', $id_factura)->get();

        if(is_object($datosFactura->pagos) && count($datosFactura->pagos) > 0){

            $datosFactura->totalesPagos = TotalesP::where('id_factura', '=', $id_factura)->first();

            foreach ($datosFactura->pagos as $pago){

                $pago->impuestos = new \stdClass ();
                $pago->impuestos->impuestosRetenidos = [];
                $pago->impuestos->impuestosTrasladados = [];

                foreach ($pago->documentosRelacionado as $documentoRelacionado){
                    if(count($documentoRelacionado->traslados) > 0 || count($documentoRelacionado->retenciones) > 0){

                        $equivalenciaDR = 0;
                        if($documentoRelacionado->MonedaDR == 'USD' && $pago->MonedaP == 'MXN' ){
                            $equivalenciaDR = Utils::formatNumber ($documentoRelacionado->ImpPagado / $documentoRelacionado->MontoPagoMoneda, 6);
                        }

                        $impuestos = new \stdClass ();
                        $impuestos->impuestosRetenidos = $documentoRelacionado->retenciones;
                        $impuestos->impuestosTrasladados = $documentoRelacionado->traslados;

                        $documentoRelacionado->impuestos = $impuestos;

                        foreach ($documentoRelacionado->traslados as $traslado){
                            $existeImpuesto = false;
                            foreach ($pago->impuestos->impuestosTrasladados as &$pagoTraslado){
                                if($pagoTraslado->impuesto == $traslado->impuesto &&
                                    $pagoTraslado->tasaCuota == $traslado->tasaCuota &&
                                    $pagoTraslado->tipoFactor == $traslado->tipoFactor){
                                    if($equivalenciaDR > 0){
                                        $pagoTraslado->base += self::truncarDosDecimales($traslado->base / $equivalenciaDR);
                                        $pagoTraslado->importe += self::truncarDosDecimales($traslado->importe / $equivalenciaDR);
                                    }else{
                                        $pagoTraslado->base += $traslado->base;
                                        $pagoTraslado->importe += $traslado->importe;
                                    }

                                    $existeImpuesto = true;
                                }
                            }
                            if(!$existeImpuesto){
                                $tmpTraslado = clone $traslado;
                                if($equivalenciaDR > 0){
                                    $tmpTraslado->base = self::truncarDosDecimales($tmpTraslado->base / $equivalenciaDR);
                                    $tmpTraslado->importe = self::truncarDosDecimales($tmpTraslado->importe / $equivalenciaDR);
                                }
                                $pago->impuestos->impuestosTrasladados[] = $tmpTraslado;
                            }
                        }

                        foreach ($documentoRelacionado->retenciones as $retencion){
                            $existeImpuesto = false;
                            foreach ($pago->impuestos->impuestosRetenidos as &$pagoRetencion){
                                if($pagoRetencion->impuesto == $retencion->impuesto){

                                    if($equivalenciaDR > 0){
                                        $pagoRetencion->base += self::truncarDosDecimales($retencion->base / $equivalenciaDR);
                                        $pagoRetencion->importe += self::truncarDosDecimales($retencion->importe / $equivalenciaDR);
                                    }else{
                                        $pagoRetencion->base += $retencion->base;
                                        $pagoRetencion->importe += $retencion->importe;
                                    }

                                    $existeImpuesto = true;
                                }
                            }
                            if(!$existeImpuesto){
                                $tmpRetencion = clone $retencion;

                                if($equivalenciaDR > 0){
                                    $tmpRetencion->base = self::truncarDosDecimales($tmpRetencion->base / $equivalenciaDR);
                                    $tmpRetencion->importe = self::truncarDosDecimales($tmpRetencion->importe / $equivalenciaDR);
                                }

                                $pago->impuestos->impuestosRetenidos[] = $tmpRetencion;
                            }
                        }
                    }
                }
            }
        }

        $datosFactura->infGlobal = null;
	    if($datosFactura->version == '4.0'){
	        if($datosFactura->rFCRecep == 'XAXX010101000' && $datosFactura->nmbRecep == 'PUBLICO EN GENERAL'){
                $informacionGlobal = new \stdClass ();
                $informacionGlobal->anio = $datosFactura->publiAnio;
                $informacionGlobal->meses = $datosFactura->publiMeses;
                $informacionGlobal->periodicidad = $datosFactura->publiPeriodicidad;
                $datosFactura->infGlobal = $informacionGlobal;
            }
        }

        $datosFactura->cartaPorte = null;


        if(!empty($datosFactura->id_cartaPorte) && $datosFactura->id_cartaPorte > 0){

            $totalDistanciaRecorrida = 0;
            $cartaPorte = new \stdClass();
            $cartaPorte->transpInternac = $datosFactura->transpInternac;
            $cartaPorte->entradaSalidaMerc = $datosFactura->entradaSalidaMerc;
            $cartaPorte->paisOrigenDestino = $datosFactura->paisOrigenDestino;
            $cartaPorte->viaEntradaSalida = $datosFactura->viaEntradaSalida;
            $cartaPorte->pesoBrutoTotal = $datosFactura->pesoBrutoTotal;
            $cartaPorte->unidadPeso = $datosFactura->unidadPeso;
            $cartaPorte->idccp = $datosFactura->idccp;

            $ubicaciones = Ubicacion::where('id_cartaPorte', '=', $datosFactura->id_cartaPorte)->get();
            foreach ($ubicaciones as &$ubicacion){
                $ubicacion->fechaHoraSalidaLlegada = date("Y-m-d\TH:i:s", strtotime($ubicacion->fechaHoraSalidaLlegada));
                $totalDistanciaRecorrida += $ubicacion->totalDistRec;

                $ubicacion->municipio = '';
                $municipioObj = Municipio::where('Estado', '=', $ubicacion->estado)->where('codigo', '=', $ubicacion->municipio)->first();
                if(is_object($municipioObj))
                    $ubicacion->municipio = $municipioObj->descripcion;
            }
            $cartaPorte->totalDistanciaRecorrida = $totalDistanciaRecorrida;
            $cartaPorte->ubicaciones = $ubicaciones;
            $cartaPorte->mercancias = Mercancia::where('id_cartaPorte', '=', $datosFactura->id_cartaPorte)->get();
            $cartaPorte->autotransporte = Autotransporte::where('id_cartaPorte', '=', $datosFactura->id_cartaPorte)->first();

            if(is_object($cartaPorte->autotransporte)){
                $cartaPorte->autotransporte->remolques = Remolque::where('id_cartaPorte', '=', $datosFactura->id_cartaPorte)->get();
            }

            $cartaPorte->figurasTransporte = FigurasTransporte::where('id_cartaPorte', '=', $datosFactura->id_cartaPorte)->get();

            $datosFactura->cartaPorte = $cartaPorte;
        }


	    if($datosFactura->tipoDeComprobante == 'N'){

	    	$totalDeduccion = 0;
	    	$totalImpuestosRetenidos = 0;
	    	$totalOtrasDeducciones = 0;

	    	$totalPercepcionGravado = 0;
	    	$totalPercepcionExcento = 0;
	    	$totalPercepciones = 0;
	    	$totalOtrosPagos = 0;
	    	$totalSueldos = 0;
	    	$totalSeparacionIndemnizacion = 0;
	    	$totalJubilacionPension = 0;

	    	$listadoPercepciones = [];
	    	$listadoDeducciones = [];
	    	$listadoOtrosPagos = [];
	    	$listadoIncapacidades = [];

	    	$empleado = EmpleadoFac::with('empleado.cliente', 'percepciones.tipopd', 'deducciones.tipopd', 'liquidacion')->where('id_factura', '=', $id_factura)->first();
	    	$periodo = PeriodoNomina::find($empleado->id_periodoNomina);

	    	$registroPatronal = $empleado->registroPatronal;
	    	if($empleado->registroPatronal == ''){
	    		$adicionalNomina = AdicionalNomina::find($id_proveedor);
	    		$registroPatronal = $adicionalNomina->registroPatronal;
	    	}


	    	if(count($empleado->percepciones) > 0)
	    		foreach ($empleado->percepciones as $percepcion){

	    			if($percepcion->tipopd->subTipo == 1){

	    				$totalPercepcionExcento += $percepcion->importeExcento;
	    				$totalPercepcionGravado += $percepcion->importeGravado;

	    				if($percepcion->tipopd->clave == '022' || $percepcion->tipopd->clave == '023' ||
	    						$percepcion->tipopd->clave == '025'){
	    							$totalSeparacionIndemnizacion += $percepcion->importeExcento + $percepcion->importeGravado;
	    				}else if( $percepcion->tipopd->clave == '039' || $percepcion->tipopd->clave == '044'){
	    					$totalJubilacionPension += $percepcion->importeExcento + $percepcion->importeGravado;
	    				}else{
	    					$totalSueldos += $percepcion->importeExcento + $percepcion->importeGravado;
	    				}

	    				$listadoPercepciones[] = array('TipoPercepcion' => $percepcion->tipopd->clave, 'Clave' => $percepcion->tipopd->clave,
	    						'Concepto' => $percepcion->tipopd->descripcion, 'ImporteGravado' => Utils::formatNumber($percepcion->importeGravado),
	    						'ImporteExento' => Utils::formatNumber($percepcion->importeExcento), 'Dias' => $percepcion->noDiasHoras,
	    						'TipoHoras' => $percepcion->tipoHoras, 'HorasExtra' => $percepcion->noHoras, 'ImportePagado' => Utils::formatNumber($percepcion->importeExcento + $percepcion->importeGravado)
	    				);

	    			}else{

	    				$totalOtrosPagos += $percepcion->importeExcento + $percepcion->importeGravado;

	    				$listadoOtrosPagos[] = array('TipoOtroPago' => $percepcion->tipopd->clave, 'Clave' => $percepcion->tipopd->clave,
	    						'Concepto' => $percepcion->tipopd->descripcion, 'Importe' => Utils::formatNumber($percepcion->importeGravado + $percepcion->importeExcento));

	    			}
	    	}

	    	if(count($empleado->deducciones) > 0)
	    		foreach ($empleado->deducciones as $deduccion){

	    			if($deduccion->id_tipoPercepcionDeduccion == 34){
	    				//Incapacidades
	    				$listadoIncapacidades[] = array('DiasIncapacidad' => $deduccion->noDiasHoras, 'TipoIncapacidad' => $deduccion->tipoHoras,
	    						'ImporteMonetario' => Utils::formatNumber($deduccion->importeExcento + $deduccion->importeGravado));

	    			}

	    			$totalDeduccion += $deduccion->importeExcento + $deduccion->importeGravado;

	    			if($deduccion->tipopd->clave == '002'){
	    				$totalImpuestosRetenidos += $deduccion->importeExcento + $deduccion->importeGravado;
	    			}else{
	    				$totalOtrasDeducciones += $deduccion->importeExcento + $deduccion->importeGravado;
	    			}

	    			$listadoDeducciones[] = array('TipoDeduccion' => $deduccion->tipopd->clave, 'Clave' => $deduccion->tipopd->clave,
	    					'Concepto' => $deduccion->tipopd->descripcion, 'Importe' => Utils::formatNumber($deduccion->importeExcento + $deduccion->importeGravado));

	    	}

	    	$datosFactura->liquidacion = null;
	    		if(is_object($empleado->liquidacion)){
                    $datosFactura->liquidacion = $empleado->liquidacion;
                }


	    	$totalPercepciones = Utils::formatNumber($totalPercepcionGravado + $totalPercepcionExcento);
	    	$subTotal = $empleado->totalPercepciones =  Utils::formatNumber($totalPercepciones + $totalOtrosPagos);
	    	$empleado->totalAPercibir = $subTotal - $totalDeduccion;

	    	$nomina = array(
	    			'Version' => '1.2',
	    			'FechaPago' => $periodo->fechaPago,
	    			'FechaInicialPago' => $periodo->fechaInicio,
	    			'FechaFinalPago' => $periodo->fechaFin,
	    			'NumDiasPagados' => $empleado->noDiasPagados,
	    			'TipoNomina' => $periodo->TipoNomina,
	    			'TotalDeducciones' => Utils::formatNumber($totalDeduccion),
	    			'TotalOtrosPagos' => Utils::formatNumber($totalOtrosPagos),
	    			'TotalPercepciones' => $totalPercepciones,
	    			'Emisor' => array('RegistroPatronal' => $registroPatronal),
	    			'Percepciones' => array(
	    					'totalPercepcion' => Utils::formatNumber($totalPercepcionGravado + $totalPercepcionExcento),
	    					'totalPercepcionGravado' => $totalPercepcionGravado,
	    					'totalPercepcionExcento' => $totalPercepcionExcento,
	    					'totalSueldos' => $totalSueldos,
	    					'totalSeparacionIndemnizacion' => $totalSeparacionIndemnizacion,
	    					'totalJubilacionPension' => $totalJubilacionPension,
	    					'listadoPercepciones' => $listadoPercepciones),
	    			'Deducciones' => array(
	    					'totalDeduccion' => $totalDeduccion,
	    					'totalImpuestosRetenidos' => $totalImpuestosRetenidos,
							'totalOtrasDeducciones' => $totalOtrasDeducciones,
							'listadoDeducciones' => $listadoDeducciones
					),
					'OtrosPagos' => array (
							'listadoOtrosPagos' => $listadoOtrosPagos
					),
					'Incapacidades' => array (
							'listadoIncapacidades' => $listadoIncapacidades
					)
			);

			$receptorN = [ ];

			if (! empty ( $empleado->curp ))
				$receptorN ['Curp'] = trim ( $empleado->curp );

			if (! empty ( $empleado->tipoContrato ))
				$receptorN ['TipoContrato'] = trim ( $empleado->tipoContrato );

			if (! empty ( $empleado->id_catalogoRegimenContratacion )) {
				$rg = CatalogoRegimenContratacion::find ( $empleado->id_catalogoRegimenContratacion );
				$receptorN ['TipoRegimen'] = trim ( $rg->clave );
			}

			if (! empty ( $empleado->noEmpleado ))
				$receptorN ['NumEmpleado'] = trim ( $empleado->noEmpleado );

			if (! empty ( $empleado->periodicidadPago ))
				$receptorN ['PeriodicidadPago'] = trim ( $empleado->periodicidadPago );

			if (! empty ( $empleado->ClaveEntFed ))
				$receptorN ['ClaveEntFed'] = trim ( $empleado->ClaveEntFed );

			if (! empty ( $empleado->nss ))
				$receptorN ['NumSeguridadSocial'] = preg_replace ( '/\D/', '', trim ( $empleado->nss ) );

			if (! empty ( $empleado->fechaInicioRelLaboral ))
				$receptorN ['FechaInicioRelLaboral'] = trim ( $empleado->fechaInicioRelLaboral );

			$datetime1 = new \DateTime ( $empleado->fechaInicioRelLaboral );
			$datetime2 = new \DateTime ( $periodo->fechaFin );
			$interval = $datetime1->diff ( $datetime2 );
			$antiguedad = $interval->format ( '%R%a' );
			$antiguedad = str_replace ( '+', '', $antiguedad );
			$antiguedad = $antiguedad / 7;
			$antiguedad = floor ( $antiguedad );
			$receptorN ['Antigüedad'] = "P" . $antiguedad . "W";

			if (! empty ( $empleado->puesto ))
				$receptorN ['Puesto'] = trim ( $empleado->puesto );

			if (! empty ( $empleado->salarioBase ))
				$receptorN ['SalarioBaseCotApor'] = Utils::formatNumber ( $empleado->salarioBase );

			if (! empty ( $empleado->salarioDiarioIntegrado ))
				$receptorN ['SalarioDiarioIntegrado'] = Utils::formatNumber ( $empleado->salarioDiarioIntegrado );

			if (! empty ( $empleado->id_catalogoRiesgoPuesto)){
	    												$rg = CatalogoRiesgoPuesto::find($empleado->id_catalogoRiesgoPuesto);
	    												$receptorN['RiesgoPuesto'] = trim($rg->clave);
	    											}

	    	$nomina['Receptor'] = $receptorN;

	    	$datosFactura->nomina = $nomina;


	    }

	    $proveedor = Proveedor::find($id_proveedor);
	    $datosFactura->tipoPersona = $proveedor->tipoPersona;


	    $datosFactura->comercio = null;

	    if(!empty($datosFactura->Incoterm)){

            $datosFactura->mercanciasComercio = MercanciaComercio::where('id_factura', '=', $id_factura)->get();
	    	$datosFactura->comercio = new \stdClass();
	    	$datosFactura->comercio->datos = ComercioE::with('incoterm')->find($id_factura);
	    	$datosFactura->comercio->emisor = DomFiscalFact::find($id_factura);
	    	$datosFactura->comercio->receptor = DomFiscalRcpFact::find($id_factura);

	    	$estado = Estado::where('codigo', '=', $datosFactura->comercio->emisor->estado)
	    		->where('pais', '=', $datosFactura->comercio->emisor->pais)->first();

	    	$municipio = Municipio::where('Estado', '=', $datosFactura->comercio->emisor->estado)
	    		->where('codigo', '=', $datosFactura->comercio->emisor->municipio)->first();

	    	$datosFactura->comercio->emisor->estadoLbl = $estado->descripcion;
	    	$datosFactura->comercio->emisor->municipioLbl = $municipio->descripcion;


	    	$estadoReceptor = Estado::where('codigo', '=', $datosFactura->comercio->receptor->estado)
	    	->where('pais', '=', $datosFactura->comercio->receptor->pais)->first();

	    	$municipioReceptor = Municipio::where('Estado', '=', $datosFactura->comercio->receptor->municipio)
	    	->where('codigo', '=', $datosFactura->comercio->receptor->municipio)->first();

            $datosFactura->comercio->receptor->estadoLbl = is_object($municipioReceptor) ? $municipioReceptor->descripcion : $datosFactura->comercio->receptor->municipio;

            $estadoLabel = $datosFactura->comercio->receptor->estado;
            if(is_object($estadoReceptor) && isset($estadoReceptor->descripcion)){
                $estadoLabel = $estadoReceptor->descripcion;
            }
	    	$datosFactura->comercio->receptor->estadoLbl .= ', ' . $estadoLabel;

	    }

	    if(!empty($datosFactura->ImporteFG)){
            $datosFactura->addenda = new \stdClass();
            $datosFactura->addenda->Importe = $datosFactura->ImporteFG;
            $datosFactura->addenda->PeriodoEnMeses = $datosFactura->PeriodoEnMesesFG;
            $datosFactura->addenda->Descripcion = $datosFactura->DescripcionFG;
        }

	    return $datosFactura;
	}

    public static function headers($xmlString, $soapAction, $token){
        return  array(
            "Content-type: text/xml;charset=\"utf-8\"",
            "Accept: text/xml",
            "Cache-Control: no-cache",
            $token ? "Authorization: WRAP access_token=\"".$token."\"":"",
            "SOAPAction: ".$soapAction,
            "Content-length: ".strlen($xmlString),
        );
    }
    public static function xmlToArray($xml){
        return json_decode(json_encode(simplexml_load_string(str_replace("s:", "", str_replace("o:","", str_replace("u:","",str_replace("h:","",'<?xml version="1.0" encoding="utf-8"?>'.$xml)))))),TRUE);
    }

    public static function genUuid() {
        return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
            mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ),
            mt_rand( 0, 0xffff ),
            mt_rand( 0, 0x0fff ) | 0x4000,
            mt_rand( 0, 0x3fff ) | 0x8000,
            mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff )
        );
    }

    public static function derToPem($der_data, $type='CERTIFICATE') {
        $pem = chunk_split(base64_encode($der_data), 64, "\n");
        $pem = "-----BEGIN ".$type."-----\n".$pem."-----END ".$type."-----\n";
        return $pem;
    }

    public static function saveBase64File($data, $filename){
        $data = base64_decode($data);
        file_put_contents($filename, $data);
    }

    public static function encryptData($data){

        $ciphering = "AES-128-CTR";
        openssl_cipher_iv_length($ciphering);
        $options = 0;
        $encryption_iv = '1234567891011121';

        return openssl_encrypt($data, $ciphering,
            self::$ENCRYPTION_KEY, $options, $encryption_iv);
    }

    public static function decryptData($encryptedData){

        $ciphering = "AES-128-CTR";
        openssl_cipher_iv_length($ciphering);
        $options = 0;
        $encryption_iv = '1234567891011121';

        return openssl_decrypt ($encryptedData, $ciphering,
            self::$ENCRYPTION_KEY, $options, $encryption_iv);

    }

    public static function registrarUsuario($rfc){

        // Username and Password, assigned by FINKOK
        $usuarioInt = "saul.flores@soliat.com";
        $passwordInt = "S3rgio.Fl0res";
        $taxpayer_id = $rfc;

        $url = "https://facturacion.finkok.com/servicios/soap/registration.wsdl";
        $client = new SoapClient ( $url, array (
            'trace' => 1
        ) );

        $params = array (
            "reseller_username" => $usuarioInt,
            "reseller_password" => $passwordInt,
            "taxpayer_id" => $taxpayer_id
        );
        $response = $client->__soapCall ( "add", array (
            $params
        ) );

        return $response;
    }

    public static function getIDCCP($proveedor)
    {
        $urlTimbrado = "https://facturacion.finkok.com/servicios/soap/utilities.wsdl";
        $usuarioInt = "saul.flores@soliat.com";
        $passwordInt = "S3rgio.Fl0res";

        if ($proveedor->id_proveedor == 1089) {
            $urlTimbrado = "https://demo-facturacion.finkok.com/servicios/soap/utilities.wsdl";
        }

        $params = array ();
        $params ['username'] = $usuarioInt;
        $params ['password'] = $passwordInt;

        $client = new SoapClient ( $urlTimbrado, array (
            'encoding' => 'UTF-8',
            "connection_timeout" => 250
        ) );
        $client->soap_defencoding = "UTF-8";
        $resultado = $client->__soapCall ( 'get_idccp', array (
            $params
        ) );

        return $resultado->get_idccpResult->idccp;
    }
}
